/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;

public class SmartDecimalFormat
extends DecimalFormat {
    private static final long serialVersionUID = 3690478034742620467L;
    private int roundingMode = 4;

    public SmartDecimalFormat() {
    }

    public SmartDecimalFormat(String pattern) {
        super(pattern);
    }

    public SmartDecimalFormat(String pattern, int roundingMode) {
        super(pattern);
        this.roundingMode = roundingMode;
    }

    public SmartDecimalFormat(String pattern, DecimalFormatSymbols symbols) {
        super(pattern, symbols);
    }

    public SmartDecimalFormat(String pattern, DecimalFormatSymbols symbols, int roundingMode) {
        super(pattern, symbols);
        this.roundingMode = roundingMode;
    }

    public StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
        int maxFractionDigits = this.getMaximumFractionDigits();
        double absNumber = Math.abs(number);
        double toBeFormatted = number;
        double mfdFactor = Math.pow(10.0, maxFractionDigits);
        long rFactor = (long)Math.pow(10.0, maxFractionDigits + 1);
        long rest = (long)(absNumber * (double)rFactor) % rFactor;
        long maxFractionDigit = rest % 10L;
        switch (this.roundingMode) {
            case 0: {
                if (maxFractionDigit < 1L) break;
                absNumber += 1.0 / mfdFactor;
                break;
            }
            case 1: {
                if (maxFractionDigit < 1L) break;
                absNumber -= (double)maxFractionDigit / (double)rFactor;
                break;
            }
            case 4: {
                if (maxFractionDigit >= 5L) {
                    absNumber -= (double)maxFractionDigit / (double)rFactor;
                    absNumber += 1.0 / mfdFactor;
                    break;
                }
                absNumber -= (double)maxFractionDigit / (double)rFactor;
                break;
            }
            case 5: {
                if (maxFractionDigit > 5L) {
                    absNumber -= (double)maxFractionDigit / (double)rFactor;
                    absNumber += 1.0 / mfdFactor;
                    break;
                }
                absNumber -= (double)maxFractionDigit / (double)rFactor;
                break;
            }
            case 2: {
                if (absNumber >= 0.0) {
                    absNumber += 1.0 / mfdFactor;
                    break;
                }
                absNumber -= (double)maxFractionDigit / (double)rFactor;
                break;
            }
            case 3: {
                if (absNumber >= 0.0) {
                    absNumber -= (double)maxFractionDigit / (double)rFactor;
                    break;
                }
                absNumber += 1.0 / mfdFactor;
            }
        }
        if (this.roundingMode != 6) {
            toBeFormatted = absNumber;
            if (number < 0.0) {
                toBeFormatted *= -1.0;
            }
        }
        return super.format(toBeFormatted, result, fieldPosition);
    }

    public int getRoundingModeId() {
        return this.roundingMode;
    }

    public void setRoundingModeId(int roundingMode) {
        this.roundingMode = roundingMode;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }
}

