/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.types;

import org.ujac.util.BeanUtils;
import org.ujac.util.TypeConverterException;
import org.ujac.util.text.FormatHelper;
import org.ujac.util.types.DataType;

public class FloatType
implements DataType {
    public int getTypeId() {
        return 5;
    }

    public Object convertObject(Object value, FormatHelper formatHelper) throws TypeConverterException {
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return value;
        }
        if (value instanceof Number) {
            return new Float(((Number)value).floatValue());
        }
        String strVal = value.toString();
        try {
            float val = Float.parseFloat(strVal);
            return new Float(val);
        }
        catch (NumberFormatException ex) {
            throw new TypeConverterException("Failed to parse float value out of given value '" + strVal + "'.", ex);
        }
    }

    public String formatValue(Object value, FormatHelper formatHelper) throws TypeConverterException {
        return BeanUtils.toString(this.convertObject(value, formatHelper));
    }
}

