/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.types;

import org.ujac.util.BeanUtils;
import org.ujac.util.TypeConverterException;
import org.ujac.util.text.FormatHelper;
import org.ujac.util.types.DataType;

public class ShortType
implements DataType {
    public int getTypeId() {
        return 3;
    }

    public Object convertObject(Object value, FormatHelper formatHelper) throws TypeConverterException {
        if (value == null) {
            return null;
        }
        if (value instanceof Short) {
            return value;
        }
        if (value instanceof Number) {
            return new Short((Short)value);
        }
        String strVal = value.toString();
        try {
            short val = Short.parseShort(strVal);
            return new Short(val);
        }
        catch (NumberFormatException ex) {
            throw new TypeConverterException("Failed to parse short value out of given value '" + strVal + "'.", ex);
        }
    }

    public String formatValue(Object value, FormatHelper formatHelper) throws TypeConverterException {
        return BeanUtils.toString(this.convertObject(value, formatHelper));
    }
}

