/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.xml;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ujac.util.CollectionUtils;
import org.ujac.util.StringUtils;
import org.ujac.util.xml.AttributeDefinition;
import org.ujac.util.xml.ElementDefinition;

public class ComplexTypeDefinition {
    private static final long serialVersionUID = 3310404559360886282L;
    private String name = null;
    private Class type = null;
    private String bodyProperty = null;
    private Map attributeMap = new HashMap();
    private List attributes = new ArrayList();
    private Map elementMap = new HashMap();
    private List elements = new ArrayList();
    private Set suppressedAttributes = null;

    public ComplexTypeDefinition(Class type) {
        this(null, type, null, null);
    }

    public ComplexTypeDefinition(String name, Class type) {
        this(name, type, null, null);
    }

    public ComplexTypeDefinition(String name, Class type, Set suppressedAttributes) {
        this(name, type, null, suppressedAttributes);
    }

    public ComplexTypeDefinition(String name, Class type, String[] suppressedAttributes) {
        this(name, type, null, CollectionUtils.createHashSet(suppressedAttributes));
    }

    public ComplexTypeDefinition(String name, Class type, String bodyProperty) {
        this(name, type, bodyProperty, null);
    }

    public ComplexTypeDefinition(String name, Class type, String bodyProperty, Set suppressedAttributes) {
        this.name = name;
        this.type = type;
        this.bodyProperty = bodyProperty;
        this.suppressedAttributes = suppressedAttributes;
        this.analyzeClass();
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public Object createInstance() throws InstantiationException, IllegalAccessException {
        Class clazz = this.getType();
        if (clazz == null) {
            return null;
        }
        return clazz.newInstance();
    }

    public String getBodyProperty() {
        return this.bodyProperty;
    }

    public void setBodyProperty(String bodyProperty) {
        this.bodyProperty = bodyProperty;
    }

    public AttributeDefinition getAttribute(String name) {
        return (AttributeDefinition)this.attributeMap.get(name);
    }

    public List getAttributes() {
        return this.attributes;
    }

    public boolean hasBody() {
        return !this.elements.isEmpty();
    }

    public ElementDefinition getElementDefinition(String name) {
        return (ElementDefinition)this.elementMap.get(name);
    }

    public List getElementDefinitions() {
        return this.elements;
    }

    public Iterator elementIterator(Object instance) {
        return null;
    }

    protected void analyzeClass() {
        this.attributeMap.clear();
        this.attributes.clear();
        this.elementMap.clear();
        this.elements.clear();
        Class clazz = this.getType();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?> attrType;
            String methodName;
            String attributeName;
            Method method = methods[i];
            if (!Modifier.isPublic(method.getModifiers()) || (attributeName = this.getAttributeName(methodName = method.getName())) == null || CollectionUtils.contains(this.suppressedAttributes, attributeName)) continue;
            AttributeDefinition attr = (AttributeDefinition)this.attributeMap.get(attributeName);
            ElementDefinition elem = (ElementDefinition)this.elementMap.get(attributeName);
            if (methodName.startsWith("set")) {
                if (method.getParameterTypes().length != 1) continue;
                attrType = method.getParameterTypes()[0];
                if (this.isLegalAttributeType(attrType)) {
                    if (attr == null) {
                        attr = new AttributeDefinition(attributeName, attrType);
                        this.attributeMap.put(attributeName, attr);
                        this.attributes.add(attr);
                    }
                    attr.setSetter(method);
                    continue;
                }
                if (elem == null) {
                    elem = new ElementDefinition(attributeName, attrType);
                    this.elementMap.put(attributeName, elem);
                    this.elements.add(elem);
                }
                elem.setSetter(method);
                continue;
            }
            if (method.getParameterTypes().length != 0 || "class".equals(attributeName)) continue;
            attrType = method.getReturnType();
            if (this.isLegalAttributeType(attrType)) {
                if (attr == null) {
                    attr = new AttributeDefinition(attributeName, attrType);
                    this.attributeMap.put(attributeName, attr);
                    this.attributes.add(attr);
                }
                attr.setGetter(method);
                continue;
            }
            if (elem == null) {
                elem = new ElementDefinition(attributeName, attrType);
                this.elementMap.put(attributeName, elem);
                this.elements.add(elem);
            }
            elem.setGetter(method);
        }
        Collections.sort(this.attributes);
        Collections.sort(this.elements);
    }

    private boolean isLegalAttributeType(Class type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (Number.class.isAssignableFrom(type)) {
            return true;
        }
        return type.equals(String.class);
    }

    private String getAttributeName(String methodName) {
        int methodNameLength = StringUtils.getLength(methodName);
        if (methodNameLength < 4) {
            return null;
        }
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            if (methodNameLength == 4) {
                return methodName.substring(3).toLowerCase();
            }
            return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
        }
        if (methodName.startsWith("is")) {
            if (methodNameLength == 3) {
                return methodName.substring(2).toLowerCase();
            }
            return Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
        }
        return null;
    }
}

