/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.web.servlet;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ujac.print.DocumentPrinter;
import org.ujac.util.UjacException;
import org.ujac.util.io.ClassPathResourceLoader;
import org.ujac.util.io.FileUtils;
import org.ujac.util.template.TemplateInterpreter;
import org.ujac.util.text.FormatHelper;
import org.ujac.web.servlet.TemplateInterpreterHelper;

public class ServletDocumentPrinter {
    private DocumentPrinter documentPrinter = null;

    public ServletDocumentPrinter(String templateSource, Map properties) throws IOException {
        ClassPathResourceLoader resourceLoader = new ClassPathResourceLoader(this.getClass().getClassLoader());
        byte[] templateBytes = resourceLoader.loadResource(templateSource);
        ByteArrayInputStream is = new ByteArrayInputStream(templateBytes);
        this.documentPrinter = new DocumentPrinter(is, properties);
        this.documentPrinter.setResourceLoader(resourceLoader);
    }

    public ServletDocumentPrinter(InputStream templateStream, Map properties) throws IOException {
        ClassPathResourceLoader resourceLoader = new ClassPathResourceLoader(this.getClass().getClassLoader());
        this.documentPrinter = new DocumentPrinter(templateStream, properties);
        this.documentPrinter.setResourceLoader(resourceLoader);
    }

    public DocumentPrinter getDocumentPrinter() {
        return this.documentPrinter;
    }

    public void printDocument(HttpServletRequest request, HttpServletResponse response) throws IOException, UjacException {
        this.printDocument(request, response, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printDocument(HttpServletRequest request, HttpServletResponse response, boolean supportToc) throws IOException, UjacException {
        File tempFile = null;
        FileOutputStream fos = null;
        try {
            TemplateInterpreter interpreter = TemplateInterpreterHelper.getTemplateInterpreter(request);
            this.documentPrinter.setTemplateInterpreter(interpreter);
            FormatHelper fh = TemplateInterpreterHelper.getFormatHelper(request);
            this.documentPrinter.setFormatHelper(fh);
            tempFile = File.createTempFile("ujac_print", "pdf");
            fos = new FileOutputStream(tempFile);
            BufferedOutputStream os = new BufferedOutputStream(fos);
            this.documentPrinter.printDocument(os, supportToc);
            os.close();
            fos.close();
            fos = null;
            long pdfSize = tempFile.length();
            response.setContentLength((int)pdfSize);
            response.setContentType("application/pdf");
            FileUtils.copyToStream(tempFile, (OutputStream)response.getOutputStream());
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (!tempFile.delete()) {
                tempFile.deleteOnExit();
            }
        }
    }
}

