/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.web.tag;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import org.ujac.util.BeanUtils;
import org.ujac.util.table.Column;
import org.ujac.util.table.GroupRow;
import org.ujac.util.table.LayoutHints;
import org.ujac.util.table.Row;
import org.ujac.util.table.TableException;
import org.ujac.web.tag.CellData;
import org.ujac.web.tag.PrintRowTag;
import org.ujac.web.tag.PrintTableTag;
import org.ujac.web.tag.RowCellHolder;

public class PrintFooterRowTag
extends PrintRowTag {
    private static final long serialVersionUID = 3691043175145944371L;
    private boolean forceFooter = false;
    private Row footerRow = null;

    public boolean isForceFooter() {
        return this.forceFooter;
    }

    public void setForceFooter(boolean forceFooter) {
        this.forceFooter = forceFooter;
    }

    protected boolean checkRowType(Row row) {
        if (row == null || !"footer".equals(row.getType())) {
            if (this.forceFooter && !this.rowContainer.getSequenceIterator().hasNext()) {
                row = new GroupRow(this.rowContainer.getTable(), "footer", null);
            } else {
                return false;
            }
        }
        this.footerRow = row;
        this.rowContainer.getTemplateContext().setProperty(this.rowContainer.getLoopVariable(), row);
        return true;
    }

    protected void outputRow() throws JspException {
        block32: {
            try {
                PrintTableTag parent = this.getRowContainer();
                String template = parent.getTemplate();
                String rowStyle = this.alternateRowStyle();
                if (BeanUtils.isEmpty(template)) {
                    super.outputRow();
                    break block32;
                }
                try {
                    this.setAttribute("_TABLE_ROW_STYLE", rowStyle);
                    this.setAttribute("_TABLE_ROW_HEIGHT", this.getHeight());
                    ArrayList<CellData> actualCells = new ArrayList<CellData>();
                    Row row = this.footerRow;
                    this.setAttribute("_TABLE_ROW_TYPE", row.getType());
                    Column[] columns = parent.getVisibleColumns();
                    for (int i = 0; i < columns.length; ++i) {
                        Column column = columns[i];
                        int columnIdx = column.getIndex();
                        boolean visible = true;
                        if (columnIdx >= 0) {
                            visible = row.isVisible(columnIdx);
                        }
                        LayoutHints layoutHints = column.getLayoutHints();
                        RowCellHolder rowCell = this.registeredRowCells[i];
                        String width = null;
                        String height = this.getHeight();
                        String valign = this.getValign();
                        String halign = null;
                        if (columnIdx != -1) {
                            switch (row.getAlign(columnIdx)) {
                                case 2: {
                                    halign = "right";
                                    break;
                                }
                                case 1: {
                                    halign = "center";
                                    break;
                                }
                                default: {
                                    halign = "left";
                                }
                            }
                        }
                        String cellStyle = rowStyle;
                        float paddingLeft = this.getPaddingLeft();
                        float paddingRight = this.getPaddingRight();
                        float paddingTop = this.getPaddingTop();
                        float paddingBottom = this.getPaddingBottom();
                        String content = null;
                        int colspan = 1;
                        if (rowCell != null) {
                            String tmpHalign;
                            visible = true;
                            width = rowCell.getWidth();
                            if (rowCell.getHeight() != null) {
                                height = rowCell.getHeight();
                            }
                            if (rowCell.getStyle() != null) {
                                cellStyle = rowCell.getStyle();
                            }
                            if (rowCell.getValign() != null) {
                                valign = rowCell.getValign();
                            }
                            if ((tmpHalign = rowCell.getHalign()) != null) {
                                halign = tmpHalign;
                            }
                            if (rowCell.getPaddingLeft() >= 0.0f) {
                                paddingLeft = rowCell.getPaddingLeft();
                            }
                            if (rowCell.getPaddingRight() >= 0.0f) {
                                paddingRight = rowCell.getPaddingRight();
                            }
                            if (rowCell.getPaddingTop() >= 0.0f) {
                                paddingTop = rowCell.getPaddingTop();
                            }
                            if (rowCell.getPaddingBottom() >= 0.0f) {
                                paddingBottom = rowCell.getPaddingBottom();
                            }
                            if (rowCell.hasContent()) {
                                content = this.rowContainer.evalTemplate(rowCell.getContent());
                            }
                            if (rowCell.getColspan() > 0) {
                                colspan = rowCell.getColspan();
                            }
                            if (rowCell.isFillRow()) {
                                colspan = columns.length - i;
                            }
                        }
                        if (width == null && layoutHints.getWidth() > 0.0f) {
                            width = Integer.toString((int)layoutHints.getWidth());
                        }
                        if (content == null) {
                            if (columnIdx != -1 && row.isVisible(columnIdx)) {
                                content = row.getString(columnIdx);
                            } else {
                                content = parent.getDefaultContent(i);
                                if (content != null) {
                                    content = this.rowContainer.evalTemplate(content);
                                }
                            }
                        }
                        if (content == null) {
                            content = "&nbsp;";
                        }
                        CellData cellData = new CellData(column.getName(), content, colspan);
                        cellData.setVisible(visible);
                        cellData.setStyle(cellStyle);
                        cellData.setWidth(width);
                        cellData.setHeight(height);
                        cellData.setHalign(halign);
                        cellData.setValign(valign);
                        cellData.setPaddingLeft((int)paddingLeft);
                        cellData.setPaddingRight((int)paddingRight);
                        cellData.setPaddingTop((int)paddingTop);
                        cellData.setPaddingBottom((int)paddingBottom);
                        actualCells.add(cellData);
                        if (colspan <= 1) continue;
                        i += colspan - 1;
                    }
                    this.setAttribute("_TABLE_CELLS", actualCells);
                    this.pageContext.include(template + "-footer.jsp");
                    parent.setFooterPrinted(true);
                }
                catch (ServletException ex) {
                    throw new JspException("Failed to include template file '" + template + "-body.jsp'.");
                }
            }
            catch (IOException ex) {
                throw new JspException("Unable to print table row: " + ex.getMessage(), (Throwable)ex);
            }
            catch (TableException ex) {
                throw new JspException("Unable to print table row: " + ex.getMessage(), (Throwable)ex);
            }
            catch (ClassCastException ex) {
                throw new JspException("Type cast problem detected: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void release() {
        super.release();
        this.forceFooter = false;
    }
}

