/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.web.tag;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;
import org.ujac.util.BeanUtils;
import org.ujac.util.StringUtils;
import org.ujac.util.table.Column;
import org.ujac.util.table.LayoutHints;
import org.ujac.util.table.Row;
import org.ujac.util.table.TableException;
import org.ujac.web.tag.BaseTag;
import org.ujac.web.tag.CellData;
import org.ujac.web.tag.ExtraRowHolder;
import org.ujac.web.tag.MarkupAttribute;
import org.ujac.web.tag.PrintTableTag;
import org.ujac.web.tag.RowCellContainer;
import org.ujac.web.tag.RowCellHolder;

public class PrintRowTag
extends BaseTag
implements RowCellContainer {
    private static final long serialVersionUID = 3258413945357220153L;
    protected PrintTableTag rowContainer = null;
    private String style = null;
    private String evenStyle = null;
    private String oddStyle = null;
    private String height = null;
    private String valign = null;
    private float paddingLeft = -1.0f;
    private float paddingRight = -1.0f;
    private float paddingTop = -1.0f;
    private float paddingBottom = -1.0f;
    private String currentStyle = null;
    protected RowCellHolder[] registeredRowCells = null;
    private boolean skipped = false;
    protected List extraRowsBefore = null;
    protected List extraRowsAfter = null;

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getEvenStyle() {
        return this.evenStyle;
    }

    public void setEvenStyle(String evenStyle) {
        this.evenStyle = evenStyle;
    }

    public String getOddStyle() {
        return this.oddStyle;
    }

    public void setOddStyle(String oddStyle) {
        this.oddStyle = oddStyle;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getValign() {
        return this.valign;
    }

    public void setValign(String valign) {
        this.valign = valign;
    }

    public float getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setPaddingLeft(float paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public float getPaddingRight() {
        return this.paddingRight;
    }

    public void setPaddingRight(float paddingRight) {
        this.paddingRight = paddingRight;
    }

    public float getPaddingTop() {
        return this.paddingTop;
    }

    public void setPaddingTop(float paddingTop) {
        this.paddingTop = paddingTop;
    }

    public float getPaddingBottom() {
        return this.paddingBottom;
    }

    public void setPaddingBottom(float paddingBottom) {
        this.paddingBottom = paddingBottom;
    }

    public void registerRowCell(RowCellHolder rowCell) {
        int index = rowCell.getColumnIndex();
        if (index < 0) {
            index = this.rowContainer.getColumnIndex(rowCell.getColumnName());
        }
        if (index < 0) {
            throw new RuntimeException("Failed to register row-cell for undefined column '" + rowCell.getColumnName() + "'.");
        }
        this.registeredRowCells[index] = rowCell;
    }

    private boolean isEvenRow() {
        return this.rowContainer.getIterationIdx() % 2 == 0;
    }

    protected boolean isSkipped() {
        return this.skipped;
    }

    protected void setSkipped(boolean skipped) {
        this.skipped = skipped;
    }

    public PrintTableTag getRowContainer() {
        return this.rowContainer;
    }

    protected String getCellAttributes(String styleClass, String width, String height, String hAlign, String vAlign, int colspan, float paddingLeft, float paddingRight, float paddingTop, float paddingBottom) {
        String styleAttributes = this.getStyleAttribute(width, height, hAlign, vAlign, paddingLeft, paddingRight, paddingTop, paddingBottom);
        StringBuffer attributesBuffer = new StringBuffer();
        if (styleClass != null) {
            attributesBuffer.append(" class=\"").append(styleClass).append("\"");
        }
        if (hAlign != null) {
            attributesBuffer.append(" align=\"").append(hAlign).append("\"");
        }
        if (vAlign != null) {
            attributesBuffer.append(" valign=\"").append(vAlign).append("\"");
        }
        if (width != null) {
            attributesBuffer.append(" width=\"").append(width).append("\"");
        }
        if (height != null) {
            attributesBuffer.append(" height=\"").append(height).append("\"");
        }
        if (colspan > 1) {
            attributesBuffer.append(" colspan=\"").append(colspan).append("\"");
        }
        if (!StringUtils.isEmpty(styleAttributes)) {
            attributesBuffer.append(" style=").append(styleAttributes).append("\"");
        }
        return attributesBuffer.toString();
    }

    protected String getStyleAttribute(String width, String height, String hAlign, String vAlign, float paddingLeft, float paddingRight, float paddingTop, float paddingBottom) {
        StringBuffer styleBuffer = new StringBuffer();
        if (hAlign != null) {
            styleBuffer.append("text-align:" + hAlign + ";");
        }
        if (vAlign != null) {
            styleBuffer.append("vertical-align:" + vAlign + ";");
        }
        if (width != null) {
            styleBuffer.append("width:" + width);
            if (!width.endsWith("%")) {
                styleBuffer.append("px");
            }
            styleBuffer.append(";");
        }
        if (height != null) {
            styleBuffer.append("height:" + height);
            if (!height.endsWith("%")) {
                styleBuffer.append("px");
            }
            styleBuffer.append(";");
        }
        if (paddingLeft > 0.0f) {
            styleBuffer.append("padding-left:" + paddingLeft);
            styleBuffer.append("px;");
        }
        if (paddingRight > 0.0f) {
            styleBuffer.append("padding-right:" + paddingRight);
            styleBuffer.append("px;");
        }
        if (paddingTop > 0.0f) {
            styleBuffer.append("padding-top:" + paddingTop);
            styleBuffer.append("px;");
        }
        if (paddingBottom > 0.0f) {
            styleBuffer.append("padding-bottom:" + paddingBottom);
            styleBuffer.append("px;");
        }
        return styleBuffer.toString();
    }

    public void insertExtraRow(ExtraRowHolder extraRow, int insertDirection) {
        List extraRowList = null;
        if (insertDirection == 1) {
            if (this.extraRowsBefore == null) {
                this.extraRowsBefore = new ArrayList();
            }
            extraRowList = this.extraRowsBefore;
        } else {
            if (this.extraRowsAfter == null) {
                this.extraRowsAfter = new ArrayList();
            }
            extraRowList = this.extraRowsAfter;
        }
        extraRowList.add(extraRow);
    }

    public int doStartTag() throws JspException {
        this.rowContainer = this.lookupRowContainer();
        Row row = this.rowContainer.getCurrentRow();
        if (!this.checkRowType(row)) {
            this.setSkipped(true);
            return 0;
        }
        this.printTagStart();
        this.registeredRowCells = new RowCellHolder[this.rowContainer.getNumColumns()];
        this.extraRowsBefore = null;
        this.extraRowsAfter = null;
        if (this.evenStyle == null) {
            this.evenStyle = this.rowContainer.getEvenStyle();
        }
        if (this.oddStyle == null) {
            this.oddStyle = this.rowContainer.getOddStyle();
        }
        return 1;
    }

    protected boolean checkRowType(Row row) {
        return row != null && "normal".equals(row.getType());
    }

    protected void printTagStart() {
        this.setSkipped(false);
    }

    public int doEndTag() throws JspException {
        String style;
        ExtraRowHolder extraRow;
        int i;
        int numExtraRows;
        List extraRows;
        this.registerColumnStyles();
        if (this.isSkipped()) {
            this.setSkipped(false);
            return 6;
        }
        this.currentStyle = this.alternateRowStyle();
        if (this.extraRowsBefore != null) {
            extraRows = this.extraRowsBefore;
            numExtraRows = extraRows.size();
            for (i = 0; i < numExtraRows; ++i) {
                extraRow = (ExtraRowHolder)extraRows.get(i);
                style = extraRow.getStyle();
                if (style == null) {
                    style = this.currentStyle;
                }
                this.outputRow(extraRow.getRowCells(), style, extraRow.getHeight(), extraRow.getValign(), extraRow.getPaddingLeft(), extraRow.getPaddingRight(), extraRow.getPaddingTop(), extraRow.getPaddingBottom());
            }
        }
        this.outputRow();
        if (this.extraRowsAfter != null) {
            extraRows = this.extraRowsAfter;
            numExtraRows = extraRows.size();
            for (i = 0; i < numExtraRows; ++i) {
                extraRow = (ExtraRowHolder)extraRows.get(i);
                style = extraRow.getStyle();
                if (style == null) {
                    style = this.currentStyle;
                }
                this.outputRow(extraRow.getRowCells(), style, extraRow.getHeight(), extraRow.getValign(), extraRow.getPaddingLeft(), extraRow.getPaddingRight(), extraRow.getPaddingTop(), extraRow.getPaddingBottom());
            }
        }
        return 6;
    }

    private void registerColumnStyles() {
        PrintTableTag parent = (PrintTableTag)this.getParent(PrintTableTag.class);
        Column[] columns = parent.getVisibleColumns();
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            int columnIdx = column.getIndex();
            LayoutHints layoutHints = column.getLayoutHints();
            RowCellHolder rowCell = null;
            if (this.registeredRowCells != null) {
                rowCell = this.registeredRowCells[i];
            }
            String width = null;
            String height = this.getHeight();
            String valign = this.valign;
            String halign = null;
            if (columnIdx != -1) {
                switch (layoutHints.getAlign()) {
                    case 0: {
                        halign = "left";
                        break;
                    }
                    case 2: {
                        halign = "right";
                        break;
                    }
                    case 1: {
                        halign = "center";
                        break;
                    }
                    default: {
                        halign = "left";
                    }
                }
            }
            float paddingLeft = this.paddingLeft;
            float paddingRight = this.paddingRight;
            float paddingTop = this.paddingTop;
            float paddingBottom = this.paddingBottom;
            if (rowCell != null) {
                String tmpHalign;
                width = rowCell.getWidth();
                if (rowCell.getHeight() != null) {
                    height = rowCell.getHeight();
                }
                if (rowCell.getValign() != null) {
                    valign = rowCell.getValign();
                }
                if ((tmpHalign = rowCell.getHalign()) != null) {
                    halign = tmpHalign;
                }
                if (rowCell.getPaddingLeft() >= 0.0f) {
                    paddingLeft = rowCell.getPaddingLeft();
                }
                if (rowCell.getPaddingRight() >= 0.0f) {
                    paddingRight = rowCell.getPaddingRight();
                }
                if (rowCell.getPaddingTop() >= 0.0f) {
                    paddingTop = rowCell.getPaddingTop();
                }
                if (rowCell.getPaddingBottom() >= 0.0f) {
                    paddingBottom = rowCell.getPaddingBottom();
                }
            }
            if (width == null && layoutHints.getWidth() > 0.0f) {
                width = Integer.toString((int)layoutHints.getWidth()) + '%';
            }
            String styleAttributes = this.getStyleAttribute(width, height, halign, valign, paddingLeft, paddingRight, paddingTop, paddingBottom);
            ArrayList<MarkupAttribute> columnAttributes = new ArrayList<MarkupAttribute>();
            if (halign != null) {
                columnAttributes.add(new MarkupAttribute("align", halign));
            }
            if (valign != null) {
                columnAttributes.add(new MarkupAttribute("valign", valign));
            }
            if (width != null) {
                columnAttributes.add(new MarkupAttribute("width", width));
            }
            if (height != null) {
                columnAttributes.add(new MarkupAttribute("height", height));
            }
            if (!StringUtils.isEmpty(styleAttributes)) {
                columnAttributes.add(new MarkupAttribute("style", styleAttributes));
            }
            if (StringUtils.isEmpty(styleAttributes)) continue;
            parent.setColumnAttributes(column, columnAttributes);
        }
    }

    protected void outputRow() throws JspException {
        String rowStyle = this.alternateRowStyle();
        this.outputRow(this.registeredRowCells, rowStyle, this.height, this.valign, this.paddingLeft, this.paddingRight, this.paddingTop, this.paddingBottom);
    }

    protected void outputRow(RowCellHolder[] rowCells, String style, String height, String vAlign, float paddingLeft, float paddingRight, float paddingTop, float paddingBottom) throws JspException {
        block69: {
            try {
                boolean evenRow = this.isEvenRow();
                PrintTableTag parent = this.getRowContainer();
                String template = parent.getTemplate();
                if (BeanUtils.isEmpty(template)) {
                    JspWriter out = this.pageContext.getOut();
                    out.print("  <tr");
                    if (style != null) {
                        out.print(" class=\"" + style + "\"");
                    }
                    out.println(">");
                    parent.setEvenStyle(this.evenStyle);
                    parent.setOddStyle(this.oddStyle);
                    Row row = parent.getCurrentRow();
                    if (row == null) {
                        return;
                    }
                    Column[] columns = parent.getVisibleColumns();
                    for (int i = 0; i < columns.length; ++i) {
                        Column column = columns[i];
                        int columnIdx = column.getIndex();
                        LayoutHints layoutHints = column.getLayoutHints();
                        RowCellHolder rowCell = rowCells[i];
                        String width = null;
                        String cellHeight = height;
                        String cellStyle = style;
                        String evenStyle = this.evenStyle;
                        String oddStyle = this.oddStyle;
                        String valign = this.valign;
                        String halign = null;
                        if (columnIdx != -1) {
                            switch (row.getAlign(columnIdx)) {
                                case 0: {
                                    halign = "left";
                                    break;
                                }
                                case 2: {
                                    halign = "right";
                                    break;
                                }
                                case 1: {
                                    halign = "center";
                                    break;
                                }
                                default: {
                                    halign = "left";
                                }
                            }
                        }
                        float cellPaddingLeft = paddingLeft;
                        float cellPaddingRight = paddingRight;
                        float cellPaddingTop = paddingTop;
                        float cellPaddingBottom = paddingBottom;
                        String content = null;
                        int colspan = 1;
                        if (rowCell != null) {
                            String tmpHalign;
                            width = rowCell.getWidth();
                            if (rowCell.getHeight() != null) {
                                cellHeight = rowCell.getHeight();
                            }
                            if (rowCell.getStyle() != null) {
                                cellStyle = rowCell.getStyle();
                            }
                            if (rowCell.getEvenStyle() != null) {
                                evenStyle = rowCell.getEvenStyle();
                            }
                            if (rowCell.getOddStyle() != null) {
                                oddStyle = rowCell.getOddStyle();
                            }
                            if (rowCell.getValign() != null) {
                                valign = rowCell.getValign();
                            }
                            if ((tmpHalign = rowCell.getHalign()) != null) {
                                halign = tmpHalign;
                            }
                            if (rowCell.getPaddingLeft() >= 0.0f) {
                                cellPaddingLeft = rowCell.getPaddingLeft();
                            }
                            if (rowCell.getPaddingRight() >= 0.0f) {
                                cellPaddingRight = rowCell.getPaddingRight();
                            }
                            if (rowCell.getPaddingTop() >= 0.0f) {
                                cellPaddingTop = rowCell.getPaddingTop();
                            }
                            if (rowCell.getPaddingBottom() >= 0.0f) {
                                cellPaddingBottom = rowCell.getPaddingBottom();
                            }
                            if (rowCell.hasContent()) {
                                content = this.rowContainer.evalTemplate(rowCell.getContent());
                            }
                            if (rowCell.getColspan() > 0) {
                                colspan = rowCell.getColspan();
                            }
                            if (rowCell.isFillRow()) {
                                colspan = columns.length - i;
                            }
                        }
                        if (evenRow) {
                            if (evenStyle != null) {
                                cellStyle = evenStyle;
                            }
                        } else if (oddStyle != null) {
                            cellStyle = oddStyle;
                        }
                        if (width == null && layoutHints.getWidth() > 0.0f) {
                            width = Integer.toString((int)layoutHints.getWidth()) + '%';
                        }
                        if (content == null) {
                            if (columnIdx != -1 && row.isVisible(columnIdx)) {
                                content = row.getString(columnIdx);
                            } else {
                                content = parent.getDefaultContent(i);
                                if (content != null) {
                                    content = this.rowContainer.evalTemplate(content);
                                }
                            }
                        }
                        if (content == null) {
                            content = "&nbsp;";
                        }
                        out.print("    <td");
                        out.print(this.getCellAttributes(cellStyle, width, cellHeight, halign, valign, colspan, cellPaddingLeft, cellPaddingRight, cellPaddingTop, cellPaddingBottom));
                        out.print(">");
                        out.print(content);
                        out.println("</td>");
                        if (colspan <= 1) continue;
                        i += colspan - 1;
                    }
                    out.println("  </tr>");
                    break block69;
                }
                try {
                    this.setAttribute("_TABLE_ROW_STYLE", style);
                    this.setAttribute("_TABLE_ROW_HEIGHT", height);
                    ArrayList<CellData> actualCells = new ArrayList<CellData>();
                    Row row = parent.getCurrentRow();
                    if (row == null) {
                        return;
                    }
                    this.setAttribute("_TABLE_ROW_TYPE", row.getType());
                    Column[] columns = parent.getVisibleColumns();
                    for (int i = 0; i < columns.length; ++i) {
                        Column column = columns[i];
                        int columnIdx = column.getIndex();
                        boolean visible = true;
                        if (columnIdx >= 0) {
                            visible = row.isVisible(columnIdx);
                        }
                        String cellStyle = style;
                        LayoutHints layoutHints = column.getLayoutHints();
                        RowCellHolder rowCell = rowCells[i];
                        String width = null;
                        String cellHeight = height;
                        String valign = this.valign;
                        String halign = null;
                        if (columnIdx != -1) {
                            switch (row.getAlign(columnIdx)) {
                                case 0: {
                                    halign = "left";
                                    break;
                                }
                                case 2: {
                                    halign = "right";
                                    break;
                                }
                                case 1: {
                                    halign = "center";
                                    break;
                                }
                                default: {
                                    halign = "left";
                                }
                            }
                        }
                        float cellPaddingLeft = paddingLeft;
                        float cellPaddingRight = paddingRight;
                        float cellPaddingTop = paddingTop;
                        float cellPaddingBottom = paddingBottom;
                        Object content = null;
                        int colspan = 1;
                        if (rowCell != null) {
                            String tmpHalign;
                            visible = true;
                            width = rowCell.getWidth();
                            if (rowCell.getHeight() != null) {
                                cellHeight = rowCell.getHeight();
                            }
                            if (rowCell.getStyle() != null) {
                                cellStyle = rowCell.getStyle();
                            }
                            if (rowCell.getEvenStyle() != null && evenRow) {
                                cellStyle = rowCell.getEvenStyle();
                            }
                            if (rowCell.getOddStyle() != null && !evenRow) {
                                cellStyle = rowCell.getOddStyle();
                            }
                            if (rowCell.getValign() != null) {
                                valign = rowCell.getValign();
                            }
                            if ((tmpHalign = rowCell.getHalign()) != null) {
                                halign = tmpHalign;
                            }
                            if (rowCell.getPaddingLeft() >= 0.0f) {
                                cellPaddingLeft = rowCell.getPaddingLeft();
                            }
                            if (rowCell.getPaddingRight() >= 0.0f) {
                                cellPaddingRight = rowCell.getPaddingRight();
                            }
                            if (rowCell.getPaddingTop() >= 0.0f) {
                                cellPaddingTop = rowCell.getPaddingTop();
                            }
                            if (rowCell.getPaddingBottom() >= 0.0f) {
                                cellPaddingBottom = rowCell.getPaddingBottom();
                            }
                            if (rowCell.hasContent()) {
                                content = this.rowContainer.evalTemplate(rowCell.getContent());
                            }
                            if (rowCell.getColspan() > 0) {
                                colspan = rowCell.getColspan();
                            }
                            if (rowCell.isFillRow()) {
                                colspan = columns.length - i;
                            }
                        }
                        if (width == null && layoutHints.getWidth() > 0.0f) {
                            width = Integer.toString((int)layoutHints.getWidth());
                        }
                        if (content == null) {
                            content = parent.getDefaultContent(i);
                            if (!BeanUtils.isEmpty((String)content)) {
                                content = this.rowContainer.evalTemplate(content.toString());
                            } else if (columnIdx != -1 && row.isVisible(columnIdx)) {
                                content = row.getObject(columnIdx);
                            }
                        }
                        if (content == null) {
                            content = "&nbsp;";
                        }
                        CellData cellData = new CellData(column.getName(), content, colspan);
                        cellData.setVisible(visible);
                        cellData.setStyle(cellStyle);
                        cellData.setWidth(width);
                        cellData.setHeight(cellHeight);
                        cellData.setHalign(halign);
                        cellData.setValign(valign);
                        cellData.setPaddingLeft((int)cellPaddingLeft);
                        cellData.setPaddingRight((int)cellPaddingRight);
                        cellData.setPaddingTop((int)cellPaddingTop);
                        cellData.setPaddingBottom((int)cellPaddingBottom);
                        actualCells.add(cellData);
                        if (colspan <= 1) continue;
                        i += colspan - 1;
                    }
                    this.setAttribute("_TABLE_CELLS", actualCells);
                    this.pageContext.include(template + "-row.jsp");
                }
                catch (ServletException ex) {
                    throw new JspException("Failed to include template file '" + template + "-body.jsp'.");
                }
            }
            catch (IOException ex) {
                throw new JspException("Unable to print table row: " + ex.getMessage(), (Throwable)ex);
            }
            catch (TableException ex) {
                throw new JspException("Unable to print table row: " + ex.getMessage(), (Throwable)ex);
            }
            catch (ClassCastException ex) {
                throw new JspException("Type cast problem detected: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void release() {
        super.release();
        this.style = null;
        this.currentStyle = null;
        this.evenStyle = "even";
        this.oddStyle = "odd";
        this.height = null;
        this.valign = null;
        this.paddingLeft = 0.0f;
        this.paddingRight = 0.0f;
        this.paddingTop = 0.0f;
        this.paddingBottom = 0.0f;
        this.registeredRowCells = null;
        this.skipped = false;
        this.extraRowsBefore = null;
        this.extraRowsAfter = null;
    }

    protected PrintTableTag lookupRowContainer() {
        Tag parent = this.getParent(PrintTableTag.class);
        return (PrintTableTag)parent;
    }

    protected String alternateRowStyle() {
        String style = this.style;
        if (style != null) {
            return style;
        }
        boolean evenRow = this.isEvenRow();
        if (evenRow) {
            if (this.evenStyle != null) {
                style = this.evenStyle;
            }
        } else if (this.oddStyle != null) {
            style = this.oddStyle;
        }
        return style;
    }
}

