/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.web.tag;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.ujac.util.BeanUtils;
import org.ujac.util.CollectionUtils;
import org.ujac.util.StringUtils;
import org.ujac.util.UjacException;
import org.ujac.util.table.BeanTable;
import org.ujac.util.table.Column;
import org.ujac.util.table.ColumnNotDefinedException;
import org.ujac.util.table.DataTable;
import org.ujac.util.table.DefaultColumn;
import org.ujac.util.table.LayoutHints;
import org.ujac.util.table.Row;
import org.ujac.util.table.Table;
import org.ujac.util.template.TemplateContext;
import org.ujac.util.text.FormatHelper;
import org.ujac.web.tag.ForeachTag;
import org.ujac.web.tag.MarkupAttribute;

public class PrintTableTag
extends ForeachTag {
    public static final int DIRECTION_BEFORE = 1;
    public static final int DIRECTION_AFTER = 2;
    public static final String ATTRIBUTE_TABLE_ROW_STYLE = "_TABLE_ROW_STYLE";
    public static final String ATTRIBUTE_TABLE_ROW_TYPE = "_TABLE_ROW_TYPE";
    public static final String ATTRIBUTE_TABLE_ROW_HEIGHT = "_TABLE_ROW_HEIGHT";
    public static final String ATTRIBUTE_TABLE_CELLS = "_TABLE_CELLS";
    public static final String ATTRIBUTE_TABLE_WIDTH = "_TABLE_WIDTH";
    private String id = null;
    private String width = null;
    private String height = null;
    private int border = 0;
    private int cellpadding = 0;
    private int cellspacing = 0;
    private int levelFilter = -1;
    private String template = null;
    private Table table = null;
    private List columnList = new ArrayList();
    private List defaultCellContents = new ArrayList();
    private Map columnIndex = null;
    private Column[] columns = null;
    private float[] widths = null;
    private boolean headerPrinted = false;
    private boolean footerPrinted = false;
    private Map columnAttributeMaps = null;
    private Object oldTableWidth = null;
    private Object oldTableCells = null;
    private Object oldTableRowStyle = null;
    private Object oldTableRowHeight = null;
    private Object oldTableRowType = null;
    private boolean columnDefinitionsCleared = false;

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public int getCellpadding() {
        return this.cellpadding;
    }

    public void setCellpadding(int cellpadding) {
        this.cellpadding = cellpadding;
    }

    public int getCellspacing() {
        return this.cellspacing;
    }

    public void setCellspacing(int cellspacing) {
        this.cellspacing = cellspacing;
    }

    public int getLevelFilter() {
        return this.levelFilter;
    }

    public void setLevelFilter(int levelFilter) {
        this.levelFilter = levelFilter;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public boolean isHeaderPrinted() {
        return this.headerPrinted;
    }

    public void setHeaderPrinted(boolean headerPrinted) {
        this.headerPrinted = headerPrinted;
    }

    public boolean isFooterPrinted() {
        return this.footerPrinted;
    }

    public void setFooterPrinted(boolean footerPrinted) {
        this.footerPrinted = footerPrinted;
    }

    public Column[] getVisibleColumns() {
        if (this.columns == null) {
            FormatHelper formatHelper = this.getTemplateContext().getFormatHelper();
            int numColumns = this.columnList.size();
            this.columns = new Column[numColumns];
            this.widths = new float[numColumns];
            block7: for (int i = 0; i < numColumns; ++i) {
                Column column;
                this.columns[i] = column = (Column)this.columnList.get(i);
                this.widths[i] = column.getLayoutHints().getWidth();
                if (column.getFormat() != null) continue;
                switch (column.getType()) {
                    case 2: 
                    case 4: {
                        column.setFormat(formatHelper.getIntegerFormat());
                        continue block7;
                    }
                    case 5: 
                    case 6: {
                        column.setFormat(formatHelper.getDoubleFormat());
                        continue block7;
                    }
                    case 8: {
                        column.setFormat(formatHelper.getDateFormat());
                        continue block7;
                    }
                    case 9: {
                        column.setFormat(formatHelper.getTimeFormat());
                        continue block7;
                    }
                    case 10: {
                        column.setFormat(formatHelper.getTimestampFormat());
                    }
                }
            }
        }
        return this.columns;
    }

    protected int getNumColumns() {
        return this.columnList.size();
    }

    protected int getColumnIndex(String columnName) {
        Integer idx;
        Column[] columns = this.getVisibleColumns();
        int numColumns = columns.length;
        if (this.columnIndex == null) {
            this.columnIndex = new HashMap();
            for (int i = 0; i < numColumns; ++i) {
                Column col = columns[i];
                this.columnIndex.put(col.getName(), new Integer(i));
            }
        }
        if ((idx = (Integer)this.columnIndex.get(columnName)) == null) {
            return -1;
        }
        return idx;
    }

    protected String getDefaultContent(int idx) {
        return (String)this.defaultCellContents.get(idx);
    }

    public boolean isOutputStarted() {
        return this.columns != null;
    }

    public Table getTable() {
        return this.table;
    }

    public float[] getWidths() {
        return this.widths;
    }

    protected Row getCurrentRow() {
        return (Row)this.getCurrentValue();
    }

    protected Object evalSequenceHolder() throws UjacException {
        Object seqHolder = super.evalSequenceHolder();
        TemplateContext tctx = this.getTemplateContext();
        if (seqHolder instanceof Table) {
            this.table = (Table)seqHolder;
        } else if (seqHolder instanceof List) {
            FormatHelper formatHelper = tctx.getFormatHelper();
            List items = (List)seqHolder;
            this.table = CollectionUtils.isEmpty(items) ? new DataTable() : new BeanTable(formatHelper, items);
        } else {
            throw new UjacException("The sequence '" + this.getSequence() + "' doesn't evaluate to a table.");
        }
        return this.table;
    }

    public int doStartTag() throws JspException {
        super.doStartTag();
        this.columnIndex = null;
        this.columnAttributeMaps = null;
        this.headerPrinted = false;
        this.footerPrinted = false;
        this.columnDefinitionsCleared = false;
        this.setAttribute("_TABLE", this.table);
        this.setAttribute("_TABLE_COLUMNS", this.table);
        Column[] columns = this.table.getVisibleColumns(this.levelFilter);
        for (int i = 0; i < columns.length; ++i) {
            this.columnList.add(columns[i]);
            this.defaultCellContents.add(null);
        }
        this.oldTableRowStyle = this.getAttribute(ATTRIBUTE_TABLE_ROW_STYLE);
        this.oldTableRowHeight = this.getAttribute(ATTRIBUTE_TABLE_ROW_HEIGHT);
        this.oldTableRowType = this.getAttribute(ATTRIBUTE_TABLE_ROW_TYPE);
        this.oldTableCells = this.getAttribute(ATTRIBUTE_TABLE_CELLS);
        this.oldTableWidth = this.getAttribute(ATTRIBUTE_TABLE_WIDTH);
        try {
            PageContext ctx = this.getPageContext();
            if (BeanUtils.isEmpty(this.template)) {
                JspWriter out = ctx.getOut();
                out.print("<table border=\"" + this.border + "\" cellspacing=\"" + "" + this.cellspacing + "\" cellpadding=\"" + this.cellpadding + "\"");
                if (this.id != null) {
                    out.print(" id=\"" + this.id + "\"");
                }
                if (this.width != null) {
                    out.print(" width=\"" + this.width + "\"");
                }
                if (this.height != null) {
                    out.print(" height=\"" + this.height + "\"");
                }
                out.println(">");
            }
        }
        catch (IOException ex) {
            throw new JspException("Unable to print table head: " + ex.getMessage(), (Throwable)ex);
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        block11: {
            super.doEndTag();
            String evenStyle = this.getEvenStyle();
            String oddStyle = this.getOddStyle();
            try {
                Row row;
                PageContext ctx = this.getPageContext();
                if (BeanUtils.isEmpty(this.template)) {
                    JspWriter out = ctx.getOut();
                    out.println("  </tbody>");
                    out.println("</table>");
                    if (this.id != null) {
                        int i;
                        String capitalizedId = StringUtils.capitalize(this.id);
                        String tableVar = this.id;
                        String tableBodyVar = this.id + "Body";
                        Column[] columns = this.getVisibleColumns();
                        out.println("<script type=\"text/javascript\" language=\"JavaScript\"><!--");
                        out.print("var ");
                        out.print(tableVar);
                        out.println(" = null;");
                        out.print("var ");
                        out.print(tableBodyVar);
                        out.println(" = null;");
                        out.println();
                        out.print("function get");
                        out.print(capitalizedId);
                        out.println("() {");
                        out.print("  if (");
                        out.print(tableVar);
                        out.println(" == null) {");
                        out.print("    ");
                        out.print(tableVar);
                        out.print(" = document.getElementById('");
                        out.print(this.id);
                        out.println("');");
                        out.print("    ");
                        out.print(tableBodyVar);
                        out.print(" = ");
                        out.print(tableVar);
                        out.println(".getElementsByTagName('tbody').item(0);");
                        out.println("  }");
                        out.print("  return ");
                        out.print(tableVar);
                        out.println(";");
                        out.println("}");
                        out.println();
                        out.print("function add");
                        out.print(capitalizedId);
                        out.print("Row(");
                        for (i = 0; i < columns.length; ++i) {
                            if (i > 0) {
                                out.print(", ");
                            }
                            out.print(columns[i].getName());
                        }
                        out.println(") {");
                        out.print("  if (");
                        out.print(tableVar);
                        out.println(" == null) {");
                        out.print("    get");
                        out.print(capitalizedId);
                        out.println("();");
                        out.println("  }");
                        out.print("  var tableBody = ");
                        out.print(tableBodyVar);
                        out.println(";");
                        out.println("  var rows = tableBody.rows;");
                        out.println("  var td = null;");
                        out.println("  var tr = document.createElement('tr');");
                        out.println("  if (rows.length % 2 == 0) {");
                        out.print("    tr.setAttribute('class', '");
                        out.print(evenStyle);
                        out.println("');");
                        out.println("  } else {");
                        out.print("    tr.setAttribute('class', '");
                        out.print(oddStyle);
                        out.println("');");
                        out.println("  }");
                        for (i = 0; i < columns.length; ++i) {
                            Column col = columns[i];
                            String colName = col.getName();
                            out.println("  td = document.createElement('td');");
                            out.print("  if (");
                            out.print(colName);
                            out.print(" instanceof Element)");
                            out.print(" td.appendChild(");
                            out.print(colName);
                            out.print("); else td.appendChild(document.createTextNode(");
                            out.print(colName);
                            out.println("));");
                            List colAttrs = (List)this.columnAttributeMaps.get(colName);
                            if (colAttrs != null) {
                                int numColAttrs = colAttrs.size();
                                for (int j = 0; j < numColAttrs; ++j) {
                                    MarkupAttribute attr = (MarkupAttribute)colAttrs.get(j);
                                    out.print("  td.setAttribute('");
                                    out.print(attr.getName());
                                    out.print("', '");
                                    out.print(attr.getValue());
                                    out.println("');");
                                }
                            }
                            out.println("  tr.appendChild(td);");
                        }
                        out.println("  tableBody.appendChild(tr);");
                        out.print("}");
                        out.println("//-->");
                        out.println("</script>");
                    }
                    break block11;
                }
                if (this.isFooterPrinted() || (row = this.getCurrentRow()) != null && "footer".equals(row.getType())) break block11;
                try {
                    ctx.include(this.template + "-footer.jsp");
                }
                catch (ServletException ex) {
                    throw new JspException("Failed to include template file '" + this.template + "-footer.jsp'.");
                }
            }
            catch (IOException ex) {
                throw new JspException("Unable to print closing table tag: " + ex.getMessage(), (Throwable)ex);
            }
        }
        this.release();
        this.setAttribute(ATTRIBUTE_TABLE_ROW_STYLE, this.oldTableRowStyle);
        this.setAttribute(ATTRIBUTE_TABLE_ROW_HEIGHT, this.oldTableRowHeight);
        this.setAttribute(ATTRIBUTE_TABLE_ROW_TYPE, this.oldTableRowType);
        this.setAttribute(ATTRIBUTE_TABLE_CELLS, this.oldTableCells);
        this.setAttribute(ATTRIBUTE_TABLE_WIDTH, this.oldTableWidth);
        return 6;
    }

    public void release() {
        super.release();
        this.columnList.clear();
        this.defaultCellContents.clear();
        this.id = null;
        this.width = null;
        this.columns = null;
        this.headerPrinted = false;
        this.border = 0;
        this.template = null;
        this.columnDefinitionsCleared = false;
    }

    public void defineColumn(String name, float width, int hAlign, String title, String defaultContents) throws JspException {
        if (this.columns != null) {
            return;
        }
        if (!this.columnDefinitionsCleared) {
            this.columnList.clear();
            this.defaultCellContents.clear();
            this.columnDefinitionsCleared = true;
        }
        int numColumns = this.columnList.size();
        Column col = null;
        try {
            col = this.table.getColumn(name);
        }
        catch (ColumnNotDefinedException ex) {
            // empty catch block
        }
        if (col != null) {
            LayoutHints lh = col.getLayoutHints();
            if (lh != null) {
                lh.setWidth(width);
                lh.setHeader(title);
                lh.setHeaderAlign(hAlign);
                lh.setVisible(true);
            } else {
                col.setLayoutHints(new LayoutHints(width, title, hAlign));
            }
            for (int i = 0; i < numColumns; ++i) {
                Column tmpCol = (Column)this.columnList.get(i);
                if (!tmpCol.getName().equals(name)) continue;
                this.defaultCellContents.set(i, defaultContents);
                return;
            }
            this.columnList.add(col);
            this.defaultCellContents.add(defaultContents);
            return;
        }
        DummyColumn newCol = new DummyColumn(name);
        newCol.setLayoutHints(new LayoutHints(width, title, hAlign));
        this.columnList.add(newCol);
        this.defaultCellContents.add(defaultContents);
    }

    public void insertColumn(String name, float width, int hAlign, String title, String reference, int direction, String defaultContents) throws JspException {
        if (this.columns != null) {
            return;
        }
        int numColumns = this.columnList.size();
        int coldx = -1;
        int referenceIdx = -1;
        if (reference != null) {
            for (int i = 0; i < numColumns; ++i) {
                Column col = (Column)this.columnList.get(i);
                if (col.getName().equals(name)) {
                    coldx = i;
                    if (referenceIdx != -1) break;
                }
                if (!col.getName().equals(reference)) continue;
                referenceIdx = i;
                if (coldx != -1) break;
            }
            if (coldx != -1) {
                Column col = (Column)this.columnList.get(coldx);
                col.setLayoutHints(new LayoutHints(width, title, hAlign));
                return;
            }
            if (referenceIdx == -1) {
                throw new JspException("The column name '" + reference + "' does not exist.");
            }
            if (direction == 2) {
                ++referenceIdx;
            }
        } else {
            referenceIdx = direction == 2 ? numColumns : 0;
        }
        Column col = null;
        try {
            col = this.table.getColumn(name);
        }
        catch (ColumnNotDefinedException ex) {
            // empty catch block
        }
        if (col != null) {
            LayoutHints lh = col.getLayoutHints();
            if (lh != null) {
                lh.setWidth(width);
                lh.setHeader(title);
                lh.setHeaderAlign(hAlign);
                lh.setVisible(true);
            } else {
                col.setLayoutHints(new LayoutHints(width, title, hAlign));
            }
            for (int i = 0; i < numColumns; ++i) {
                Column tmpCol = (Column)this.columnList.get(i);
                if (!tmpCol.getName().equals(name)) continue;
                this.defaultCellContents.set(i, defaultContents);
                return;
            }
            this.columnList.add(col);
            this.defaultCellContents.add(defaultContents);
            return;
        }
        DummyColumn newCol = new DummyColumn(name);
        newCol.setLayoutHints(new LayoutHints(width, title, hAlign));
        if (referenceIdx >= numColumns) {
            this.columnList.add(newCol);
            this.defaultCellContents.add(defaultContents);
        } else {
            this.columnList.add(referenceIdx, newCol);
            this.defaultCellContents.add(referenceIdx, defaultContents);
        }
    }

    public void alterColumn(String name, float width, int hAlign, String title) throws JspException {
        if (this.columns != null) {
            return;
        }
        int numColumns = this.columnList.size();
        int coldx = -1;
        for (int i = 0; i < numColumns; ++i) {
            Column col = (Column)this.columnList.get(i);
            if (!col.getName().equals(name)) continue;
            coldx = i;
            LayoutHints layoutHints = col.getLayoutHints();
            if (layoutHints == null) {
                layoutHints = new LayoutHints();
                col.setLayoutHints(layoutHints);
            }
            if ((double)width >= 0.0) {
                layoutHints.setWidth(width);
            }
            if (hAlign >= 0) {
                layoutHints.setAlign(hAlign);
            }
            if (title == null) break;
            layoutHints.setHeader(title);
            break;
        }
        if (coldx < 0) {
            throw new JspException("The column name '" + name + "' is undefined.");
        }
    }

    public void removeColumn(String name) throws JspException {
        if (this.columns != null) {
            return;
        }
        int numColumns = this.columnList.size();
        for (int i = 0; i < numColumns; ++i) {
            Column col = (Column)this.columnList.get(i);
            if (!col.getName().equals(name)) continue;
            this.columnList.remove(i);
            return;
        }
        throw new JspException("The column name '" + name + "', which was requested to remove, does not exist.");
    }

    protected boolean isColumnStylesDefined() {
        return this.columnAttributeMaps != null;
    }

    protected void setColumnAttributes(Column column, List columnAttributes) {
        if (this.columnAttributeMaps == null) {
            this.columnAttributeMaps = new HashMap();
        }
        this.columnAttributeMaps.put(column.getName(), columnAttributes);
    }

    public class DummyColumn
    extends DefaultColumn {
        private static final long serialVersionUID = 3618696418123134000L;

        protected DummyColumn(String name) {
            super(null, name, -1);
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            this.writeData(s);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            this.readData(s);
        }
    }
}

