/*
 * Decompiled with CFR 0.152.
 */
package er.restadaptor;

import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EOAdaptorContext;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOGeneralAdaptorException;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOStoredProcedure;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOOrQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation.NSTimestampFormatter;
import er.extensions.foundation.ERXMutableURL;
import er.extensions.localization.ERXLocalizer;
import er.restadaptor.ERRESTAdaptorContext;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERRESTAdaptorChannel
extends EOAdaptorChannel {
    private static final NSTimestampFormatter restDateFormat = new NSTimestampFormatter("%Y-%m-%dT%H:%M:%SZ");
    private NSArray<EOAttribute> _attributes;
    private NSMutableArray<NSMutableDictionary<String, Object>> _fetchedRows;
    private int _fetchIndex = -1;
    private boolean _open;

    public ERRESTAdaptorChannel(ERRESTAdaptorContext context) {
        super((EOAdaptorContext)context);
    }

    public ERRESTAdaptorContext context() {
        return (ERRESTAdaptorContext)this._context;
    }

    public NSArray<EOAttribute> attributesToFetch() {
        return this._attributes;
    }

    public void cancelFetch() {
        this._fetchedRows = null;
        this._fetchIndex = -1;
    }

    public void closeChannel() {
        this._open = false;
    }

    public NSArray describeResults() {
        return this._attributes;
    }

    public NSArray describeTableNames() {
        return NSArray.EmptyArray;
    }

    public EOModel describeModelWithTableNames(NSArray anArray) {
        return null;
    }

    public void evaluateExpression(EOSQLExpression anExpression) {
        throw new UnsupportedOperationException("ERRESTAdaptorChannel.evaluateExpression");
    }

    public void executeStoredProcedure(EOStoredProcedure aStoredProcedure, NSDictionary someValues) {
        throw new UnsupportedOperationException("ERRESTAdaptorChannel.executeStoredProcedure");
    }

    public NSMutableDictionary fetchRow() {
        NSMutableDictionary row = null;
        if (this._fetchedRows != null && this._fetchIndex < this._fetchedRows.count()) {
            row = (NSMutableDictionary)this._fetchedRows.objectAtIndex(this._fetchIndex++);
        }
        return row;
    }

    public boolean isFetchInProgress() {
        return this._fetchedRows != null && this._fetchIndex < this._fetchedRows.count();
    }

    public boolean isOpen() {
        return this._open;
    }

    public void openChannel() {
        if (!this._open) {
            this._open = true;
        }
    }

    public NSDictionary returnValuesForLastStoredProcedureInvocation() {
        throw new UnsupportedOperationException("ERRESTAdaptorChannel.returnValuesForLastStoredProcedureInvocation");
    }

    public NSArray<String> urlPrefixes(EOEntity entity) {
        String[] externalNames;
        String urlPrefix = null;
        String externalName = entity.externalName();
        if (externalName != null && (externalNames = externalName.split(",")).length > 0 && externalNames[0].contains("/")) {
            urlPrefix = externalNames[0];
        }
        if (urlPrefix == null) {
            urlPrefix = "/" + this.pluralName(entity);
        }
        return new NSArray((Object[])urlPrefix.split("\\|"));
    }

    public String pluralName(EOEntity entity) {
        String[] externalNames;
        String pluralName = null;
        String externalName = entity.externalName();
        if (externalName != null && (externalNames = externalName.split(",")).length > 0) {
            if (externalNames[0].contains("/")) {
                if (externalNames.length > 2) {
                    pluralName = externalNames[2];
                }
            } else if (externalNames.length > 1) {
                pluralName = externalNames[1];
            }
        }
        if (pluralName == null) {
            pluralName = ERXLocalizer.defaultLocalizer().plurifiedString(this.singularName(entity), 2);
        }
        return pluralName;
    }

    public String singularName(EOEntity entity) {
        String[] externalNames;
        String singularName = null;
        String externalName = entity.externalName();
        if (externalName != null && (externalNames = externalName.split(",")).length > 0) {
            if (externalNames[0].contains("/")) {
                if (externalNames.length > 1) {
                    singularName = externalNames[1];
                }
            } else {
                singularName = externalNames[0];
            }
        }
        if (singularName == null) {
            singularName = entity.name();
        }
        return singularName;
    }

    public String textValue(Element element) {
        NodeList children = element.getChildNodes();
        String textValue = null;
        for (int i = 0; i < children.getLength(); ++i) {
            String value = children.item(i).getNodeValue();
            if (value == null) continue;
            textValue = value = value.trim();
            break;
        }
        return textValue;
    }

    public Object convertValue(String strValue, EOAttribute attribute) {
        return strValue;
    }

    public String urlForQualifier(EOEntity entity, EOQualifier qualifier, NSMutableDictionary<String, Object> attributesFromQualifier) {
        StringBuffer urlBuffer = new StringBuffer();
        NSDictionary connectionDictionary = this.adaptorContext().adaptor().connectionDictionary();
        String url = (String)connectionDictionary.objectForKey((Object)"URL");
        if (url == null || url.length() == 0) {
            throw new IllegalArgumentException("There is no URL specified for the connection dictionary " + connectionDictionary + ".");
        }
        if (url.endsWith("/")) {
            urlBuffer.append(url.substring(0, url.length() - 1));
        } else {
            urlBuffer.append(url);
        }
        NSArray<String> urlPrefixes = this.urlPrefixes(entity);
        if (urlPrefixes.count() == 1) {
            urlBuffer.append((String)urlPrefixes.objectAtIndex(0));
        } else {
            String bestUrlPrefix = null;
            int bestMatchCount = 0;
            NSSet qualifierKeys = qualifier.allQualifierKeys();
            for (String urlPrefix : urlPrefixes) {
                NSSet<String> urlVariableNames = this.variableNamesForUrl(urlPrefix);
                if (urlVariableNames.count() < bestMatchCount || !urlVariableNames.isSubsetOfSet(qualifierKeys)) continue;
                bestUrlPrefix = urlPrefix;
                bestMatchCount = urlVariableNames.count();
            }
            if (bestUrlPrefix == null) {
                throw new IllegalArgumentException("The qualifier " + qualifier + " was insufficient to fetch " + entity.name() + " objects with one of the URLs " + urlPrefixes + ".");
            }
            urlBuffer.append(bestUrlPrefix);
        }
        if (qualifier != null) {
            this.processQualifier(entity, qualifier, urlBuffer, attributesFromQualifier);
        }
        urlBuffer.append(".xml");
        System.out.println("ERRESTAdaptorChannel.urlForQualifier: " + urlBuffer);
        return urlBuffer.toString();
    }

    protected NSSet<String> variableNamesForUrl(String url) {
        NSMutableSet variableNames = new NSMutableSet();
        Matcher matcher = Pattern.compile("\\[([^]]+)\\]").matcher(url);
        while (matcher.find()) {
            variableNames.addObject((Object)matcher.group(1));
        }
        return variableNames;
    }

    protected void processQualifier(EOEntity entity, EOQualifier qualifier, StringBuffer urlBuffer, NSMutableDictionary<String, Object> attributesFromQualifier) {
        NSArray childQualifiers;
        if (qualifier instanceof EOKeyValueQualifier) {
            EOKeyValueQualifier eokvq = (EOKeyValueQualifier)qualifier;
            String key = eokvq.key();
            Object value = eokvq.value();
            EOAttribute keyAttribute = entity.attributeNamed(key);
            if (entity.primaryKeyAttributes().containsObject((Object)keyAttribute)) {
                urlBuffer.append("/");
                urlBuffer.append(value);
            } else {
                String var = "[" + key + "]";
                int varIndex = urlBuffer.indexOf(var);
                if (varIndex != -1) {
                    urlBuffer.replace(varIndex, varIndex + var.length(), value.toString());
                }
            }
            if (value != null) {
                attributesFromQualifier.setObjectForKey(value, (Object)key);
            }
        } else if (qualifier instanceof EOAndQualifier) {
            NSArray childQualifiers2 = ((EOAndQualifier)qualifier).qualifiers();
            for (EOQualifier childQualifier : childQualifiers2) {
                this.processQualifier(entity, childQualifier, urlBuffer, attributesFromQualifier);
            }
        } else if (qualifier instanceof EOOrQualifier && (childQualifiers = ((EOOrQualifier)qualifier).qualifiers()).count() == 1) {
            this.processQualifier(entity, (EOQualifier)childQualifiers.objectAtIndex(0), urlBuffer, attributesFromQualifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void selectAttributes(NSArray attributesToFetch, EOFetchSpecification fetchSpecification, boolean shouldLock, EOEntity entity) {
        if (entity == null) {
            throw new IllegalArgumentException("null entity.");
        }
        if (attributesToFetch == null) {
            throw new IllegalArgumentException("null attributes.");
        }
        this.setAttributesToFetch(attributesToFetch);
        try {
            Document document;
            this._fetchIndex = 0;
            NSMutableDictionary attributesFromQualifier = new NSMutableDictionary();
            ERXMutableURL url = new ERXMutableURL(this.urlForQualifier(entity, fetchSpecification.qualifier(), (NSMutableDictionary<String, Object>)attributesFromQualifier));
            BufferedInputStream urlStream = new BufferedInputStream(url.toURL().openStream());
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(urlStream);
            }
            finally {
                ((InputStream)urlStream).close();
            }
            document.normalize();
            this._fetchedRows = new NSMutableArray();
            NodeList rowElements = document.getElementsByTagName(this.singularName(entity));
            for (int rowNum = 0; rowNum < rowElements.getLength(); ++rowNum) {
                EOQualifier qualifier;
                NSMutableDictionary row = new NSMutableDictionary();
                Element rowElement = (Element)rowElements.item(rowNum);
                for (int attributeNum = 0; attributeNum < attributesToFetch.count(); ++attributeNum) {
                    Object value;
                    EOAttribute attribute = (EOAttribute)attributesToFetch.objectAtIndex(attributeNum);
                    String columnName = attribute.columnName();
                    NodeList attributeElements = rowElement.getElementsByTagName(columnName);
                    if (attributeElements.getLength() == 0) {
                        if (rowElement.hasAttribute(columnName)) {
                            Attr columnAttribute = rowElement.getAttributeNode(columnName);
                            value = this.convertValue(columnAttribute.getValue(), attribute);
                        } else {
                            value = null;
                        }
                    } else {
                        if (attributeElements.getLength() > 1) {
                            throw new EOGeneralAdaptorException("There was more than one column named '" + columnName + "'.");
                        }
                        Element attributeElement = (Element)attributeElements.item(0);
                        if ("true".equals(attributeElement.getAttribute("nil"))) {
                            value = null;
                        } else {
                            String strValue = this.textValue(attributeElement);
                            if (attributeElement.hasAttribute("type")) {
                                String type = attributeElement.getAttribute("type");
                                if ("bigit".equals(type)) {
                                    value = new BigDecimal(strValue);
                                } else if ("boolean".equals(type)) {
                                    value = Boolean.parseBoolean(strValue);
                                } else if ("datetime".equals(type)) {
                                    value = restDateFormat.parseObject(strValue);
                                } else if ("double".equals(type)) {
                                    value = Double.parseDouble(strValue);
                                } else if ("float".equals(type)) {
                                    value = Float.valueOf(Float.parseFloat(strValue));
                                } else if ("integer".equals(type)) {
                                    value = Integer.parseInt(strValue);
                                } else {
                                    if (!"short".equals(type)) throw new IllegalArgumentException("Unknown type '" + type + "'.");
                                    value = Short.parseShort(strValue);
                                }
                            } else {
                                value = this.convertValue(strValue, attribute);
                            }
                        }
                    }
                    if (value == null) continue;
                    row.setObjectForKey(value, (Object)attribute.name());
                }
                if (attributesFromQualifier.count() > 0) {
                    for (String qualifierAttributeName : attributesFromQualifier.allKeys()) {
                        EOAttribute qualifierAttribute;
                        if (row.containsKey((Object)qualifierAttributeName) || (qualifierAttribute = entity.attributeNamed(qualifierAttributeName)) == null || !attributesToFetch.containsObject((Object)qualifierAttribute)) continue;
                        row.setObjectForKey(attributesFromQualifier.objectForKey((Object)qualifierAttributeName), (Object)qualifierAttributeName);
                    }
                }
                if ((qualifier = fetchSpecification.qualifier()) == null || qualifier.evaluateWithObject((Object)row)) {
                    this._fetchedRows.addObject((Object)row);
                    continue;
                }
                System.out.println("ERRESTAdaptorChannel.selectAttributes: skipping " + row + " (" + qualifier + ")");
            }
            return;
        }
        catch (EOGeneralAdaptorException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new EOGeneralAdaptorException("Failed to fetch '" + entity.name() + "' with fetch specification '" + fetchSpecification + "': " + e.getMessage());
        }
    }

    public void setAttributesToFetch(NSArray attributesToFetch) {
        if (attributesToFetch == null) {
            throw new IllegalArgumentException("ERMemoryAdaptorChannel.setAttributesToFetch: null attributes.");
        }
        this._attributes = attributesToFetch;
    }

    public int updateValuesInRowsDescribedByQualifier(NSDictionary updatedRow, EOQualifier qualifier, EOEntity entity) {
        try {
            throw new EOGeneralAdaptorException("ERRESTAdaptorChannel.updateValuesInRowsDescribedByQualifier not supported.");
        }
        catch (EOGeneralAdaptorException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new EOGeneralAdaptorException("Failed to update '" + entity.name() + "' row " + updatedRow + " with qualifier " + qualifier + ": " + e.getMessage());
        }
    }

    public void insertRow(NSDictionary row, EOEntity entity) {
        try {
            throw new EOGeneralAdaptorException("ERRESTAdaptorChannel.insertRow not supported.");
        }
        catch (EOGeneralAdaptorException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new EOGeneralAdaptorException("Failed to insert '" + entity.name() + "' with row " + row + ": " + e.getMessage());
        }
    }

    public int deleteRowsDescribedByQualifier(EOQualifier qualifier, EOEntity entity) {
        try {
            throw new EOGeneralAdaptorException("ERRESTAdaptorChannel.deleteRowsDescribedByQualifier not supported.");
        }
        catch (EOGeneralAdaptorException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new EOGeneralAdaptorException("Failed to delete '" + entity.name() + "' with qualifier " + qualifier + ": " + e.getMessage());
        }
    }
}

