/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WODynamicElementCreationException;
import com.webobjects.appserver._private.WODynamicGroup;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import er.ajax.AjaxUpdateLink;
import er.ajax.AjaxUtils;
import er.extensions.appserver.ERXWOContext;
import er.extensions.eof.ERXEOControlUtilities;

public class AjaxHighlight
extends WODynamicGroup {
    private static final String HIGHLIGHTED_KEY = "er.ajax.AjaxHighlight.highlighted";
    private NSDictionary _associations;
    private WOAssociation _value;
    private WOAssociation _id;
    private WOAssociation _elementName;
    private WOAssociation _effect;
    private WOAssociation _duration;
    private WOAssociation _newEffect;
    private WOAssociation _newDuration;
    private WOAssociation _updateEffect;
    private WOAssociation _updateDuration;
    private WOAssociation _hidden;
    private WOAssociation _newHidden;
    private WOAssociation _updateHidden;
    private WOAssociation _delay;
    private WOAssociation _showEffect;
    private WOAssociation _showDuration;
    private WOAssociation _hideDelay;
    private WOAssociation _hideEffect;
    private WOAssociation _hideDuration;

    public AjaxHighlight(String name, NSDictionary associations, WOElement template) {
        super(name, associations, template);
        this._associations = associations;
        this._value = (WOAssociation)associations.valueForKey("value");
        if (this._value == null) {
            throw new WODynamicElementCreationException("'value' is a required binding.");
        }
        this._elementName = (WOAssociation)associations.valueForKey("elementName");
        this._id = (WOAssociation)associations.valueForKey("id");
        this._effect = (WOAssociation)associations.valueForKey("effect");
        this._duration = (WOAssociation)associations.valueForKey("duration");
        this._newEffect = (WOAssociation)associations.valueForKey("newEffect");
        this._newDuration = (WOAssociation)associations.valueForKey("newDuration");
        this._updateEffect = (WOAssociation)associations.valueForKey("updateEffect");
        this._updateDuration = (WOAssociation)associations.valueForKey("updateDuration");
        this._hidden = (WOAssociation)associations.valueForKey("hidden");
        this._newHidden = (WOAssociation)associations.valueForKey("newHidden");
        this._updateHidden = (WOAssociation)associations.valueForKey("updateHidden");
        this._delay = (WOAssociation)associations.valueForKey("delay");
        this._showEffect = (WOAssociation)associations.valueForKey("showEffect");
        this._showDuration = (WOAssociation)associations.valueForKey("showDuration");
        this._hideDelay = (WOAssociation)associations.valueForKey("hideDelay");
        this._hideDuration = (WOAssociation)associations.valueForKey("hideDuration");
        this._hideEffect = (WOAssociation)associations.valueForKey("hideEffect");
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        String effect;
        Object value;
        AjaxUtils.addScriptResourceInHead(context, response, "prototype.js");
        AjaxUtils.addScriptResourceInHead(context, response, "effects.js");
        AjaxUtils.addScriptResourceInHead(context, response, "wonder.js");
        WOComponent component = context.component();
        boolean generateContainer = this._id == null || this._elementName != null;
        String elementName = this._elementName == null ? "div" : (String)this._elementName.valueInComponent(component);
        String id = this._id == null ? ERXWOContext.safeIdentifierName((WOContext)context, (boolean)false) : (String)this._id.valueInComponent(component);
        HighlightMetadata metadata = null;
        if (this._value != null && (value = this._value.valueInComponent(component)) != null) {
            metadata = AjaxHighlight.highlightMetadataForObject(value);
        }
        if (generateContainer) {
            response.appendContentString("<");
            response.appendContentString(elementName);
            response._appendTagAttributeAndValue("id", id, true);
            AjaxUtils.appendTagAttributeAndValue(response, context, component, this._associations, "class");
            String displayStyle = null;
            if (metadata != null) {
                boolean hidden = false;
                if (metadata.isNew() && this._newHidden != null) {
                    hidden = this._newHidden.booleanValueInComponent(component);
                } else if (!metadata.isNew() && this._updateHidden != null) {
                    hidden = this._updateHidden.booleanValueInComponent(component);
                } else if (this._hidden != null) {
                    hidden = this._hidden.booleanValueInComponent(component);
                }
                if (hidden) {
                    displayStyle = "display: none;";
                }
            }
            AjaxUtils.appendTagAttributeAndValue(response, context, component, this._associations, "style", displayStyle);
            AjaxUtils.appendTagAttributeAndValue(response, context, component, this._associations, "onMouseOver");
            AjaxUtils.appendTagAttributeAndValue(response, context, component, this._associations, "onMouseOut");
            response.appendContentString(">");
        }
        super.appendToResponse(response, context);
        if (generateContainer) {
            response.appendContentString("</");
            response.appendContentString(elementName);
            response.appendContentString(">");
        }
        if (metadata != null && !"none".equalsIgnoreCase(effect = metadata.isNew() && this._newEffect != null ? (String)this._newEffect.valueInComponent(component) : (!metadata.isNew() && this._updateEffect != null ? (String)this._updateEffect.valueInComponent(component) : (this._effect != null ? (String)this._effect.valueInComponent(component) : "Highlight")))) {
            AjaxUtils.appendScriptHeader(response);
            Object duration = null;
            if (metadata.isNew() && this._newDuration != null) {
                duration = this._newDuration.valueInComponent(component);
            } else if (!metadata.isNew() && this._updateDuration != null) {
                duration = this._updateDuration.valueInComponent(component);
            } else if (this._duration != null) {
                duration = this._duration.valueInComponent(component);
            }
            Object delay = this._delay == null ? null : this._delay.valueInComponent(component);
            String effectName = AjaxUpdateLink.fullEffectName(effect);
            Object showDuration = this._showDuration == null ? null : this._showDuration.valueInComponent(component);
            String showEffectName = this._showEffect == null ? null : AjaxUpdateLink.fullEffectName((String)this._showEffect.valueInComponent(component));
            Object hideDelay = this._hideDelay == null ? null : this._hideDelay.valueInComponent(component);
            Object hideDuration = this._hideDuration == null ? null : this._hideDuration.valueInComponent(component);
            String hideEffectName = this._hideEffect == null ? null : AjaxUpdateLink.fullEffectName((String)this._hideEffect.valueInComponent(component));
            response.appendContentString("AH.highlight(" + AjaxUtils.quote(id) + "," + delay + "," + AjaxUtils.quote(showEffectName) + "," + showDuration + "," + AjaxUtils.quote(effectName) + "," + duration + "," + hideDelay + "," + AjaxUtils.quote(hideEffectName) + "," + hideDuration + ");");
            AjaxUtils.appendScriptFooter(response);
        }
    }

    protected static Object highlightedValue(Object obj) {
        Object highlightedValue = ERXEOControlUtilities.convertEOtoGID((Object)obj);
        return highlightedValue;
    }

    public static HighlightMetadata highlightMetadataForObject(Object obj) {
        NSMutableDictionary highlightedObjects;
        HighlightMetadata metadata = null;
        if (obj != null && (highlightedObjects = (NSMutableDictionary)ERXWOContext.contextDictionary().valueForKey(HIGHLIGHTED_KEY)) != null) {
            metadata = (HighlightMetadata)highlightedObjects.objectForKey(AjaxHighlight.highlightedValue(obj));
        }
        return metadata;
    }

    public static final void highlight(Object obj) {
        AjaxHighlight.highlightUpdate(obj);
    }

    public static final void highlightNew(Object obj) {
        AjaxHighlight.highlight(obj, true);
    }

    public static final void highlightUpdate(Object obj) {
        AjaxHighlight.highlight(obj, false);
    }

    public static final void highlight(Object obj, boolean isNew) {
        if (obj != null) {
            NSMutableDictionary highlightedObjects = (NSMutableDictionary)ERXWOContext.contextDictionary().valueForKey(HIGHLIGHTED_KEY);
            if (highlightedObjects == null) {
                highlightedObjects = new NSMutableDictionary();
                ERXWOContext.contextDictionary().takeValueForKey((Object)highlightedObjects, HIGHLIGHTED_KEY);
            }
            highlightedObjects.setObjectForKey((Object)new HighlightMetadata(isNew), AjaxHighlight.highlightedValue(obj));
        }
    }

    protected static class HighlightMetadata {
        private boolean _new;

        public HighlightMetadata(boolean isNew) {
            this._new = isNew;
        }

        public boolean isNew() {
            return this._new;
        }
    }
}

