/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.ajax.AjaxDynamicElement;
import er.ajax.AjaxOption;
import er.ajax.AjaxOptions;
import er.ajax.AjaxResponse;
import er.ajax.AjaxSubmitButton;
import er.ajax.AjaxUpdateContainer;
import er.ajax.AjaxUtils;
import er.extensions.appserver.ERXWOContext;
import er.extensions.appserver.ajax.ERXAjaxApplication;

public class AjaxObserveField
extends AjaxDynamicElement {
    public AjaxObserveField(String name, NSDictionary associations, WOElement children) {
        super(name, associations, children);
    }

    protected void addRequiredWebResources(WOResponse response, WOContext context) {
        this.addScriptResourceInHead(context, response, "prototype.js");
        this.addScriptResourceInHead(context, response, "wonder.js");
    }

    public NSMutableDictionary createAjaxOptions(WOComponent component) {
        NSMutableArray ajaxOptionsArray = new NSMutableArray();
        ajaxOptionsArray.addObject((Object)new AjaxOption("observeFieldFrequency", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("observeDelay", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onCreate", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onLoading", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onComplete", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onBeforeSubmit", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onSuccess", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onFailure", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onException", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("insertion", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("evalScripts", AjaxOption.BOOLEAN));
        NSMutableDictionary<String, String> options = AjaxOption.createAjaxOptionsDictionary((NSArray<AjaxOption>)ajaxOptionsArray, component, (NSDictionary<String, ? extends WOAssociation>)this.associations());
        return options;
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        boolean observeFieldDescendents;
        super.appendToResponse(response, context);
        WOComponent component = context.component();
        String observeFieldID = (String)this.valueForBinding("observeFieldID", component);
        String updateContainerID = AjaxUpdateContainer.updateContainerID(this, component);
        NSMutableDictionary options = this.createAjaxOptions(component);
        boolean fullSubmit = this.booleanValueForBinding("fullSubmit", false, component);
        if (observeFieldID != null) {
            observeFieldDescendents = false;
        } else {
            String style;
            String elementName;
            observeFieldDescendents = true;
            observeFieldID = (String)this.valueForBinding("id", component);
            if (observeFieldID == null) {
                observeFieldID = ERXWOContext.safeIdentifierName((WOContext)context, (boolean)false);
            }
            if ((elementName = (String)this.valueForBinding("elementName", component)) == null) {
                elementName = "div";
            }
            response.appendContentString("<" + elementName + " id = \"" + observeFieldID + "\"");
            String className = this.stringValueForBinding("class", component);
            if (className != null && className.length() > 0) {
                response.appendContentString(" class=\"" + className + "\"");
            }
            if ((style = this.stringValueForBinding("style", component)) != null && style.length() > 0) {
                response.appendContentString(" style=\"" + style + "\"");
            }
            response.appendContentString(">");
            if (this.hasChildrenElements()) {
                this.appendChildrenToResponse(response, context);
            }
            response.appendContentString("</" + elementName + ">");
        }
        AjaxUtils.appendScriptHeader(response);
        AjaxObserveField.appendToResponse(response, context, this, observeFieldID, observeFieldDescendents, updateContainerID, fullSubmit, options);
        AjaxUtils.appendScriptFooter(response);
    }

    public static void appendToResponse(WOResponse response, WOContext context, AjaxDynamicElement element, String observeFieldID, boolean observeDescendentFields, String updateContainerID, boolean fullSubmit, NSMutableDictionary options) {
        WOComponent component = context.component();
        String submitButtonName = AjaxObserveField.nameInContext(context, component, element);
        NSMutableDictionary observerOptions = new NSMutableDictionary();
        if (options != null) {
            observerOptions.addEntriesFromDictionary((NSDictionary)options);
        }
        AjaxSubmitButton.fillInAjaxOptions(element, component, submitButtonName, observerOptions);
        Object observeFieldFrequency = observerOptions.removeObjectForKey((Object)"observeFieldFrequency");
        if (observeDescendentFields) {
            response.appendContentString("ASB.observeDescendentFields");
        } else {
            response.appendContentString("ASB.observeField");
        }
        Object observeDelay = observerOptions.removeObjectForKey((Object)"observeDelay");
        response.appendContentString("(" + AjaxUtils.quote(updateContainerID) + ", " + AjaxUtils.quote(observeFieldID) + ", " + observeFieldFrequency + ", " + !fullSubmit + ", " + observeDelay + ", ");
        AjaxOptions.appendToResponse((NSDictionary)observerOptions, response, context);
        response.appendContentString(");");
    }

    public static String nameInContext(WOContext context, WOComponent component, AjaxDynamicElement element) {
        return (String)element.valueForBinding("name", context.elementID(), component);
    }

    public WOActionResults invokeAction(WORequest worequest, WOContext wocontext) {
        boolean shouldHandleRequest;
        WOActionResults result = null;
        WOComponent wocomponent = wocontext.component();
        String nameInContext = AjaxObserveField.nameInContext(wocontext, wocomponent, this);
        boolean bl = shouldHandleRequest = !wocontext._wasActionInvoked() && wocontext._wasFormSubmitted() && nameInContext.equals(ERXAjaxApplication.ajaxSubmitButtonName((WORequest)worequest));
        if (shouldHandleRequest) {
            String updateContainerID = AjaxUpdateContainer.updateContainerID(this, wocomponent);
            AjaxUpdateContainer.setUpdateContainerID(worequest, updateContainerID);
            wocontext._setActionInvoked(true);
            result = (WOActionResults)this.valueForBinding("action", wocomponent);
            if (result == null) {
                result = this.handleRequest(worequest, wocontext);
            }
            AjaxUtils.updateMutableUserInfoWithAjaxInfo(wocontext);
        } else {
            result = this.invokeChildrenAction(worequest, wocontext);
        }
        return result;
    }

    public WOActionResults handleRequest(WORequest request, WOContext context) {
        AjaxResponse response = AjaxUtils.createResponse(request, context);
        return response;
    }
}

