/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WOConstantValueAssociation;
import com.webobjects.appserver._private.WODynamicElementCreationException;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.ajax.AjaxDynamicElement;
import er.ajax.AjaxOption;
import er.ajax.AjaxOptions;
import er.ajax.AjaxUtils;

public class AjaxRoundEffect
extends AjaxDynamicElement {
    private WOAssociation _elementNameAssociation;
    private WOAssociation _classAssociation;
    private WOAssociation _generateTagsAssociation;
    private WOAssociation _idAssociation;

    public AjaxRoundEffect(String name, NSDictionary associations, WOElement children) {
        super(name, associations, children);
        this._elementNameAssociation = (WOAssociation)associations.objectForKey((Object)"elementName");
        if (this._elementNameAssociation == null) {
            this._elementNameAssociation = new WOConstantValueAssociation((Object)"div");
        }
        this._classAssociation = (WOAssociation)associations.objectForKey((Object)"class");
        if (this._classAssociation == null) {
            throw new WODynamicElementCreationException("'class' is a required binding.");
        }
        this._generateTagsAssociation = (WOAssociation)associations.objectForKey((Object)"generateTags");
        if (this._generateTagsAssociation == null) {
            this._generateTagsAssociation = new WOConstantValueAssociation((Object)Boolean.FALSE);
        }
        this._idAssociation = (WOAssociation)associations.objectForKey((Object)"id");
    }

    protected void addRequiredWebResources(WOResponse response, WOContext context) {
        this.addScriptResourceInHead(context, response, "prototype.js");
        this.addScriptResourceInHead(context, response, "rico.js");
    }

    public WOActionResults handleRequest(WORequest request, WOContext context) {
        return null;
    }

    public NSDictionary createAjaxOptions(WOComponent component) {
        NSMutableArray ajaxOptionsArray = new NSMutableArray();
        ajaxOptionsArray.addObject((Object)new AjaxOption("corners", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("color", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("bgColor", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("blend", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("border", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("compact", AjaxOption.BOOLEAN));
        NSMutableDictionary<String, String> options = AjaxOption.createAjaxOptionsDictionary((NSArray<AjaxOption>)ajaxOptionsArray, component, (NSDictionary<String, ? extends WOAssociation>)this.associations());
        return options;
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        super.appendToResponse(response, context);
        WOComponent component = context.component();
        String className = (String)this._classAssociation.valueInComponent(component);
        String elementName = (String)this._elementNameAssociation.valueInComponent(component);
        boolean generateTags = (Boolean)this._generateTagsAssociation.valueInComponent(component);
        if (generateTags) {
            elementName = "div";
            response.appendContentString("<");
            response.appendContentString(elementName);
            response.appendContentString(" class = \"");
            response.appendContentString(className);
            response.appendContentString("\"");
            if (this._idAssociation != null) {
                response.appendContentString(" id = \"");
                String id = (String)this._idAssociation.valueInComponent(component);
                response.appendContentString(id);
                response.appendContentString("\"");
            }
            response.appendContentString(">");
        }
        this.appendChildrenToResponse(response, context);
        if (generateTags) {
            response.appendContentString("\n</");
            response.appendContentString(elementName);
            response.appendContentString(">");
        }
        response.appendContentString("\n");
        AjaxUtils.appendScriptHeader(response);
        response.appendContentString("new Rico.Effect.Round('");
        response.appendContentString(elementName);
        response.appendContentString("', '");
        response.appendContentString(className);
        response.appendContentString("', ");
        NSDictionary options = this.createAjaxOptions(component);
        AjaxOptions.appendToResponse(options, response, context);
        response.appendContentString(");");
        AjaxUtils.appendScriptFooter(response);
    }
}

