/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNumberFormatter;
import er.ajax.AjaxComponent;
import er.ajax.AjaxOption;
import er.ajax.AjaxOptions;
import er.ajax.AjaxResponse;
import er.ajax.AjaxUtils;
import er.extensions.components.ERXComponentUtilities;
import org.apache.log4j.Logger;

public class AjaxSlider
extends AjaxComponent {
    private static final Logger log = Logger.getLogger(AjaxSlider.class);
    private String _trackerId;
    private String _handleId;

    public AjaxSlider(WOContext context) {
        super(context);
    }

    public boolean isStateless() {
        return true;
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public void appendToResponse(WOResponse res, WOContext ctx) {
        String parent;
        super.appendToResponse(res, ctx);
        this._trackerId = this.safeElementID() + "_tracker";
        this._handleId = this.safeElementID() + "_handle";
        NSMutableDictionary options = new NSMutableDictionary();
        new AjaxOption("axis", "orientation", null, AjaxOption.STRING).addToDictionary(this, (NSMutableDictionary<String, String>)options);
        new AjaxOption("sliderValue", "value", null, AjaxOption.NUMBER).addToDictionary(this, (NSMutableDictionary<String, String>)options);
        new AjaxOption("values", "possibleValues", null, AjaxOption.ARRAY).addToDictionary(this, (NSMutableDictionary<String, String>)options);
        new AjaxOption("alignX", AjaxOption.NUMBER).addToDictionary(this, (NSMutableDictionary<String, String>)options);
        new AjaxOption("alignY", AjaxOption.NUMBER).addToDictionary(this, (NSMutableDictionary<String, String>)options);
        new AjaxOption("disabled", AjaxOption.BOOLEAN).addToDictionary(this, (NSMutableDictionary<String, String>)options);
        new AjaxOption("handleImage", AjaxOption.STRING).addToDictionary(this, (NSMutableDictionary<String, String>)options);
        new AjaxOption("handleDisabled", AjaxOption.STRING).addToDictionary(this, (NSMutableDictionary<String, String>)options);
        new AjaxOption("increment", AjaxOption.NUMBER).addToDictionary(this, (NSMutableDictionary<String, String>)options);
        new AjaxOption("restricted", AjaxOption.BOOLEAN).addToDictionary(this, (NSMutableDictionary<String, String>)options);
        new AjaxOption("step", AjaxOption.NUMBER).addToDictionary(this, (NSMutableDictionary<String, String>)options);
        if (this.hasBinding("onChangeServer")) {
            parent = (String)this.valueForBinding("onChange");
            options.setObjectForKey((Object)("function(v) {new Ajax.Request('" + AjaxUtils.ajaxComponentActionUrl(this.context()) + "', {parameters: '" + this.context().elementID() + "=' + v + '&ajaxSlideTrigger=onChange'})" + (parent != null ? "; var parentFunction = " + parent + "; parentFunction(v);" : "") + "}"), (Object)"onChange");
        } else {
            new AjaxOption("onChange", AjaxOption.SCRIPT).addToDictionary(this, (NSMutableDictionary<String, String>)options);
        }
        if (this.hasBinding("onSlideServer")) {
            parent = (String)this.valueForBinding("onSlide");
            options.setObjectForKey((Object)("function(v) {new Ajax.Request('" + AjaxUtils.ajaxComponentActionUrl(this.context()) + "', {parameters: '" + this.context().elementID() + "=' + v + '&ajaxSlideTrigger=onSlide'})" + (parent != null ? "; var parentFunction = " + parent + "; parentFunction(v);" : "") + "}"), (Object)"onSlide");
        } else {
            new AjaxOption("onSlide", AjaxOption.SCRIPT).addToDictionary(this, (NSMutableDictionary<String, String>)options);
        }
        Number min = (Number)this.valueForBinding("minimum", new Integer(0));
        Number max = (Number)this.valueForBinding("maximum", new Integer(100));
        options.setObjectForKey((Object)("$R(" + min + "," + max + ")"), (Object)"range");
        if (min != null && max != null && ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"snap")) {
            StringBuffer valuesBuffer = new StringBuffer();
            valuesBuffer.append("[");
            for (int i = min.intValue(); i <= max.intValue(); ++i) {
                valuesBuffer.append(i);
                if (i >= max.intValue()) continue;
                valuesBuffer.append(",");
            }
            valuesBuffer.append("]");
            options.setObjectForKey((Object)valuesBuffer.toString(), (Object)"values");
        }
        res.appendContentString("<div class=\"tracker\" id=\"" + this._trackerId + "\"><div class=\"handle\" id=\"" + this._handleId + "\"></div></div>");
        AjaxUtils.appendScriptHeader(res);
        if (this.hasBinding("id")) {
            res.appendContentString((String)this.valueForBinding("id") + " = ");
        }
        res.appendContentString("new Control.Slider('" + this._handleId + "', '" + this._trackerId + "', ");
        AjaxOptions.appendToResponse((NSDictionary)options, res, ctx);
        res.appendContentString(");");
        AjaxUtils.appendScriptFooter(res);
    }

    protected void addRequiredWebResources(WOResponse res) {
        this.addScriptResourceInHead(res, "prototype.js");
        this.addScriptResourceInHead(res, "effects.js");
        this.addScriptResourceInHead(res, "controls.js");
        this.addScriptResourceInHead(res, "slider.js");
    }

    public void takeValuesFromRequest(WORequest worequest, WOContext wocontext) {
        try {
            String format = (String)this.valueForBinding("numberformat", "0");
            Number num = worequest.numericFormValueForKey(wocontext.elementID(), new NSNumberFormatter(format));
            if (num != null) {
                this.setValueForBinding(num, "value");
            }
        }
        catch (NumberFormatException ex) {
            log.error((Object)ex);
        }
        super.takeValuesFromRequest(worequest, wocontext);
    }

    public WOActionResults handleRequest(WORequest worequest, WOContext wocontext) {
        AjaxResponse result = AjaxUtils.createResponse(worequest, wocontext);
        String mode = worequest.stringFormValueForKey("ajaxSlideTrigger");
        if (mode != null) {
            result.setHeader("text/javascript", "content-type");
            result.setContent((String)this.valueForBinding(mode + "Server", ""));
        }
        return result;
    }
}

