/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation._NSDelegate;
import java.util.Enumeration;

public class AjaxTreeModel {
    private Object _rootTreeNode;
    private NSMutableSet _expandedTreeNodes = new NSMutableSet();
    private NSMutableSet _collapsedTreeNodes = new NSMutableSet();
    private String _parentTreeNodeKeyPath;
    private String _childrenTreeNodesKeyPath;
    private String _isLeafKeyPath;
    private boolean _allExpanded;
    private boolean _rootExpanded;
    private _NSDelegate _delegate = new _NSDelegate(Delegate.class);

    public void setDelegate(Object delegate) {
        this._delegate.setDelegate(delegate);
    }

    public Object delegate() {
        return this._delegate.delegate();
    }

    public void setRootExpanded(boolean rootExpanded) {
        if (this._rootExpanded != rootExpanded) {
            this._rootExpanded = rootExpanded;
            this.expandRootIfNecessary();
        }
    }

    public boolean isRootExpanded() {
        return this._rootExpanded;
    }

    public void setAllExpanded(boolean allExpanded) {
        this._allExpanded = allExpanded;
    }

    public boolean isAllExpanded() {
        return this._allExpanded;
    }

    public void setParentTreeNodeKeyPath(String parentTreeNodeKeyPath) {
        this._parentTreeNodeKeyPath = parentTreeNodeKeyPath;
    }

    public String parentTreeNodeKeyPath() {
        return this._parentTreeNodeKeyPath;
    }

    public void setChildrenTreeNodesKeyPath(String childrenTreeNodesKayPath) {
        this._childrenTreeNodesKeyPath = childrenTreeNodesKayPath;
    }

    public String childrenTreeNodesKeyPath() {
        return this._childrenTreeNodesKeyPath;
    }

    public void setIsLeafKeyPath(String isLeafKeyPath) {
        this._isLeafKeyPath = isLeafKeyPath;
    }

    public String isLeafKeyPath() {
        return this._isLeafKeyPath;
    }

    public void setRootTreeNode(Object rootTreeNode) {
        if (rootTreeNode != this._rootTreeNode) {
            this._rootTreeNode = rootTreeNode;
            this._expandedTreeNodes.removeAllObjects();
            this._collapsedTreeNodes.removeAllObjects();
            this.expandRootIfNecessary();
        }
    }

    public Object rootTreeNode() {
        return this._rootTreeNode;
    }

    public boolean isExpanded(Object treeNode) {
        boolean expanded = this._allExpanded ? !this._collapsedTreeNodes.containsObject(treeNode) : this._expandedTreeNodes.containsObject(treeNode);
        return expanded;
    }

    public void setExpanded(Object treeNode, boolean expanded) {
        if (this._rootExpanded && treeNode == this._rootTreeNode && !expanded) {
            return;
        }
        if (expanded) {
            if (this._allExpanded) {
                this._collapsedTreeNodes.removeObject(treeNode);
            } else {
                this._expandedTreeNodes.addObject(treeNode);
            }
        } else if (this._allExpanded) {
            this._collapsedTreeNodes.addObject(treeNode);
        } else {
            this._expandedTreeNodes.removeObject(treeNode);
        }
    }

    public void collapseAll() {
        if (this._allExpanded) {
            this._allExpanded = false;
        }
        this.clearExpandedAndCollapsed();
    }

    public void expandAll() {
        if (!this._allExpanded) {
            this._allExpanded = true;
        }
        this.clearExpandedAndCollapsed();
    }

    protected void clearExpandedAndCollapsed() {
        this._collapsedTreeNodes.removeAllObjects();
        this._expandedTreeNodes.removeAllObjects();
        this.expandRootIfNecessary();
    }

    protected void expandRootIfNecessary() {
        if (this._rootExpanded && this._rootTreeNode != null) {
            this.setExpanded(this._rootTreeNode, true);
        }
    }

    public int level(Object treeNode) {
        Object parentTreeNode = treeNode;
        int level = 0;
        while (parentTreeNode != null) {
            parentTreeNode = this.parentTreeNode(parentTreeNode);
            ++level;
        }
        return level - 1;
    }

    public boolean isLeaf(Object node) {
        boolean isLeaf;
        if (this._isLeafKeyPath == null) {
            NSArray childrenTreeNodes = this.childrenTreeNodes(node);
            isLeaf = childrenTreeNodes == null || childrenTreeNodes.count() == 0;
        } else if (this._delegate.respondsTo("isLeaf")) {
            isLeaf = this._delegate.booleanPerform("isLeaf", node);
        } else {
            Boolean isLeafBoolean = (Boolean)NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)node, (String)this._isLeafKeyPath);
            isLeaf = isLeafBoolean;
        }
        return isLeaf;
    }

    public Object parentTreeNode(Object node) {
        Object parentTreeNode = null;
        parentTreeNode = this._delegate.respondsTo("parentTreeNode") ? this._delegate.perform("parentTreeNode", node) : (node != null ? NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)node, (String)this._parentTreeNodeKeyPath) : null);
        return parentTreeNode;
    }

    public NSArray childrenTreeNodes(Object node) {
        NSArray childrenTreeNodes = this._delegate.respondsTo("childrenTreeNodes") ? (NSArray)this._delegate.perform("childrenTreeNodes", node) : (NSArray)NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)node, (String)this._childrenTreeNodesKeyPath);
        return childrenTreeNodes;
    }

    public Enumeration depthFirstEnumeration(Object node, boolean enumeratedClosedNodes) {
        return new DepthFirstEnumeration(node, enumeratedClosedNodes);
    }

    public Enumeration rootDepthFirstEnumeration(boolean enumeratedClosedNodes) {
        return new DepthFirstEnumeration(this._rootTreeNode, enumeratedClosedNodes);
    }

    public static abstract class WrapperNode {
        private WrapperNode _parent;
        private Object _userObject;

        public WrapperNode(WrapperNode parent, Object userObject) {
            this._parent = parent;
            this._userObject = userObject;
        }

        public Object userObject() {
            return this._userObject;
        }

        protected abstract WrapperNode _createChildNode(Object var1);

        protected abstract NSArray _childrenTreeNodes();

        public NSArray childrenTreeNodes() {
            NSArray childrenTreeNodes = this._childrenTreeNodes();
            if (childrenTreeNodes != null && childrenTreeNodes.count() > 0) {
                NSMutableArray wrappedTreeNodes = new NSMutableArray();
                Enumeration childrenTreeNodesEnum = childrenTreeNodes.objectEnumerator();
                while (childrenTreeNodesEnum.hasMoreElements()) {
                    Object obj = childrenTreeNodesEnum.nextElement();
                    wrappedTreeNodes.addObject((Object)this._createChildNode(obj));
                }
                childrenTreeNodes = wrappedTreeNodes;
            }
            return childrenTreeNodes;
        }

        public boolean isLeaf() {
            NSArray childrenTreeNodes = this._childrenTreeNodes();
            boolean isLeaf = childrenTreeNodes == null || childrenTreeNodes.count() == 0;
            return isLeaf;
        }

        public WrapperNode parentTreeNode() {
            return this._parent;
        }

        public int hashCode() {
            int hashCode = this._userObject == null ? super.hashCode() : this._userObject.hashCode();
            if (this._parent != null) {
                hashCode *= this._parent.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            boolean equals;
            if (obj instanceof WrapperNode) {
                WrapperNode wrapperNode = (WrapperNode)obj;
                equals = this._userObject == null ? wrapperNode._userObject == null : this._userObject.equals(wrapperNode._userObject);
                if (equals) {
                    equals = this._parent == null ? wrapperNode._parent == null : this._parent.equals(wrapperNode._parent);
                }
            } else {
                equals = false;
            }
            return equals;
        }
    }

    protected class DepthFirstEnumeration
    implements Enumeration {
        private Object _rootNode;
        private Enumeration _childrenEnumeration;
        private Enumeration _subtreeEnumeration;
        private boolean _enumerateClosedNodes;

        public DepthFirstEnumeration(Object rootNode, boolean enumerateClosedNodes) {
            this._rootNode = rootNode;
            this._enumerateClosedNodes = enumerateClosedNodes;
            if (this._enumerateClosedNodes || AjaxTreeModel.this.isExpanded(rootNode)) {
                this._childrenEnumeration = AjaxTreeModel.this.childrenTreeNodes(rootNode).objectEnumerator();
            }
            this._subtreeEnumeration = NSArray.EmptyArray.objectEnumerator();
        }

        public boolean hasMoreElements() {
            return this._rootNode != null;
        }

        public Object nextElement() {
            Object retval;
            if (this._subtreeEnumeration.hasMoreElements()) {
                retval = this._subtreeEnumeration.nextElement();
            } else if (this._childrenEnumeration != null && this._childrenEnumeration.hasMoreElements()) {
                this._subtreeEnumeration = new DepthFirstEnumeration(this._childrenEnumeration.nextElement(), this._enumerateClosedNodes);
                retval = this._subtreeEnumeration.nextElement();
            } else {
                retval = this._rootNode;
                this._rootNode = null;
            }
            return retval;
        }
    }

    public static interface Delegate {
        public boolean isLeaf(Object var1);

        public Object parentTreeNode(Object var1);

        public NSArray childrenTreeNodes(Object var1);
    }
}

