/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WOMessage;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.ajax.AjaxDynamicElement;
import er.ajax.AjaxModalDialog;
import er.ajax.AjaxObserveField;
import er.ajax.AjaxOption;
import er.ajax.AjaxOptions;
import er.ajax.AjaxResponse;
import er.ajax.AjaxUtils;
import er.ajax.IAjaxElement;
import er.extensions.appserver.ERXWOContext;
import er.extensions.foundation.ERXValueUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxUpdateContainer
extends AjaxDynamicElement {
    private static final String CURRENT_UPDATE_CONTAINER_ID_KEY = "er.ajax.AjaxUpdateContainer.currentID";

    public AjaxUpdateContainer(String name, NSDictionary associations, WOElement children) {
        super(name, associations, children);
    }

    @Override
    protected void addRequiredWebResources(WOResponse response, WOContext context) {
        this.addScriptResourceInHead(context, response, "prototype.js");
        this.addScriptResourceInHead(context, response, "effects.js");
        this.addScriptResourceInHead(context, response, "wonder.js");
    }

    protected boolean shouldRenderContainer(WOComponent component) {
        boolean renderContainer = !this.booleanValueForBinding("optional", false, component) || AjaxUpdateContainer.currentUpdateContainerID() == null;
        return renderContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void takeValuesFromRequest(WORequest request, WOContext context) {
        if (this.shouldRenderContainer(context.component())) {
            String previousUpdateContainerID = AjaxUpdateContainer.currentUpdateContainerID();
            try {
                AjaxUpdateContainer.setCurrentUpdateContainerID(this._containerID(context));
                super.takeValuesFromRequest(request, context);
            }
            finally {
                AjaxUpdateContainer.setCurrentUpdateContainerID(previousUpdateContainerID);
            }
        } else {
            super.takeValuesFromRequest(request, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WOActionResults invokeAction(WORequest request, WOContext context) {
        WOActionResults results;
        if (this.shouldRenderContainer(context.component())) {
            String previousUpdateContainerID = AjaxUpdateContainer.currentUpdateContainerID();
            try {
                AjaxUpdateContainer.setCurrentUpdateContainerID(this._containerID(context));
                results = super.invokeAction(request, context);
            }
            finally {
                AjaxUpdateContainer.setCurrentUpdateContainerID(previousUpdateContainerID);
            }
        } else {
            results = super.invokeAction(request, context);
        }
        return results;
    }

    public NSDictionary createAjaxOptions(WOComponent component) {
        NSMutableArray ajaxOptionsArray = new NSMutableArray();
        ajaxOptionsArray.addObject((Object)new AjaxOption("frequency", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("decay", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onLoading", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onComplete", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onSuccess", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onFailure", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onException", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("insertion", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("evalScripts", Boolean.TRUE, AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("asynchronous", Boolean.TRUE, AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("method", "get", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("evalScripts", Boolean.TRUE, AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("parameters", AjaxOption.STRING));
        NSMutableDictionary<String, String> options = AjaxOption.createAjaxOptionsDictionary((NSArray<AjaxOption>)ajaxOptionsArray, component, (NSDictionary<String, ? extends WOAssociation>)this.associations());
        AjaxUpdateContainer.expandInsertionFromOptions(options, this, component);
        return options;
    }

    public static void expandInsertionFromOptions(NSMutableDictionary<String, String> options, IAjaxElement element, WOComponent component) {
        String insertion;
        String expandedInsertion;
        String afterInsertionDuration;
        String insertionDuration = (String)element.valueForBinding("insertionDuration", component);
        String beforeInsertionDuration = (String)element.valueForBinding("beforeInsertionDuration", component);
        if (beforeInsertionDuration == null) {
            beforeInsertionDuration = insertionDuration;
        }
        if ((afterInsertionDuration = (String)element.valueForBinding("afterInsertionDuration", component)) == null) {
            afterInsertionDuration = insertionDuration;
        }
        if ((expandedInsertion = AjaxUpdateContainer.expandInsertion(insertion = (String)options.objectForKey((Object)"insertion"), beforeInsertionDuration, afterInsertionDuration)) != null) {
            options.setObjectForKey((Object)expandedInsertion, (Object)"insertion");
        }
    }

    public static String expandInsertion(String originalInsertion, String beforeDuration, String afterDuration) {
        String expandedInsertion = originalInsertion;
        if (originalInsertion != null && originalInsertion.startsWith("Effect.")) {
            String effectPairName = originalInsertion.substring("Effect.".length());
            expandedInsertion = "AUC.insertionFunc('" + effectPairName + "', " + beforeDuration + "," + afterDuration + ")";
        }
        return expandedInsertion;
    }

    public static NSDictionary removeDefaultOptions(NSDictionary options) {
        NSMutableDictionary mutableOptions = options.mutableClone();
        if ("'get'".equals(mutableOptions.objectForKey((Object)"method"))) {
            mutableOptions.removeObjectForKey((Object)"method");
        }
        if ("true".equals(mutableOptions.objectForKey((Object)"evalScripts"))) {
            mutableOptions.removeObjectForKey((Object)"evalScripts");
        }
        if ("true".equals(mutableOptions.objectForKey((Object)"asynchronous"))) {
            mutableOptions.removeObjectForKey((Object)"asynchronous");
        }
        return mutableOptions;
    }

    public NSMutableDictionary createObserveFieldOptions(WOComponent component) {
        NSMutableArray ajaxOptionsArray = new NSMutableArray();
        ajaxOptionsArray.addObject((Object)new AjaxOption("observeFieldFrequency", AjaxOption.NUMBER));
        NSMutableDictionary<String, String> options = AjaxOption.createAjaxOptionsDictionary((NSArray<AjaxOption>)ajaxOptionsArray, component, (NSDictionary<String, ? extends WOAssociation>)this.associations());
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendToResponse(WOResponse response, WOContext context) {
        block15: {
            WOComponent component = context.component();
            if (!this.shouldRenderContainer(component)) {
                if (this.hasChildrenElements()) {
                    this.appendChildrenToResponse(response, context);
                }
                super.appendToResponse(response, context);
            } else {
                String previousUpdateContainerID = AjaxUpdateContainer.currentUpdateContainerID();
                try {
                    boolean skipFunction;
                    String elementName = (String)this.valueForBinding("elementName", "div", component);
                    String id = this._containerID(context);
                    AjaxUpdateContainer.setCurrentUpdateContainerID(this._containerID(context));
                    response.appendContentString("<" + elementName + " ");
                    this.appendTagAttributeToResponse(response, "id", id);
                    this.appendTagAttributeToResponse(response, "class", this.valueForBinding("class", component));
                    this.appendTagAttributeToResponse(response, "style", this.valueForBinding("style", component));
                    this.appendTagAttributeToResponse(response, "updateUrl", AjaxUtils.ajaxComponentActionUrl(context));
                    response.appendContentString(">");
                    if (this.hasChildrenElements()) {
                        this.appendChildrenToResponse(response, context);
                    }
                    response.appendContentString("</" + elementName + ">");
                    super.appendToResponse(response, context);
                    NSDictionary options = this.createAjaxOptions(component);
                    Object frequency = this.valueForBinding("frequency", component);
                    String observeFieldID = (String)this.valueForBinding("observeFieldID", component);
                    boolean bl = skipFunction = frequency == null && observeFieldID == null && this.booleanValueForBinding("skipFunction", false, component);
                    if (skipFunction) break block15;
                    AjaxUtils.appendScriptHeader(response);
                    if (frequency != null) {
                        boolean isNotZero = true;
                        try {
                            float numberFrequency = ERXValueUtilities.floatValue((Object)frequency);
                            if ((double)numberFrequency == 0.0) {
                                isNotZero = false;
                            }
                        }
                        catch (RuntimeException e) {
                            throw new IllegalStateException("Error parsing float from value : <" + frequency + ">");
                        }
                        if (isNotZero) {
                            boolean canStop = false;
                            boolean stopped = false;
                            if (this.associations().objectForKey((Object)"stopped") != null) {
                                canStop = true;
                                stopped = this.booleanValueForBinding("stopped", false, component);
                            }
                            response.appendContentString("AUC.registerPeriodic('" + id + "'," + canStop + "," + stopped + ",");
                            AjaxOptions.appendToResponse(options, response, context);
                            response.appendContentString(");");
                        }
                    }
                    if (observeFieldID != null) {
                        boolean fullSubmit = this.booleanValueForBinding("fullSubmit", false, component);
                        AjaxObserveField.appendToResponse(response, context, this, observeFieldID, false, id, fullSubmit, this.createObserveFieldOptions(component));
                    }
                    response.appendContentString("AUC.register('" + id + "'");
                    NSDictionary nonDefaultOptions = AjaxUpdateContainer.removeDefaultOptions(options);
                    if (nonDefaultOptions.count() > 0) {
                        response.appendContentString(", ");
                        AjaxOptions.appendToResponse(nonDefaultOptions, response, context);
                    }
                    response.appendContentString(");");
                    AjaxUtils.appendScriptFooter(response);
                }
                finally {
                    AjaxUpdateContainer.setCurrentUpdateContainerID(previousUpdateContainerID);
                }
            }
        }
    }

    @Override
    public WOActionResults handleRequest(WORequest request, WOContext context) {
        String onRefreshComplete;
        WOComponent component = context.component();
        String id = this._containerID(context);
        if (this.associations().objectForKey((Object)"action") != null) {
            WOActionResults results = (WOActionResults)this.valueForBinding("action", component);
        }
        AjaxResponse response = AjaxUtils.createResponse(request, context);
        AjaxUtils.setPageReplacementCacheKey(context, id);
        if (this.hasChildrenElements()) {
            this.appendChildrenToResponse((WOResponse)response, context);
        }
        if ((onRefreshComplete = (String)this.valueForBinding("onRefreshComplete", component)) != null) {
            AjaxUtils.appendScriptHeader((WOResponse)response);
            response.appendContentString(onRefreshComplete);
            AjaxUtils.appendScriptFooter((WOResponse)response);
        }
        if (AjaxModalDialog.isInDialog(context)) {
            AjaxUtils.appendScriptHeader((WOResponse)response);
            response.appendContentString("AMD.contentUpdated();");
            AjaxUtils.appendScriptFooter((WOResponse)response);
        }
        return null;
    }

    @Override
    protected String _containerID(WOContext context) {
        String id = (String)this.valueForBinding("id", context.component());
        if (id == null) {
            id = ERXWOContext.safeIdentifierName((WOContext)context, (boolean)false);
        }
        return id;
    }

    public static String updateContainerID(WORequest request) {
        NSMutableDictionary userInfo = AjaxUtils.mutableUserInfo((WOMessage)request);
        String updateContainerID = (String)userInfo.objectForKey((Object)"_u");
        return updateContainerID;
    }

    public static void setUpdateContainerID(WORequest request, String updateContainerID) {
        if (updateContainerID != null) {
            AjaxUtils.mutableUserInfo((WOMessage)request).setObjectForKey((Object)updateContainerID, (Object)"_u");
        }
    }

    public static boolean hasUpdateContainerID(WORequest request) {
        return AjaxUpdateContainer.updateContainerID(request) != null;
    }

    public static String currentUpdateContainerID() {
        return (String)ERXWOContext.contextDictionary().objectForKey((Object)CURRENT_UPDATE_CONTAINER_ID_KEY);
    }

    public static void setCurrentUpdateContainerID(String updateContainerID) {
        if (updateContainerID == null) {
            ERXWOContext.contextDictionary().removeObjectForKey((Object)CURRENT_UPDATE_CONTAINER_ID_KEY);
        } else {
            ERXWOContext.contextDictionary().setObjectForKey((Object)updateContainerID, (Object)CURRENT_UPDATE_CONTAINER_ID_KEY);
        }
    }

    protected static String updateContainerID(AjaxDynamicElement element, WOComponent component) {
        return AjaxUpdateContainer.updateContainerID(element, "updateContainerID", component);
    }

    protected static String updateContainerID(AjaxDynamicElement element, String bindingName, WOComponent component) {
        String updateContainerID = (String)element.valueForBinding("updateContainerID", component);
        return AjaxUpdateContainer.updateContainerID(updateContainerID);
    }

    protected static String updateContainerID(String updateContainerID) {
        if ("_parent".equals(updateContainerID)) {
            updateContainerID = AjaxUpdateContainer.currentUpdateContainerID();
        }
        return updateContainerID;
    }

    public static void updateContainerWithID(String updateContainerID, WOContext context) {
        String containerID = "'" + updateContainerID + "'";
        AjaxUtils.javascriptResponse("AUC.update(" + containerID + ");", context);
    }

    public static void safeUpdateContainerWithID(String updateContainerID, WOContext context) {
        String containerID = "'" + updateContainerID + "'";
        AjaxUtils.javascriptResponse("if ( $(" + containerID + ") != null ) AUC.update(" + containerID + ");", context);
    }
}

