/*
 * Decompiled with CFR 0.152.
 */
package er.ajax.json;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WORequestHandler;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOSession;
import com.webobjects.foundation._NSUtilities;
import er.ajax.json.JSONBridge;
import er.ajax.json.JSONComponent;
import er.extensions.components.ERXDynamicURL;
import er.extensions.foundation.ERXMutableURL;
import er.extensions.foundation.ERXProperties;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jabsorb.JSONRPCBridge;
import org.jabsorb.JSONRPCResult;
import org.jabsorb.callback.InvocationCallback;
import org.jabsorb.serializer.Serializer;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONRequestHandler
extends WORequestHandler {
    public static final String RequestHandlerKey = "json";
    private JSONRPCBridge _sharedBridge = JSONBridge.createBridge();

    public static JSONRequestHandler register() {
        JSONRequestHandler requestHandler = new JSONRequestHandler();
        WOApplication.application().registerRequestHandler((WORequestHandler)requestHandler, RequestHandlerKey);
        return requestHandler;
    }

    public JSONRPCBridge getJSONBridge() {
        return this._sharedBridge;
    }

    public static void registerSerializer(Serializer serializer) throws Exception {
        JSONRPCBridge.getSerializer().registerSerializer(serializer);
    }

    public static void registerClass(Class clazz) throws Exception {
        JSONRequestHandler.registerClass(clazz.getSimpleName(), clazz);
    }

    public static void registerClass(String name, Class clazz) throws Exception {
        JSONRPCBridge.getGlobalBridge().registerClass(name, clazz);
    }

    public void registerService(String name, Object serviceObject) {
        this._sharedBridge.registerObject(name, serviceObject);
    }

    public static String jsonUrl(WOContext context, String queryString) {
        return JSONRequestHandler.jsonUrl(context, RequestHandlerKey, null, null, queryString);
    }

    public static String jsonUrl(WOContext context, String requestHandlerKey, String queryString) {
        return JSONRequestHandler.jsonUrl(context, requestHandlerKey, null, null, queryString);
    }

    public static String jsonUrl(WOContext context, String componentName, String instance, String queryString) {
        return JSONRequestHandler.jsonUrl(context, RequestHandlerKey, componentName, instance, queryString);
    }

    public static String jsonUrl(WOContext context, String requestHandlerKey, String componentName, String componentInstance, String queryString) {
        String componentNameAndInstance = componentName == null ? "" : JSONRequestHandler.componentNameAndInstance(componentName, componentInstance);
        return JSONRequestHandler._jsonUrl(context, requestHandlerKey, componentNameAndInstance, queryString);
    }

    public static String _jsonUrl(WOContext context, String requestHandlerKey, String componentNameAndInstance, String queryString) {
        String jsonUrl = context.urlWithRequestHandlerKey(RequestHandlerKey, componentNameAndInstance, queryString);
        return jsonUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOResponse handleRequest(WORequest request) {
        WOApplication application = WOApplication.application();
        application.awake();
        try {
            WOContext context = application.createContextForRequest(request);
            WOResponse response = application.createResponseInContext(context);
            try {
                String inputString = request.contentString();
                JSONObject input = new JSONObject(inputString);
                String wosid = request.cookieValueForKey("wosid");
                if (wosid == null) {
                    ERXMutableURL url = new ERXMutableURL();
                    url.setQueryParameters(request.queryString());
                    wosid = url.queryParameter("wosid");
                    if (wosid == null && input.has("wosid")) {
                        wosid = input.getString("wosid");
                    }
                }
                context._setRequestSessionID(wosid);
                WOSession session = null;
                if (context._requestSessionID() != null) {
                    session = WOApplication.application().restoreSessionWithID(wosid, context);
                }
                if (session != null) {
                    session.awake();
                }
                try {
                    JSONRPCResult output;
                    JSONRPCBridge jsonBridge;
                    JSONComponentCallback componentCallback = null;
                    ERXDynamicURL url = new ERXDynamicURL((Object)request._uriDecomposed());
                    String requestHandlerPath = url.requestHandlerPath();
                    if (requestHandlerPath != null && requestHandlerPath.length() > 0) {
                        String bridgesKey;
                        LRUMap<String, JSONRPCBridge> componentBridges;
                        String componentInstance;
                        String componentName;
                        String componentNameAndInstance = requestHandlerPath;
                        int slashIndex = componentNameAndInstance.indexOf(47);
                        if (slashIndex == -1) {
                            componentName = componentNameAndInstance;
                            componentInstance = null;
                        } else {
                            componentName = componentNameAndInstance.substring(0, slashIndex);
                            componentInstance = componentNameAndInstance.substring(slashIndex + 1);
                        }
                        if (session == null) {
                            session = context.session();
                        }
                        if ((componentBridges = (LRUMap<String, JSONRPCBridge>)session.objectForKey(bridgesKey = componentInstance == null ? "_JSONGlobalBridges" : "_JSONInstanceBridges")) == null) {
                            int limit = ERXProperties.intForKeyWithDefault((String)(componentInstance == null ? "er.ajax.json.globalBacktrackCacheSize" : "er.ajax.json.backtrackCacheSize"), (int)WOApplication.application().pageCacheSize());
                            componentBridges = new LRUMap<String, JSONRPCBridge>(limit);
                            session.setObjectForKey(componentBridges, bridgesKey);
                        }
                        if ((jsonBridge = (JSONRPCBridge)componentBridges.get(componentNameAndInstance)) == null) {
                            Class componentClass = _NSUtilities.classWithName((String)componentName);
                            if (!JSONComponent.class.isAssignableFrom(componentClass)) {
                                throw new SecurityException("There is no JSON component named '" + componentName + "'.");
                            }
                            JSONComponent component = (JSONComponent)_NSUtilities.instantiateObject((Class)componentClass, (Class[])new Class[]{WOContext.class}, (Object[])new Object[]{context}, (boolean)true, (boolean)false);
                            jsonBridge = this.createBridgeForComponent(component, componentName, componentInstance, componentBridges);
                        }
                        componentCallback = new JSONComponentCallback(context);
                        jsonBridge.registerCallback(componentCallback, WOContext.class);
                    } else {
                        jsonBridge = this._sharedBridge;
                    }
                    try {
                        output = jsonBridge.call(new Object[]{request, response, context}, input);
                    }
                    finally {
                        if (componentCallback != null) {
                            jsonBridge.unregisterCallback(componentCallback, WOContext.class);
                        }
                    }
                    if (context._session() != null) {
                        WOSession contextSession = context._session();
                        if (wosid == null) {
                            boolean storesIDsInCookies = contextSession.storesIDsInCookies();
                            try {
                                contextSession.setStoresIDsInCookies(true);
                                contextSession._appendCookieToResponse(response);
                            }
                            finally {
                                contextSession.setStoresIDsInCookies(storesIDsInCookies);
                            }
                        } else {
                            contextSession._appendCookieToResponse(response);
                        }
                    }
                    if (output != null) {
                        response.appendContentString(output.toString());
                    }
                    if (response != null) {
                        response._finalizeInContext(context);
                        response.disableClientCaching();
                    }
                }
                finally {
                    try {
                        if (session != null) {
                            session.sleep();
                        }
                    }
                    finally {
                        if (context._session() != null) {
                            WOApplication.application().saveSessionForContext(context);
                        }
                    }
                }
            }
            catch (NoSuchElementException e) {
                e.printStackTrace();
                JSONRPCResult output = new JSONRPCResult(591, null, (Object)"method not found (session may have timed out)");
            }
            catch (JSONException e) {
                e.printStackTrace();
                JSONRPCResult output = new JSONRPCResult(590, null, (Object)"couldn't parse request arguments");
            }
            catch (Throwable t) {
                t.printStackTrace();
                JSONRPCResult output = new JSONRPCResult(590, null, (Object)t.getMessage());
            }
            WOResponse wOResponse = response;
            return wOResponse;
        }
        finally {
            application.sleep();
        }
    }

    protected static String componentNameAndInstance(String componentName, String componentInstance) {
        String componentNameAndInstance = componentInstance == null ? componentName : componentName + "/" + componentInstance;
        return componentNameAndInstance;
    }

    protected JSONRPCBridge createBridgeForComponent(JSONComponent component, String componentName, String componentInstance, Map<String, JSONRPCBridge> componentBridges) throws Exception {
        JSONBridge jsonBridge = JSONBridge.createBridge();
        jsonBridge.registerCallableReference(JSONComponent.class);
        jsonBridge.registerObject("component", component);
        String componentNameAndInstance = JSONRequestHandler.componentNameAndInstance(componentName, componentInstance);
        componentBridges.put(componentNameAndInstance, jsonBridge);
        return jsonBridge;
    }

    protected static class JSONComponentCallback
    implements InvocationCallback {
        private WOContext _context;

        public JSONComponentCallback(WOContext context) {
            this._context = context;
        }

        public void preInvoke(Object context, Object instance, Method method, Object[] arguments) throws Exception {
            if (instance instanceof JSONComponent) {
                JSONComponent component = (JSONComponent)instance;
                component._setContext(this._context);
                component.checkAccess();
            }
        }

        public void postInvoke(Object context, Object instance, Method method, Object result) throws Exception {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LRUMap<U, V>
    extends LinkedHashMap<U, V> {
        private int _maxSize;

        public LRUMap(int maxSize) {
            super(16, 0.75f, true);
            this._maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<U, V> eldest) {
            return this.size() > this._maxSize;
        }
    }
}

