/*
 * Decompiled with CFR 0.152.
 */
package er.ajax.json.serializer;

import com.webobjects.appserver.WOSession;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOTemporaryGlobalID;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.appserver.ERXSession;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXRandomGUID;
import er.extensions.foundation.ERXStringUtilities;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.jabsorb.JSONSerializer;
import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EOEnterpriseObjectSerializer
extends AbstractSerializer {
    protected static final NSMutableDictionary<String, NSArray<String>> readableAttributeNames = new NSMutableDictionary();
    protected static final NSMutableDictionary<String, NSArray<String>> writableAttributeNames = new NSMutableDictionary();
    protected static final NSMutableDictionary<String, NSArray<String>> includedRelationshipNames = new NSMutableDictionary();
    private static Class[] _serializableClasses = new Class[]{EOEnterpriseObject.class};
    private static Class[] _JSONClasses = new Class[]{JSONObject.class};
    private EOEditingContextFactory _editingContextFactory;
    private static Map<EOEditingContext, String> _contexts = new WeakHashMap<EOEditingContext, String>();

    public EOEnterpriseObjectSerializer() {
        String editingContextFactory = ERXProperties.stringForKey((String)"er.ajax.json.EOEditingContextFactory");
        if (editingContextFactory == null) {
            this._editingContextFactory = new ERXECEditingContextFactory();
        } else {
            try {
                this._editingContextFactory = (EOEditingContextFactory)Class.forName(editingContextFactory).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize EOEnterpriseObjectSerializer.", e);
            }
        }
    }

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    protected boolean _canSerialize(Class clazz, Class jsonClazz) {
        return super.canSerialize(clazz, jsonClazz);
    }

    public boolean canSerialize(Class clazz, Class jsonClazz) {
        return super.canSerialize(clazz, jsonClazz) || (jsonClazz == null || jsonClazz == JSONObject.class) && EOEnterpriseObject.class.isAssignableFrom(clazz);
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object jso) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        EOEnterpriseObject eOEnterpriseObject;
        JSONObject jso;
        JSONObject eoDict = jso = (JSONObject)o;
        if (jso.has("eo")) {
            jso.getJSONObject("eo");
        }
        if (eoDict == null) {
            throw new UnmarshallException("eo missing");
        }
        String gidString = jso.getString("gid");
        if (gidString == null) {
            throw new UnmarshallException("gid missing");
        }
        String[] parts = gidString.split("/");
        String ecid = parts[0];
        String entityName = parts[1];
        EOEditingContext ec = null;
        if (ecid != null) {
            ec = EOEnterpriseObjectSerializer.editingContextForKey(ecid);
        }
        if (ec == null) {
            ec = this._editingContextFactory.newEditingContext();
            EOEnterpriseObjectSerializer.registerEditingContext(ec);
        }
        ec.lock();
        try {
            EOEnterpriseObject eo;
            String type = null;
            String pk = null;
            if (parts.length > 2) {
                type = parts[2];
                pk = parts[3];
            }
            if (pk != null && pk.length() > 0) {
                EOTemporaryGlobalID gid;
                if ("T".equals(type)) {
                    byte[] bytes = ERXStringUtilities.hexStringToByteArray((String)pk);
                    gid = EOTemporaryGlobalID._gidForRawBytes((byte[])bytes);
                    eo = ec.objectForGlobalID((EOGlobalID)gid);
                } else {
                    pk = ERXStringUtilities.urlDecode((String)pk);
                    gid = ERXEOControlUtilities.globalIDForString((EOEditingContext)ec, (String)entityName, (String)pk);
                    eo = ec.faultForGlobalID((EOGlobalID)gid, ec);
                }
            } else {
                eo = this._canInsert(entityName) ? ERXEOControlUtilities.createAndInsertObject((EOEditingContext)ec, (String)entityName) : null;
            }
            if (eo != null) {
                NSArray<String> attributeNames = this._writableAttributeNames(eo);
                NSArray<String> relationshipNames = this._includedRelationshipNames(eo);
                Iterator iterator = eoDict.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    if ("javaClass".equals(key) || "gid".equals(key)) continue;
                    Object value = eoDict.get(key);
                    Object obj = this.ser.unmarshall(state, null, value);
                    if (!attributeNames.containsObject((Object)key) || obj == null && !relationshipNames.containsObject((Object)key) && (eo.toOneRelationshipKeys().containsObject((Object)key) || eo.toManyRelationshipKeys().containsObject((Object)key))) continue;
                    eo.takeValueForKey(obj, key);
                }
            }
            state.setSerialized(o, (Object)eo);
            eOEnterpriseObject = eo;
        }
        catch (Throwable throwable) {
            try {
                ec.unlock();
                throw throwable;
            }
            catch (JSONException e) {
                throw new UnmarshallException("Failed to unmarshall EO.", (Throwable)e);
            }
        }
        ec.unlock();
        return eOEnterpriseObject;
    }

    public Object marshall(SerializerState state, Object p, Object o) throws MarshallException {
        try {
            String pkStr;
            String type;
            EOEnterpriseObject eo = (EOEnterpriseObject)o;
            JSONObject obj = new JSONObject();
            obj.put("javaClass", (Object)o.getClass().getName());
            EOEditingContext ec = eo.editingContext();
            String ecid = EOEnterpriseObjectSerializer.registerEditingContext(ec);
            EOGlobalID gid = ec.globalIDForObject(eo);
            if (gid instanceof EOTemporaryGlobalID) {
                type = "T";
                byte[] bytes = ((EOTemporaryGlobalID)gid)._rawBytes();
                pkStr = ERXStringUtilities.byteArrayToHexString((byte[])bytes);
            } else {
                type = "K";
                pkStr = ERXEOControlUtilities.primaryKeyStringForObject((EOEnterpriseObject)eo);
                pkStr = ERXStringUtilities.urlEncode((String)pkStr);
            }
            obj.put("gid", (Object)(ecid + "/" + eo.entityName() + "/" + type + "/" + pkStr));
            this.addAttributes(state, eo, obj);
            return obj;
        }
        catch (JSONException e) {
            throw new MarshallException("Failed to marshall EO.", (Throwable)e);
        }
    }

    public void addAttributes(SerializerState state, EOEnterpriseObject source, JSONObject destination) throws MarshallException {
        boolean useEO = false;
        try {
            JSONObject eoData = destination;
            if (useEO) {
                destination = new JSONObject();
                destination.put("eo", (Object)eoData);
                state.push((Object)source, (Object)eoData, (Object)"eo");
            }
            EOClassDescription cd = source.classDescription();
            NSArray<String> attributeNames = this._readableAttributeNames(source);
            NSArray<String> relationshipNames = this._includedRelationshipNames(source);
            Enumeration e = attributeNames.objectEnumerator();
            while (e.hasMoreElements()) {
                Object jsonValue;
                Object value;
                String key = (String)e.nextElement();
                if (cd.toManyRelationshipKeys().containsObject((Object)key)) {
                    if (relationshipNames.containsObject((Object)key)) {
                        value = source.valueForKey(key);
                        jsonValue = this.ser.marshall(state, (Object)source, value, (Object)key);
                    } else {
                        jsonValue = null;
                    }
                } else if (cd.toOneRelationshipKeys().containsObject((Object)key)) {
                    if (relationshipNames.containsObject((Object)key)) {
                        value = source.valueForKey(key);
                        jsonValue = this.ser.marshall(state, (Object)source, value, (Object)key);
                    } else {
                        jsonValue = null;
                    }
                } else {
                    value = source.valueForKey(key);
                    jsonValue = this.ser.marshall(state, (Object)source, value, (Object)key);
                }
                if (JSONSerializer.CIRC_REF_OR_DUPLICATE == jsonValue) {
                    destination.put(key, JSONObject.NULL);
                    continue;
                }
                destination.put(key, jsonValue);
            }
            this._addCustomAttributes(state, source, destination);
        }
        catch (JSONException e) {
            throw new MarshallException("Failed to marshall EO.", (Throwable)e);
        }
        finally {
            if (useEO) {
                state.pop();
            }
        }
    }

    protected void _addCustomAttributes(SerializerState state, EOEnterpriseObject source, JSONObject destination) throws MarshallException {
    }

    protected boolean _canInsert(String entityName) {
        return ERXProperties.booleanForKeyWithDefault((String)("er.ajax.json." + entityName + ".canInsert"), (boolean)false);
    }

    protected NSArray<String> _readableAttributeNames(EOEnterpriseObject eo) {
        return EOEnterpriseObjectSerializer.readableAttributeNames(eo);
    }

    protected NSArray<String> _writableAttributeNames(EOEnterpriseObject eo) {
        return EOEnterpriseObjectSerializer.writableAttributeNames(eo);
    }

    protected NSArray<String> _includedRelationshipNames(EOEnterpriseObject eo) {
        return EOEnterpriseObjectSerializer.includedRelationshipNames(eo);
    }

    public static NSArray<String> readableAttributeNames(EOEnterpriseObject source) {
        EOEntity entity = EOUtilities.entityForObject((EOEditingContext)source.editingContext(), (EOEnterpriseObject)source);
        NSArray attributeNames = (NSArray)readableAttributeNames.objectForKey((Object)entity.name());
        if (attributeNames == null) {
            for (EOEntity currentEntity = entity; attributeNames == null && currentEntity != null; currentEntity = currentEntity.parentEntity()) {
                attributeNames = ERXProperties.arrayForKey((String)("er.ajax.json." + currentEntity.name() + ".attributes"));
            }
            if (attributeNames == null) {
                attributeNames = entity.clientClassPropertyNames();
            }
            readableAttributeNames.setObjectForKey((Object)attributeNames, (Object)entity.name());
        }
        return attributeNames;
    }

    public static NSArray<String> writableAttributeNames(EOEnterpriseObject source) {
        EOEntity entity = EOUtilities.entityForObject((EOEditingContext)source.editingContext(), (EOEnterpriseObject)source);
        NSArray writableNames = (NSArray)writableAttributeNames.objectForKey((Object)entity.name());
        if (writableNames == null) {
            for (EOEntity currentEntity = entity; writableNames == null && currentEntity != null; currentEntity = currentEntity.parentEntity()) {
                writableNames = ERXProperties.arrayForKey((String)("er.ajax.json." + currentEntity.name() + ".writableAttributes"));
            }
            if (writableNames == null) {
                writableNames = entity.clientClassPropertyNames();
            }
            writableAttributeNames.setObjectForKey((Object)writableNames, (Object)entity.name());
        }
        return writableNames;
    }

    public static NSArray<String> includedRelationshipNames(EOEnterpriseObject source) {
        EOEntity entity = EOUtilities.entityForObject((EOEditingContext)source.editingContext(), (EOEnterpriseObject)source);
        NSArray relationshipNames = (NSArray)includedRelationshipNames.objectForKey((Object)entity.name());
        if (relationshipNames == null) {
            for (EOEntity currentEntity = entity; relationshipNames == null && currentEntity != null; currentEntity = currentEntity.parentEntity()) {
                relationshipNames = ERXProperties.arrayForKey((String)("er.ajax.json." + currentEntity.name() + ".relationships"));
            }
            if (relationshipNames == null) {
                relationshipNames = entity.classDescriptionForInstances().toOneRelationshipKeys();
            }
            includedRelationshipNames.setObjectForKey((Object)relationshipNames, (Object)entity.name());
        }
        return relationshipNames;
    }

    public static Map<EOEditingContext, String> contexts() {
        HashMap contexts;
        WOSession session = ERXSession.anySession();
        if (session == null) {
            contexts = _contexts;
        } else {
            contexts = (HashMap)session.objectForKey("_jsonContexts");
            if (contexts == null) {
                contexts = new HashMap();
                session.setObjectForKey(contexts, "_jsonContexts");
            }
        }
        return contexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String registerEditingContext(EOEditingContext ec) {
        Map<EOEditingContext, String> contexts;
        Map<EOEditingContext, String> map = contexts = EOEnterpriseObjectSerializer.contexts();
        synchronized (map) {
            String id = contexts.get(ec);
            if (id != null) {
                return id;
            }
            id = ERXRandomGUID.newGid();
            contexts.put(ec, id);
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EOEditingContext editingContextForKey(String key) {
        Map<EOEditingContext, String> contexts;
        Map<EOEditingContext, String> map = contexts = EOEnterpriseObjectSerializer.contexts();
        synchronized (map) {
            for (Map.Entry<EOEditingContext, String> entry : contexts.entrySet()) {
                if (!entry.getValue().equals(key)) continue;
                return entry.getKey();
            }
            return null;
        }
    }

    public static class SadEditingContextFactory
    implements EOEditingContextFactory {
        public EOEditingContext newEditingContext() {
            return new EOEditingContext();
        }
    }

    public static class ERXECEditingContextFactory
    implements EOEditingContextFactory {
        public EOEditingContext newEditingContext() {
            return ERXEC.newEditingContext();
        }
    }

    public static interface EOEditingContextFactory {
        public EOEditingContext newEditingContext();
    }
}

