/*
 * Decompiled with CFR 0.152.
 */
package er.ajax.json.serializer;

import com.webobjects.foundation.NSMutableDictionary;
import er.ajax.json.client.IJSONEnterpriseObject;
import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.jabsorb.serializer.impl.BeanSerializer;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONEnterpriseObjectSerializer
extends AbstractSerializer {
    protected static NSMutableDictionary publicAttributes = new NSMutableDictionary();
    private static Class[] _serializableClasses = new Class[]{IJSONEnterpriseObject.class};
    private static Class[] _JSONClasses = new Class[]{JSONObject.class};

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public boolean canSerialize(Class clazz, Class jsonClazz) {
        return super.canSerialize(clazz, jsonClazz) || (jsonClazz == null || jsonClazz == JSONObject.class) && IJSONEnterpriseObject.class.isAssignableFrom(clazz);
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object jso) {
        return null;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        try {
            JSONObject jso = (JSONObject)o;
            String gid = jso.getString("gid");
            jso.put("globalID", (Object)gid);
            jso.remove("gid");
            String javaClassName = jso.getString("javaClass");
            Class<?> javaClass = Class.forName(javaClassName);
            BeanSerializer beanSerializer = new BeanSerializer();
            beanSerializer.setOwner(this.ser);
            Object obj = beanSerializer.unmarshall(state, javaClass, (Object)jso);
            state.setSerialized(o, obj);
            return obj;
        }
        catch (Exception e) {
            throw new UnmarshallException("Failed to unmarshall EO.", (Throwable)e);
        }
    }

    public Object marshall(SerializerState state, Object p, Object o) throws MarshallException {
        try {
            IJSONEnterpriseObject eo = (IJSONEnterpriseObject)o;
            JSONObject obj = new JSONObject();
            obj.put("javaClass", (Object)o.getClass().getName());
            obj.put("gid", (Object)eo.globalID());
            return obj;
        }
        catch (JSONException e) {
            throw new MarshallException("Failed to marshall EO.", (Throwable)e);
        }
    }
}

