/*
 * Decompiled with CFR 0.152.
 */
package er.imadaptor;

import com.levelonelabs.aim.AIMBuddy;
import com.levelonelabs.aim.AIMClient;
import com.levelonelabs.aim.AIMListener;
import er.imadaptor.AbstractInstantMessenger;
import er.imadaptor.BuddyOfflineException;
import er.imadaptor.ConnectedTooFastException;
import er.imadaptor.IInstantMessenger;
import er.imadaptor.IInstantMessengerFactory;
import er.imadaptor.IMConnectionException;
import er.imadaptor.MessageException;
import java.util.Iterator;
import java.util.LinkedList;

public class AimBotInstantMessenger
extends AbstractInstantMessenger {
    private boolean _connected;
    private AIMClient _sender;
    private AimBotListener _listener = new AimBotListener();
    private long _lastConnectionAttempt;

    public AimBotInstantMessenger(String screenName, String password) {
        super(screenName, password);
    }

    public long buddyListLastModified() {
        return System.currentTimeMillis();
    }

    public synchronized boolean isBuddyOnline(String buddyName) {
        AIMBuddy buddy = this.getBuddy(buddyName);
        boolean online = buddy != null && buddy.isOnline();
        return online;
    }

    public synchronized AIMBuddy getBuddy(String buddyName) {
        AIMBuddy buddy;
        if (this._sender == null) {
            buddy = null;
        } else {
            buddy = this._sender.getBuddy(buddyName);
            if (buddy == null) {
                this._sender.addBuddy(new AIMBuddy(buddyName));
                buddy = this._sender.getBuddy(buddyName);
            }
        }
        return buddy;
    }

    public synchronized void addBuddy(String buddyName) {
        if (this._sender != null) {
            this._sender.addBuddy(new AIMBuddy(buddyName));
        }
    }

    public void removeBuddy(String buddyName) {
        if (this._sender != null) {
            this._sender.removeBuddy(new AIMBuddy(buddyName));
        }
    }

    public String[] getGroupNames() {
        return new String[]{"Buddies"};
    }

    public String[] getBuddiesInGroupNamed(String groupName) {
        LinkedList<String> buddyNamesList = new LinkedList<String>();
        Iterator buddyNamesIter = this._sender.getBuddyNames();
        while (buddyNamesIter.hasNext()) {
            String buddyName = (String)buddyNamesIter.next();
            buddyNamesList.add(buddyName);
        }
        String[] buddyNames = buddyNamesList.toArray(new String[buddyNamesList.size()]);
        return buddyNames;
    }

    public synchronized void connect() throws IMConnectionException {
        long now;
        if (this._connected) {
            this.disconnect();
        }
        if ((now = System.currentTimeMillis()) - this._lastConnectionAttempt <= 900000L) {
            throw new ConnectedTooFastException("You attempted to connect repeatedly too quickly.");
        }
        this._lastConnectionAttempt = now;
        this._sender = new AIMClient(this.getScreenName(), this.getPassword(), "", true);
        this._sender.addAIMListener((AIMListener)this._listener);
        this._sender.signOn();
        this._sender.setAvailable();
        this._connected = true;
    }

    public synchronized void disconnect() {
        if (this._connected) {
            this._sender.signOff();
            this._sender = null;
            this._connected = false;
        }
    }

    public synchronized boolean isConnected() {
        return this._connected;
    }

    public String getAwayMessage(String buddyName) {
        return null;
    }

    public String getStatusMessage(String buddyName) {
        return null;
    }

    public boolean isBuddyAway(String buddyName) {
        return false;
    }

    public synchronized void sendMessage(String buddyName, String message, boolean ignoreIfOffline) throws MessageException {
        AIMBuddy buddy;
        if (this._sender != null && (buddy = this.getBuddy(buddyName)) != null) {
            if (!buddy.isOnline()) {
                if (!ignoreIfOffline) {
                    throw new BuddyOfflineException("The buddy '" + buddyName + "' is not online.");
                }
            } else {
                this._sender.sendMessage(buddy, message);
            }
        }
    }

    public static class Factory
    implements IInstantMessengerFactory {
        public IInstantMessenger createInstantMessenger(String screenName, String password) {
            return new AimBotInstantMessenger(screenName, password);
        }
    }

    protected class AimBotListener
    implements AIMListener {
        protected AimBotListener() {
        }

        public void handleBuddyAvailable(AIMBuddy buddy, String _message) {
        }

        public void handleBuddySignOff(AIMBuddy buddy, String info) {
        }

        public void handleBuddySignOn(AIMBuddy buddy, String info) {
        }

        public void handleBuddyUnavailable(AIMBuddy buddy, String message) {
        }

        public void handleConnected() {
        }

        public void handleDisconnected() {
        }

        public void handleError(String error, String message) {
        }

        public void handleMessage(AIMBuddy buddy, String message) {
            AimBotInstantMessenger.this.fireMessageReceived(buddy.getName(), message);
        }

        public void handleWarning(AIMBuddy buddy, int amount) {
        }
    }
}

