/*
 * Decompiled with CFR 0.152.
 */
package er.imadaptor;

import er.imadaptor.AbstractInstantMessenger;
import er.imadaptor.ConnectedTooFastException;
import er.imadaptor.IInstantMessenger;
import er.imadaptor.IInstantMessengerFactory;
import er.imadaptor.IMConnectionException;
import er.imadaptor.InstantMessengerException;
import er.imadaptor.MessageException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.channel.aolim.AOLIM;
import org.walluck.oscar.client.AbstractOscarClient;
import org.walluck.oscar.client.Buddy;
import org.walluck.oscar.client.DaimLoginEvent;

public class DaimInstantMessenger
extends AbstractInstantMessenger {
    private boolean _connected;
    private DaimOscarClient _oscarClient;
    private long _lastConnectionAttempt;

    public DaimInstantMessenger(String screenName, String password) {
        super(screenName, password);
    }

    public long buddyListLastModified() {
        return System.currentTimeMillis();
    }

    public void addBuddy(String buddyName) throws InstantMessengerException {
        try {
            if (this._oscarClient != null) {
                this._oscarClient.addBuddy(buddyName, "Group");
            }
        }
        catch (IOException e) {
            throw new InstantMessengerException("Failed to add buddy.", e);
        }
    }

    public void removeBuddy(String buddyName) throws InstantMessengerException {
        throw new InstantMessengerException("I can't do this right now.");
    }

    public void connect() throws IMConnectionException {
        long now;
        if (this._connected) {
            this.disconnect();
        }
        if ((now = System.currentTimeMillis()) - this._lastConnectionAttempt > 900000L) {
            this._lastConnectionAttempt = now;
            try {
                this._oscarClient = new DaimOscarClient();
                this._oscarClient.login(this.getScreenName(), this.getPassword());
            }
            catch (IOException e) {
                throw new IMConnectionException("Failed to connect to AIM.", e);
            }
        } else {
            throw new ConnectedTooFastException("You attempted to connect repeatedly too quickly.");
        }
    }

    public void disconnect() {
        if (this._oscarClient != null) {
            this._oscarClient.logout();
            this._oscarClient = null;
        }
    }

    public boolean isConnected() {
        return this._connected;
    }

    public boolean isBuddyOnline(String buddyName) {
        return this._oscarClient != null && this._oscarClient.isBuddyOnline(buddyName);
    }

    public String[] getGroupNames() {
        return new String[]{"Buddies"};
    }

    public String[] getBuddiesInGroupNamed(String groupName) {
        List buddiesList = this._oscarClient.getBuddies();
        return buddiesList.toArray(new String[buddiesList.size()]);
    }

    public String getAwayMessage(String buddyName) {
        return null;
    }

    public String getStatusMessage(String buddyName) {
        return null;
    }

    public boolean isBuddyAway(String buddyName) {
        return false;
    }

    public void sendMessage(String buddyName, String message, boolean ignoreIfOffline) throws MessageException {
        try {
            if (this._oscarClient != null) {
                this._oscarClient.sendIM(buddyName, message, 4);
            }
        }
        catch (IOException e) {
            throw new MessageException("Failed to send message.", e);
        }
    }

    public static class Factory
    implements IInstantMessengerFactory {
        public IInstantMessenger createInstantMessenger(String screenName, String password) {
            return new DaimInstantMessenger(screenName, password);
        }
    }

    public class DaimOscarClient
    extends AbstractOscarClient {
        private List<String> _buddies = new LinkedList<String>();
        private List<String> _onlineBuddies = new LinkedList<String>();
        private List<String> _offlineBuddies = new LinkedList<String>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isBuddyOnline(String buddyName) {
            boolean online;
            List<String> list = this._buddies;
            synchronized (list) {
                online = this._onlineBuddies.contains(buddyName.toLowerCase());
            }
            return online;
        }

        public List getBuddies() {
            return this._buddies;
        }

        public void buddyOffline(String buddyName, Buddy buddy) {
            if (buddyName != null) {
                String lcBuddyName = buddyName.toLowerCase();
                this._onlineBuddies.remove(lcBuddyName);
                this._offlineBuddies.add(lcBuddyName);
            }
        }

        public void buddyOnline(String buddyName, Buddy buddy) {
            if (buddyName != null) {
                String lcBuddyName = buddyName.toLowerCase();
                this._offlineBuddies.remove(lcBuddyName);
                this._onlineBuddies.add(lcBuddyName);
            }
        }

        public void removeBuddy(String buddyName) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void newBuddyList(Buddy[] buddies) {
            List<String> list = this._buddies;
            synchronized (list) {
                this._buddies.clear();
                this._onlineBuddies.clear();
                this._offlineBuddies.clear();
                for (int i = 0; i < buddies.length; ++i) {
                    this._buddies.add(buddies[i].getName().toLowerCase());
                }
            }
        }

        public void loginDone(DaimLoginEvent event) {
            super.loginDone(event);
            DaimInstantMessenger.this._connected = true;
        }

        public void incomingICQ(UserInfo userInfo, int arg1, int arg2, String message) {
            super.incomingICQ(userInfo, arg1, arg2, message);
            if (userInfo != null) {
                message = message.replaceAll("\\<.*?\\>", "");
                DaimInstantMessenger.this.fireMessageReceived(userInfo.getSN(), message);
            }
        }

        public void incomingIM(Buddy buddy, UserInfo userInfo, AOLIM im) {
            super.incomingIM(buddy, userInfo, im);
            String message = im.getMsg();
            if (buddy != null) {
                message = message.replaceAll("\\<.*?\\>", "");
                DaimInstantMessenger.this.fireMessageReceived(buddy.getName(), message);
            }
        }

        public void login(String screenName, String password) throws IOException {
            super.login(screenName, password);
        }

        public void loginError(DaimLoginEvent event) {
            super.loginError(event);
            DaimInstantMessenger.this._connected = false;
        }

        public void logout() {
            super.logout();
            DaimInstantMessenger.this._connected = false;
        }
    }
}

