/*
 * Decompiled with CFR 0.152.
 */
package er.bugtracker;

import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOQualifierEvaluation;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSValidation;
import er.bugtracker.Bug;
import er.bugtracker.State;
import er.bugtracker._Component;
import er.extensions.foundation.ERXArrayUtilities;
import java.util.Enumeration;

public class Component
extends _Component {
    public static ComponentClazz clazz = new ComponentClazz();

    public String sortOrder() {
        NSMutableArray array = new NSMutableArray();
        for (Component p = this; p != null; p = p.parent()) {
            array.addObject((Object)p.textDescription());
        }
        return array.valueForKeyPath("@reverse.toString").toString();
    }

    public int level() {
        return this.level(0);
    }

    public int level(int safe) {
        if (safe > 10) {
            return -1;
        }
        Component parent = this.parent();
        return parent == null ? 0 : 1 + parent.level(safe + 1);
    }

    public String indentedDescription() {
        int level = this.level();
        StringBuffer sb = new StringBuffer();
        if (level == -1) {
            sb.append("***");
        } else {
            for (int i = 0; i < this.level(); ++i) {
                sb.append("-");
            }
        }
        sb.append(this.valueForKey("textDescription"));
        return sb.toString();
    }

    public Object validateParent(Component newParent) {
        if (!this.okToSetParent(this, newParent)) {
            throw new NSValidation.ValidationException("Sorry: the parent-child relationship you are setting would create a cycle");
        }
        return null;
    }

    public boolean okToSetParent(Component child, Component parent) {
        return parent == null ? true : this.okToSetParent(child, (Component)((Object)parent.valueForKey("parent")));
    }

    public NSArray openBugs() {
        return ERXArrayUtilities.filteredArrayWithQualifierEvaluation(this.bugs(), (EOQualifierEvaluation)new EOQualifierEvaluation(){

            public boolean evaluateWithObject(Object object) {
                State state = ((Bug)object).state();
                return !((Object)((Object)state)).equals((Object)State.CLOSED) && !((Object)((Object)state)).equals((Object)State.DOCUMENT);
            }
        });
    }

    public NSArray openRequirements() {
        return ERXArrayUtilities.filteredArrayWithQualifierEvaluation(this.requirements(), (EOQualifierEvaluation)new EOQualifierEvaluation(){

            public boolean evaluateWithObject(Object object) {
                State state = ((Bug)object).state();
                return !((Object)((Object)state)).equals((Object)State.CLOSED) && !((Object)((Object)state)).equals((Object)State.DOCUMENT);
            }
        });
    }

    public static class ComponentClazz
    extends _Component._ComponentClazz {
        private NSMutableDictionary _cachedComponentsByGlobalID;
        private NSMutableArray _cachedComponents;
        private static NSArray DESCRIPTION_SORT = new NSArray((Object)EOSortOrdering.sortOrderingWithKey((String)"textDescription", (NSSelector)EOSortOrdering.CompareAscending));

        public synchronized NSArray orderedComponents(EOEditingContext ec) {
            Component component;
            NSMutableArray result = new NSMutableArray();
            if (this._cachedComponentsByGlobalID == null) {
                this._cachedComponents = new NSMutableArray();
                this._cachedComponentsByGlobalID = new NSMutableDictionary();
                this.addChildrenOfComponentToArray(null, result, ec);
                int level = 0;
                Enumeration e = result.objectEnumerator();
                while (e.hasMoreElements()) {
                    component = (Component)((Object)e.nextElement());
                    String sortOrder = (level < 10 ? "0" : "") + level;
                    this._cachedComponentsByGlobalID.setObjectForKey((Object)sortOrder, (Object)component.permanentGlobalID());
                    this._cachedComponents.addObject((Object)component.permanentGlobalID());
                    ++level;
                }
            }
            result.removeAllObjects();
            Enumeration e = this._cachedComponents.objectEnumerator();
            while (e.hasMoreElements()) {
                EOGlobalID gid = (EOGlobalID)e.nextElement();
                component = (Component)ec.faultForGlobalID(gid, ec);
                if (component != null) {
                    result.addObject((Object)component);
                    continue;
                }
                log.error((Object)("No object: " + gid));
            }
            return result;
        }

        public void addChildrenOfComponentToArray(Component c, NSMutableArray a, EOEditingContext ec) {
            NSArray children = c != null ? (NSArray)c.valueForKey("children") : EOUtilities.objectsMatchingKeyAndValue((EOEditingContext)ec, (String)"Component", (String)"parent", (Object)NSKeyValueCoding.NullValue);
            children = EOSortOrdering.sortedArrayUsingKeyOrderArray((NSArray)children, (NSArray)DESCRIPTION_SORT);
            Enumeration e = children.objectEnumerator();
            while (e.hasMoreElements()) {
                Component child = (Component)((Object)e.nextElement());
                a.addObject((Object)child);
                this.addChildrenOfComponentToArray(child, a, ec);
            }
        }
    }
}

