/*
 * Decompiled with CFR 0.152.
 */
package jofc2.model.elements;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jofc2.model.elements.Element;
import jofc2.model.metadata.Alias;
import jofc2.model.metadata.Converter;
import jofc2.util.StackKeyConverter;
import jofc2.util.StackValueConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackedBarChart
extends Element {
    private static final long serialVersionUID = -4495162733156231531L;
    private List<Key> keys = new ArrayList<Key>();

    public StackedBarChart() {
        super("bar_stack");
    }

    public List<Key> getKeys() {
        return this.keys;
    }

    public StackedBarChart addKeys(Key ... keys) {
        return this.addKeys(Arrays.asList(keys));
    }

    public StackedBarChart addKeys(List<Key> keys) {
        this.getKeys().addAll(keys);
        return this;
    }

    public StackedBarChart addStack(Stack ... stacks) {
        return this.copy(Arrays.asList(stacks));
    }

    public StackedBarChart addStack(List<Stack> stacks) {
        return this.copy(stacks);
    }

    public Stack newStack() {
        Stack s = new Stack();
        this.copy(Arrays.asList(s));
        return s;
    }

    public Stack lastStack() {
        if (this.getValues().isEmpty()) {
            return this.newStack();
        }
        return this.stack(this.getStackCount() - 1);
    }

    public Stack stack(int index) {
        return new Stack((List)this.getValues().get(index));
    }

    public int getStackCount() {
        return this.getValues().size();
    }

    private StackedBarChart copy(List<Stack> stacks) {
        for (Stack s : stacks) {
            this.getValues().add(s.getBackingList());
        }
        return this;
    }

    @Converter(value=StackKeyConverter.class)
    public static class Key
    implements Serializable {
        private String colour;
        private String text;
        @Alias(value="font-size")
        private Integer fontSize;

        public Key(String colour, String text, Integer fontSize) {
            this.colour = colour;
            this.text = text;
            this.fontSize = fontSize;
        }

        public String getColour() {
            return this.colour;
        }

        public void setColour(String colour) {
            this.colour = colour;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public Integer getFontSize() {
            return this.fontSize;
        }

        public void setFontSize(Integer fontSize) {
            this.fontSize = fontSize;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Stack
    implements Serializable {
        private transient List<Object> values;

        public Stack() {
            this.values = new ArrayList<Object>();
        }

        Stack(List<Object> values) {
            this.values = values;
        }

        public Stack addStackValues(StackValue ... values) {
            return this.doAdd(Arrays.asList(values));
        }

        public Stack addStackValues(List<StackValue> values) {
            return this.doAdd(values);
        }

        public Stack addValues(Number ... numbers) {
            return this.addValues(Arrays.asList(numbers));
        }

        public Stack addValues(List<Number> numbers) {
            for (Number number : numbers) {
                if (number == null) continue;
                this.doAdd(Collections.singletonList(new StackValue(number)));
            }
            return this;
        }

        private Stack doAdd(List<?> values) {
            this.values.addAll(values);
            return this;
        }

        List<Object> getBackingList() {
            return this.values;
        }
    }

    @Converter(value=StackValueConverter.class)
    public static class StackValue
    implements Serializable {
        private Number val;
        private String colour;
        @Alias(value="tip")
        private String tooltip;

        public StackValue(Number value) {
            this(value, null, null);
        }

        public StackValue(Number value, String colour) {
            this(value, colour, null);
        }

        public StackValue(Number value, String colour, String tooltip) {
            this.setValue(value);
            this.setColour(colour);
            this.setTooltip(tooltip);
        }

        public Number getValue() {
            return this.val;
        }

        public StackValue setValue(Number val) {
            this.val = val;
            return this;
        }

        public String getColour() {
            return this.colour;
        }

        public StackValue setColour(String colour) {
            this.colour = colour;
            return this;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public StackValue setTooltip(String tooltip) {
            this.tooltip = tooltip;
            return this;
        }
    }
}

