/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSLocking;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation._NSUtilities;

public class NSLock
implements NSLocking {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName("com.webobjects.foundation.NSLock");
    protected boolean _locked;
    protected short _waitingThreads;

    public synchronized void lock() {
        while (this._locked) {
            this._waitingThreads = (short)(this._waitingThreads + 1);
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                this.notify();
            }
            this._waitingThreads = (short)(this._waitingThreads - 1);
        }
        this._locked = true;
    }

    public synchronized void unlock() {
        this._locked = false;
        if (this._waitingThreads > 0) {
            this.notify();
        }
    }

    public synchronized boolean tryLock() {
        if (this._locked) {
            return false;
        }
        this._locked = true;
        return this._locked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean tryLock(long msecs) {
        if (!this._locked) {
            this._locked = true;
            return true;
        }
        if (msecs <= 0L) {
            return false;
        }
        long waitTime = msecs;
        long start = System.currentTimeMillis();
        this._waitingThreads = (short)(this._waitingThreads + 1);
        try {
            do {
                this.wait(waitTime);
                if (this._locked) continue;
                this._locked = true;
                boolean bl = true;
                return bl;
            } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ex) {
            this.notify();
            boolean bl = false;
            return bl;
        }
        finally {
            this._waitingThreads = (short)(this._waitingThreads - 1);
        }
    }

    public boolean tryLock(NSTimestamp timestamp) {
        return this.tryLock(timestamp.getTime() - System.currentTimeMillis());
    }

    public boolean lockBeforeDate(NSTimestamp timestamp) {
        return this.tryLock(timestamp);
    }

    public String toString() {
        return new String("<NSLock " + super.toString() + "> " + this._locked);
    }

    public synchronized boolean _isLocked() {
        return this._locked;
    }
}

