/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSCoding;
import com.webobjects.foundation.NSTimeZone;
import com.webobjects.foundation._NSGregorianCalendar;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class NSTimestamp
extends Timestamp
implements NSCoding {
    public static final Class _CLASS = _NSUtilitiesExtra._classWithFullySpecifiedNamePrime("com.webobjects.foundation.NSTimestamp");
    private static transient boolean _JVM131Compatible = false;
    public static final NSTimestamp DistantPast;
    public static final NSTimestamp DistantFuture;
    static final long serialVersionUID = 6870088373061302940L;
    private static int _DistantPastYear;
    private static int _DistantFutureYear;
    private transient Calendar _calendar;
    private transient boolean _notInConstructor = false;
    private static final String SerializationLegacyFieldKey = "_timeZone";
    private static final ObjectStreamField[] serialPersistentFields;

    public static long currentTimeIntervalSinceReferenceDate() {
        return System.currentTimeMillis() / 1000L;
    }

    public static NSTimestamp distantFuture() {
        return DistantFuture;
    }

    public static NSTimestamp distantPast() {
        return DistantPast;
    }

    public static long millisecondsToTimeInterval(long milliseconds) {
        return milliseconds / 1000L;
    }

    public static long timeIntervalToMilliseconds(long timeInterval) {
        return timeInterval * 1000L;
    }

    public Class classForCoder() {
        return _CLASS;
    }

    public static Object decodeObject(NSCoder coder) {
        long milliseconds = coder.decodeLong();
        int nanos = coder.decodeInt();
        String tzString = (String)coder.decodeObject();
        return new NSTimestamp(milliseconds, nanos, NSTimeZone.timeZoneWithName(tzString, true));
    }

    public void encodeWithCoder(NSCoder coder) {
        coder.encodeLong(this.getTime());
        coder.encodeInt(this.getNanos());
        coder.encodeObject(this.timeZone().getID());
    }

    public NSTimestamp() {
        this(System.currentTimeMillis());
    }

    public NSTimestamp(long time) {
        super(time);
        if (_JVM131Compatible) {
            this._shiftMilliseconds(0);
        } else {
            this._initialize(time, 0);
        }
        this._notInConstructor = true;
    }

    public NSTimestamp(long milliseconds, int nanoseconds) {
        super(milliseconds);
        if (_JVM131Compatible) {
            this._shiftMilliseconds(nanoseconds);
        } else {
            this._initialize(milliseconds, nanoseconds);
        }
        this._notInConstructor = true;
    }

    public NSTimestamp(long time, NSTimestamp date) {
        super(time + date.getTime());
        if (_JVM131Compatible) {
            this._shiftMilliseconds(date.getNanos());
        } else {
            this._initialize(time + date.getTime(), date.getNanos());
        }
        this._notInConstructor = true;
    }

    public NSTimestamp(long time, TimeZone tz) {
        super(NSTimestamp._timestampAdjustedForZone(time, tz));
        if (_JVM131Compatible) {
            this._shiftMilliseconds(0);
        } else {
            this._initialize(NSTimestamp._timestampAdjustedForZone(time, tz), 0);
        }
        this._notInConstructor = true;
    }

    public NSTimestamp(long time, int nanos, TimeZone tz) {
        super(NSTimestamp._timestampAdjustedForZone(time, tz));
        if (_JVM131Compatible) {
            this._shiftMilliseconds(nanos);
        } else {
            this._initialize(NSTimestamp._timestampAdjustedForZone(time, tz), nanos);
        }
        this._notInConstructor = true;
    }

    public NSTimestamp(int year, int month, int date, int hour, int minute, int second, TimeZone tz) {
        super(0L);
        if (_DistantPastYear < 0) {
            _DistantPastYear = DistantPast.yearOfCommonEra();
            _DistantFutureYear = DistantFuture.yearOfCommonEra();
        }
        if (year <= _DistantPastYear) {
            throw new IllegalArgumentException("Cannot create a timestamp before " + DistantPast + " (or of that year).  Use another constructor.");
        }
        if (year >= _DistantFutureYear) {
            throw new IllegalArgumentException("Cannot create a timestamp after " + DistantFuture + " (or of that year).  Use another constructor.");
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        cal.clear();
        cal.set(year, month - 1, date, hour, minute, second);
        long millis = cal.getTime().getTime();
        NSTimeZone ntz = tz != null ? NSTimeZone._nstimeZoneWithTimeZone(tz) : NSTimeZone.getGMT();
        int rawOffset1 = ntz.getOffset(new NSTimestamp(millis));
        int rawOffset2 = ntz.getOffset(new NSTimestamp(millis - (long)rawOffset1));
        if (rawOffset1 == rawOffset2) {
            this.setTime(millis - (long)rawOffset1);
        } else if (hour == 2) {
            long special = rawOffset1 > rawOffset2 ? millis - (long)rawOffset2 : millis - (long)rawOffset1;
            this.setTime(special);
        } else {
            this.setTime(millis - (long)rawOffset2);
        }
        this._notInConstructor = true;
    }

    public NSTimestamp(Date date) {
        this(date.getTime());
    }

    public NSTimestamp(Timestamp sqlTimestamp) {
        this(_JVM131Compatible ? sqlTimestamp.getTime() : sqlTimestamp.getTime() - (long)(sqlTimestamp.getNanos() / 1000000), sqlTimestamp.getNanos());
    }

    public NSTimestamp timestampByAddingGregorianUnits(int years, int months, int days, int hours, int minutes, int seconds) {
        int yoce = this.yearOfCommonEra();
        int moy = this.monthOfYear();
        int dom = this.dayOfMonth();
        boolean dateIsPostGregorian = yoce > 1582 || yoce == 1582 && moy > 10 || yoce == 1582 && moy == 10 && dom >= 15;
        GregorianDateAsRawUnits units = new GregorianDateAsRawUnits(years, months, days, hours, minutes, seconds);
        long absoluteTimeAfterAddingReferenceUnits = this.absoluteTimeAddGregorianUnits(this.timeIntervalSinceReferenceDate(), units, dateIsPostGregorian) * 1000L;
        return new NSTimestamp(absoluteTimeAfterAddingReferenceUnits);
    }

    private long absoluteTimeAddGregorianUnits(long at, GregorianDateAsRawUnits units, boolean dateIsPostGregorian) {
        boolean newDateIsMidGregorian;
        if (!dateIsPostGregorian) {
            at += -864000L;
        }
        GregorianDateAsRawUnits gdate = this.absoluteTimeGetGregorianDate(at);
        long correction = at - this.gregorianDateGetAbsoluteTime(gdate);
        gdate.years += units.years;
        gdate.months += units.months;
        while (12 < gdate.months) {
            gdate.months -= 12;
            ++gdate.years;
        }
        while (gdate.months < 1) {
            gdate.months += 12;
            --gdate.years;
        }
        int monthdays = this.__DaysInMonth(gdate.months, gdate.years - 1970);
        if (monthdays < gdate.days) {
            gdate.days = monthdays;
        }
        gdate.days += units.days;
        while (monthdays < gdate.days) {
            ++gdate.months;
            if (12 < gdate.months) {
                gdate.months -= 12;
                ++gdate.years;
            }
            gdate.days -= monthdays;
            monthdays = this.__DaysInMonth(gdate.months, gdate.years - 1970);
        }
        while (gdate.days < 1) {
            --gdate.months;
            if (gdate.months < 1) {
                gdate.months += 12;
                --gdate.years;
            }
            monthdays = this.__DaysInMonth(gdate.months, gdate.years - 1970);
            gdate.days += monthdays;
        }
        int correctionFactor = 0;
        boolean newDateIsPreGregorian = gdate.years < 1582 || gdate.years == 1582 && gdate.months < 10 || gdate.years == 1582 && gdate.months == 10 && gdate.days <= 4;
        boolean bl = newDateIsMidGregorian = gdate.years == 1582 && gdate.months == 10 && gdate.days > 4 && gdate.days < 15;
        if (newDateIsPreGregorian) {
            correctionFactor = 864000;
        } else if (newDateIsMidGregorian) {
            gdate.days = 15;
        }
        long candidate_at0 = this.gregorianDateGetAbsoluteTime(gdate);
        long candidate_at1 = (long)((double)candidate_at0 + 3600.0 * (double)units.hours + 60.0 * (double)units.minutes + (double)units.seconds + (double)correctionFactor);
        return candidate_at1 + correction;
    }

    private GregorianDateAsRawUnits absoluteTimeGetGregorianDate(long at) {
        GregorianDateAsRawUnits gdate = new GregorianDateAsRawUnits();
        GregorianDateAsRawUnits ymd = new GregorianDateAsRawUnits();
        long fixedat = at;
        int absolute = (int)Math.floor((double)fixedat / 86400.0);
        this.__YMDFromAbsolute(absolute, ymd);
        gdate.years = ymd.years + 1970;
        gdate.months = ymd.months;
        gdate.days = ymd.days;
        gdate.hours = this.__DoubleModToInt(Math.floor((double)fixedat / 3600.0), 24);
        gdate.minutes = this.__DoubleModToInt(Math.floor((double)fixedat / 60.0), 60);
        gdate.seconds = (int)this.__DoubleMod(fixedat, 60);
        return gdate;
    }

    private long gregorianDateGetAbsoluteTime(GregorianDateAsRawUnits gdate) {
        long at = (long)(86400.0 * (double)this.__AbsoluteFromYMD(gdate.years - 1970, gdate.months, gdate.days));
        at = (long)((double)at + (3600.0 * (double)gdate.hours + 60.0 * (double)gdate.minutes + (double)gdate.seconds));
        return at;
    }

    private int __AbsoluteFromYMD(int year, int month, int day) {
        int absolute = 0;
        if (year < 0) {
            for (int idx = year; idx < 0; ++idx) {
                absolute -= this.__DaysAfterMonth(0, idx);
            }
        } else {
            for (int idx = year - 1; 0 <= idx; --idx) {
                absolute += this.__DaysAfterMonth(0, idx);
            }
        }
        return absolute += this.__DaysBeforeMonth(month, year) + day - 1;
    }

    private void __YMDFromAbsolute(int absolute, GregorianDateAsRawUnits ymd) {
        int y = 0;
        while (absolute < 0) {
            absolute += this.__DaysAfterMonth(0, --y);
        }
        int ydays = this.__DaysAfterMonth(0, y);
        while (ydays <= absolute) {
            absolute -= ydays;
            ydays = this.__DaysAfterMonth(0, ++y);
        }
        int m = absolute / 33 + 1;
        while (this.__DaysBeforeMonth(m + 1, y) <= absolute) {
            ++m;
        }
        ymd.years = y;
        ymd.months = m;
        ymd.days = absolute - this.__DaysBeforeMonth(m, y) + 1;
    }

    private int __DaysInMonth(int month, int year) {
        switch (month) {
            case 1: {
                return 31;
            }
            case 2: {
                if ((year += 1970) < 1600) {
                    return year % 4 == 0 ? 29 : 28;
                }
                int y = year % 400;
                return year % 4 == 0 && y != 100 && y != 200 && y != 300 ? 29 : 28;
            }
            case 3: {
                return 31;
            }
            case 4: {
                return 30;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 30;
            }
            case 7: {
                return 31;
            }
            case 8: {
                return 31;
            }
            case 9: {
                return 30;
            }
            case 10: {
                return 31;
            }
            case 11: {
                return 30;
            }
            case 12: {
                return 31;
            }
        }
        return 0;
    }

    private int __DaysBeforeMonth(int month, int year) {
        switch (month) {
            case 1: {
                return 0;
            }
            case 2: {
                return 31;
            }
            case 3: {
                return 31 + this.__DaysInMonth(2, year);
            }
            case 4: {
                return 62 + this.__DaysInMonth(2, year);
            }
            case 5: {
                return 92 + this.__DaysInMonth(2, year);
            }
            case 6: {
                return 123 + this.__DaysInMonth(2, year);
            }
            case 7: {
                return 153 + this.__DaysInMonth(2, year);
            }
            case 8: {
                return 184 + this.__DaysInMonth(2, year);
            }
            case 9: {
                return 215 + this.__DaysInMonth(2, year);
            }
            case 10: {
                return 245 + this.__DaysInMonth(2, year);
            }
            case 11: {
                return 276 + this.__DaysInMonth(2, year);
            }
            case 12: {
                return 306 + this.__DaysInMonth(2, year);
            }
            case 13: {
                return 337 + this.__DaysInMonth(2, year);
            }
        }
        return 0;
    }

    private int __DaysAfterMonth(int month, int year) {
        switch (month) {
            case 0: {
                return 337 + this.__DaysInMonth(2, year);
            }
            case 1: {
                return 306 + this.__DaysInMonth(2, year);
            }
            case 2: {
                return 306;
            }
            case 3: {
                return 275;
            }
            case 4: {
                return 245;
            }
            case 5: {
                return 214;
            }
            case 6: {
                return 184;
            }
            case 7: {
                return 153;
            }
            case 8: {
                return 122;
            }
            case 9: {
                return 92;
            }
            case 10: {
                return 61;
            }
            case 11: {
                return 31;
            }
            case 12: {
                return 0;
            }
        }
        return 0;
    }

    private int __DoubleModToInt(double d, int modulus) {
        int result = (int)Math.floor(d - Math.floor(d / (double)modulus) * (double)modulus);
        if (result < 0) {
            result += modulus;
        }
        return result;
    }

    private double __DoubleMod(double d, int modulus) {
        double result = d - Math.floor(d / (double)modulus) * (double)modulus;
        if (result < 0.0) {
            result += (double)modulus;
        }
        return result;
    }

    public NSTimestamp timestampByAddingTimeInterval(long interval) {
        return new NSTimestamp(interval * 1000L + this.getTime(), this.getNanos());
    }

    public long dayOfCommonEra() {
        int correction = 0;
        long time = this.getTime();
        if (time < 0L) {
            correction = -1;
        }
        return 719163L + time / 86400000L + (long)correction;
    }

    public int dayOfMonth() {
        this._initializeCalendar();
        return this._calendar.get(5);
    }

    public int dayOfWeek() {
        this._initializeCalendar();
        return this._calendar.get(7) - 1;
    }

    public int dayOfYear() {
        this._initializeCalendar();
        return this._calendar.get(6);
    }

    public int hourOfDay() {
        this._initializeCalendar();
        return this._calendar.get(11);
    }

    public int microsecondOfSecond() {
        this._initializeCalendar();
        return this._calendar.get(14) * 1000 + this.getNanos() / 1000;
    }

    public int minuteOfHour() {
        this._initializeCalendar();
        return this._calendar.get(12);
    }

    public int monthOfYear() {
        this._initializeCalendar();
        return this._calendar.get(2) + 1;
    }

    public int secondOfMinute() {
        this._initializeCalendar();
        return this._calendar.get(13);
    }

    public int yearOfCommonEra() {
        this._initializeCalendar();
        return this._calendar.get(1);
    }

    public void gregorianUnitsSinceTimestamp(IntRef years, IntRef months, IntRef days, IntRef hours, IntRef minutes, IntRef seconds, NSTimestamp time) {
        if (time == null) {
            throw new IllegalStateException(this.getClass().getName() + " gregorianUnitsSinceTimestamp: nil time parameter");
        }
        long base = time.timeIntervalSinceReferenceDate();
        long target = this.timeIntervalSinceReferenceDate();
        if (target != base) {
            int breakDirection;
            int incr;
            IntRef[] pointers = new IntRef[5];
            int[] offsets = new int[5];
            int[] secs = new int[]{31622400, 2678400, 86400, 3600, 60};
            NSTimestamp candidate = null;
            NSTimestamp over = null;
            pointers[0] = years;
            pointers[1] = months;
            pointers[2] = days;
            pointers[3] = hours;
            pointers[4] = minutes;
            if (target > base) {
                incr = 1;
                breakDirection = -1;
            } else {
                incr = -1;
                breakDirection = 1;
            }
            for (int i = 0; i < 5; ++i) {
                if (pointers[i] == null) continue;
                offsets[i] = -2 * incr + (int)(target - base) / secs[i];
                while (this.compare(over = time.timestampByAddingGregorianUnits(offsets[0], offsets[1], offsets[2], offsets[3], offsets[4], 0)) != breakDirection) {
                    int n = i;
                    offsets[n] = offsets[n] + incr;
                    candidate = over;
                }
                int n = i;
                offsets[n] = offsets[n] - incr;
                if (pointers[i] != null) {
                    pointers[i].value = offsets[i];
                }
                if (candidate == null) {
                    throw new IllegalStateException(this.getClass().getName() + " gregorianUnitsSinceTimestamp: bad stuff happened (null candidate)");
                }
                base = candidate.timeIntervalSinceReferenceDate();
            }
            if (seconds != null) {
                seconds.value = (int)(target - base);
            }
        } else {
            if (years != null) {
                years.value = 0;
            }
            if (months != null) {
                months.value = 0;
            }
            if (days != null) {
                days.value = 0;
            }
            if (hours != null) {
                hours.value = 0;
            }
            if (minutes != null) {
                minutes.value = 0;
            }
            if (seconds != null) {
                seconds.value = 0;
            }
        }
    }

    public long timeIntervalSinceTimestamp(NSTimestamp ts) {
        return (this.getTime() - ts.getTime()) / 1000L;
    }

    public long timeIntervalSinceNow() {
        return (this.getTime() - System.currentTimeMillis()) / 1000L;
    }

    public long timeIntervalSinceReferenceDate() {
        return this.getTime() / 1000L;
    }

    public int compare(NSTimestamp ts) {
        if (this.before(ts)) {
            return -1;
        }
        if (this.after(ts)) {
            return 1;
        }
        return 0;
    }

    public NSTimestamp earlierTimestamp(NSTimestamp ts) {
        if (this.before(ts)) {
            return this;
        }
        return ts;
    }

    public NSTimestamp laterTimestamp(NSTimestamp ts) {
        if (this.before(ts)) {
            return ts;
        }
        return this;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(24);
        buffer.append(this.yearOfCommonEra());
        buffer.append("-");
        if (this.monthOfYear() < 10) {
            buffer.append("0");
        }
        buffer.append(this.monthOfYear());
        buffer.append("-");
        if (this.dayOfMonth() < 10) {
            buffer.append("0");
        }
        buffer.append(this.dayOfMonth());
        buffer.append(" ");
        if (this.hourOfDay() < 10) {
            buffer.append("0");
        }
        buffer.append(this.hourOfDay());
        buffer.append(":");
        if (this.minuteOfHour() < 10) {
            buffer.append("0");
        }
        buffer.append(this.minuteOfHour());
        buffer.append(":");
        if (this.secondOfMinute() < 10) {
            buffer.append("0");
        }
        buffer.append(this.secondOfMinute());
        buffer.append(" ");
        buffer.append(this.timeZone().getID());
        return buffer.toString();
    }

    public NSTimeZone timeZone() {
        return NSTimeZone.getGMT();
    }

    private void _initializeCalendar() {
        if (this._calendar == null) {
            this._calendar = new _NSGregorianCalendar(this.timeZone(), this.getTime());
        }
    }

    private long _timeInMillis(long milliseconds, int nanos) {
        int nanosToMillis = nanos / 1000000;
        return milliseconds + (long)nanosToMillis;
    }

    public void setNanos(int nanoseconds) {
        if (this._notInConstructor) {
            throw new IllegalStateException(this.getClass().getName() + " is an immutable object.  Invocations of setNanos() are illegal.");
        }
        super.setNanos(nanoseconds);
    }

    public void setDate(int date) {
        if (this._notInConstructor) {
            throw new IllegalStateException(this.getClass().getName() + " is an immutable object.  Invocations of setDate() are illegal.");
        }
        super.setDate(date);
    }

    public void setHours(int hours) {
        if (this._notInConstructor) {
            throw new IllegalStateException(this.getClass().getName() + " is an immutable object.  Invocations of setHours() are illegal.");
        }
        super.setHours(hours);
    }

    public void setMinutes(int minutes) {
        if (this._notInConstructor) {
            throw new IllegalStateException(this.getClass().getName() + " is an immutable object.  Invocations of setMinutes() are illegal.");
        }
        super.setMinutes(minutes);
    }

    public void setMonth(int month) {
        if (this._notInConstructor) {
            throw new IllegalStateException(this.getClass().getName() + " is an immutable object.  Invocations of setMonth() are illegal.");
        }
        super.setMonth(month);
    }

    public void setSeconds(int seconds) {
        if (this._notInConstructor) {
            throw new IllegalStateException(this.getClass().getName() + " is an immutable object.  Invocations of setSeconds() are illegal.");
        }
        super.setSeconds(seconds);
    }

    public void setTime(long time) {
        if (this._notInConstructor) {
            throw new IllegalStateException(this.getClass().getName() + " is an immutable object.  Invocations of setTime() are illegal.");
        }
        super.setTime(time);
    }

    private static long _timestampAdjustedForZone(long time, TimeZone tz) {
        if (tz == null) {
            return time;
        }
        NSTimeZone ntz = NSTimeZone._nstimeZoneWithTimeZone(tz);
        int delta = ntz.secondsFromGMTForOffsetInSeconds(time / 1000L);
        return time + (long)delta * 1000L;
    }

    private void _shiftMilliseconds(int nanos) {
        int fractionalSeconds;
        long integralSeconds = this.getTime();
        long integralMillis = this._timeInMillis(integralSeconds, fractionalSeconds = this.getNanos() + nanos);
        int delta = (int)(integralMillis - integralSeconds);
        if (delta < 0) {
            delta = -delta;
        }
        int fractionalMillis = fractionalSeconds - 1000000 * delta;
        this.setTime(integralMillis);
        this.setNanos(fractionalMillis);
    }

    private void _initialize(long m, int n) {
        super.setTime(m);
        super.setNanos(super.getNanos() / 1000000 * 1000000 + n);
    }

    public long getTime() {
        if (!_JVM131Compatible) {
            return super.getTime();
        }
        return super.getTime() + (long)(super.getNanos() / 1000000);
    }

    public int getNanos() {
        return super.getNanos() % 1000000;
    }

    public void setYear(int year) {
        if (this._notInConstructor) {
            throw new IllegalStateException(this.getClass().getName() + " is an immutable object.  Invocations of setYear() are illegal.");
        }
        super.setYear(year);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        if (_JVM131Compatible) {
            this._shiftMilliseconds(0);
        }
        this._notInConstructor = true;
    }

    static {
        Timestamp ts = new Timestamp(29922898L);
        if (ts.getTime() % 1000L == 0L) {
            _JVM131Compatible = true;
        }
        DistantPast = new NSTimestamp(-62125920000000L);
        DistantFuture = new NSTimestamp(Long.MAX_VALUE);
        _DistantPastYear = -1;
        _DistantFutureYear = -1;
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField(SerializationLegacyFieldKey, NSTimeZone._CLASS)};
    }

    private class GregorianDateAsRawUnits {
        public int years = 0;
        public int months = 0;
        public int days = 0;
        public int hours = 0;
        public int minutes = 0;
        public int seconds = 0;

        public GregorianDateAsRawUnits(int[] units) {
            this.years = units[0];
            this.months = units[1];
            this.days = units[2];
            this.hours = units[3];
            this.minutes = units[4];
            this.seconds = units[5];
        }

        public GregorianDateAsRawUnits(int y, int m, int d, int h, int min, int s) {
            this.years = y;
            this.months = m;
            this.days = d;
            this.hours = h;
            this.minutes = min;
            this.seconds = s;
        }

        public GregorianDateAsRawUnits() {
        }

        public String toString() {
            return "<GregorianDateAsRawUnits years=" + this.years + "months=" + this.months + "days=" + this.days + "hours=" + this.hours + "minutes=" + this.minutes + "seconds=" + this.seconds + ">";
        }
    }

    public static class IntRef {
        public int value;

        public String toString() {
            StringBuffer buffer = new StringBuffer(50);
            buffer.append(this.getClass().getName());
            buffer.append(" < value = ");
            buffer.append(this.value);
            buffer.append(" >");
            return new String(buffer);
        }
    }
}

