/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation._NSMutableIntegerDictionary;
import com.webobjects.foundation._NSSerialClassReflector;
import com.webobjects.foundation._NSSerialFieldDesc;
import java.io.Externalizable;
import java.io.InvalidClassException;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.WeakHashMap;

public abstract class _NSObjectStreamClass
implements Serializable {
    private static _NSSerialClassReflector.Factory _reflFactory;
    private static WeakHashMap _cachedDescs;
    private InvalidClassException deserializeEx;
    public static final ObjectStreamField[] NO_FIELDS;
    protected static Constructor objectStreamClassCtor;
    protected Class clazz;
    protected String name;
    protected long uid;
    protected boolean serializable;
    protected boolean externalizable;
    protected boolean isProxy;
    protected _NSObjectStreamClass superDesc;
    protected _NSSerialClassReflector reflector;
    protected _NSSerialFieldDesc[] fieldDescs;
    protected Method[] methodsForSerialization;
    protected int numPrimFields = -1;
    protected int numObjFields = -1;
    protected _NSMutableIntegerDictionary primFieldPos;
    protected _NSMutableIntegerDictionary objFieldPos;
    protected _NSObjectStreamClass[] hierarchy;

    private _NSObjectStreamClass cloneFor(Class cl) throws InvalidClassException {
        if (this.clazz == cl) {
            return this;
        }
        return _NSObjectStreamClass.lookup(this.clazz);
    }

    private void initForPutFields() {
        this.numPrimFields = 0;
        this.numObjFields = 0;
        this.primFieldPos = new _NSMutableIntegerDictionary(this.fieldDescs.length);
        this.objFieldPos = new _NSMutableIntegerDictionary(this.fieldDescs.length);
        for (int i = 0; i < this.fieldDescs.length; ++i) {
            _NSSerialFieldDesc fDesc = this.fieldDescs[i];
            if (fDesc.isPrimitive()) {
                this.primFieldPos.setIntegerForKey(this.numPrimFields++, fDesc.name());
                continue;
            }
            this.objFieldPos.setIntegerForKey(this.numObjFields++, fDesc.name());
        }
    }

    protected _NSObjectStreamClass() {
    }

    protected _NSObjectStreamClass(Class cl) {
        this.clazz = cl;
        this.name = this.clazz.getName();
        this.uid = this.serialVersionUID(this.clazz);
        this.isProxy = Proxy.isProxyClass(this.clazz);
        this.serializable = Serializable.class.isAssignableFrom(this.clazz);
        this.externalizable = Externalizable.class.isAssignableFrom(this.clazz);
        this.reflector = _reflFactory.classReflector(this.clazz);
        this.fieldDescs = this.reflector.serializableFields();
        this.methodsForSerialization = this.reflector.methodsForSerialization();
        Class superCl = this.clazz.getSuperclass();
        this.superDesc = superCl != null ? _NSObjectStreamClass.lookup(superCl) : null;
    }

    protected long serialVersionUID(Class cl) {
        ObjectStreamClass osc = ObjectStreamClass.lookup(cl);
        return osc.getSerialVersionUID();
    }

    public _NSSerialFieldDesc[] serializableFields() {
        return this.fieldDescs;
    }

    public boolean hasWriteObject() {
        return this.methodsForSerialization[0] != null;
    }

    public Method writeObjectMethod() {
        return this.methodsForSerialization[0];
    }

    public boolean hasWriteReplace() {
        return this.methodsForSerialization[2] != null;
    }

    public Method writeReplaceMethod() {
        return this.methodsForSerialization[2];
    }

    public _NSObjectStreamClass[] classHierarchy() throws InvalidClassException {
        Class end;
        if (this.hierarchy != null) {
            return this.hierarchy;
        }
        ArrayList<_NSObjectStreamClass> slots = new ArrayList<_NSObjectStreamClass>();
        Class start = this.clazz;
        for (end = this.clazz; end != null && (class$java$io$Serializable == null ? _NSObjectStreamClass.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(end); end = end.getSuperclass()) {
        }
        _NSObjectStreamClass d = this;
        while (d != null) {
            Class c;
            String searchName = d.clazz != null ? d.clazz.getName() : d.name;
            Class match = null;
            for (c = start; c != end; c = c.getSuperclass()) {
                if (!searchName.equals(c.getName())) continue;
                match = c;
                break;
            }
            if (match != null) {
                for (c = start; c != match; c = c.getSuperclass()) {
                    slots.add(_NSObjectStreamClass.lookup(c));
                }
                start = match.getSuperclass();
            }
            slots.add(d.cloneFor(match));
            d = d.superDesc;
        }
        for (Class c = start; c != end; c = c.getSuperclass()) {
            slots.add(_NSObjectStreamClass.lookup(c));
        }
        Collections.reverse(slots);
        this.hierarchy = slots.toArray(new _NSObjectStreamClass[slots.size()]);
        return this.hierarchy;
    }

    public int numPrimFields() {
        if (this.numPrimFields == -1) {
            this.initForPutFields();
        }
        return this.numPrimFields;
    }

    public int numObjFields() {
        if (this.numObjFields == -1) {
            this.initForPutFields();
        }
        return this.numObjFields;
    }

    public int primFieldPosition(String fieldName) {
        int i;
        if (this.primFieldPos == null) {
            this.initForPutFields();
        }
        if ((i = this.primFieldPos.integerForKey(fieldName)) == Integer.MIN_VALUE) {
            throw new IllegalArgumentException(fieldName + " does not exist");
        }
        return i;
    }

    public int objFieldPosition(String fieldName) {
        int i;
        if (this.objFieldPos == null) {
            this.initForPutFields();
        }
        if ((i = this.objFieldPos.integerForKey(fieldName)) == Integer.MIN_VALUE) {
            throw new IllegalArgumentException(fieldName + " does not exist");
        }
        return i;
    }

    public boolean isProxy() {
        return this.isProxy;
    }

    public _NSObjectStreamClass superDesc() {
        return this.superDesc;
    }

    public Class forClass() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public long getSerialVersionUID() {
        return this.uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static _NSObjectStreamClass lookup(Class cl) {
        if (!Serializable.class.isAssignableFrom(cl)) {
            return null;
        }
        _NSObjectStreamClass[] _NSObjectStreamClassArray = _cachedDescs;
        synchronized (_cachedDescs) {
            _NSObjectStreamClass[] entry = (_NSObjectStreamClass[])_cachedDescs.get(cl);
            if (entry == null) {
                entry = new _NSObjectStreamClass[1];
                _cachedDescs.put(cl, entry);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            _NSObjectStreamClassArray = entry;
            synchronized (entry) {
                if (entry[0] == null) {
                    try {
                        entry[0] = (_NSObjectStreamClass)objectStreamClassCtor.newInstance(cl);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new InternalError();
                    }
                }
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return entry[0];
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(255);
        buf.append(this.name);
        buf.append(": static final long serialVersionUID = ");
        buf.append(this.uid);
        return buf.toString();
    }

    static {
        _cachedDescs = new WeakHashMap();
        NO_FIELDS = new ObjectStreamField[0];
        _reflFactory = (_NSSerialClassReflector.Factory)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return _NSSerialClassReflector.factory();
            }
        });
    }
}

