/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.xml;

import com.webobjects.foundation._NSSerialFieldDesc;
import com.webobjects.foundation.xml.NSXMLObjectStreamConstants;
import com.webobjects.foundation.xml.NSXMLOutputStream;
import com.webobjects.foundation.xml._NSXMLObjectStreamClass;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import org.w3c.dom.Element;

final class _NSXMLPutField
extends ObjectOutputStream.PutField
implements NSXMLObjectStreamConstants {
    private final NSXMLOutputStream _xmlOs;
    private final NSXMLOutputStream.DOMRecursiveInfo _DOMRecursiveInfo;
    private final _NSXMLObjectStreamClass _osc;
    private final Element[] _primFields;
    private final Element[] _objFields;
    private Object[] _storedObjects;
    private final _NSSerialFieldDesc[] _fieldDescs;
    private boolean _writtenOnce;

    _NSXMLPutField(NSXMLOutputStream os, _NSXMLObjectStreamClass osc, NSXMLOutputStream.DOMRecursiveInfo info) {
        this._xmlOs = os;
        this._osc = osc;
        this._DOMRecursiveInfo = info;
        this._primFields = new Element[this._osc.numPrimFields()];
        this._objFields = new Element[this._osc.numObjFields()];
        this._storedObjects = new Object[this._osc.numObjFields()];
        this._fieldDescs = this._osc.serializableFields();
    }

    public void put(String name, boolean val) {
        Element ele = NSXMLOutputStream.createTextElement(this._xmlOs._doc, "boolean", val ? "true" : "false");
        ele.setAttribute("field", name);
        this._primFields[this._osc.primFieldPosition((String)name)] = ele;
    }

    public void put(String name, byte val) {
        Element ele = NSXMLOutputStream.createTextElement(this._xmlOs._doc, "byte", String.valueOf(val));
        ele.setAttribute("field", name);
        this._primFields[this._osc.primFieldPosition((String)name)] = ele;
    }

    public void put(String name, short val) {
        Element ele = NSXMLOutputStream.createTextElement(this._xmlOs._doc, "short", String.valueOf(val));
        ele.setAttribute("field", name);
        this._primFields[this._osc.primFieldPosition((String)name)] = ele;
    }

    public void put(String name, char val) {
        Element ele = NSXMLOutputStream.createTextElement(this._xmlOs._doc, "ch", _NSSerialFieldDesc.sanitizeCharForXML(val, false));
        ele.setAttribute("field", name);
        this._primFields[this._osc.primFieldPosition((String)name)] = ele;
    }

    public void put(String name, int val) {
        Element ele = NSXMLOutputStream.createTextElement(this._xmlOs._doc, "int", String.valueOf(val));
        ele.setAttribute("field", name);
        this._primFields[this._osc.primFieldPosition((String)name)] = ele;
    }

    public void put(String name, long val) {
        Element ele = NSXMLOutputStream.createTextElement(this._xmlOs._doc, "long", String.valueOf(val));
        ele.setAttribute("field", name);
        this._primFields[this._osc.primFieldPosition((String)name)] = ele;
    }

    public void put(String name, float val) {
        Element ele = NSXMLOutputStream.createTextElement(this._xmlOs._doc, "float", String.valueOf(val));
        ele.setAttribute("field", name);
        this._primFields[this._osc.primFieldPosition((String)name)] = ele;
    }

    public void put(String name, double val) {
        Element ele = NSXMLOutputStream.createTextElement(this._xmlOs._doc, "double", String.valueOf(val));
        ele.setAttribute("field", name);
        this._primFields[this._osc.primFieldPosition((String)name)] = ele;
    }

    public void put(String name, Object val) {
        this._storedObjects[this._osc.objFieldPosition((String)name)] = val;
    }

    public void write(ObjectOutput out) throws IOException {
        NSXMLOutputStream os = (NSXMLOutputStream)out;
        this.writeFields(os.curParent());
    }

    private void writeFields(Element parent) throws IOException {
        if (!this._writtenOnce) {
            int i;
            for (i = 0; i < this._primFields.length; ++i) {
                if (this._primFields[i] == null) {
                    _NSSerialFieldDesc fDesc = this._fieldDescs[i];
                    _NSXMLObjectStreamClass.PrimitiveValue pv = (_NSXMLObjectStreamClass.PrimitiveValue)_NSXMLObjectStreamClass.primitiveClassToXMLTag.get(fDesc.type());
                    Element ele = NSXMLOutputStream.createTextElement(this._xmlOs._doc, pv.tag, pv.zeroValue);
                    ele.setAttribute("field", fDesc.name());
                    this._primFields[i] = ele;
                }
                parent.appendChild(this._primFields[i]);
            }
            for (i = 0; i < this._objFields.length; ++i) {
                Element ele = null;
                ele = this._storedObjects[i] != null ? this._xmlOs.writeInternalObject(this._storedObjects[i], null) : NSXMLOutputStream.createTextElement(this._xmlOs._doc, "object", "");
                _NSSerialFieldDesc fDesc = this._fieldDescs[i + this._primFields.length];
                ele.setAttribute("field", fDesc.name());
                this._objFields[i] = ele;
                parent.appendChild(ele);
            }
        } else {
            int i;
            for (i = 0; i < this._primFields.length; ++i) {
                parent.appendChild(this._primFields[i].cloneNode(true));
            }
            for (i = 0; i < this._objFields.length; ++i) {
                parent.appendChild(this._objFields[i].cloneNode(true));
            }
        }
        this._storedObjects = null;
        this._writtenOnce = true;
    }

    void writeFields() throws IOException {
        this.writeFields(this._DOMRecursiveInfo._curParent);
    }
}

