/*
 * Decompiled with CFR 0.152.
 */
package er.corebusinesslogic.audittrail;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOKeyGlobalID;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSUtilities;
import er.corebusinesslogic.audittrail.ERCAuditTrail;
import er.corebusinesslogic.audittrail.ERCAuditTrailEntry;
import er.corebusinesslogic.audittrail.ERCAuditTrailType;
import er.extensions.eof.ERXConstant;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.eof.ERXGenericRecord;
import er.extensions.eof.ERXKeyGlobalID;
import er.extensions.foundation.ERXPatcher;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXSelectorUtilities;
import er.extensions.foundation.ERXValueUtilities;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERCAuditTrailHandler {
    static final Logger log = Logger.getLogger(ERCAuditTrail.class);
    private static final String ERXAUDIT_KEYS = "ERXAuditKeys";
    private static ERCAuditTrailHandler _handler;
    protected NSMutableDictionary<String, Configuration> configuration = new NSMutableDictionary();

    public static void initialize() {
        String className = ERXProperties.stringForKeyWithDefault((String)"er.corebusinesslogic.ERCAuditTrailClassName", (String)ERCAuditTrailHandler.class.getName());
        Class c = ERXPatcher.classForName((String)className);
        _handler = (ERCAuditTrailHandler)_NSUtilities.instantiateObject((Class)c, (Class[])new Class[0], (Object[])new Object[0], (boolean)true, (boolean)false);
        NSSelector sel = ERXSelectorUtilities.notificationSelector((String)"modelGroupDidLoad");
        NSNotificationCenter.defaultCenter().addObserver((Object)_handler, sel, "ERXModelGroupAddedNotification", null);
    }

    public void modelGroupDidLoad(NSNotification n) {
        this.configuration.removeAllObjects();
        EOModelGroup group = (EOModelGroup)n.object();
        Enumeration e = group.models().objectEnumerator();
        while (e.hasMoreElements()) {
            EOModel model = (EOModel)e.nextElement();
            Enumeration e1 = model.entities().objectEnumerator();
            while (e1.hasMoreElements()) {
                EOEntity entity = (EOEntity)e1.nextElement();
                if (entity.userInfo() == null || entity.userInfo().objectForKey((Object)ERXAUDIT_KEYS) == null) continue;
                this.configureEntity(entity);
            }
        }
        log.info((Object)("Configuration : " + this.configuration));
        NSNotificationCenter.defaultCenter().removeObserver((Object)_handler, "ERXModelGroupAddedNotification", null);
        NSSelector sel = ERXSelectorUtilities.notificationSelector((String)"handleSave");
        NSNotificationCenter.defaultCenter().addObserver((Object)_handler, sel, "EOEditingContextWillSaveChanges", null);
    }

    protected Configuration configureEntity(EOEntity entity) {
        Configuration config = (Configuration)this.configuration.objectForKey((Object)entity.name());
        if (config == null) {
            config = new Configuration();
            this.configuration.setObjectForKey((Object)config, (Object)entity.name());
        }
        if (entity.userInfo() != null) {
            String val;
            Object object = entity.userInfo().objectForKey((Object)ERXAUDIT_KEYS);
            String string = val = object != null ? object.toString() : null;
            if (val != null) {
                NSArray keys = null;
                keys = val.length() == 0 ? entity.classDescriptionForInstances().attributeKeys() : ERXValueUtilities.arrayValue((Object)val);
                config.isAudited = true;
                config.keys.addObjectsFromArray(keys);
                Enumeration e = config.keys.objectEnumerator();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    EOEntity source = entity;
                    Enumeration e1 = NSArray.componentsSeparatedByString((String)key, (String)".").objectEnumerator();
                    while (e1.hasMoreElements()) {
                        String part = (String)e1.nextElement();
                        EORelationship rel = source._relationshipForPath(key);
                        if (rel == null) continue;
                        if (rel.isFlattened()) {
                            throw new IllegalStateException("Can't handle flattened relations, use the definition: " + rel);
                        }
                        if (rel.isToMany()) {
                            EOEntity destinationEntity = rel.destinationEntity();
                            Configuration destinationConfiguration = this.configureEntity(destinationEntity);
                            String inverseName = rel.anyInverseRelationship().name();
                            destinationConfiguration.notificationKeys.addObject((Object)inverseName);
                            source = rel.destinationEntity();
                            continue;
                        }
                        config.keys.addObject((Object)rel.name());
                    }
                }
            }
        }
        return config;
    }

    public void handleSave(NSNotification n) {
        if (this.configuration.count() == 0) {
            return;
        }
        EOEditingContext ec = (EOEditingContext)n.object();
        if (ec.parentObjectStore() instanceof EOObjectStoreCoordinator) {
            ec.processRecentChanges();
            NSArray insertedObjects = ec.insertedObjects().immutableClone();
            for (EOEnterpriseObject eo : insertedObjects) {
                if (ERCAuditTrailEntry.clazz.entityName().equals(eo.entityName())) {
                    ec.deleteObject(eo);
                }
                if (!ERCAuditTrail.clazz.entityName().equals(eo.entityName())) continue;
                ec.deleteObject(eo);
            }
            ec.processRecentChanges();
            NSArray updatedObjects = ec.updatedObjects();
            NSArray deletedObjects = ec.deletedObjects();
            this.handleSave(ec, "inserted", insertedObjects);
            this.handleSave(ec, "updated", updatedObjects);
            this.handleSave(ec, "deleted", deletedObjects);
        }
    }

    protected void handleUpdate(EOEditingContext ec, EOEnterpriseObject eo) {
        NSMutableArray keys = ((Configuration)this.configuration.objectForKey((Object)eo.entityName())).keys;
        NSDictionary committedSnapshotForObject = ec.committedSnapshotForObject(eo);
        NSDictionary changes = eo.changesFromSnapshot(committedSnapshotForObject);
        Enumeration e1 = changes.keyEnumerator();
        while (e1.hasMoreElements()) {
            String key = (String)e1.nextElement();
            if (!keys.containsObject((Object)key)) continue;
            this.handleUpdate(ec, eo, key, committedSnapshotForObject.objectForKey((Object)key), changes.objectForKey((Object)key));
        }
    }

    private void handleSave(EOEditingContext ec, String typeKey, EOEnterpriseObject eo) {
        if (typeKey.equals("updated")) {
            this.handleUpdate(ec, eo);
        } else if (typeKey.equals("inserted")) {
            this.handleInsert(ec, eo, this.serializeObject(eo));
        } else if (typeKey.equals("deleted")) {
            this.handleDelete(ec, eo, this.serializeObject(eo));
        }
    }

    protected NSDictionary serializeObject(EOEnterpriseObject eo) {
        NSMutableDictionary result = new NSMutableDictionary();
        result.addEntriesFromDictionary(eo.snapshot());
        Enumeration e = eo.snapshot().keyEnumerator();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object value = result.objectForKey((Object)key);
            if (value instanceof ERXConstant.Constant) {
                ERXConstant.Constant constant = (ERXConstant.Constant)value;
                result.setObjectForKey(constant.value(), (Object)key);
                continue;
            }
            if (value == NSKeyValueCoding.NullValue) {
                result.removeObjectForKey((Object)key);
                continue;
            }
            if (value instanceof ERXGenericRecord) {
                ERXGenericRecord rec = (ERXGenericRecord)value;
                result.setObjectForKey((Object)ERXKeyGlobalID.globalIDForGID((EOKeyGlobalID)rec.permanentGlobalID()).asString(), (Object)key);
                continue;
            }
            if (!(value instanceof NSArray)) continue;
            NSArray oldValue = (NSArray)value;
            NSMutableArray newValue = new NSMutableArray(oldValue.count());
            Enumeration e1 = newValue.objectEnumerator();
            while (e1.hasMoreElements()) {
                ERXGenericRecord rec = (ERXGenericRecord)e1.nextElement();
                newValue.addObject((Object)ERXKeyGlobalID.globalIDForGID((EOKeyGlobalID)rec.permanentGlobalID()).asString());
            }
            result.setObjectForKey((Object)newValue, (Object)key);
        }
        return result;
    }

    protected void handleSave(EOEditingContext ec, String typeKey, NSArray objects) {
        if (objects == null) {
            return;
        }
        Enumeration e = objects.objectEnumerator();
        while (e.hasMoreElements()) {
            EOEnterpriseObject eo = (EOEnterpriseObject)e.nextElement();
            Configuration config = (Configuration)this.configuration.objectForKey((Object)eo.entityName());
            if (config == null) continue;
            if (config.isAudited) {
                this.handleSave(ec, typeKey, eo);
                continue;
            }
            Enumeration e1 = config.notificationKeys.objectEnumerator();
            while (e1.hasMoreElements()) {
                String key = (String)e1.nextElement();
                EOEnterpriseObject target = (EOEnterpriseObject)eo.valueForKey(key);
                EOEntity entity = ERXEOAccessUtilities.entityForEo((EOEnterpriseObject)eo);
                String inverse = entity.relationshipNamed(key).anyInverseRelationship().name();
                if (typeKey.equals("updated")) {
                    this.handleUpdate(ec, target, inverse, eo);
                    continue;
                }
                if (typeKey.equals("inserted")) {
                    this.handleAdd(ec, target, inverse, eo);
                    continue;
                }
                if (!typeKey.equals("deleted")) continue;
                target = (EOEnterpriseObject)ec.committedSnapshotForObject(eo).valueForKey(key);
                this.handleRemove(ec, target, inverse, eo);
            }
        }
    }

    protected void handleInsert(EOEditingContext ec, EOEnterpriseObject eo, Object newValue) {
        this.handleChange(ec, eo, ERCAuditTrailType.INSERTED, null, null, newValue);
    }

    protected void handleUpdate(EOEditingContext ec, EOEnterpriseObject eo, String keyPath, Object oldValue, Object newValue) {
        this.handleChange(ec, eo, ERCAuditTrailType.UPDATED, keyPath, oldValue, newValue);
    }

    protected void handleDelete(EOEditingContext ec, EOEnterpriseObject eo, Object oldValue) {
        this.handleChange(ec, eo, ERCAuditTrailType.DELETED, null, oldValue, null);
    }

    protected void handleRemove(EOEditingContext ec, EOEnterpriseObject target, String keyPath, EOEnterpriseObject eo) {
        ERXGenericRecord rec = (ERXGenericRecord)target;
        this.handleChange(ec, target, ERCAuditTrailType.REMOVED, keyPath, this.serializeObject(eo), null);
    }

    protected void handleAdd(EOEditingContext ec, EOEnterpriseObject target, String keyPath, EOEnterpriseObject eo) {
        ERXGenericRecord rec = (ERXGenericRecord)target;
        this.handleChange(ec, target, ERCAuditTrailType.ADDED, keyPath, null, this.serializeObject(eo));
    }

    protected void handleUpdate(EOEditingContext ec, EOEnterpriseObject target, String keyPath, EOEnterpriseObject eo) {
        ERXGenericRecord rec = (ERXGenericRecord)target;
        EOEnterpriseObject oldValue = (EOEnterpriseObject)rec.valueForKeyPath(keyPath);
        this.handleChange(ec, target, ERCAuditTrailType.UPDATED, keyPath, oldValue, oldValue);
    }

    protected void handleChange(EOEditingContext ec, EOEnterpriseObject eo, ERCAuditTrailType type, String keyPath, Object oldValue, Object newValue) {
        ERXGenericRecord rec1;
        ERXGenericRecord rec = (ERXGenericRecord)eo;
        ERCAuditTrail trail = ERCAuditTrail.clazz.auditTrailForObject(ec, eo);
        if (trail == null) {
            trail = ERCAuditTrail.clazz.createAuditTrailForObject(ec, eo);
        }
        log.info((Object)((Object)((Object)trail) + " " + (Object)((Object)type) + ": " + rec.permanentGlobalID() + " " + keyPath + " from " + oldValue + " to " + newValue));
        if (oldValue instanceof ERXGenericRecord) {
            rec1 = (ERXGenericRecord)oldValue;
            oldValue = ERXKeyGlobalID.globalIDForGID((EOKeyGlobalID)rec1.permanentGlobalID()).asString();
        }
        if (newValue instanceof ERXGenericRecord) {
            rec1 = (ERXGenericRecord)newValue;
            newValue = ERXKeyGlobalID.globalIDForGID((EOKeyGlobalID)rec1.permanentGlobalID()).asString();
        }
        trail.createEntry(type, keyPath, oldValue, newValue);
    }

    public class Configuration {
        public boolean isAudited = false;
        public NSMutableArray keys = new NSMutableArray();
        public NSMutableArray notificationKeys = new NSMutableArray();

        public String toString() {
            return "{ isAudited =" + this.isAudited + "; keys = " + this.keys + "; notificationKeys = " + this.notificationKeys + ";}";
        }
    }

    public static interface Delegate {
    }
}

