/*
 * Decompiled with CFR 0.152.
 */
package ag.kcmedia;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOJoin;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSchemaGeneration;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import org.apache.log4j.Logger;

public class EOModeler
extends WOComponent {
    private static final Logger log = Logger.getLogger(EOModeler.class);
    protected String modelPath;
    public boolean showTableNames = false;
    public EOModelGroup modelGroup;
    public EOModel model;
    public EOEntity entity;
    public EOEntity selectedEntity;
    public EOEntity subEntity;
    public EOEntity targetEntity;
    public EOAttribute attribute;
    public EORelationship relationship;
    public EOEntity destinationEntity;
    public EOAttribute prototype;
    public EOEntity prototypes;
    public String entityName = "NewEntity";
    public String sql;
    public NSArray attributesUsedInRelationships;

    public EOModeler(WOContext context) {
        super(context);
    }

    public void setModelPath(String value) {
        this.modelPath = value;
        this.modelGroup = new EOModelGroup();
        this.model = this.modelGroup.addModelWithPath(this.modelPath);
        this.prototypes = this.model.entityNamed("EOPrototypes");
        if (this.prototypes == null) {
            this.prototypes = this.model.entityNamed("EOJDBCPrototypes");
        }
    }

    public String modelPath() {
        if (this.modelPath == null) {
            this.modelPath = this.context().request().stringFormValueForKey("modelPath");
            if (this.modelPath == null) {
                this.modelPath = "/Volumes/Home/Roots/AHLogic.framework/Resources/armehaut.eomodeld";
            }
            log.info((Object)this.modelPath);
        }
        return this.modelPath;
    }

    public void awake() {
        super.awake();
        this.modelPath();
        this.attributesUsedInRelationships = null;
    }

    public void setRelationshipIsToMany(boolean value) {
        this.relationship.setToMany(value);
    }

    public boolean relationshipIsToMany() {
        return this.relationship.isToMany();
    }

    public void setRelationshipName(String value) {
        this.relationship.setName(value);
    }

    public String relationshipName() {
        return this.relationship.name();
    }

    public boolean relationshipIsClassProperty() {
        return this.selectedEntity.classProperties().containsObject((Object)this.relationship);
    }

    public void setRelationshipIsClassProperty(boolean value) {
        this.updateClassProperties(this.selectedEntity, this.relationship, value);
    }

    public void setAttributePrototype(EOAttribute value) {
        String oldName = this.attribute.columnName();
        this.attribute.setPrototype(value);
        this.attribute.setColumnName(oldName);
    }

    public EOAttribute attributePrototype() {
        return this.attribute.prototype();
    }

    public NSArray attributesUsedInRelationships() {
        if (this.attributesUsedInRelationships == null) {
            NSMutableArray array = new NSMutableArray((NSArray)this.valueForKeyPath("model.entities.relationships.joins.sourceAttribute"));
            array.addObject(this.valueForKeyPath("model.entities.relationships.joins.destinationAttribute"));
            this.attributesUsedInRelationships = (NSArray)array.valueForKeyPath("@flatten");
        }
        return this.attributesUsedInRelationships;
    }

    public boolean attributeHasRelationships() {
        return this.attributesUsedInRelationships().containsObject((Object)this.attribute);
    }

    public void setAttributeName(String value) {
        this.attribute.setColumnName(value);
        this.attribute.setName(value);
    }

    public String attributeName() {
        return this.attribute.name();
    }

    public boolean attributeIsPrimaryKey() {
        return this.selectedEntity.primaryKeyAttributes().containsObject((Object)this.attribute);
    }

    public boolean attributeIsClassProperty() {
        return this.selectedEntity.classProperties().containsObject((Object)this.attribute);
    }

    public void setAttributeIsClassProperty(boolean value) {
        this.updateClassProperties(this.selectedEntity, this.attribute, value);
    }

    public String selectedEntityString() {
        String string = "none";
        try {
            if (this.selectedEntity != null) {
                return this.selectedEntity.toString();
            }
        }
        catch (Exception ex) {
            string = "" + ex;
        }
        return string;
    }

    public WOComponent addAttribute() {
        this.addAttributeNamed(this.selectedEntity, "attributeName", null);
        return null;
    }

    public EOAttribute addAttributeNamed(EOEntity entity, String name, EOAttribute prototype) {
        EOAttribute a = new EOAttribute();
        a.setName(name);
        entity.addAttribute(a);
        if (prototype != null) {
            a.setPrototype(prototype);
        }
        a.setColumnName(name.toLowerCase());
        this.updateClassProperties(entity, a, false);
        return a;
    }

    public void updateClassProperties(EOEntity entity, Object o, boolean add) {
        NSMutableArray array = entity.classProperties().mutableClone();
        boolean contains = array.containsObject(o);
        if (add && !contains) {
            array.addObject(o);
            entity.setClassProperties((NSArray)array);
        } else if (!add && contains) {
            array.removeObject(o);
            entity.setClassProperties((NSArray)array);
        }
    }

    public void addRelationship(EOEntity selectedEntity, EOEntity targetEntity, EOAttribute foreignAttribute, boolean isToMany, boolean addBack) {
        String targetName = targetEntity.name().toLowerCase();
        String selectedName = selectedEntity.name().toLowerCase();
        EOAttribute selectedPK = (EOAttribute)selectedEntity.primaryKeyAttributes().objectAtIndex(0);
        if (foreignAttribute == null) {
            foreignAttribute = this.addAttributeNamed(targetEntity, selectedName + "id", selectedPK.prototype());
        }
        EORelationship relationship = new EORelationship();
        relationship.setName(targetName + (isToMany ? "s" : ""));
        selectedEntity.addRelationship(relationship);
        EOJoin join = new EOJoin(selectedPK, foreignAttribute);
        relationship.addJoin(join);
        relationship.setToMany(isToMany);
        relationship.setJoinSemantic(0);
        if (addBack) {
            relationship = new EORelationship();
            join = new EOJoin(foreignAttribute, selectedPK);
            relationship.setName(selectedName);
            targetEntity.addRelationship(relationship);
            relationship.addJoin(join);
            relationship.setToMany(false);
            relationship.setJoinSemantic(0);
        }
    }

    public void addBackRelationship(EOEntity selectedEntity, EOEntity targetEntity, EOAttribute foreignAttribute, boolean isToMany, boolean addBack) {
        EORelationship relationship = new EORelationship();
        String targetName = targetEntity.name().toLowerCase();
        String selectedName = selectedEntity.name().toLowerCase();
        EOAttribute selectedPK = (EOAttribute)targetEntity.primaryKeyAttributes().objectAtIndex(0);
        if (foreignAttribute == null) {
            foreignAttribute = this.addAttributeNamed(selectedEntity, targetName + "id", selectedPK.prototype());
        }
        relationship.setName(targetName + (isToMany ? "s" : ""));
        selectedEntity.addRelationship(relationship);
        EOJoin join = new EOJoin(foreignAttribute, selectedPK);
        relationship.addJoin(join);
        relationship.setToMany(isToMany);
        relationship.setJoinSemantic(0);
    }

    public void addRelationship(EOAttribute foreignAttribute, boolean isToMany, boolean addBack) {
        this.addRelationship(this.selectedEntity, this.targetEntity, foreignAttribute, isToMany, addBack);
    }

    public WOComponent addBackToOneRelationship() {
        this.addBackRelationship(this.selectedEntity, this.targetEntity, null, false, false);
        return null;
    }

    public WOComponent addBackToManyRelationship() {
        this.addBackRelationship(this.selectedEntity, this.targetEntity, null, true, false);
        return null;
    }

    public WOComponent addToOneRelationship() {
        this.addRelationship(null, false, false);
        return null;
    }

    public WOComponent addToManyRelationship() {
        this.addRelationship(null, true, false);
        return null;
    }

    public WOComponent addToOneWithBackRelationship() {
        this.addRelationship(null, false, true);
        return null;
    }

    public WOComponent addToManyWithBackRelationship() {
        this.addRelationship(null, true, true);
        return null;
    }

    public EORelationship addFlattenedRelationshipWithNamePathToEntity(String name, String path, EOEntity entity) {
        this.relationship = new EORelationship();
        this.relationship.setName(name);
        this.relationship.setDefinition(path);
        this.relationship.setJoinSemantic(0);
        this.selectedEntity.addRelationship(this.relationship);
        return this.relationship;
    }

    public EOEntity addFlattenedManyToManyRelationship(EOEntity selectedEntity, EOEntity targetEntity) {
        String name = "X" + selectedEntity.name() + targetEntity.name();
        name = name.toLowerCase() + "s";
        EOEntity intermediate = this.addManyToManyRelationship(selectedEntity, targetEntity);
        this.updateClassProperties(selectedEntity, selectedEntity.relationshipNamed(name), false);
        this.updateClassProperties(targetEntity, targetEntity.relationshipNamed(name), false);
        this.relationship = this.addFlattenedRelationshipWithNamePathToEntity(selectedEntity.name().toLowerCase() + "s", name + "." + targetEntity.name().toLowerCase(), selectedEntity);
        this.relationship = this.addFlattenedRelationshipWithNamePathToEntity(targetEntity.name().toLowerCase() + "s", name + "." + selectedEntity.name().toLowerCase(), targetEntity);
        return intermediate;
    }

    public EOEntity addManyToManyRelationship(EOEntity selectedEntity, EOEntity targetEntity) {
        EOEntity intermediate = new EOEntity();
        String name = "X" + selectedEntity.name() + targetEntity.name();
        intermediate.setName(name);
        intermediate.setExternalName(name.toLowerCase());
        this.model.addEntity(intermediate);
        this.addRelationship(selectedEntity, intermediate, null, true, true);
        this.addRelationship(targetEntity, intermediate, null, true, true);
        intermediate.setPrimaryKeyAttributes(intermediate.attributes());
        intermediate.setName(name);
        intermediate.setClassProperties(new NSArray());
        return intermediate;
    }

    public EOEntity addEntityWithName(EOModel model, String entityName) {
        this.entity = new EOEntity();
        this.entity.setName(entityName);
        this.entity.setExternalName(entityName.toLowerCase());
        model.addEntity(this.entity);
        EOAttribute oid = new EOAttribute();
        NSArray pks = new NSArray((Object)oid);
        this.entity.setPrimaryKeyAttributes(pks);
        oid.setPrototype(this.prototypes.attributeNamed("id"));
        oid.setColumnName("oid");
        oid.setName("oid");
        this.entity.addAttribute(oid);
        return this.entity;
    }

    public WOComponent addFlattenedManyToManyRelationship() {
        this.addFlattenedManyToManyRelationship(this.selectedEntity, this.targetEntity);
        return null;
    }

    public WOComponent addManyToManyRelationship() {
        this.addManyToManyRelationship(this.selectedEntity, this.targetEntity);
        return null;
    }

    public WOComponent update() {
        this.sql = "";
        try {
            EOAdaptor adaptor = EOAdaptor.adaptorWithModel((EOModel)this.model);
            EOSchemaGeneration synchronizationFactory = adaptor.synchronizationFactory();
            NSArray array = synchronizationFactory.createTableStatementsForEntityGroup(new NSArray((Object)this.selectedEntity));
            this.sql = ((NSArray)array.valueForKeyPath("statement")).componentsJoinedByString(";\n");
        }
        catch (Exception ex) {
            this.sql = "" + ex;
        }
        return null;
    }

    public WOComponent selectEntity() {
        this.selectedEntity = this.entity;
        return null;
    }

    public WOComponent removeAttribute() {
        this.selectedEntity.removeAttribute(this.attribute);
        return null;
    }

    public WOComponent removeRelationship() {
        this.selectedEntity.removeRelationship(this.relationship);
        return null;
    }

    public WOComponent removeEntity() {
        this.model.removeEntity(this.selectedEntity);
        this.selectedEntity = null;
        return null;
    }

    public String entityName() {
        return this.selectedEntity.name();
    }

    public void setEntityName(String name) {
        this.selectedEntity.setName(name);
        this.selectedEntity.setExternalName(name.toLowerCase());
    }

    public WOComponent addEntity() {
        this.selectedEntity = this.addEntityWithName(this.model, this.entityName);
        return null;
    }

    public WOComponent selectDestinationEntity() {
        this.selectedEntity = this.relationship.destinationEntity();
        return null;
    }
}

