/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.jdbcadaptor;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOSynchronizationFactory;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import com.webobjects.jdbcadaptor.JDBCAdaptorException;
import com.webobjects.jdbcadaptor.JDBCChannel;
import com.webobjects.jdbcadaptor.JDBCPlugIn;
import com.webobjects.jdbcadaptor.PostgresqlExpression;
import com.webobjects.jdbcadaptor.PostgresqlSynchronizationFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

public class PostgresqlPlugIn
extends JDBCPlugIn {
    private static final String QUERY_STRING_USE_BUNDLED_JDBC_INFO = "useBundledJdbcInfo";

    public PostgresqlPlugIn(JDBCAdaptor adaptor) {
        super(adaptor);
    }

    public String defaultDriverName() {
        return "org.postgresql.Driver";
    }

    public String databaseProductName() {
        return "Postgresql";
    }

    public String name() {
        return "Postgresql";
    }

    protected boolean shouldUseBundledJdbcInfo() {
        boolean shouldUseBundledJdbcInfo = false;
        String url = this.connectionURL();
        if (url != null) {
            shouldUseBundledJdbcInfo = url.toLowerCase().matches(".*(\\?|\\?.*&)" + QUERY_STRING_USE_BUNDLED_JDBC_INFO.toLowerCase() + "=(true|yes)(\\&|$)");
        }
        return shouldUseBundledJdbcInfo;
    }

    public NSDictionary jdbcInfo() {
        NSDictionary jdbcInfo;
        if (this.shouldUseBundledJdbcInfo()) {
            InputStream jdbcInfoStream;
            if (NSLog.debugLoggingAllowedForLevel((int)3)) {
                NSLog.debug.appendln((Object)"Loading jdbcInfo from JDBCInfo.plist as opposed to using the JDBCPlugIn default implementation.");
            }
            if ((jdbcInfoStream = NSBundle.bundleForClass(((Object)((Object)this)).getClass()).inputStreamForResourcePath("JDBCInfo.plist")) == null) {
                throw new IllegalStateException("Unable to find 'JDBCInfo.plist' in this plugin jar.");
            }
            try {
                jdbcInfo = (NSDictionary)NSPropertyListSerialization.propertyListFromData((NSData)new NSData(jdbcInfoStream, 2048), (String)"US-ASCII");
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load 'JDBCInfo.plist' from this plugin jar.", e);
            }
        } else {
            jdbcInfo = super.jdbcInfo();
        }
        return jdbcInfo;
    }

    public EOSynchronizationFactory createSynchronizationFactory() {
        try {
            return new PostgresqlSynchronizationFactory((EOAdaptor)this.adaptor());
        }
        catch (Exception e) {
            throw new NSForwardException((Throwable)e, "Couldn't create synchronization factory");
        }
    }

    public Class defaultExpressionClass() {
        return PostgresqlExpression.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSArray newPrimaryKeys(int count, EOEntity entity, JDBCChannel channel) {
        if (this.isPrimaryKeyGenerationNotSupported(entity)) {
            return null;
        }
        EOAttribute attribute = (EOAttribute)entity.primaryKeyAttributes().lastObject();
        String attrName = attribute.name();
        boolean isIntType = "i".equals(attribute.valueType());
        NSMutableArray results = new NSMutableArray(count);
        String sequenceName = PostgresqlPlugIn._sequenceNameForEntity(entity);
        PostgresqlExpression expression = new PostgresqlExpression(entity);
        int keysPerBatch = 20;
        boolean succeeded = false;
        for (int tries = 0; !succeeded && tries < 2; ++tries) {
            while (results.count() < count) {
                try {
                    StringBuffer sql = new StringBuffer();
                    sql.append("SELECT ");
                    for (int keyBatchNum = Math.min(keysPerBatch, count - results.count()) - 1; keyBatchNum >= 0; --keyBatchNum) {
                        sql.append("NEXTVAL('" + sequenceName + "') AS KEY" + keyBatchNum);
                        if (keyBatchNum <= 0) continue;
                        sql.append(", ");
                    }
                    expression.setStatement(sql.toString());
                    channel.evaluateExpression((EOSQLExpression)expression);
                    try {
                        NSMutableDictionary row;
                        while ((row = channel.fetchRow()) != null) {
                            Enumeration pksEnum = row.allValues().objectEnumerator();
                            while (pksEnum.hasMoreElements()) {
                                Number pkObj = (Number)pksEnum.nextElement();
                                Number pk = isIntType ? (Number)new Integer(pkObj.intValue()) : (Number)new Long(pkObj.longValue());
                                results.addObject((Object)new NSDictionary((Object)pk, (Object)attrName));
                            }
                        }
                    }
                    finally {
                        channel.cancelFetch();
                    }
                    succeeded = true;
                }
                catch (JDBCAdaptorException ex) {
                    NSMutableDictionary row;
                    int dotIndex = sequenceName.indexOf(".");
                    if (dotIndex == -1) {
                        expression.setStatement("select count(*) from pg_class where relname = '" + sequenceName.toLowerCase() + "' and relkind = 'S'");
                    } else {
                        String schemaName = sequenceName.substring(0, dotIndex);
                        String sequenceNameOnly = sequenceName.toLowerCase().substring(dotIndex + 1);
                        expression.setStatement("select count(c.*) from pg_catalog.pg_class c, pg_catalog.pg_namespace n where c.relnamespace=n.oid AND c.relkind = 'S' AND c.relname='" + sequenceNameOnly + "' AND n.nspname='" + schemaName + "'");
                    }
                    channel.evaluateExpression((EOSQLExpression)expression);
                    try {
                        row = channel.fetchRow();
                    }
                    finally {
                        channel.cancelFetch();
                    }
                    Number numCount = (Number)row.objectForKey((Object)"COUNT");
                    if (numCount != null && numCount.longValue() == 0L) {
                        EOSynchronizationFactory f = this.createSynchronizationFactory();
                        NSArray statements = f.primaryKeySupportStatementsForEntityGroup(new NSArray((Object)entity));
                        int stmCount = statements.count();
                        for (int i = 0; i < stmCount; ++i) {
                            channel.evaluateExpression((EOSQLExpression)statements.objectAtIndex(i));
                        }
                        continue;
                    }
                    if (numCount == null) {
                        throw new IllegalStateException("Couldn't call sequence " + sequenceName + " and couldn't get sequence information from pg_class: " + (Object)((Object)ex));
                    }
                    throw new IllegalStateException("Caught exception, but sequence did already exist: " + (Object)((Object)ex));
                }
            }
        }
        if (results.count() != count) {
            throw new IllegalStateException("Unable to generate primary keys from the sequence for " + entity + ".");
        }
        return results;
    }

    protected static String _sequenceNameForEntity(EOEntity entity) {
        return entity.primaryKeyRootName() + "_seq";
    }

    private boolean isPrimaryKeyGenerationNotSupported(EOEntity entity) {
        return entity.primaryKeyAttributes().count() > 1 || ((EOAttribute)entity.primaryKeyAttributes().lastObject()).adaptorValueType() != 0;
    }

    static {
        PostgresqlPlugIn.setPlugInNameForSubprotocol((String)PostgresqlPlugIn.class.getName(), (String)"postgresql");
    }
}

