/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.jdbcadaptor;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOSchemaGeneration;
import com.webobjects.eoaccess.EOSchemaSynchronization;
import com.webobjects.eoaccess.EOSynchronizationFactory;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation._NSDictionaryUtilities;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.jdbcadaptor.PostgresqlExpression;
import com.webobjects.jdbcadaptor.PostgresqlPlugIn;

public class PostgresqlSynchronizationFactory
extends EOSynchronizationFactory
implements EOSchemaGeneration,
EOSchemaSynchronization {
    public static final String USING_KEY = "USING";
    private Boolean _enableIdentifierQuoting;

    public PostgresqlSynchronizationFactory(EOAdaptor adaptor) {
        super(adaptor);
    }

    public String _columnCreationClauseForAttribute(EOAttribute attribute) {
        return this.addCreateClauseForAttribute(attribute).toString();
    }

    public StringBuffer addCreateClauseForAttribute(EOAttribute eoattribute) {
        EOSQLExpression expression = this._expressionForEntity(eoattribute.entity());
        expression.addCreateClauseForAttribute(eoattribute);
        return new StringBuffer(expression.listString());
    }

    private boolean enableIdentifierQuoting() {
        if (this._enableIdentifierQuoting == null) {
            this._enableIdentifierQuoting = Boolean.getBoolean(PostgresqlExpression.class.getName() + ".enableIdentifierQuoting") ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._enableIdentifierQuoting;
    }

    protected String formatTableName(String name) {
        if (!this.enableIdentifierQuoting()) {
            return name;
        }
        return "\"" + name + "\"";
    }

    protected String formatColumnName(String name) {
        if (!this.enableIdentifierQuoting()) {
            return name;
        }
        return "\"" + name + "\"";
    }

    public NSArray _foreignKeyConstraintStatementsForEntityGroup(NSArray group) {
        if (group == null) {
            return NSArray.EmptyArray;
        }
        NSMutableArray result = new NSMutableArray();
        NSMutableSet generatedStatements = new NSMutableSet();
        int groupCount = group.count();
        for (int i = 0; i < groupCount; ++i) {
            EOEntity currentEntity = (EOEntity)group.objectAtIndex(i);
            if (currentEntity.externalName() == null) continue;
            NSArray relationships = currentEntity.relationships();
            int relCount = relationships.count();
            for (int j = 0; j < relCount; ++j) {
                NSArray statements;
                EORelationship currentRelationship = (EORelationship)relationships.objectAtIndex(j);
                if (!this._shouldGenerateForeignKeyConstraints(currentRelationship) || generatedStatements.containsObject((statements = this.foreignKeyConstraintStatementsForRelationship(currentRelationship)).valueForKey("statement"))) continue;
                result.addObjectsFromArray(statements);
                generatedStatements.addObject(statements.valueForKey("statement"));
            }
        }
        return result;
    }

    protected boolean _shouldGenerateForeignKeyConstraints(EORelationship rel) {
        EOEntity destinationEntity = rel.destinationEntity();
        return !rel.isFlattened() && destinationEntity.externalName() != null && rel.entity().model() == destinationEntity.model();
    }

    private static PostgresqlExpression createExpression(EOEntity entity, String statement) {
        PostgresqlExpression result = new PostgresqlExpression(entity);
        result.setStatement(statement);
        return result;
    }

    public NSArray dropPrimaryKeySupportStatementsForEntityGroup(NSArray entityGroup) {
        NSMutableSet sequenceNames = new NSMutableSet();
        NSMutableArray results = new NSMutableArray();
        int count = entityGroup.count();
        for (int i = 0; i < count; ++i) {
            EOEntity entity = (EOEntity)entityGroup.objectAtIndex(i);
            String sequenceName = PostgresqlPlugIn._sequenceNameForEntity(entity);
            if (sequenceNames.containsObject((Object)sequenceName)) continue;
            sequenceNames.addObject((Object)sequenceName);
            String sql = "DROP SEQUENCE " + sequenceName + " CASCADE";
            results.addObject((Object)PostgresqlSynchronizationFactory.createExpression(entity, sql));
        }
        return results;
    }

    public NSArray dropTableStatementsForEntityGroup(NSArray entityGroup) {
        NSMutableArray results = new NSMutableArray();
        int count = entityGroup.count();
        for (int i = 0; i < count; ++i) {
            EOEntity entity = (EOEntity)entityGroup.objectAtIndex(i);
            PostgresqlExpression result = new PostgresqlExpression(entity);
            String tableName = result.sqlStringForSchemaObjectName(entity.externalName());
            if (!PostgresqlSynchronizationFactory.entityUsesSeparateTable(entity)) continue;
            result.setStatement("DROP TABLE " + tableName + " CASCADE");
            results.addObject((Object)result);
        }
        return results;
    }

    public NSArray foreignKeyConstraintStatementsForRelationship(EORelationship relationship) {
        NSMutableArray results = new NSMutableArray();
        NSArray superResults = super.foreignKeyConstraintStatementsForRelationship(relationship);
        int count = superResults.count();
        for (int i = 0; i < count; ++i) {
            EOSQLExpression expression = (EOSQLExpression)superResults.objectAtIndex(i);
            String s = expression.statement();
            s = PostgresqlSynchronizationFactory.replaceStringByStringInString(") INITIALLY DEFERRED", ") DEFERRABLE INITIALLY DEFERRED", s);
            expression.setStatement(s);
            results.addObject((Object)expression);
            String tableName = expression.sqlStringForSchemaObjectName(expression.entity().externalName());
            NSArray columnNames = (NSArray)relationship.sourceAttributes().valueForKey("columnName");
            StringBuffer sbColumnNames = new StringBuffer();
            for (int j = 0; j < columnNames.count(); ++j) {
                sbColumnNames.append((j == 0 ? "" : ", ") + expression.sqlStringForSchemaObjectName((String)columnNames.objectAtIndex(j)));
            }
            String indexName = this.externalNameForEntityWithoutSchema(relationship.entity()) + "_" + columnNames.componentsJoinedByString("_") + "_idx";
            results.addObject((Object)PostgresqlSynchronizationFactory.createExpression(expression.entity(), "CREATE INDEX " + indexName + " ON " + tableName + "( " + sbColumnNames.toString() + " )"));
        }
        return results;
    }

    protected String externalNameForEntityWithoutSchema(EOEntity entity) {
        int dotIndex;
        String externalName = entity.externalName();
        if (externalName != null && (dotIndex = externalName.indexOf(46)) != -1) {
            externalName = externalName.substring(dotIndex + 1);
        }
        return externalName;
    }

    public NSArray primaryKeyConstraintStatementsForEntityGroup(NSArray entityGroup) {
        NSMutableArray results = new NSMutableArray();
        int count = entityGroup.count();
        for (int i = 0; i < count; ++i) {
            EOEntity entity = (EOEntity)entityGroup.objectAtIndex(i);
            if (!PostgresqlSynchronizationFactory.entityUsesSeparateTable(entity)) continue;
            PostgresqlExpression result = new PostgresqlExpression(entity);
            String constraintName = result.sqlStringForSchemaObjectName(this.externalNameForEntityWithoutSchema(entity) + "_pk");
            String tableName = result.sqlStringForSchemaObjectName(entity.externalName());
            StringBuffer statement = new StringBuffer("ALTER TABLE ");
            statement.append(tableName);
            statement.append(" ADD CONSTRAINT ");
            statement.append(constraintName);
            statement.append(" PRIMARY KEY (");
            NSArray priKeyAttributes = entity.primaryKeyAttributes();
            int priKeyAttributeCount = priKeyAttributes.count();
            for (int j = 0; j < priKeyAttributeCount; ++j) {
                EOAttribute priKeyAttribute = (EOAttribute)priKeyAttributes.objectAtIndex(j);
                String attributeName = result.sqlStringForAttribute(priKeyAttribute);
                statement.append(attributeName);
                if (j < priKeyAttributeCount - 1) {
                    statement.append(", ");
                    continue;
                }
                statement.append(")");
            }
            result.setStatement(statement.toString());
            results.addObject((Object)result);
        }
        return results;
    }

    protected boolean isInEntityModeler(EOModel model) {
        Boolean inEntityModelerBoolean;
        NSDictionary userInfo;
        NSDictionary entityModelerDict;
        boolean inEntityModeler = false;
        if (model != null && (entityModelerDict = (NSDictionary)(userInfo = model.userInfo()).objectForKey((Object)"_EntityModeler")) != null && (inEntityModelerBoolean = (Boolean)entityModelerDict.objectForKey((Object)"inEntityModeler")) != null && inEntityModelerBoolean.booleanValue()) {
            inEntityModeler = inEntityModelerBoolean;
        }
        return inEntityModeler;
    }

    public NSArray primaryKeySupportStatementsForEntityGroup(NSArray entityGroup) {
        NSMutableSet sequenceNames = new NSMutableSet();
        NSMutableArray results = new NSMutableArray();
        int count = entityGroup.count();
        for (int i = 0; i < count; ++i) {
            String sequenceName;
            EOAttribute priKeyAttribute;
            EOEntity entity = (EOEntity)entityGroup.objectAtIndex(i);
            NSArray priKeyAttributes = entity.primaryKeyAttributes();
            if (priKeyAttributes.count() != 1 || (priKeyAttribute = (EOAttribute)priKeyAttributes.objectAtIndex(0)).adaptorValueType() != 0 || sequenceNames.containsObject((Object)(sequenceName = PostgresqlPlugIn._sequenceNameForEntity(entity)))) continue;
            sequenceNames.addObject((Object)sequenceName);
            PostgresqlExpression result = new PostgresqlExpression(entity);
            String attributeName = result.sqlStringForAttribute(priKeyAttribute);
            String tableName = result.sqlStringForSchemaObjectName(entity.externalName());
            String sql = "CREATE SEQUENCE " + sequenceName;
            results.addObject((Object)PostgresqlSynchronizationFactory.createExpression(entity, sql));
            sql = "CREATE TEMP TABLE EOF_TMP_TABLE AS SELECT SETVAL('" + sequenceName + "', (SELECT MAX(" + attributeName + ") FROM " + tableName + "))";
            results.addObject((Object)PostgresqlSynchronizationFactory.createExpression(entity, sql));
            if (!this.isInEntityModeler(entity.model())) {
                sql = "DROP TABLE EOF_TMP_TABLE";
                results.addObject((Object)PostgresqlSynchronizationFactory.createExpression(entity, sql));
            }
            sql = "ALTER TABLE " + tableName + " ALTER COLUMN " + attributeName + " SET DEFAULT nextval( '" + sequenceName + "' )";
            results.addObject((Object)PostgresqlSynchronizationFactory.createExpression(entity, sql));
        }
        return results;
    }

    public static boolean entityUsesSeparateTable(EOEntity entity) {
        if (entity.parentEntity() == null) {
            return true;
        }
        EOEntity parent = entity.parentEntity();
        while (parent != null) {
            if (!entity.externalName().equals(parent.externalName())) {
                return true;
            }
            entity = parent;
            parent = entity.parentEntity();
        }
        return false;
    }

    public NSArray createTableStatementsForEntityGroup(NSArray entityGroup) {
        NSMutableSet columnNames = new NSMutableSet();
        StringBuffer aStatement = new StringBuffer(128);
        if (entityGroup != null && entityGroup.count() > 0) {
            EOSQLExpression sqlExpr = this._expressionForEntity((EOEntity)entityGroup.objectAtIndex(0));
            for (EOEntity entity : entityGroup) {
                for (EOAttribute attribute : entity.attributes()) {
                    String columnName = attribute.columnName();
                    if (attribute.isDerived() || attribute.isFlattened() || columnName == null || columnName.length() <= 0 || columnNames.contains((Object)columnName)) continue;
                    sqlExpr.appendItemToListString(this._columnCreationClauseForAttribute(attribute), aStatement);
                    columnNames.addObject((Object)columnName);
                }
            }
            return new NSArray((Object)this._expressionForString("CREATE TABLE " + this.formatTableName(((EOEntity)entityGroup.objectAtIndex(0)).externalName()) + " (" + aStatement.toString() + ")"));
        }
        return new NSArray();
    }

    public static String replaceStringByStringInString(String old, String newString, String buffer) {
        int oldLength = old.length();
        int length = buffer.length();
        StringBuffer convertedString = new StringBuffer(length + 100);
        int begin = 0;
        while (begin < length) {
            int end = buffer.indexOf(old, begin);
            if (end == -1) {
                convertedString.append(buffer.substring(begin));
                break;
            }
            if (end == 0) {
                convertedString.append(newString);
            } else {
                convertedString.append(buffer.substring(begin, end));
                convertedString.append(newString);
            }
            begin = end + oldLength;
        }
        return convertedString.toString();
    }

    public String columnTypeStringForAttribute(EOAttribute attribute) {
        if (attribute.precision() != 0) {
            String precision = String.valueOf(attribute.precision());
            String scale = String.valueOf(attribute.scale());
            return _NSStringUtilities.concat((String)attribute.externalType(), (String)"(", (String)precision, (String)",", (String)scale, (String)")");
        }
        if (attribute.width() != 0) {
            String width = String.valueOf(attribute.width());
            return _NSStringUtilities.concat((String)attribute.externalType(), (String)"(", (String)width, (String)")");
        }
        return attribute.externalType();
    }

    public NSArray statementsToModifyColumnNullRule(String columnName, String tableName, boolean allowsNull, NSDictionary nsdictionary) {
        NSArray statements = allowsNull ? new NSArray((Object)this._expressionForString("alter table " + this.formatTableName(tableName) + " alter column " + this.formatColumnName(columnName) + " drop not null")) : new NSArray((Object)this._expressionForString("alter table " + this.formatTableName(tableName) + " alter column " + this.formatColumnName(columnName) + " set not null"));
        return statements;
    }

    public NSArray statementsToConvertColumnType(String columnName, String tableName, EOSchemaSynchronization.ColumnTypes oldType, EOSchemaSynchronization.ColumnTypes newType, NSDictionary options) {
        String usingExpression;
        EOAttribute attr = new EOAttribute();
        attr.setName(columnName);
        attr.setColumnName(columnName);
        attr.setExternalType(newType.name());
        attr.setScale(newType.scale());
        attr.setPrecision(newType.precision());
        attr.setWidth(newType.width());
        String usingClause = "";
        String columnTypeString = this.columnTypeStringForAttribute(attr);
        if (options != null && (usingExpression = (String)options.objectForKey((Object)USING_KEY)) != null) {
            usingClause = " USING " + usingExpression;
        }
        NSArray statements = new NSArray((Object)this._expressionForString("alter table " + this.formatTableName(tableName) + " alter column " + this.formatColumnName(columnName) + " type " + columnTypeString + usingClause));
        return statements;
    }

    public NSArray statementsToRenameColumnNamed(String columnName, String tableName, String newName, NSDictionary nsdictionary) {
        return new NSArray((Object)this._expressionForString("alter table " + this.formatTableName(tableName) + " rename column " + this.formatColumnName(columnName) + " to " + this.formatColumnName(newName)));
    }

    public NSArray statementsToInsertColumnForAttribute(EOAttribute attribute, NSDictionary options) {
        String clause = this._columnCreationClauseForAttribute(attribute);
        return new NSArray((Object)this._expressionForString("alter table " + this.formatTableName(attribute.entity().externalName()) + " add " + clause));
    }

    public NSArray statementsToRenameTableNamed(String tableName, String newName, NSDictionary options) {
        return new NSArray((Object)this._expressionForString("alter table " + this.formatTableName(tableName) + " rename to " + this.formatTableName(newName)));
    }

    public NSArray statementsToDeleteColumnNamed(String columnName, String tableName, NSDictionary options) {
        return new NSArray((Object)this._expressionForString("alter table " + this.formatTableName(tableName) + " drop column " + this.formatTableName(columnName) + " cascade"));
    }

    public String schemaCreationScriptForEntities(NSArray allEntities, NSDictionary options) {
        StringBuffer result = new StringBuffer();
        if (options == null) {
            options = NSDictionary.EmptyDictionary;
        }
        NSArray statements = this.schemaCreationStatementsForEntities(allEntities, options);
        int count = statements.count();
        for (int i = 0; i < count; ++i) {
            this.appendExpressionToScript((EOSQLExpression)statements.objectAtIndex(i), result);
        }
        return new String(result);
    }

    public NSArray schemaCreationStatementsForEntities(NSArray allEntities, NSDictionary options) {
        NSMutableArray result = new NSMutableArray();
        if (allEntities == null || allEntities.count() == 0) {
            return result;
        }
        if (options == null) {
            options = NSDictionary.EmptyDictionary;
        }
        NSDictionary connectionDictionary = ((EOEntity)allEntities.lastObject()).model().connectionDictionary();
        boolean createDatabase = _NSDictionaryUtilities.boolValueForKeyDefault((NSDictionary)options, (String)"createDatabase", (boolean)false);
        boolean dropDatabase = _NSDictionaryUtilities.boolValueForKeyDefault((NSDictionary)options, (String)"dropDatabase", (boolean)false);
        if (createDatabase || dropDatabase) {
            boolean adminCommentsNeeded = false;
            NSArray dropDatabaseStatements = null;
            NSArray createDatabaseStatements = null;
            if (dropDatabase) {
                dropDatabaseStatements = this.dropDatabaseStatementsForConnectionDictionary(connectionDictionary, null);
                if (dropDatabaseStatements == null) {
                    dropDatabaseStatements = new NSArray((Object)this._expressionForString("/* The 'Drop Database' option is unavailable. */"));
                } else {
                    adminCommentsNeeded = true;
                }
            }
            if (createDatabase) {
                createDatabaseStatements = this.createDatabaseStatementsForConnectionDictionary(connectionDictionary, null);
                if (createDatabaseStatements == null) {
                    createDatabaseStatements = new NSArray((Object)this._expressionForString("/* The 'Create Database' option is unavailable. */"));
                } else {
                    adminCommentsNeeded = true;
                }
            }
            if (adminCommentsNeeded) {
                result.addObject((Object)this._expressionForString("/* connect as an administrator */"));
            }
            if (dropDatabaseStatements != null) {
                result.addObjectsFromArray(dropDatabaseStatements);
            }
            if (createDatabaseStatements != null) {
                result.addObjectsFromArray(createDatabaseStatements);
            }
            if (adminCommentsNeeded) {
                result.addObject((Object)this._expressionForString("/* connect as the user from the connection dictionary */"));
            }
        }
        if (_NSDictionaryUtilities.boolValueForKeyDefault((NSDictionary)options, (String)"dropPrimaryKeySupport", (boolean)true)) {
            NSArray entityGroups = this.primaryKeyEntityGroupsForEntities(allEntities);
            result.addObjectsFromArray(this.dropPrimaryKeySupportStatementsForEntityGroups(entityGroups));
        }
        if (_NSDictionaryUtilities.boolValueForKeyDefault((NSDictionary)options, (String)"dropTables", (boolean)true)) {
            NSArray entityGroups = this.tableEntityGroupsForEntities(allEntities);
            result.addObjectsFromArray(this.dropTableStatementsForEntityGroups(entityGroups));
        }
        if (_NSDictionaryUtilities.boolValueForKeyDefault((NSDictionary)options, (String)"createTables", (boolean)true)) {
            NSArray entityGroups = this.tableEntityGroupsForEntities(allEntities);
            result.addObjectsFromArray(this.createTableStatementsForEntityGroups(entityGroups));
        }
        if (_NSDictionaryUtilities.boolValueForKeyDefault((NSDictionary)options, (String)"createPrimaryKeySupport", (boolean)true)) {
            NSArray entityGroups = this.primaryKeyEntityGroupsForEntities(allEntities);
            result.addObjectsFromArray(this.primaryKeySupportStatementsForEntityGroups(entityGroups));
        }
        if (_NSDictionaryUtilities.boolValueForKeyDefault((NSDictionary)options, (String)"primaryKeyConstraints", (boolean)true)) {
            NSArray entityGroups = this.tableEntityGroupsForEntities(allEntities);
            result.addObjectsFromArray(this.primaryKeyConstraintStatementsForEntityGroups(entityGroups));
        }
        if (_NSDictionaryUtilities.boolValueForKeyDefault((NSDictionary)options, (String)"foreignKeyConstraints", (boolean)false)) {
            NSArray entityGroups = this.tableEntityGroupsForEntities(allEntities);
            int iCount = entityGroups.count();
            for (int i = 0; i < iCount; ++i) {
                result.addObjectsFromArray(this._foreignKeyConstraintStatementsForEntityGroup((NSArray)entityGroups.objectAtIndex(i)));
            }
        }
        return result;
    }
}

