/*
 * Decompiled with CFR 0.152.
 */
package er.captcha;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.foundation.NSValidation;
import er.extensions.appserver.ERXRequest;
import er.extensions.components.ERXComponent;
import er.extensions.foundation.ERXProperties;
import java.util.Properties;
import net.tanesha.recaptcha.ReCaptcha;
import net.tanesha.recaptcha.ReCaptchaFactory;
import net.tanesha.recaptcha.ReCaptchaResponse;

public class ERReCaptcha
extends ERXComponent {
    private String _html;

    public ERReCaptcha(WOContext context) {
        super(context);
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    protected ReCaptcha recaptcha() {
        String publicKey = ERXProperties.stringForKey((String)"er.captcha.recaptcha.publicKey");
        String privateKey = ERXProperties.stringForKey((String)"er.captcha.recaptcha.privateKey");
        if (publicKey == null || privateKey == null) {
            throw new IllegalStateException("You have not set 'er.captcha.recaptcha.publicKey' or 'er.captcha.recaptcha.publicKey'. Please go to http://recaptcha.net and sign up for a key.");
        }
        boolean secure = this.booleanValueForBinding("secure", ERXRequest.isRequestSecure((WORequest)this.context().request()));
        ReCaptcha recaptcha = secure ? ReCaptchaFactory.newSecureReCaptcha((String)publicKey, (String)privateKey, (boolean)false) : ReCaptchaFactory.newReCaptcha((String)publicKey, (String)privateKey, (boolean)false);
        return recaptcha;
    }

    public String recaptchaHTML() {
        Properties props = new Properties();
        String theme = this.stringValueForBinding("theme");
        if (theme != null) {
            props.setProperty("theme", theme);
        }
        String errorMessage = this.stringValueForBinding("errorMessage");
        String html = this.recaptcha().createRecaptchaHtml(errorMessage, props);
        return html;
    }

    public void takeValuesFromRequest(WORequest request, WOContext context) {
        super.takeValuesFromRequest(request, context);
        if (context._wasFormSubmitted()) {
            ReCaptchaResponse recaptchaResponse;
            String remoteAddress;
            String response;
            String challenge = request.stringFormValueForKey("recaptcha_challenge_field");
            if (challenge == null) {
                challenge = "";
            }
            if ((response = request.stringFormValueForKey("recaptcha_response_field")) == null) {
                response = "";
            }
            if ((remoteAddress = request._remoteAddress()) == null) {
                remoteAddress = WOApplication.application().hostAddress().getHostAddress();
            }
            if (!(recaptchaResponse = this.recaptcha().checkAnswer(remoteAddress, challenge, response)).isValid()) {
                String errorMessage = recaptchaResponse.getErrorMessage();
                if (errorMessage != null && errorMessage.equals("incorrect-captcha-sol")) {
                    errorMessage = this.stringValueForBinding("errorMessage");
                }
                this.validationFailedWithException((Throwable)new NSValidation.ValidationException(errorMessage), (Object)this, "spamCheck");
                this.setValueForBinding(Boolean.FALSE, "valid");
            } else {
                this.setValueForBinding(Boolean.TRUE, "valid");
            }
            this._html = null;
        }
    }
}

