/*
 * Decompiled with CFR 0.152.
 */
package com.meetup.memcached.test;

import com.meetup.memcached.MemcachedClient;
import com.meetup.memcached.SockIOPool;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class UnitTests {
    private static Logger log = Logger.getLogger((String)UnitTests.class.getName());
    public static MemcachedClient mc = null;

    public static void test1() {
        mc.set("foo", Boolean.TRUE);
        Boolean b = (Boolean)mc.get("foo");
        UnitTests.assertTrue(b);
        log.debug((Object)"+ store/retrieve Boolean type test passed");
    }

    public static void test2() {
        mc.set("foo", new Integer(Integer.MAX_VALUE));
        Integer i = (Integer)mc.get("foo");
        UnitTests.assertTrue(i == Integer.MAX_VALUE);
        log.debug((Object)"+ store/retrieve Integer type test passed");
    }

    public static void test3() {
        String input = "test of string encoding";
        mc.set("foo", input);
        String s = (String)mc.get("foo");
        UnitTests.assertTrue(s.equals(input));
        log.debug((Object)"+ store/retrieve String type test passed");
    }

    public static void test4() {
        mc.set("foo", new Character('z'));
        Character c = (Character)mc.get("foo");
        UnitTests.assertTrue(c.charValue() == 'z');
        log.debug((Object)"+ store/retrieve Character type test passed");
    }

    public static void test5() {
        mc.set("foo", new Byte(127));
        Byte b = (Byte)mc.get("foo");
        UnitTests.assertTrue(b == 127);
        log.debug((Object)"+ store/retrieve Byte type test passed");
    }

    public static void test6() {
        mc.set("foo", new StringBuffer("hello"));
        StringBuffer o = (StringBuffer)mc.get("foo");
        UnitTests.assertTrue(o.toString().equals("hello"));
        log.debug((Object)"+ store/retrieve StringBuffer type test passed");
    }

    public static void test7() {
        mc.set("foo", new Short(100));
        Short o = (Short)mc.get("foo");
        UnitTests.assertTrue(o == 100);
        log.debug((Object)"+ store/retrieve Short type test passed");
    }

    public static void test8() {
        mc.set("foo", new Long(Long.MAX_VALUE));
        Long o = (Long)mc.get("foo");
        UnitTests.assertTrue(o == Long.MAX_VALUE);
        log.debug((Object)"+ store/retrieve Long type test passed");
    }

    public static void test9() {
        mc.set("foo", new Double(1.1));
        Double o = (Double)mc.get("foo");
        UnitTests.assertTrue(o == 1.1);
        log.debug((Object)"+ store/retrieve Double type test passed");
    }

    public static void test10() {
        mc.set("foo", new Float(1.1f));
        Float o = (Float)mc.get("foo");
        UnitTests.assertTrue(o.floatValue() == 1.1f);
        log.debug((Object)"+ store/retrieve Float type test passed");
    }

    public static void test11() {
        mc.set("foo", (Object)new Integer(100), new Date(System.currentTimeMillis()));
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        UnitTests.assertTrue(mc.get("foo") == null);
        log.debug((Object)"+ store/retrieve w/ expiration test passed");
    }

    public static void test12() {
        long i = 0L;
        mc.storeCounter("foo", i);
        mc.incr("foo");
        mc.incr("foo", 5L);
        long j = mc.decr("foo", 2L);
        UnitTests.assertTrue(j == 4L);
        UnitTests.assertTrue(j == mc.getCounter("foo"));
        log.debug((Object)"+ incr/decr test passed");
    }

    public static void test13() {
        Date d1 = new Date();
        mc.set("foo", d1);
        Date d2 = (Date)mc.get("foo");
        UnitTests.assertTrue(d1.equals(d2));
        log.debug((Object)"+ store/retrieve Date type test passed");
    }

    public static void test14() {
        UnitTests.assertTrue(!mc.keyExists("foobar123"));
        mc.set("foobar123", new Integer(100000));
        UnitTests.assertTrue(mc.keyExists("foobar123"));
        log.debug((Object)"+ store/retrieve test passed");
        UnitTests.assertTrue(!mc.keyExists("counterTest123"));
        mc.storeCounter("counterTest123", 0L);
        UnitTests.assertTrue(mc.keyExists("counterTest123"));
        log.debug((Object)"+ counter store test passed");
    }

    public static void test15() {
        Map stats = mc.statsItems();
        UnitTests.assertTrue(stats != null);
        stats = mc.statsSlabs();
        UnitTests.assertTrue(stats != null);
        log.debug((Object)"+ stats test passed");
    }

    public static void test16() {
        UnitTests.assertTrue(!mc.set("foo", null));
        log.debug((Object)"+ invalid data store [null] test passed");
    }

    public static void test17() {
        mc.set("foo bar", Boolean.TRUE);
        Boolean b = (Boolean)mc.get("foo bar");
        UnitTests.assertTrue(b);
        log.debug((Object)"+ store/retrieve Boolean type test passed");
    }

    public static void test18() {
        mc.addOrIncr("foo");
        mc.incr("foo");
        mc.incr("foo", 5L);
        mc.addOrIncr("foo");
        long j = mc.decr("foo", 3L);
        UnitTests.assertTrue(j == 4L);
        UnitTests.assertTrue(j == mc.getCounter("foo"));
        log.debug((Object)"+ incr/decr test passed");
    }

    public static void test19() {
        int max = 100;
        String[] keys = new String[max];
        for (int i = 0; i < max; ++i) {
            keys[i] = Integer.toString(i);
            mc.set(keys[i], "value" + i);
        }
        Map<String, Object> results = mc.getMulti(keys);
        for (int i = 0; i < max; ++i) {
            UnitTests.assertTrue(results.get(keys[i]).equals("value" + i));
        }
        log.debug((Object)"+ getMulti test passed");
    }

    public static void test20(int max, int skip, int start) {
        int numEntries = max / skip + 1;
        log.debug((Object)String.format("test 20 starting with start=%5d skip=%5d max=%7d num=%d", start, skip, max, numEntries, numEntries * start));
        String[] keys = new String[numEntries];
        byte[][] vals = new byte[numEntries][];
        int size = start;
        for (int i = 0; i < numEntries; ++i) {
            keys[i] = Integer.toString(size);
            vals[i] = new byte[size + 1];
            for (int j = 0; j < size + 1; ++j) {
                vals[i][j] = (byte)j;
            }
            mc.set(keys[i], vals[i]);
            size += skip;
        }
        Map<String, Object> results = mc.getMulti(keys);
        for (int i = 0; i < numEntries; ++i) {
            byte[] res = (byte[])results.get(keys[i]);
            byte[] except = vals[i];
            UnitTests.assertTrue(Arrays.equals(res, except));
        }
        log.info((Object)String.format("test 20 finished with start=%5d skip=%5d max=%7d num=%d bytes=%d", start, skip, max, numEntries, numEntries * size));
    }

    public static void test21() {
        mc.set("foo", new StringBuilder("hello"));
        StringBuilder o = (StringBuilder)mc.get("foo");
        UnitTests.assertTrue(o.toString().equals("hello"));
        log.debug((Object)"+ store/retrieve StringBuilder type test passed");
    }

    public static void test22() {
        byte[] b = new byte[10];
        for (int i = 0; i < 10; ++i) {
            b[i] = (byte)i;
        }
        mc.set("foo", b);
        UnitTests.assertTrue(Arrays.equals((byte[])mc.get("foo"), b));
        log.debug((Object)"+ store/retrieve byte[] type test passed");
    }

    public static void test23() {
        TestClass tc = new TestClass("foo", "bar", new Integer(32));
        mc.set("foo", tc);
        UnitTests.assertTrue(tc.equals((TestClass)mc.get("foo")));
        log.debug((Object)"+ store/retrieve serialized object test passed");
    }

    public static void test24() {
        String[] setKeys;
        String[] allKeys = new String[]{"key1", "key2", "key3", "key4", "key5", "key6", "key7"};
        for (String key : setKeys = new String[]{"key1", "key3", "key5", "key7"}) {
            mc.set(key, key);
        }
        Map<String, Object> results = mc.getMulti(allKeys);
        UnitTests.assertTrue(allKeys.length == results.size());
        for (String key : setKeys) {
            String val = (String)results.get(key);
            UnitTests.assertTrue(key.equals(val));
        }
        log.debug((Object)"+ getMulti w/ keys that don't exist test passed");
    }

    public static void runAlTests(MemcachedClient mc) {
        UnitTests.test14();
        for (int t = 0; t < 2; ++t) {
            mc.setCompressEnable((t & 1) == 1);
            UnitTests.test1();
            UnitTests.test2();
            UnitTests.test3();
            UnitTests.test4();
            UnitTests.test5();
            UnitTests.test6();
            UnitTests.test7();
            UnitTests.test8();
            UnitTests.test9();
            UnitTests.test10();
            UnitTests.test11();
            UnitTests.test12();
            UnitTests.test13();
            UnitTests.test15();
            UnitTests.test16();
            UnitTests.test17();
            UnitTests.test21();
            UnitTests.test22();
            UnitTests.test23();
            UnitTests.test24();
            for (int i = 0; i < 3; ++i) {
                UnitTests.test19();
            }
            UnitTests.test20(8191, 1, 0);
            UnitTests.test20(8192, 1, 0);
            UnitTests.test20(8193, 1, 0);
            UnitTests.test20(16384, 100, 0);
            UnitTests.test20(17000, 128, 0);
            UnitTests.test20(131072, 1023, 0);
            UnitTests.test20(131072, 1023, 1);
            UnitTests.test20(131072, 1024, 0);
            UnitTests.test20(131072, 1024, 1);
            UnitTests.test20(131072, 1023, 0);
            UnitTests.test20(131072, 1023, 1);
            UnitTests.test20(131072, 1024, 0);
            UnitTests.test20(131072, 1024, 1);
            UnitTests.test20(921600, 32768, 0);
            UnitTests.test20(921600, 32768, 1);
        }
    }

    private static void assertTrue(boolean v) {
        if (!v) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Logger.getLogger((String)"com").setLevel(Level.WARN);
        log.warn((Object)"starting tests");
        long time = System.currentTimeMillis();
        if (!UnitTests.class.desiredAssertionStatus()) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        String[] serverlist = new String[]{"127.0.0.1:12345"};
        Integer[] weights = new Integer[]{1, 1, 1, 1, 10, 5, 1, 1, 1, 3};
        if (args.length > 0) {
            serverlist = args;
        }
        SockIOPool pool = SockIOPool.getInstance("test");
        try {
            pool.setServers(serverlist);
            pool.setWeights(weights);
            pool.setMaxConn(250);
            pool.setNagle(false);
            pool.setHashingAlg(3);
            pool.initialize();
            mc = new MemcachedClient("test");
            mc.flushAll();
            UnitTests.runAlTests(mc);
        }
        finally {
            pool.shutDown();
        }
        log.warn((Object)("Finished: " + (System.currentTimeMillis() - time) / 1000L + "s"));
    }

    public static final class TestClass
    implements Serializable {
        private String field1;
        private String field2;
        private Integer field3;

        public TestClass(String field1, String field2, Integer field3) {
            this.field1 = field1;
            this.field2 = field2;
            this.field3 = field3;
        }

        public String getField1() {
            return this.field1;
        }

        public String getField2() {
            return this.field2;
        }

        public Integer getField3() {
            return this.field3;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TestClass)) {
                return false;
            }
            TestClass obj = (TestClass)o;
            return (this.field1 == obj.getField1() || this.field1 != null && this.field1.equals(obj.getField1())) && (this.field2 == obj.getField2() || this.field2 != null && this.field2.equals(obj.getField2())) && (this.field3 == obj.getField3() || this.field3 != null && this.field3.equals(obj.getField3()));
        }
    }
}

