/*
 * Decompiled with CFR 0.152.
 */
package webobjectsexamples.businesslogic.movies.common;

import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EORelationshipManipulation;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSTimestamp;
import er.attachment.model.ERAttachment;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.eof.ERXFetchSpecification;
import er.extensions.eof.ERXGenericRecord;
import er.extensions.eof.ERXKey;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import webobjectsexamples.businesslogic.movies.common.Movie;
import webobjectsexamples.businesslogic.movies.common.MovieRole;
import webobjectsexamples.businesslogic.movies.common.PlotSummary;
import webobjectsexamples.businesslogic.movies.common.Review;
import webobjectsexamples.businesslogic.movies.common.Talent;
import webobjectsexamples.businesslogic.movies.common.Voting;
import webobjectsexamples.businesslogic.movies.server.Studio;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class _Movie
extends ERXGenericRecord {
    public static final String ENTITY_NAME = "Movie";
    public static final ERXKey<String> CATEGORY = new ERXKey("category");
    public static final ERXKey<NSTimestamp> DATE_RELEASED = new ERXKey("dateReleased");
    public static final ERXKey<String> POSTER_NAME = new ERXKey("posterName");
    public static final ERXKey<String> RATED = new ERXKey("rated");
    public static final ERXKey<BigDecimal> REVENUE = new ERXKey("revenue");
    public static final ERXKey<String> TITLE = new ERXKey("title");
    public static final ERXKey<String> TRAILER_NAME = new ERXKey("trailerName");
    public static final ERXKey<Talent> DIRECTORS = new ERXKey("directors");
    public static final ERXKey<PlotSummary> PLOT_SUMMARY = new ERXKey("plotSummary");
    public static final ERXKey<ERAttachment> POSTER = new ERXKey("poster");
    public static final ERXKey<Review> REVIEWS = new ERXKey("reviews");
    public static final ERXKey<MovieRole> ROLES = new ERXKey("roles");
    public static final ERXKey<Studio> STUDIO = new ERXKey("studio");
    public static final ERXKey<Voting> VOTING = new ERXKey("voting");
    public static final String CATEGORY_KEY = CATEGORY.key();
    public static final String DATE_RELEASED_KEY = DATE_RELEASED.key();
    public static final String POSTER_NAME_KEY = POSTER_NAME.key();
    public static final String RATED_KEY = RATED.key();
    public static final String REVENUE_KEY = REVENUE.key();
    public static final String TITLE_KEY = TITLE.key();
    public static final String TRAILER_NAME_KEY = TRAILER_NAME.key();
    public static final String DIRECTORS_KEY = DIRECTORS.key();
    public static final String PLOT_SUMMARY_KEY = PLOT_SUMMARY.key();
    public static final String POSTER_KEY = POSTER.key();
    public static final String REVIEWS_KEY = REVIEWS.key();
    public static final String ROLES_KEY = ROLES.key();
    public static final String STUDIO_KEY = STUDIO.key();
    public static final String VOTING_KEY = VOTING.key();
    private static Logger LOG = Logger.getLogger(_Movie.class);

    public Movie localInstanceIn(EOEditingContext editingContext) {
        Movie localInstance = (Movie)EOUtilities.localInstanceOfObject((EOEditingContext)editingContext, (EOEnterpriseObject)this);
        if (localInstance == null) {
            throw new IllegalStateException("You attempted to localInstance " + (Object)((Object)this) + ", which has not yet committed.");
        }
        return localInstance;
    }

    public String category() {
        return (String)this.storedValueForKey(CATEGORY_KEY);
    }

    public void setCategory(String value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("updating category from " + this.category() + " to " + value));
        }
        this.takeStoredValueForKey(value, CATEGORY_KEY);
    }

    public NSTimestamp dateReleased() {
        return (NSTimestamp)this.storedValueForKey(DATE_RELEASED_KEY);
    }

    public void setDateReleased(NSTimestamp value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("updating dateReleased from " + this.dateReleased() + " to " + value));
        }
        this.takeStoredValueForKey(value, DATE_RELEASED_KEY);
    }

    public String posterName() {
        return (String)this.storedValueForKey(POSTER_NAME_KEY);
    }

    public void setPosterName(String value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("updating posterName from " + this.posterName() + " to " + value));
        }
        this.takeStoredValueForKey(value, POSTER_NAME_KEY);
    }

    public String rated() {
        return (String)this.storedValueForKey(RATED_KEY);
    }

    public void setRated(String value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("updating rated from " + this.rated() + " to " + value));
        }
        this.takeStoredValueForKey(value, RATED_KEY);
    }

    public BigDecimal revenue() {
        return (BigDecimal)this.storedValueForKey(REVENUE_KEY);
    }

    public void setRevenue(BigDecimal value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("updating revenue from " + this.revenue() + " to " + value));
        }
        this.takeStoredValueForKey(value, REVENUE_KEY);
    }

    public String title() {
        return (String)this.storedValueForKey(TITLE_KEY);
    }

    public void setTitle(String value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("updating title from " + this.title() + " to " + value));
        }
        this.takeStoredValueForKey(value, TITLE_KEY);
    }

    public String trailerName() {
        return (String)this.storedValueForKey(TRAILER_NAME_KEY);
    }

    public void setTrailerName(String value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("updating trailerName from " + this.trailerName() + " to " + value));
        }
        this.takeStoredValueForKey(value, TRAILER_NAME_KEY);
    }

    public PlotSummary plotSummary() {
        return (PlotSummary)((Object)this.storedValueForKey(PLOT_SUMMARY_KEY));
    }

    public void setPlotSummary(PlotSummary value) {
        this.takeStoredValueForKey((Object)value, PLOT_SUMMARY_KEY);
    }

    public void setPlotSummaryRelationship(PlotSummary value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("updating plotSummary from " + (Object)((Object)this.plotSummary()) + " to " + (Object)((Object)value)));
        }
        if (ERXGenericRecord.InverseRelationshipUpdater.updateInverseRelationships()) {
            this.setPlotSummary(value);
        } else if (value == null) {
            PlotSummary oldValue = this.plotSummary();
            if (oldValue != null) {
                this.removeObjectFromBothSidesOfRelationshipWithKey((EORelationshipManipulation)oldValue, PLOT_SUMMARY_KEY);
            }
        } else {
            this.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)value, PLOT_SUMMARY_KEY);
        }
    }

    public ERAttachment poster() {
        return (ERAttachment)this.storedValueForKey(POSTER_KEY);
    }

    public void setPoster(ERAttachment value) {
        this.takeStoredValueForKey(value, POSTER_KEY);
    }

    public void setPosterRelationship(ERAttachment value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("updating poster from " + this.poster() + " to " + value));
        }
        if (ERXGenericRecord.InverseRelationshipUpdater.updateInverseRelationships()) {
            this.setPoster(value);
        } else if (value == null) {
            ERAttachment oldValue = this.poster();
            if (oldValue != null) {
                this.removeObjectFromBothSidesOfRelationshipWithKey((EORelationshipManipulation)oldValue, POSTER_KEY);
            }
        } else {
            this.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)value, POSTER_KEY);
        }
    }

    public Studio studio() {
        return (Studio)((Object)this.storedValueForKey(STUDIO_KEY));
    }

    public void setStudio(Studio value) {
        this.takeStoredValueForKey((Object)value, STUDIO_KEY);
    }

    public void setStudioRelationship(Studio value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("updating studio from " + (Object)((Object)this.studio()) + " to " + (Object)((Object)value)));
        }
        if (ERXGenericRecord.InverseRelationshipUpdater.updateInverseRelationships()) {
            this.setStudio(value);
        } else if (value == null) {
            Studio oldValue = this.studio();
            if (oldValue != null) {
                this.removeObjectFromBothSidesOfRelationshipWithKey((EORelationshipManipulation)oldValue, STUDIO_KEY);
            }
        } else {
            this.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)value, STUDIO_KEY);
        }
    }

    public Voting voting() {
        return (Voting)((Object)this.storedValueForKey(VOTING_KEY));
    }

    public void setVoting(Voting value) {
        this.takeStoredValueForKey((Object)value, VOTING_KEY);
    }

    public void setVotingRelationship(Voting value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("updating voting from " + (Object)((Object)this.voting()) + " to " + (Object)((Object)value)));
        }
        if (ERXGenericRecord.InverseRelationshipUpdater.updateInverseRelationships()) {
            this.setVoting(value);
        } else if (value == null) {
            Voting oldValue = this.voting();
            if (oldValue != null) {
                this.removeObjectFromBothSidesOfRelationshipWithKey((EORelationshipManipulation)oldValue, VOTING_KEY);
            }
        } else {
            this.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)value, VOTING_KEY);
        }
    }

    public NSArray<Talent> directors() {
        return (NSArray)this.storedValueForKey(DIRECTORS_KEY);
    }

    public NSArray<Talent> directors(EOQualifier qualifier) {
        return this.directors(qualifier, null);
    }

    public NSArray<Talent> directors(EOQualifier qualifier, NSArray<EOSortOrdering> sortOrderings) {
        NSArray results = this.directors();
        if (qualifier != null) {
            results = EOQualifier.filteredArrayWithQualifier(results, (EOQualifier)qualifier);
        }
        if (sortOrderings != null) {
            results = EOSortOrdering.sortedArrayUsingKeyOrderArray((NSArray)results, sortOrderings);
        }
        return results;
    }

    public void addToDirectors(Talent object) {
        this.includeObjectIntoPropertyWithKey((Object)object, DIRECTORS_KEY);
    }

    public void removeFromDirectors(Talent object) {
        this.excludeObjectFromPropertyWithKey((Object)object, DIRECTORS_KEY);
    }

    public void addToDirectorsRelationship(Talent object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("adding " + (Object)((Object)object) + " to directors relationship"));
        }
        if (ERXGenericRecord.InverseRelationshipUpdater.updateInverseRelationships()) {
            this.addToDirectors(object);
        } else {
            this.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)object, DIRECTORS_KEY);
        }
    }

    public void removeFromDirectorsRelationship(Talent object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removing " + (Object)((Object)object) + " from directors relationship"));
        }
        if (ERXGenericRecord.InverseRelationshipUpdater.updateInverseRelationships()) {
            this.removeFromDirectors(object);
        } else {
            this.removeObjectFromBothSidesOfRelationshipWithKey((EORelationshipManipulation)object, DIRECTORS_KEY);
        }
    }

    public Talent createDirectorsRelationship() {
        EOClassDescription eoClassDesc = EOClassDescription.classDescriptionForEntityName((String)"Talent");
        EOEnterpriseObject eo = eoClassDesc.createInstanceWithEditingContext(this.editingContext(), null);
        this.editingContext().insertObject(eo);
        this.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)eo, DIRECTORS_KEY);
        return (Talent)eo;
    }

    public void deleteDirectorsRelationship(Talent object) {
        this.removeObjectFromBothSidesOfRelationshipWithKey((EORelationshipManipulation)object, DIRECTORS_KEY);
        this.editingContext().deleteObject((EOEnterpriseObject)object);
    }

    public void deleteAllDirectorsRelationships() {
        Enumeration objects = this.directors().immutableClone().objectEnumerator();
        while (objects.hasMoreElements()) {
            this.deleteDirectorsRelationship((Talent)((Object)objects.nextElement()));
        }
    }

    public NSArray<Review> reviews() {
        return (NSArray)this.storedValueForKey(REVIEWS_KEY);
    }

    public NSArray<Review> reviews(EOQualifier qualifier) {
        return this.reviews(qualifier, null, false);
    }

    public NSArray<Review> reviews(EOQualifier qualifier, boolean fetch) {
        return this.reviews(qualifier, null, fetch);
    }

    public NSArray<Review> reviews(EOQualifier qualifier, NSArray<EOSortOrdering> sortOrderings, boolean fetch) {
        NSArray<Review> results;
        if (fetch) {
            EOKeyValueQualifier fullQualifier;
            EOKeyValueQualifier inverseQualifier = new EOKeyValueQualifier(Review.MOVIE_KEY, EOQualifier.QualifierOperatorEqual, (Object)this);
            if (qualifier == null) {
                fullQualifier = inverseQualifier;
            } else {
                NSMutableArray qualifiers = new NSMutableArray();
                qualifiers.addObject((Object)qualifier);
                qualifiers.addObject((Object)inverseQualifier);
                fullQualifier = new EOAndQualifier((NSArray)qualifiers);
            }
            results = Review.fetchReviews(this.editingContext(), (EOQualifier)fullQualifier, sortOrderings);
        } else {
            results = this.reviews();
            if (qualifier != null) {
                results = EOQualifier.filteredArrayWithQualifier(results, (EOQualifier)qualifier);
            }
            if (sortOrderings != null) {
                results = EOSortOrdering.sortedArrayUsingKeyOrderArray((NSArray)results, sortOrderings);
            }
        }
        return results;
    }

    public void addToReviews(Review object) {
        this.includeObjectIntoPropertyWithKey((Object)object, REVIEWS_KEY);
    }

    public void removeFromReviews(Review object) {
        this.excludeObjectFromPropertyWithKey((Object)object, REVIEWS_KEY);
    }

    public void addToReviewsRelationship(Review object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("adding " + (Object)((Object)object) + " to reviews relationship"));
        }
        if (ERXGenericRecord.InverseRelationshipUpdater.updateInverseRelationships()) {
            this.addToReviews(object);
        } else {
            this.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)object, REVIEWS_KEY);
        }
    }

    public void removeFromReviewsRelationship(Review object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removing " + (Object)((Object)object) + " from reviews relationship"));
        }
        if (ERXGenericRecord.InverseRelationshipUpdater.updateInverseRelationships()) {
            this.removeFromReviews(object);
        } else {
            this.removeObjectFromBothSidesOfRelationshipWithKey((EORelationshipManipulation)object, REVIEWS_KEY);
        }
    }

    public Review createReviewsRelationship() {
        EOClassDescription eoClassDesc = EOClassDescription.classDescriptionForEntityName((String)"Review");
        EOEnterpriseObject eo = eoClassDesc.createInstanceWithEditingContext(this.editingContext(), null);
        this.editingContext().insertObject(eo);
        this.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)eo, REVIEWS_KEY);
        return (Review)eo;
    }

    public void deleteReviewsRelationship(Review object) {
        this.removeObjectFromBothSidesOfRelationshipWithKey((EORelationshipManipulation)object, REVIEWS_KEY);
    }

    public void deleteAllReviewsRelationships() {
        Enumeration objects = this.reviews().immutableClone().objectEnumerator();
        while (objects.hasMoreElements()) {
            this.deleteReviewsRelationship((Review)((Object)objects.nextElement()));
        }
    }

    public NSArray<MovieRole> roles() {
        return (NSArray)this.storedValueForKey(ROLES_KEY);
    }

    public NSArray<MovieRole> roles(EOQualifier qualifier) {
        return this.roles(qualifier, null, false);
    }

    public NSArray<MovieRole> roles(EOQualifier qualifier, boolean fetch) {
        return this.roles(qualifier, null, fetch);
    }

    public NSArray<MovieRole> roles(EOQualifier qualifier, NSArray<EOSortOrdering> sortOrderings, boolean fetch) {
        NSArray<MovieRole> results;
        if (fetch) {
            EOKeyValueQualifier fullQualifier;
            EOKeyValueQualifier inverseQualifier = new EOKeyValueQualifier(MovieRole.MOVIE_KEY, EOQualifier.QualifierOperatorEqual, (Object)this);
            if (qualifier == null) {
                fullQualifier = inverseQualifier;
            } else {
                NSMutableArray qualifiers = new NSMutableArray();
                qualifiers.addObject((Object)qualifier);
                qualifiers.addObject((Object)inverseQualifier);
                fullQualifier = new EOAndQualifier((NSArray)qualifiers);
            }
            results = MovieRole.fetchMovieRoles(this.editingContext(), (EOQualifier)fullQualifier, sortOrderings);
        } else {
            results = this.roles();
            if (qualifier != null) {
                results = EOQualifier.filteredArrayWithQualifier(results, (EOQualifier)qualifier);
            }
            if (sortOrderings != null) {
                results = EOSortOrdering.sortedArrayUsingKeyOrderArray((NSArray)results, sortOrderings);
            }
        }
        return results;
    }

    public void addToRoles(MovieRole object) {
        this.includeObjectIntoPropertyWithKey((Object)object, ROLES_KEY);
    }

    public void removeFromRoles(MovieRole object) {
        this.excludeObjectFromPropertyWithKey((Object)object, ROLES_KEY);
    }

    public void addToRolesRelationship(MovieRole object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("adding " + (Object)((Object)object) + " to roles relationship"));
        }
        if (ERXGenericRecord.InverseRelationshipUpdater.updateInverseRelationships()) {
            this.addToRoles(object);
        } else {
            this.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)object, ROLES_KEY);
        }
    }

    public void removeFromRolesRelationship(MovieRole object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removing " + (Object)((Object)object) + " from roles relationship"));
        }
        if (ERXGenericRecord.InverseRelationshipUpdater.updateInverseRelationships()) {
            this.removeFromRoles(object);
        } else {
            this.removeObjectFromBothSidesOfRelationshipWithKey((EORelationshipManipulation)object, ROLES_KEY);
        }
    }

    public MovieRole createRolesRelationship() {
        EOClassDescription eoClassDesc = EOClassDescription.classDescriptionForEntityName((String)"MovieRole");
        EOEnterpriseObject eo = eoClassDesc.createInstanceWithEditingContext(this.editingContext(), null);
        this.editingContext().insertObject(eo);
        this.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)eo, ROLES_KEY);
        return (MovieRole)eo;
    }

    public void deleteRolesRelationship(MovieRole object) {
        this.removeObjectFromBothSidesOfRelationshipWithKey((EORelationshipManipulation)object, ROLES_KEY);
    }

    public void deleteAllRolesRelationships() {
        Enumeration objects = this.roles().immutableClone().objectEnumerator();
        while (objects.hasMoreElements()) {
            this.deleteRolesRelationship((MovieRole)((Object)objects.nextElement()));
        }
    }

    public static Movie createMovie(EOEditingContext editingContext, String title) {
        Movie eo = (Movie)EOUtilities.createAndInsertInstance((EOEditingContext)editingContext, (String)ENTITY_NAME);
        eo.setTitle(title);
        return eo;
    }

    public static NSArray<Movie> fetchAllMovies(EOEditingContext editingContext) {
        return _Movie.fetchAllMovies(editingContext, null);
    }

    public static NSArray<Movie> fetchAllMovies(EOEditingContext editingContext, NSArray<EOSortOrdering> sortOrderings) {
        return _Movie.fetchMovies(editingContext, null, sortOrderings);
    }

    public static NSArray<Movie> fetchMovies(EOEditingContext editingContext, EOQualifier qualifier, NSArray<EOSortOrdering> sortOrderings) {
        ERXFetchSpecification fetchSpec = new ERXFetchSpecification(ENTITY_NAME, qualifier, sortOrderings);
        fetchSpec.setIsDeep(true);
        NSArray eoObjects = fetchSpec.fetchObjects(editingContext);
        return eoObjects;
    }

    public static Movie fetchMovie(EOEditingContext editingContext, String keyName, Object value) {
        return _Movie.fetchMovie(editingContext, (EOQualifier)new EOKeyValueQualifier(keyName, EOQualifier.QualifierOperatorEqual, value));
    }

    public static Movie fetchMovie(EOEditingContext editingContext, EOQualifier qualifier) {
        Movie eoObject;
        NSArray<Movie> eoObjects = _Movie.fetchMovies(editingContext, qualifier, null);
        int count = eoObjects.count();
        if (count == 0) {
            eoObject = null;
        } else if (count == 1) {
            eoObject = (Movie)((Object)eoObjects.objectAtIndex(0));
        } else {
            throw new IllegalStateException("There was more than one Movie that matched the qualifier '" + qualifier + "'.");
        }
        return eoObject;
    }

    public static Movie fetchRequiredMovie(EOEditingContext editingContext, String keyName, Object value) {
        return _Movie.fetchRequiredMovie(editingContext, (EOQualifier)new EOKeyValueQualifier(keyName, EOQualifier.QualifierOperatorEqual, value));
    }

    public static Movie fetchRequiredMovie(EOEditingContext editingContext, EOQualifier qualifier) {
        Movie eoObject = _Movie.fetchMovie(editingContext, qualifier);
        if (eoObject == null) {
            throw new NoSuchElementException("There was no Movie that matched the qualifier '" + qualifier + "'.");
        }
        return eoObject;
    }

    public static Movie localInstanceIn(EOEditingContext editingContext, Movie eo) {
        Movie localInstance;
        Movie movie = localInstance = eo == null ? null : (Movie)ERXEOControlUtilities.localInstanceOfObject((EOEditingContext)editingContext, (EOEnterpriseObject)eo);
        if (localInstance == null && eo != null) {
            throw new IllegalStateException("You attempted to localInstance " + (Object)((Object)eo) + ", which has not yet committed.");
        }
        return localInstance;
    }

    public static NSArray<Movie> fetchDeepFetchOneMovie(EOEditingContext editingContext, NSDictionary<String, Object> bindings) {
        EOFetchSpecification fetchSpec = EOFetchSpecification.fetchSpecificationNamed((String)"DeepFetchOneMovie", (String)ENTITY_NAME);
        fetchSpec = fetchSpec.fetchSpecificationWithQualifierBindings(bindings);
        return editingContext.objectsWithFetchSpecification(fetchSpec);
    }

    public static NSArray<Movie> fetchDeepFetchOneMovie(EOEditingContext editingContext, Integer myMovieBinding) {
        EOFetchSpecification fetchSpec = EOFetchSpecification.fetchSpecificationNamed((String)"DeepFetchOneMovie", (String)ENTITY_NAME);
        NSMutableDictionary bindings = new NSMutableDictionary();
        bindings.takeValueForKey((Object)myMovieBinding, "myMovie");
        fetchSpec = fetchSpec.fetchSpecificationWithQualifierBindings((NSDictionary)bindings);
        return editingContext.objectsWithFetchSpecification(fetchSpec);
    }

    public static NSArray<Movie> fetchQualifierVariable(EOEditingContext editingContext, NSDictionary<String, Object> bindings) {
        EOFetchSpecification fetchSpec = EOFetchSpecification.fetchSpecificationNamed((String)"QualifierVariable", (String)ENTITY_NAME);
        fetchSpec = fetchSpec.fetchSpecificationWithQualifierBindings(bindings);
        return editingContext.objectsWithFetchSpecification(fetchSpec);
    }

    public static NSArray<Movie> fetchQualifierVariable(EOEditingContext editingContext, BigDecimal revenueBinding, Studio studioBinding, String studioNameBinding, String titleBinding) {
        EOFetchSpecification fetchSpec = EOFetchSpecification.fetchSpecificationNamed((String)"QualifierVariable", (String)ENTITY_NAME);
        NSMutableDictionary bindings = new NSMutableDictionary();
        bindings.takeValueForKey((Object)revenueBinding, "revenue");
        bindings.takeValueForKey((Object)studioBinding, "studio");
        bindings.takeValueForKey((Object)studioNameBinding, "studioName");
        bindings.takeValueForKey((Object)titleBinding, "title");
        fetchSpec = fetchSpec.fetchSpecificationWithQualifierBindings((NSDictionary)bindings);
        return editingContext.objectsWithFetchSpecification(fetchSpec);
    }

    public static NSArray<NSDictionary> fetchRawFetchAllMovies(EOEditingContext editingContext, NSDictionary<String, Object> bindings) {
        EOFetchSpecification fetchSpec = EOFetchSpecification.fetchSpecificationNamed((String)"RawFetchAllMovies", (String)ENTITY_NAME);
        fetchSpec = fetchSpec.fetchSpecificationWithQualifierBindings(bindings);
        return editingContext.objectsWithFetchSpecification(fetchSpec);
    }

    public static NSArray<NSDictionary> fetchRawFetchAllMovies(EOEditingContext editingContext) {
        EOFetchSpecification fetchSpec = EOFetchSpecification.fetchSpecificationNamed((String)"RawFetchAllMovies", (String)ENTITY_NAME);
        return editingContext.objectsWithFetchSpecification(fetchSpec);
    }
}

