/*
 * Decompiled with CFR 0.152.
 */
package webobjectsexamples.businesslogic.rentals.common;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOGenericRecord;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EORelationshipManipulation;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSValidation;
import java.math.BigDecimal;
import webobjectsexamples.businesslogic.rentals.common.CreditCard;
import webobjectsexamples.businesslogic.rentals.common.Fee;
import webobjectsexamples.businesslogic.rentals.common.Rental;
import webobjectsexamples.businesslogic.rentals.common.Unit;

public class Customer
extends EOGenericRecord {
    private static final long serialVersionUID = -1996155567059278076L;
    public static final String CityKey = "city";
    public static final String CreditCardKey = "creditCard";
    public static final String FirstNameKey = "firstName";
    public static final String LastNameKey = "lastName";
    public static final String MemberSinceKey = "memberSince";
    public static final String PhoneKey = "phone";
    public static final String RentalsKey = "rentals";
    public static final String StateKey = "state";
    public static final String StreetAddressKey = "streetAddress";
    public static final String ZipKey = "zip";
    private static final String _DepositAmountKeyPath = "unit.video.rentalTerms.depositAmount";
    public static final BigDecimal DefaultCostRestriction = new BigDecimal(50);

    public void awakeFromInsertion(EOEditingContext editingContext) {
        super.awakeFromInsertion(editingContext);
        if (this.memberSince() == null) {
            this.setMemberSince(new NSTimestamp());
        }
    }

    public void validateForSave() throws NSValidation.ValidationException {
        BigDecimal deposit = new BigDecimal(0);
        NSArray outRentals = this.outRentals();
        int count = outRentals.count();
        for (int i = 0; i < count; ++i) {
            BigDecimal amount = (BigDecimal)((EOEnterpriseObject)outRentals.objectAtIndex(i)).valueForKeyPath(_DepositAmountKeyPath);
            if (amount == null) continue;
            deposit = deposit.add(amount);
        }
        BigDecimal maxDeposit = this.costRestriction();
        if (deposit.compareTo(maxDeposit) > 0) {
            throw new NSValidation.ValidationException("The total value of the rented videos (" + deposit + ") exceed limitations (" + maxDeposit + ") of " + this.fullName() + "!");
        }
        super.validateForSave();
    }

    public CreditCard creditCard() {
        return (CreditCard)((Object)this.storedValueForKey(CreditCardKey));
    }

    public String firstName() {
        return (String)this.storedValueForKey(FirstNameKey);
    }

    public void setFirstName(String value) {
        this.takeStoredValueForKey(value, FirstNameKey);
    }

    public String lastName() {
        return (String)this.storedValueForKey(LastNameKey);
    }

    public void setLastName(String value) {
        this.takeStoredValueForKey(value, LastNameKey);
    }

    public NSTimestamp memberSince() {
        return (NSTimestamp)this.storedValueForKey(MemberSinceKey);
    }

    public void setMemberSince(NSTimestamp value) {
        this.takeStoredValueForKey(value, MemberSinceKey);
    }

    public NSArray rentals() {
        return (NSArray)this.storedValueForKey(RentalsKey);
    }

    public BigDecimal costRestriction() {
        CreditCard creditCard = this.creditCard();
        return creditCard != null ? creditCard.limit() : DefaultCostRestriction;
    }

    public String fullName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.firstName());
        buffer.append(' ');
        buffer.append(this.lastName());
        return new String(buffer);
    }

    public NSArray allFees() {
        NSMutableArray allFees = new NSMutableArray();
        NSArray rentals = this.rentals();
        if (rentals != null) {
            int count = rentals.count();
            for (int i = 0; i < count; ++i) {
                NSArray fees = ((Rental)((Object)rentals.objectAtIndex(i))).fees();
                if (fees == null) continue;
                allFees.addObjectsFromArray(fees);
            }
        }
        return allFees;
    }

    public Number numberOfAllFees() {
        return new Integer(this.allFees().count());
    }

    public NSArray unpaidFees() {
        EOKeyValueQualifier qualifier = new EOKeyValueQualifier("datePaid", EOQualifier.QualifierOperatorEqual, (Object)NSKeyValueCoding.NullValue);
        return EOQualifier.filteredArrayWithQualifier((NSArray)this.allFees(), (EOQualifier)qualifier);
    }

    public Number numberOfUnpaidFees() {
        return new Integer(this.unpaidFees().count());
    }

    public boolean hasUnpaidFees() {
        return this.unpaidFees().count() > 0;
    }

    public NSArray allRentals() {
        NSArray rentals = this.rentals();
        return rentals != null ? rentals : new NSArray();
    }

    public Number numberOfAllRentals() {
        return new Integer(this.allRentals().count());
    }

    public NSArray outRentals() {
        EOKeyValueQualifier qualifier = new EOKeyValueQualifier("isOut", EOQualifier.QualifierOperatorEqual, (Object)Boolean.TRUE);
        return EOQualifier.filteredArrayWithQualifier((NSArray)this.allRentals(), (EOQualifier)qualifier);
    }

    public Number numberOfOutRentals() {
        return new Integer(this.outRentals().count());
    }

    public boolean hasOutRentals() {
        return this.outRentals().count() > 0;
    }

    public NSArray overdueRentals() {
        EOKeyValueQualifier qualifier = new EOKeyValueQualifier("isOverdue", EOQualifier.QualifierOperatorEqual, (Object)Boolean.TRUE);
        return EOQualifier.filteredArrayWithQualifier((NSArray)this.allRentals(), (EOQualifier)qualifier);
    }

    public Number numberOfOverdueRentals() {
        return new Integer(this.overdueRentals().count());
    }

    public boolean hasOverdueRentals() {
        return this.overdueRentals().count() > 0;
    }

    public boolean isAllowedToRent() {
        return !this.hasOverdueRentals();
    }

    public void rentUnit(Unit unit) {
        EOEditingContext editingContext = this.editingContext();
        Fee fee = new Fee();
        Rental rental = new Rental();
        editingContext.insertObject((EOEnterpriseObject)fee);
        editingContext.insertObject((EOEnterpriseObject)rental);
        rental.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)unit, "unit");
        rental.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)fee, "fees");
        this.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)rental, RentalsKey);
    }
}

