/*
 * Decompiled with CFR 0.152.
 */
package webobjectsexamples.businesslogic.rentals.common;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOGenericRecord;
import com.webobjects.eocontrol.EORelationshipManipulation;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSValidation;
import java.sql.Timestamp;
import webobjectsexamples.businesslogic.rentals.common.Customer;
import webobjectsexamples.businesslogic.rentals.common.Fee;

public class Rental
extends EOGenericRecord {
    private static final long serialVersionUID = -6572273760378405850L;
    public static final String CustomerKey = "customer";
    public static final String DateOutKey = "dateOut";
    public static final String DateReturnedKey = "dateReturned";
    public static final String FeesKey = "fees";
    public static final String UnitKey = "unit";
    public static final String IsOutKey = "isOut";
    public static final String IsOverdueKey = "isOverdue";
    private static final String _CheckOutLengthKeyPath = "unit.video.rentalTerms.checkOutLength";

    public void awakeFromInsertion(EOEditingContext editingContext) {
        super.awakeFromInsertion(editingContext);
        if (this.dateOut() == null) {
            this.setDateOut(new NSTimestamp());
        }
    }

    public void validateForSave() throws NSValidation.ValidationException {
        Customer customer = this.customer();
        if (customer != null) {
            customer.validateForSave();
        }
        super.validateForSave();
    }

    public Customer customer() {
        return (Customer)((Object)this.storedValueForKey(CustomerKey));
    }

    public NSTimestamp dateOut() {
        return (NSTimestamp)this.storedValueForKey(DateOutKey);
    }

    public void setDateOut(NSTimestamp value) {
        this.takeStoredValueForKey(value, DateOutKey);
    }

    public NSTimestamp dateReturned() {
        return (NSTimestamp)this.storedValueForKey(DateReturnedKey);
    }

    public void setDateReturned(NSTimestamp value) {
        this.takeStoredValueForKey(value, DateReturnedKey);
    }

    public NSArray fees() {
        return (NSArray)this.storedValueForKey(FeesKey);
    }

    public NSTimestamp dateDue() {
        NSTimestamp dateOut = this.dateOut();
        if (dateOut != null) {
            Number checkOutLength = (Number)this.valueForKeyPath(_CheckOutLengthKeyPath);
            if (checkOutLength != null) {
                int days = checkOutLength.intValue();
                return new NSTimestamp(dateOut.getTime() + (long)(days * 86400000));
            }
            return dateOut;
        }
        return null;
    }

    public boolean isOut() {
        return this.dateReturned() == null;
    }

    public boolean isReturned() {
        return !this.isOut();
    }

    public boolean isOverdue() {
        return this.isReturned() ? false : this.dateDue().before((Timestamp)new NSTimestamp());
    }

    public String isOverdueString() {
        return this.isOverdue() ? "Yes" : "No";
    }

    public void feePaid() {
        NSArray fees;
        if (this.dateReturned() != null && (fees = this.fees()) != null) {
            int count = fees.count();
            for (int i = 0; i < count; ++i) {
                if (((Fee)((Object)fees.objectAtIndex(i))).isPaid()) continue;
                return;
            }
        }
    }

    public void returnVideo() {
        this.setDateReturned(new NSTimestamp());
        if (!this.isOverdue()) {
            this.feePaid();
        } else {
            EOEditingContext editingContext = this.editingContext();
            Fee fee = new Fee(this.dateDue(), editingContext);
            editingContext.insertObject((EOEnterpriseObject)fee);
            this.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)fee, FeesKey);
        }
    }
}

