/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.FLAP;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.TLV;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.handlers.icq.ICQPacket;

public class AIMFrame {
    private static final Logger LOG = Logger.getLogger((String)AIMFrame.class.getName());
    private AIMConnection conn;
    private int type;
    private int length;
    private boolean handled = true;
    private FLAP flap;
    private SNAC snac;
    private byte[] data;
    private ICQPacket icqPacket;

    public AIMFrame() {
    }

    public AIMFrame(AIMConnection conn, ICQPacket icqPacket, AIMOutputStream buffer) throws IOException {
        this.conn = conn;
        if (buffer != null) {
            icqPacket.setData(buffer.getBytes());
        } else {
            icqPacket.setData(null);
        }
        this.icqPacket = icqPacket;
        this.type = 0;
    }

    public AIMFrame(AIMConnection conn, int type, AIMInputStream buffer) throws IOException {
        this.conn = conn;
        this.type = type;
        this.flap = buffer.readFLAP();
        if (this.flap.getCommand() != 42) {
            throw new IOException("Invalid start command=" + Integer.toHexString(this.flap.getCommand()));
        }
        int channel = this.flap.getChannel();
        int length = this.flap.getLength();
        switch (channel) {
            case 2: {
                int toRead;
                this.snac = buffer.readSNAC();
                int tlvLength = 0;
                int version = -1;
                if (this.snac.getFlags() == Short.MIN_VALUE) {
                    TLVChain tlvchain = buffer.readTLVChain(buffer.readShort());
                    tlvLength = 2 + tlvchain.length();
                    TLV tlv = tlvchain.getTLV(1, 1);
                    if (tlv != null) {
                        version = tlv.getValueShort();
                        this.snac.setVersion(version);
                    }
                }
                if ((toRead = length - 10 - tlvLength) <= 0) break;
                this.data = buffer.readBytes(toRead);
                break;
            }
            case 4: {
                if (length <= 0) break;
                this.snac = new SNAC(23, 3, 0, -1);
                this.data = buffer.readBytes(length);
                break;
            }
            default: {
                if (length <= 0) break;
                this.data = buffer.readBytes(length);
            }
        }
    }

    public AIMFrame(AIMConnection conn, int type, FLAP flap, SNAC snac, AIMOutputStream buffer) throws IOException {
        this.conn = conn;
        this.type = type;
        this.flap = flap;
        this.snac = snac;
        if (buffer != null) {
            try {
                this.data = buffer.getBytes();
                this.length = this.data.length;
            }
            catch (IOException ioe) {
                LOG.error((Object)"IOException", (Throwable)ioe);
            }
        } else {
            this.data = null;
            this.length = 0;
        }
        if (snac != null) {
            this.length += 10;
        }
        this.flap.setLength(this.length);
    }

    public AIMConnection getConn() {
        return this.conn;
    }

    public void setConn(AIMConnection conn) {
        this.conn = conn;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public boolean isHandled() {
        return this.handled;
    }

    public void setHandled(boolean handled) {
        this.handled = handled;
    }

    public FLAP getFLAP() {
        return this.flap;
    }

    public void setFLAP(FLAP flap) {
        this.flap = flap;
    }

    public SNAC getSNAC() {
        return this.snac;
    }

    public void setSNAC(SNAC snac) {
        this.snac = snac;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public ICQPacket getICQPacket() {
        return this.icqPacket;
    }

    public void setICQPacket(ICQPacket icqPacket) {
        this.icqPacket = icqPacket;
    }
}

