/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMClientInfo;
import org.walluck.oscar.handlers.icq.ICQClientInfo;

public class AIMUtil {
    private static final Logger LOG = Logger.getLogger((String)AIMUtil.class.getName());
    private static final String VERSION = "$Revision: 1.22 $";
    private static final String DATE = "$Date: 2004/12/11 23:53:13 $";
    private static final String[] CHANNELS = new String[]{"Invalid", "FLAP Version", "SNAC", "ICQ", "Negotiation", "FLAP NOP"};
    private static final String[][] SNACS = new String[][]{{"Invalid Family", "Invalid Subtype"}, {"Service", "Error", "Client Ready", "Server Ready", "Service Request", "Redirect", "Rate Information Request", "Rate Information", "Rate Information Ack", "Delete Rate Parameters", "Rate Information Change", "Server Pause", "Server Pause Ack", "Server Resume", "Request Personal User Information", "Personal User Information", "Evil Notification", "Set Idle", "Migration Notice", "Message Of The Day", "Set Privacy Flags", "Well Known URL", "NOP", "Client Versions", "Host Versions", "Unknown 0x0019", "Unknown 0x001a", "Unknown 0x001b", "Unknown 0x001c", "Unknown 0x001d", "Set Extended Status", "Memory Request", "Memory Reply", "Extended Status Reply", "SecureIM Request", "SecureIM Reply"}, {"Location", "Error", "Request Rights", "Rights Information", "Set User Information", "Request User Information", "User Information", "Unknown 0x0007", "Unknown 0x0008", "Unknown 0x0009", "Unknown 0x000a", "Unknown 0x000b"}, {"Buddy List Management", "Error", "Request Rights", "Rights Information", "Add Buddy", "Remove Buddy", "Watcher List Query", "Watcher List Response", "Watcher Sub Request", "Watcher Notification", "Reject Notification", "Oncoming Buddy", "Offgoing Buddy"}, {"Messaging", "Error", "Set ICBM Parameters", "Delete ICBM Parameters", "Request Parameter Information", "Parameter Information", "Outgoing Message", "Incoming Message", "Evil Request", "Evil Reply", "Missed Calls", "Message Error", "Host Ack", "Unknown 0x000d", "Unknown 0x000e", "Unknown 0x000f", "Unknown 0x0010", "Unknown 0x0011", "Unknown 0x0012", "Unknown 0x0013", "Typing Notification"}, {"Advertisements", "Error", "Request Ad", "Ad Data"}, {"Invitation", "Error", "Invite a Friend", "Invitation Ack"}, {"Administrative", "Error", "Information Request", "Information Reply", "Information Change Request", "Information Chat Reply", "Account Confirm Request", "Account Confirm Reply", "Account Delete Request", "Account Delete Reply"}, {"Popups", "Error", "Display Popup"}, {"BOS", "Error", "Request Rights", "Rights Response", "Set Permission Mask", "Add Permission List Entries", "Delete Permission List Entries", "Add Deny List Entries", "Delete Deny List Entries", "BOS Server Error"}, {"User Lookup", "Invalid", "Error", "Search Request", "Search Response"}, {"Stats", "Error", "Set Minimum Report Interval", "Report Events"}, {"Translate", "Error", "Translate Request", "Translate Reply"}, {"Chat Navigation", "Error", "Request Rights", "Request Exchange Information", "Request Room Information", "Request More Room Information", "Request Occupant List", "Search For Room", "Create Room", "Room Information Reply"}, {"Chat", "Error", "Room Information Update", "User Joined Room", "User Left Room", "Outgoing Message", "Incoming Message", "Evil Request", "Evil Reply", "Client Error"}, {"OSCAR Directory", "Error", "Search For User By Email", "Search Reply", "Request Interests", "Interests Reply"}, {"Icon", "Error", "Upload Icon", "Acknowledge Icon Upload", "Request Icon", "Receieve Icon"}, new String[0], new String[0], {"Server Stored Information", "Error", "Request Response", "Rights Reply", "Request New List", "Request List", "List", "Activate List", "Add To List", "Modify List", "Delete From List", "Unknown 0x000b", "Unknown 0x000c", "Unknown 0x000d", "Server Ack", "No List", "Unknown 0x0010", "Start Editing List", "Stop Editing List", "Unknown 0x0013", "Send Authorization", "Receive Authorization", "Unknown 0x0016", "Unknown 0x0017", "Request Authorization", "Send Authorization Request", "Receive Authorization Request", "Send Authorization Resply", "Receive Authorization Reply", "Added"}, new String[0], {"ICQ", "Error", "ICQ Request", "ICQ Response"}, new String[0], {"Login", "Error", "Login Request", "Login Response", "New UIN Request", "New UIN Response", "Login Authorization Request", "Login Authorization Response", "Unknown 0x0008", "Unknown 0x0009", "SecurID Request", "SecurID Reply"}, {"Mail", "Error", "Unknown 0x0002", "Unknown 0x0003", "Unknown 0x0004", "Unknown 0x0005", "Mail Request", "Mail Response", "Unknown 0x0008", "Unknown 0x0009", "Unknown 0x000a", "Unknown 0x000b", "Unknown 0x000c", "Unknown 0x000d", "Unknown 0x000e", "Unknown 0x000f", "Unknown 0x0010", "Unknown 0x0011", "Unknown 0x0012", "Unknown 0x0013", "Unknown 0x0014", "Unknown 0x0015", "Subtype 0x0016"}};
    private static final String[] ERRORS = new String[]{"Invalid error", "Invalid SNAC", "Rate to host", "Rate to client", "Not logged in", "Service unavailable", "Service not defined", "Obsolete SNAC", "Not supported by host", "Not supported by client", "Refused by client", "Reply too big", "Responses lost", "Request denied", "Busted SNAC payload", "Insufficient rights", "In local permit/deny", "Too evil (sender)", "Too evil (receiver)", "User temporarily unavailable", "No match", "List overflow", "Request ambiguous", "Queue full", "Not while on AOL"};

    public static String getLibraryVersion() {
        return VERSION.substring(11, VERSION.length() - 2);
    }

    public static String getLibraryDate() {
        return DATE.substring(7, DATE.length() - 2);
    }

    public static int snLen(String sn) {
        int count = 0;
        int length = sn.length();
        for (int i = 0; i < length; ++i) {
            char c = sn.charAt(i);
            if (c == ' ') continue;
            ++count;
        }
        return count;
    }

    public static String normalize(String sn) {
        int length = sn.length();
        StringBuffer sb = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = sn.charAt(i);
            if (c == ' ') continue;
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static boolean snCmp(String sn1, String sn2) {
        return (sn1 = AIMUtil.normalize(sn1)).equals(sn2 = AIMUtil.normalize(sn2));
    }

    public static byte[] byteArrayFromHexString(String s) {
        int length = s.length();
        byte[] b = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            b[i / 2] = (byte)Integer.valueOf(s.substring(i, i + 2), 16).intValue();
        }
        return b;
    }

    public static String byteArrayToHexString(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            int j = b[i] & 0xFF;
            if (j < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(j));
        }
        return sb.toString();
    }

    public static byte[] uuidToByteArray(String uuid) {
        int length = uuid.length();
        if (uuid.charAt(0) == '{') {
            uuid = uuid.substring(1, length - 1);
            length -= 2;
        }
        StringBuffer sb = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = uuid.charAt(i);
            if (c == '-') continue;
            sb.append(c);
        }
        return AIMUtil.byteArrayFromHexString(sb.toString());
    }

    public static String about() {
        AIMClientInfo aci = new AIMClientInfo();
        ICQClientInfo ici = new ICQClientInfo();
        String nl = System.getProperty("line.separator");
        String us = "daim " + AIMUtil.getLibraryVersion() + " - OSCAR Protocol Library for Java " + "(" + AIMUtil.getLibraryDate() + ")";
        String aim = "AIM " + aci.getMajor() + "." + aci.getMinor() + "." + aci.getBuild();
        String icq = "ICQ " + ici.getMajor() + "." + ici.getMinor() + "." + ici.getBuild();
        String osv = "Running on " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") " + System.getProperty("os.version") + " / " + "Java (" + System.getProperty("java.vendor") + ") " + System.getProperty("java.version");
        String about = us + nl + aim + nl + icq + nl + osv;
        return about;
    }

    public static String memInfo() {
        long freeNow = Runtime.getRuntime().freeMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        Runtime.getRuntime().gc();
        long freeLater = Runtime.getRuntime().freeMemory();
        long gcFree = freeLater - freeNow;
        String mem = "Memory usage: " + freeNow / 1000L + "KB/" + totalMemory / 1000L + "KB" + " Garbage Collection released " + gcFree / 1000L + "KB";
        return mem;
    }

    public static String flapChannelToString(int channel) {
        if (channel > CHANNELS.length) {
            return "Unknown";
        }
        return CHANNELS[channel];
    }

    public static String snacToString(int family, int subtype) {
        String s = null;
        s = subtype == 0 ? Integer.toHexString(family) : Integer.toHexString(subtype);
        try {
            return "[" + s + "]" + SNACS[family][subtype];
        }
        catch (ArrayIndexOutOfBoundsException aiobe) {
            return "[" + s + "]" + "Unknown/Invalid family or subtype";
        }
    }

    public static String snacErrorToString(int error) {
        try {
            return ERRORS[error];
        }
        catch (ArrayIndexOutOfBoundsException aiobe) {
            return "Unknown error (" + error + ")";
        }
    }

    public static String extractRoomName(String s) {
        String start = "!aol://";
        if (!s.startsWith(start)) {
            return null;
        }
        s = s.substring(start.length(), s.length());
        StringTokenizer st = new StringTokenizer(s, "-");
        String name = null;
        while (st.hasMoreTokens()) {
            name = st.nextToken();
        }
        return name;
    }

    public static String dirAOLToSys(String name) {
        if (name == null) {
            LOG.warn((Object)"dirAOLToSys: someone passed in a null name");
            return null;
        }
        int length = name.length();
        StringBuffer sb = new StringBuffer(length);
        char aol = '\u0001';
        char sep = File.separatorChar;
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (c == aol) {
                sb.append(sep);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String dirSysToAOL(String name) {
        if (name == null) {
            LOG.warn((Object)"dirAOLToSys: someone passed in a null name");
            return null;
        }
        int length = name.length();
        StringBuffer sb = new StringBuffer(length);
        char aol = '\u0001';
        char sep = File.separatorChar;
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (c == sep) {
                sb.append(aol);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String prettyPrintTime(long time) {
        int itime = (int)(time / 1000L);
        int days = itime / 86400;
        int hours = (itime - days * 86400) / 3600;
        int minutes = (itime - days * 86400 - hours * 3600) / 60;
        String prettyTime = (int)((double)minutes + 0.5) + " minutes";
        if (hours > 0) {
            prettyTime = hours + " hours, " + prettyTime;
        }
        if (days > 0) {
            prettyTime = days + " days, " + prettyTime;
        }
        return prettyTime;
    }

    public static String hexdump(byte[] data) {
        StringBuffer sb = new StringBuffer(2058);
        String nl = System.getProperty("line.separator");
        sb.append(nl);
        int j = 0;
        while (j * 16 < data.length) {
            int i;
            String l = j * 16 < 10 ? "   " : (j * 16 < 100 ? "  " : (j * 16 < 1000 ? " " : ""));
            sb.append(j * 16 + l + ": ");
            for (i = j * 16; i < j * 16 + 16; ++i) {
                if (i < data.length) {
                    String p = data[i] < 16 ? "0" : "";
                    String s = p + Integer.toHexString(data[i]).toUpperCase();
                    if (s.length() > 2) {
                        sb.append(s.substring(s.length() - 2, s.length()));
                    } else {
                        sb.append(s);
                    }
                    sb.append(" ");
                    continue;
                }
                sb.append("    ");
            }
            sb.append("  ");
            for (i = j * 16; i < j * 16 + 16; ++i) {
                if (i < data.length) {
                    if (data[i] >= 32 && data[i] < 127) {
                        sb.append(String.valueOf((char)data[i]));
                        continue;
                    }
                    sb.append(".");
                    continue;
                }
                sb.append(" ");
            }
            sb.append(nl);
            ++j;
        }
        return sb.toString();
    }

    public static String convertHTMLToOSCAR(String str) {
        String lcStr = str.toLowerCase();
        int index = -1;
        while ((index = lcStr.indexOf("<font ", index + 1)) != -1) {
            str = str.substring(0, index) + "<BODY " + str.substring(index + 6);
        }
        index = -1;
        while ((index = lcStr.indexOf("</font>", index + 1)) != -1) {
            str = str.substring(0, index) + "</BODY>" + str.substring(index + 7);
        }
        return str;
    }

    public static String convertOSCARToHTML(String str) {
        String lcStr = str.toLowerCase();
        int index = -1;
        while ((index = lcStr.indexOf("<body ", index + 1)) != -1) {
            str = str.substring(0, index) + "<FONT " + str.substring(index + 6);
        }
        index = -1;
        while ((index = lcStr.indexOf("</body>", index + 1)) != -1) {
            str = str.substring(0, index) + "</FONT>" + str.substring(index + 7);
        }
        index = -1;
        while ((index = str.indexOf("\n", index + 1)) != -1) {
            str = str.substring(0, index) + "<br>" + str.substring(index + 1);
        }
        index = lcStr.indexOf("<html>");
        if (index != -1) {
            str = str.substring(0, index) + str.substring(index + 6);
        }
        if ((index = lcStr.indexOf("</html>")) != -1) {
            str = str.substring(0, index);
        }
        return str;
    }

    public static String parseProfileEncoding(String enc) {
        StringTokenizer st = new StringTokenizer(enc, ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (!token.startsWith("charset=")) continue;
            String charset = token.substring(8, token.length());
            if (charset.charAt(0) == '\"') {
                charset = charset.substring(1, charset.length());
            }
            if (charset.charAt(charset.length() - 1) == '\"') {
                charset = charset.substring(0, charset.length() - 1);
            }
            return charset;
        }
        LOG.warn((Object)("Parsing of " + enc + " failed. Defaulting to \"us-ascii\""));
        return "us-ascii";
    }

    public static String charsetAOLToJava(int charset) throws UnsupportedEncodingException {
        switch (charset) {
            case 0: {
                return "US-ASCII";
            }
            case 3: {
                return "ISO-8859-1";
            }
            case 2: {
                return "UTF-16BE";
            }
        }
        throw new UnsupportedEncodingException("No corresponding Java encoding found for AOL encoding 0x" + Integer.toHexString(charset));
    }

    public static String charsetAOLToJava(String charset) throws UnsupportedEncodingException {
        if (charset.equals("us-ascii")) {
            return "US-ASCII";
        }
        if (charset.equals("iso-8859-1")) {
            return "ISO-8859-1";
        }
        if (charset.equals("unicode-2-0")) {
            return "UTF-16BE";
        }
        if (charset.equals("utf-8")) {
            return "UTF-8";
        }
        throw new UnsupportedEncodingException("No corresponding Java encoding found for AOL encoding " + charset);
    }
}

