/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.client;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMClientInfo;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFingerPrintInfo;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMPopup;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.Chat;
import org.walluck.oscar.ClientInfo;
import org.walluck.oscar.EmailInfo;
import org.walluck.oscar.ExchangeInfo;
import org.walluck.oscar.ICBMParams;
import org.walluck.oscar.IChatClientInfo;
import org.walluck.oscar.IncomingIMCH2;
import org.walluck.oscar.LoginResponseInfo;
import org.walluck.oscar.MsgCookie;
import org.walluck.oscar.ODirInfo;
import org.walluck.oscar.RateClass;
import org.walluck.oscar.RateClearTask;
import org.walluck.oscar.Redir;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.SSIItem;
import org.walluck.oscar.TLV;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.channel.aolim.AOLIM;
import org.walluck.oscar.channel.rendezvous.BuddyIconRendezvous;
import org.walluck.oscar.channel.rendezvous.ChatRendezvous;
import org.walluck.oscar.client.Buddy;
import org.walluck.oscar.client.BuddyGroup;
import org.walluck.oscar.handlers.AdminHandler;
import org.walluck.oscar.handlers.BOSHandler;
import org.walluck.oscar.handlers.BOSListener;
import org.walluck.oscar.handlers.BuddyListHandler;
import org.walluck.oscar.handlers.BuddyListListener;
import org.walluck.oscar.handlers.ChatHandler;
import org.walluck.oscar.handlers.ChatListener;
import org.walluck.oscar.handlers.ChatNavHandler;
import org.walluck.oscar.handlers.ChatNavListener;
import org.walluck.oscar.handlers.ICBMHandler;
import org.walluck.oscar.handlers.ICBMListener;
import org.walluck.oscar.handlers.ICQHandler;
import org.walluck.oscar.handlers.ICQListener;
import org.walluck.oscar.handlers.IconHandler;
import org.walluck.oscar.handlers.IconListener;
import org.walluck.oscar.handlers.LocateHandler;
import org.walluck.oscar.handlers.LocateListener;
import org.walluck.oscar.handlers.LoginHandler;
import org.walluck.oscar.handlers.LoginListener;
import org.walluck.oscar.handlers.MailHandler;
import org.walluck.oscar.handlers.MailListener;
import org.walluck.oscar.handlers.MiscListener;
import org.walluck.oscar.handlers.ODirHandler;
import org.walluck.oscar.handlers.ODirListener;
import org.walluck.oscar.handlers.PopupListener;
import org.walluck.oscar.handlers.SSIHandler;
import org.walluck.oscar.handlers.SSIListener;
import org.walluck.oscar.handlers.ServiceHandler;
import org.walluck.oscar.handlers.ServiceListener;
import org.walluck.oscar.handlers.StatsListener;
import org.walluck.oscar.handlers.UserLookupListener;
import org.walluck.oscar.handlers.directim.DirectIM;
import org.walluck.oscar.handlers.filetransfer.FT;
import org.walluck.oscar.handlers.filetransfer.FileTransfer;
import org.walluck.oscar.handlers.icq.ICQMetaFound;
import org.walluck.oscar.handlers.icq.ICQMetaGeneral;
import org.walluck.oscar.handlers.icq.ICQMetaMore;
import org.walluck.oscar.handlers.icq.ICQMetaWork;
import org.walluck.oscar.handlers.icq.ICQOfflineMsg;
import org.walluck.oscar.handlers.icq.ICQPacket;
import org.walluck.oscar.handlers.icq.ICQSMSMessage;
import org.walluck.oscar.handlers.icq.IncomingIMCH4;
import org.walluck.oscar.handlers.news.NewsHandler;
import org.walluck.oscar.handlers.secureim.SecureIM;
import org.walluck.oscar.handlers.stocks.StocksHandler;
import org.walluck.oscar.handlers.trilliansecureim.TrillianSecureIM;
import org.walluck.oscar.script.ScriptInterpreter;

public class Oscar
implements ServiceListener,
LocateListener,
BuddyListListener,
ICBMListener,
UserLookupListener,
PopupListener,
BOSListener,
StatsListener,
ChatNavListener,
ChatListener,
ODirListener,
IconListener,
SSIListener,
ICQListener,
LoginListener,
MailListener,
MiscListener {
    private static final Logger LOG = Logger.getLogger((String)Oscar.class.getName());
    private RateClearTask rct;
    private String sn;
    private String password;
    private static final int UC_UNAVAILABLE = 1;
    private static final int UC_AOL = 2;
    private static final int UC_ADMIN = 4;
    private static final int UC_UNCONFIRMED = 8;
    private static final int UC_NORMAL = 16;
    private static final int UC_AB = 32;
    private static final int UC_WIRELESS = 64;
    private static final int UC_HIPTOP = 128;
    private static final String AIMHASHDATA = "http://gaim.sourceforge.net/aim_data.php3";
    private int aimCaps = 3998207;
    private static final int ICQ_CAPS = 218112;
    private AIMConnection bosconn;
    private ArrayList buddyGroups;
    private Hashtable icons = new Hashtable();
    private Hashtable trillianSessions = new Hashtable();
    private ArrayList stocks;
    private ArrayList news;
    private boolean formatScreenname = false;
    private boolean changePassword = false;
    private boolean confirmAccount = false;
    private boolean getEmail = false;
    private boolean setEmail = false;
    private String email;
    private String nick;
    private String oldPassword;
    private String newPassword;
    private int maxSigLen = 0;

    public int getAIMCaps() {
        return this.aimCaps;
    }

    public static int getICQCaps() {
        return 218112;
    }

    public ICQPacket getICQPacket(AIMFrame frame) {
        ICQPacket recvicqPacket = frame.getICQPacket();
        int pid = recvicqPacket.getId();
        ICQPacket sendicqPacket = (ICQPacket)frame.getConn().getICQHashtable().remove(new Integer(pid));
        if (sendicqPacket == null) {
            LOG.warn((Object)("No ICQ packet found for recvdpid=0x" + Integer.toHexString(pid)));
            return null;
        }
        return sendicqPacket;
    }

    public synchronized ArrayList getBuddyGroups() {
        return this.buddyGroups;
    }

    public synchronized void printBuddyList() {
        if (this.buddyGroups == null) {
            return;
        }
        Iterator i = this.buddyGroups.iterator();
        while (i.hasNext()) {
            BuddyGroup buddyGroup = (BuddyGroup)i.next();
            System.out.println(buddyGroup.getName());
            Iterator i2 = buddyGroup.iterator();
            while (i2.hasNext()) {
                Buddy buddy = (Buddy)i2.next();
                System.out.println("  " + buddy.getName());
            }
        }
    }

    private synchronized int findGroupInBuddyList(String group) {
        int j = 0;
        Iterator i = this.buddyGroups.iterator();
        while (i.hasNext()) {
            BuddyGroup buddyGroup = (BuddyGroup)i.next();
            if (AIMUtil.snCmp(buddyGroup.getName(), group)) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    private synchronized int findBuddyInBuddyList(String name, String group) {
        int j = this.findGroupInBuddyList(group);
        if (j == -1) {
            return -1;
        }
        BuddyGroup buddyGroup = (BuddyGroup)this.buddyGroups.get(j);
        j = 0;
        Iterator i = buddyGroup.iterator();
        while (i.hasNext()) {
            Buddy buddy = (Buddy)i.next();
            if (AIMUtil.snCmp(buddy.getName(), name)) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    public synchronized Buddy findBuddy(String sn) {
        int size = this.buddyGroups.size();
        for (int i = 0; i < size; ++i) {
            BuddyGroup g = (BuddyGroup)this.buddyGroups.get(i);
            Buddy b = g.findBuddy(sn);
            if (b == null) continue;
            return b;
        }
        return null;
    }

    public synchronized BuddyGroup findBuddyGroupByBuddy(String sn) {
        int size = this.buddyGroups.size();
        for (int i = 0; i < size; ++i) {
            BuddyGroup g = (BuddyGroup)this.buddyGroups.get(i);
            if (g.findBuddy(sn) == null) continue;
            return g;
        }
        return null;
    }

    public String getSN() {
        return this.sn;
    }

    public void setSN(String sn) {
        this.sn = sn;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    private String typeToText(int type) {
        if ((type & 0x20) != 0) {
            return "ActiveBuddy!";
        }
        if ((type & 2) != 0) {
            return "AOL";
        }
        if ((type & 4) != 0) {
            return "Administrator";
        }
        if ((type & 8) != 0) {
            return "Unconfirmed Internet";
        }
        if ((type & 0x10) != 0) {
            return "Internet";
        }
        if ((type & 0x40) != 0) {
            return "Mobile Device User";
        }
        if ((type & 1) != 0) {
            return "Unavailable";
        }
        if ((type & 0x80) != 0) {
            return "Hiptop";
        }
        return null;
    }

    public String capsToText(int caps) {
        String s;
        StringBuffer sb = new StringBuffer();
        if ((caps & 0x800) != 0) {
            sb.append("Active Buddy, ");
        }
        if ((caps & 0x40) != 0 || (caps & 0x200) != 0 || (caps & 0x80) != 0) {
            sb.append("Add-Ins, ");
        }
        if ((caps & 1) != 0) {
            sb.append("Buddy Icon, ");
        }
        if ((caps & 8) != 0) {
            sb.append("Chat, ");
        }
        if ((caps & 4) != 0) {
            sb.append("Direct IM, ");
        }
        if ((caps & 0x2000) != 0) {
            sb.append("Empty, ");
        }
        if ((caps & 0x10) != 0) {
            sb.append("File Sharing, ");
        }
        if ((caps & 0x20) != 0) {
            sb.append("File Transfer, ");
        }
        if ((caps & 0x40000) != 0) {
            sb.append("Interoperate, ");
        }
        if ((caps & 0x10000) != 0) {
            sb.append("SecureIM, ");
        }
        if ((caps & 0x200000) != 0) {
            sb.append("Security Enabled, ");
        }
        if ((caps & 0x100) != 0) {
            sb.append("Send Buddy List, ");
        }
        if ((caps & 2) != 0) {
            sb.append("Talk, ");
        }
        if ((caps & 0x400) != 0) {
            sb.append("ICQ, ");
        }
        if ((caps & 0x1000) != 0) {
            sb.append("ICQ RTF, ");
        }
        if ((caps & 0x4000) != 0) {
            sb.append("ICQ Server Relay, ");
        }
        if ((caps & 0x8000) != 0) {
            sb.append("ICQ Unknown, ");
        }
        if ((caps & 0x20000) != 0) {
            sb.append("ICQ UTF-8, ");
        }
        if ((s = sb.toString()) != null && s.length() >= 2) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }

    public void sendIM(AIMSession sess, String name, String message, int imflags) throws IOException {
        AOLIM args = new AOLIM();
        args.setFlags(args.getFlags() | 2);
        if (sess.isICQ()) {
            args.setFlags(args.getFlags() | 0x800);
        } else if ((imflags & 1) != 0) {
            args.setFlags(args.getFlags() | 1);
        }
        args.setDestSN(name);
        if ((args.getFlags() & 4) != 0) {
            args.setCharset(2);
            args.setCharSubset(0);
        } else if ((args.getFlags() & 8) != 0) {
            args.setCharset(3);
            args.setCharSubset(0);
        } else {
            args.setCharset(0);
            args.setCharSubset(0);
        }
        args.setMsg(message);
        ICBMHandler im = (ICBMHandler)sess.getHandler(4);
        im.sendCH1Ext(sess, args);
    }

    public void sendFile(AIMSession sess, String sn, String file) {
        try {
            byte[] ck = new byte[8];
            MsgCookie cookie = new MsgCookie(this.bosconn, ck, 18, null);
            FT ft = new FT(sess, ck);
            ft.sendFile(sn, file, 1, null);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void getFile(AIMSession sess, String sn) {
        try {
            MsgCookie cookie = new MsgCookie(this.bosconn, null, 18, null);
            FT ft = new FT(sess, cookie.getCookie());
            ft.sendFile(sn, null, 18, null);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void trillianEncryption(AIMSession sess, String sn, String msg) {
        if (msg != null) {
            TrillianSecureIM tsi = (TrillianSecureIM)this.trillianSessions.get(AIMUtil.normalize(sn));
            if (tsi != null) {
                LOG.debug((Object)"Session found, sending message...");
                tsi.sendMsg(msg);
            } else {
                LOG.debug((Object)"No previous session found. Please start one first");
            }
            return;
        }
        try {
            LOG.debug((Object)("Creating Trillian SecureIM session with " + sn + "..."));
            TrillianSecureIM tsi = new TrillianSecureIM(sess, sn);
            LOG.debug((Object)("Requesting that " + sn + " join session..."));
            tsi.sendRequest();
            this.trillianSessions.put(AIMUtil.normalize(sn), tsi);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void join(AIMSession sess, String chat) {
        try {
            ChatNavHandler chatNav = (ChatNavHandler)sess.getHandler(13);
            chatNav.createRoom(sess, this.bosconn, chat, 4);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void invite(AIMSession sess, String sn, String name) {
        try {
            ChatRendezvous rv = new ChatRendezvous();
            Chat chat = new Chat();
            chat.setName(name);
            chat.setExchange(4);
            chat.setInstance(0);
            rv.setChat(chat);
            rv.setMsg("Join " + name + " now!");
            rv.setRequest();
            ICBMHandler im = (ICBMHandler)sess.getHandler(4);
            im.sendRendezvous(sess, sn, rv);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void getInfo(AIMSession sess, String sn) throws IOException {
        LocateHandler loc = (LocateHandler)sess.getHandler(2);
        if (sess.isICQ()) {
            return;
        }
        loc.getInfo(sess, this.bosconn, sn, 3);
    }

    public void getAway(AIMSession sess, String sn) throws IOException {
        LocateHandler loc = (LocateHandler)sess.getHandler(2);
        if (sess.isICQ()) {
            return;
        }
        loc.getInfo(sess, this.bosconn, sn, 1);
    }

    public void setInfo(AIMSession sess, String encoding, String text) throws IOException {
        LocateHandler loc = (LocateHandler)sess.getHandler(2);
        if (sess.isICQ()) {
            loc.setProfile(sess, this.bosconn, null, null, null, null, 218112, null);
            return;
        }
        loc.setProfile(sess, this.bosconn, encoding, text, null, null, this.aimCaps, null);
    }

    public void setAwayAIM(AIMSession sess, String encoding, byte[] awaymb) throws IOException {
        LocateHandler loc = (LocateHandler)sess.getHandler(2);
        String awaymsg = new String(awaymb, AIMUtil.charsetAOLToJava(encoding));
        loc.setProfile(sess, this.bosconn, encoding, null, encoding, awaymsg, this.aimCaps, null);
    }

    public void setAwayAIM(AIMSession sess, String awaymsg) throws IOException {
        this.setAwayAIM(sess, "us-ascii", awaymsg.getBytes("US-ASCII"));
    }

    public void setAwayICQ(AIMSession sess, String awaymsg) throws IOException {
        ServiceHandler service = (ServiceHandler)sess.getHandler(1);
        if (awaymsg.equals("Online")) {
            service.setExtStatus(sess, 0);
        } else if (awaymsg.equals("Away")) {
            service.setExtStatus(sess, 1);
        } else if (awaymsg.equals("Do Not Disturb")) {
            service.setExtStatus(sess, 19);
        } else if (awaymsg.equals("Not Available")) {
            service.setExtStatus(sess, 5);
        } else if (awaymsg.equals("Occupied")) {
            service.setExtStatus(sess, 17);
        } else if (awaymsg.equals("Free For Chat")) {
            service.setExtStatus(sess, 32);
        } else if (awaymsg.equals("Invisible")) {
            service.setExtStatus(sess, 256);
        }
    }

    private static String icqStatus(int state) {
        if ((state & 0x20) != 0) {
            return "Free For Chat";
        }
        if ((state & 0x13) != 0) {
            return "Do Not Disturb";
        }
        if ((state & 5) != 0) {
            return "Not Available";
        }
        if ((state & 0x11) != 0) {
            return "Occupied";
        }
        if ((state & 1) != 0) {
            return "Away";
        }
        if ((state & 0x30000) != 0) {
            return "Web Aware";
        }
        if ((state & 0x100) != 0) {
            return "Invisible";
        }
        return "Online";
    }

    public void addBuddy(AIMSession sess, String name, String group) throws IOException {
        Buddy b;
        int i;
        SSIHandler ssi = (SSIHandler)sess.getHandler(19);
        if (sess.getSSI().getReceivedData() && ssi.itemListExists(sess.getSSI().getLocal(), name) == null) {
            ssi.addBuddy(sess, name, group, null, null, null, false);
        }
        if ((i = this.findGroupInBuddyList(group)) != -1) {
            b = ((BuddyGroup)this.buddyGroups.get(i)).addBuddy(name);
        } else {
            this.buddyGroups.add(new BuddyGroup(group));
            b = ((BuddyGroup)this.buddyGroups.get(this.buddyGroups.size() - 1)).addBuddy(name);
        }
        b.setProperty(Buddy.SESSION, sess);
    }

    public void moveBuddy(AIMSession sess, String name, String oldGroup, String newGroup) throws IOException {
        int j;
        int i;
        int f = this.findBuddyInBuddyList(name, oldGroup);
        if (f == -1) {
            return;
        }
        if (sess.getSSI().getReceivedData()) {
            SSIHandler ssi = (SSIHandler)sess.getHandler(19);
            ssi.moveBuddy(sess, oldGroup, newGroup, name);
        }
        if ((i = this.findGroupInBuddyList(oldGroup)) != -1 && (j = this.findBuddyInBuddyList(name, oldGroup)) != -1) {
            ((BuddyGroup)this.buddyGroups.get(i)).remove(j);
        }
    }

    public void removeBuddy(AIMSession sess, String name, String group) throws IOException {
        int j = this.findBuddyInBuddyList(name, group);
        if (j == -1) {
            LOG.debug((Object)("Tried to remove non-existent buddy=" + name));
            return;
        }
        SSIHandler ssi = (SSIHandler)sess.getHandler(19);
        if (sess.getSSI().getReceivedData()) {
            ssi.delBuddy(sess, name, group);
        }
    }

    public void renameGroup(AIMSession sess, String oldGroup, String newGroup) throws IOException {
        int f = this.findGroupInBuddyList(oldGroup);
        if (f == -1) {
            return;
        }
        ((BuddyGroup)this.buddyGroups.get(f)).setName(newGroup);
        SSIHandler ssi = (SSIHandler)sess.getHandler(19);
        ssi.renameGroup(sess, oldGroup, newGroup);
    }

    public void login(AIMSession sess, String sn) throws IOException {
        String dest = "login.oscar.aol.com:5190";
        AIMConnection conn = new AIMConnection(sess, 7, dest);
        conn.registerListener(23, 7, this);
        conn.registerListener(23, 3, this);
        conn.connect();
        LoginHandler login = (LoginHandler)sess.getHandler(23);
        login.requestLogin(sess, conn, sn);
    }

    public void checkMail(AIMSession sess) throws IOException {
        MailHandler mail = (MailHandler)sess.getHandler(24);
        mail.sendCookies(sess);
        mail.activate(sess);
    }

    public void addPermit(AIMSession sess, String who) throws IOException {
        SSIHandler ssi = (SSIHandler)sess.getHandler(19);
        if (sess.getSSI().getReceivedData()) {
            ssi.addPermit(sess, who);
        }
    }

    public void addDeny(AIMSession sess, String who) throws IOException {
        SSIHandler ssi = (SSIHandler)sess.getHandler(19);
        if (sess.getSSI().getReceivedData()) {
            ssi.addDeny(sess, who);
        }
    }

    public void remPermit(AIMSession sess, String who) throws IOException {
        SSIHandler ssi = (SSIHandler)sess.getHandler(19);
        if (sess.getSSI().getReceivedData()) {
            ssi.delPermit(sess, who);
        }
    }

    public void remDeny(AIMSession sess, String who) throws IOException {
        SSIHandler ssi = (SSIHandler)sess.getHandler(19);
        if (sess.getSSI().getReceivedData()) {
            ssi.delDeny(sess, who);
        }
    }

    public void getEmail(AIMSession sess) throws IOException {
        AIMConnection conn = AIMConnection.findByType(sess, 7);
        if (conn == null) {
            this.getEmail = true;
            ServiceHandler service = (ServiceHandler)sess.getHandler(1);
            service.reqService(sess, this.bosconn, 7);
        } else {
            AdminHandler admin = (AdminHandler)sess.getHandler(7);
            admin.getInfo(sess, conn, 17);
        }
    }

    public void confirmAccount(AIMSession sess) throws IOException {
        AIMConnection conn = AIMConnection.findByType(sess, 7);
        if (conn == null) {
            this.confirmAccount = true;
            ServiceHandler service = (ServiceHandler)sess.getHandler(1);
            service.reqService(sess, this.bosconn, 7);
        } else {
            AdminHandler admin = (AdminHandler)sess.getHandler(7);
            admin.reqConfirm(sess, conn);
        }
    }

    public void changeEmail(AIMSession sess, String eml) throws IOException {
        if (AIMConnection.findByType(sess, 7) != null) {
            this.setEmail = true;
            this.email = eml;
            ServiceHandler service = (ServiceHandler)sess.getHandler(1);
            service.reqService(sess, this.bosconn, 7);
        } else {
            AdminHandler admin = (AdminHandler)sess.getHandler(7);
            admin.setEmail(sess, AIMConnection.findByType(sess, 7), this.email);
        }
    }

    public void formatScreenname(AIMSession sess, String sn) throws IOException {
        if (!AIMUtil.snCmp(this.nick, sess.getSN())) {
            if (AIMConnection.findByType(sess, 7) != null) {
                this.formatScreenname = true;
                this.nick = sn;
                ServiceHandler service = (ServiceHandler)sess.getHandler(1);
                service.reqService(sess, this.bosconn, 7);
            } else {
                AdminHandler admin = (AdminHandler)sess.getHandler(7);
                admin.setNick(sess, AIMConnection.findByType(sess, 7), this.nick);
            }
        }
    }

    public void changePassword(AIMSession sess, String oldp, String newp) throws IOException {
        if (AIMConnection.findByType(sess, 7) != null) {
            this.changePassword = true;
            this.oldPassword = oldp;
            this.newPassword = newp;
            ServiceHandler service = (ServiceHandler)sess.getHandler(1);
            service.reqService(sess, this.bosconn, 7);
        } else {
            AdminHandler admin = (AdminHandler)sess.getHandler(7);
            admin.changePassword(sess, AIMConnection.findByType(sess, 7), newp, oldp);
        }
    }

    public void convoClosed(ArrayList dims, DirectIM who) {
        if (!dims.contains(who)) {
            return;
        }
        dims.remove(who);
        who.end();
    }

    public void infoChange(AIMSession sess, AIMFrame frame, boolean infoChange, short perms, short err, String url, String sn, String email) {
    }

    public void accountConfirm(AIMSession sess, AIMFrame frame, int status) {
    }

    public void godDamnICQ(AIMSession sess, AIMFrame frame, String unused) {
        try {
            LoginHandler login = (LoginHandler)sess.getHandler(23);
            login.sendLogin(sess, frame.getConn(), this.sn, this.password, null, null, null);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void parse(AIMSession sess, AIMFrame frame, LoginResponseInfo info, int family, int subtype) {
        sess.setLoginInfo(info);
        try {
            if (info.getBosip() == null) {
                LOG.fatal((Object)("Error in signon code=" + info.getErrorCode() + " url=" + info.getErrorURL()));
                String errorMsg = null;
                switch (info.getErrorCode()) {
                    case 1: 
                    case 5: {
                        errorMsg = "Incorrect nickname or password.";
                        break;
                    }
                    case 17: {
                        errorMsg = "Your account is currently suspended.";
                        break;
                    }
                    case 20: {
                        errorMsg = "The AOL Instant Messenger service is temporarily unavailable.";
                        break;
                    }
                    case 24: {
                        errorMsg = "You have been connecting and disconnecting too frequently. If you continue to try, you will need to wait even longer.";
                        break;
                    }
                    case 28: {
                        errorMsg = "The client version you are using is too old. Please upgrade.";
                        break;
                    }
                    default: {
                        errorMsg = "Unknown.";
                    }
                }
                LOG.fatal((Object)errorMsg);
                frame.getConn().close();
                return;
            }
            LOG.debug((Object)"Closing authorizer connection...");
            frame.getConn().close();
            LOG.debug((Object)"Creating BOS connection...");
            this.bosconn = new AIMConnection(sess, 2, info.getBosip());
            this.bosconn.registerListener(65535, 65533, this);
            this.bosconn.registerListener(65535, 65535, this);
            this.bosconn.registerListener(65535, 65534, this);
            this.bosconn.registerListener(1, 7, this);
            this.bosconn.registerListener(9, 3, this);
            this.bosconn.registerListener(1, 5, this);
            this.bosconn.registerListener(2, 3, this);
            this.bosconn.registerListener(3, 3, this);
            this.bosconn.registerListener(3, 11, this);
            this.bosconn.registerListener(3, 12, this);
            this.bosconn.registerListener(4, 7, this);
            this.bosconn.registerListener(2, 1, this);
            this.bosconn.registerListener(4, 10, this);
            this.bosconn.registerListener(4, 11, this);
            this.bosconn.registerListener(1, 10, this);
            this.bosconn.registerListener(1, 16, this);
            this.bosconn.registerListener(10, 1, this);
            this.bosconn.registerListener(4, 1, this);
            this.bosconn.registerListener(1, 1, this);
            this.bosconn.registerListener(3, 1, this);
            this.bosconn.registerListener(9, 1, this);
            this.bosconn.registerListener(10, 3, this);
            this.bosconn.registerListener(2, 6, this);
            this.bosconn.registerListener(4, 12, this);
            this.bosconn.registerListener(1, 19, this);
            this.bosconn.registerListener(4, 5, this);
            this.bosconn.registerListener(1, 31, this);
            this.bosconn.registerListener(1, 15, this);
            this.bosconn.registerListener(21, 3, this);
            this.bosconn.registerListener(8, 2, this);
            this.bosconn.registerListener(19, 3, this);
            this.bosconn.registerListener(19, 6, this);
            this.bosconn.registerListener(19, 15, this);
            this.bosconn.registerListener(24, 7, this);
            this.bosconn.registerListener(11, 2, this);
            this.bosconn.registerListener(11, 4, this);
            this.bosconn.registerListener(4, 20, this);
            this.bosconn.getTransmitQueue().setMode(1);
            this.bosconn.connect();
            LoginHandler login = (LoginHandler)sess.getHandler(23);
            login.sendCookie(sess, this.bosconn, info.getCookie());
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void keyParse(AIMSession sess, AIMFrame frame, String keystr) {
        ClientInfo ci = !sess.isIChat() ? new AIMClientInfo() : new IChatClientInfo();
        try {
            LoginHandler login = (LoginHandler)sess.getHandler(23);
            login.sendLogin(sess, frame.getConn(), this.sn, this.password, ci, keystr, "AOL Instant Messenger (SM)");
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void newUIN(AIMSession sess, AIMFrame frame, int uin, int ip, int port) {
        LOG.debug((Object)("Got new UIN=" + uin));
    }

    public void securID(AIMSession sess, AIMFrame frame) {
        LOG.debug((Object)"Got SecurID request");
    }

    public void bosRights(AIMSession sess, AIMFrame frame, int maxpermits, int maxdenies) {
        try {
            LOG.debug((Object)("BOS rights: Max permit = " + maxpermits + " / Max deny = " + maxdenies));
            ServiceHandler service = (ServiceHandler)sess.getHandler(1);
            if (sess.isICQ()) {
                service.setExtStatus(sess, 0);
            }
            if (!sess.isICQ()) {
                service.reqService(sess, frame.getConn(), 13);
                service.reqService(sess, frame.getConn(), 24);
                service.reqService(sess, frame.getConn(), 16);
                service.reqService(sess, frame.getConn(), 15);
            }
            service.clientReady(sess, frame.getConn());
            ScriptInterpreter si = new ScriptInterpreter(sess, frame.getConn(), this);
            sess.setScriptInterpreter(si);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void buddyChange(AIMSession sess, AIMFrame frame, UserInfo info) {
        SNAC snac = frame.getSNAC();
        Buddy b = null;
        for (int i = 0; i < this.buddyGroups.size() && (b = ((BuddyGroup)this.buddyGroups.get(i)).findBuddy(info.getSN())) == null; ++i) {
        }
        String state = "Invalid";
        if (snac.getFamily() == 3) {
            if (frame.getSNAC().getSubtype() == 11) {
                LOG.debug((Object)(info.getSN() + " signed on"));
                state = "Online";
            } else if (frame.getSNAC().getSubtype() == 12) {
                LOG.debug((Object)(info.getSN() + " signed off"));
                state = "Offline";
                TrillianSecureIM tsi = (TrillianSecureIM)this.trillianSessions.remove(AIMUtil.normalize(info.getSN()));
                if (tsi != null) {
                    LOG.debug((Object)("Removed Trillian SecureIM session with " + info.getSN()));
                }
                if (b != null) {
                    b.setProperty(Buddy.STATE, state);
                    LOG.debug((Object)("[3] " + info.getSN() + "'s state set to " + state));
                }
                return;
            }
        }
        int caps = 0;
        if ((info.getPresent() & 0x80) != 0) {
            caps = info.getCapabilities();
        }
        if ((info.getPresent() & 0x400) != 0) {
            caps |= info.getCapabilities2();
        }
        if ((info.getPresent() & 0x2000) != 0) {
            caps |= info.getCapabilities3();
        }
        int type = 0;
        if ((info.getCapabilities() & 0x400000) != 0) {
            type |= 0x80;
        }
        String userclass = "";
        if (!sess.isICQ() && (info.getPresent() & 1) != 0) {
            if ((info.getFlags() & 1) != 0) {
                type |= 8;
                userclass = "trial";
            }
            if ((info.getFlags() & 2) != 0) {
                type |= 4;
                userclass = "admin";
            }
            if ((info.getFlags() & 4) != 0) {
                type |= 2;
                userclass = "aol";
            }
            if ((info.getFlags() & 0x10) != 0) {
                type |= 0x10;
                userclass = "normal";
            }
            if ((info.getFlags() & 0x20) != 0) {
                type |= 1;
                state = "Away";
            } else if (info.getAvailableMsg() != null) {
                LOG.debug((Object)(info.getSN() + " is available: " + info.getAvailableMsg()));
                state = info.getAvailableMsg();
            } else {
                LOG.warn((Object)(info.getSN() + " is not away, and has no available" + " message"));
            }
            if ((info.getFlags() & 0x400) != 0) {
                type |= 0x20;
                userclass = "bot";
            }
            if ((info.getFlags() & 0x80) != 0) {
                type |= 0x40;
                userclass = "wireless";
            }
            if ((info.getCapabilities() & 0x400000) != 0) {
                type |= 0x80;
                userclass = "hiptop";
            }
        }
        if ((info.getPresent() & 0x10) != 0) {
            type = info.getIcqInfo().getStatus();
            if ((info.getIcqInfo().getStatus() & 0x20) == 0 && info.getIcqInfo().getStatus() != 0) {
                type = 1;
            }
        }
        if ((caps & 0x400) != 0) {
            caps ^= 0x400;
        }
        long idleTime = 0L;
        if ((info.getPresent() & 8) != 0) {
            idleTime = (long)info.getIdleTime() * 60L * 1000L;
        }
        long signon = 0L;
        if ((info.getPresent() & 0x100) != 0) {
            signon = (long)info.getSessionLen() * 1000L;
        }
        float warnLevel = info.getWarnLevel();
        long memberSince = info.getMemberSince();
        if (!sess.isICQ() && snac.getFamily() == 3) {
            LOG.debug((Object)(info.getSN() + ": warnLevel=" + warnLevel + "%, signon=" + AIMUtil.prettyPrintTime(signon) + " ago, idleTime=" + AIMUtil.prettyPrintTime(idleTime) + ", user=" + type + "/" + this.typeToText(type) + ", capabilities=" + this.capsToText(caps) + (memberSince > 0L ? ", member since=" + new Date(memberSince * 1000L) : "") + ", state=" + state));
            if (b != null) {
                if (caps != 0) {
                    b.setProperty(Buddy.CAPABILITIES, new Integer(caps));
                }
                b.setProperty(Buddy.STATE, state);
                LOG.debug((Object)("[3] " + info.getSN() + "'s state set to " + state));
                b.setProperty(Buddy.WARN_LEVEL, new Float(warnLevel));
                b.setProperty(Buddy.CLASS, this.typeToText(type));
                b.setProperty(Buddy.MEMBER_SINCE, new Date(memberSince * 1000L));
                b.setProperty(Buddy.SIGNON_TIME, new Long(signon));
                b.setProperty(Buddy.IDLE_TIME, new Long(idleTime));
            }
        } else if (snac.getFamily() == 3) {
            TLV tlv;
            LOG.debug((Object)(info.getSN() + ": warnLevel=" + warnLevel + "%, signon=" + signon + " minutes ago, idleTime=" + idleTime + " minutes, user=" + this.typeToText(type) + ", capabilities=" + this.capsToText(caps)));
            if (b != null) {
                b.setProperty(Buddy.CAPABILITIES, new Integer(caps));
                b.setProperty(Buddy.STATE, state);
                LOG.debug((Object)("[3] " + info.getSN() + "'s state set to " + state));
                b.setProperty(Buddy.WARN_LEVEL, new Float(warnLevel));
                b.setProperty(Buddy.CLASS, this.typeToText(type));
                b.setProperty(Buddy.SIGNON_TIME, new Long(signon * 60L * 1000L));
                b.setProperty(Buddy.IDLE_TIME, new Long((long)info.getIdleTime() * 60L * 1000L));
            }
            if ((tlv = info.getIconData()) != null) {
                try {
                    LOG.debug((Object)("icon data TLV, length=" + tlv.getLength()));
                    LOG.debug((Object)AIMUtil.hexdump(tlv.getValue()));
                    AIMInputStream tmp = new AIMInputStream(new ByteArrayInputStream(tlv.getValue()));
                    while (!tmp.isEmpty()) {
                        short ttype = tmp.readShort();
                        byte flag = tmp.readByte();
                        byte length = tmp.readByte();
                        byte[] data = tmp.readBytes(length);
                        LOG.debug((Object)("type=0x" + ttype + ", flag=0x" + flag + ", length=" + length + ", data=" + (data != null ? AIMUtil.byteArrayToHexString(data) : "empty")));
                        if (ttype == 1 && flag == 1) {
                            if (this.checkIcon(info.getSN(), data)) {
                                LOG.debug((Object)("[10] icon for " + info.getSN() + " the same as on disk"));
                                return;
                            }
                            String nsn = AIMUtil.normalize(info.getSN());
                            if (this.icons.get(nsn) != null) {
                                LOG.debug((Object)("[10] Pending request for " + info.getSN()));
                                return;
                            }
                            this.icons.put(nsn, data);
                            LOG.debug((Object)("[10] " + info.getSN() + ": getting icon..."));
                            this.getIcons(sess);
                            continue;
                        }
                        if (ttype != 2 || flag != 4) continue;
                        AIMInputStream tmp2 = new AIMInputStream(new ByteArrayInputStream(data));
                        byte[] availableMsgBytes = tmp2.readBytes(tmp2.readShort());
                        if (tmp2.readShort() == 1) {
                            LOG.debug((Object)("AvailableMsgEncoding short value=0x" + Integer.toHexString(tmp2.readShort())));
                            info.setAvailableMsgEncoding(tmp2.readStringLL());
                        } else {
                            info.setAvailableMsgEncoding("utf-8");
                        }
                        String enc = info.getAvailableMsgEncoding();
                        String availableMsg = new String(availableMsgBytes, AIMUtil.charsetAOLToJava(enc));
                        info.setAvailableMsg(availableMsg);
                    }
                }
                catch (IOException ioe) {
                    LOG.error((Object)"IOException", (Throwable)ioe);
                }
            }
        }
    }

    public void buddylistRights(AIMSession sess, AIMFrame frame, int maxbuddies, int maxwatchers) {
    }

    public void outgoingIM(AIMSession sess, AIMFrame frame, int channel, String sn, String msg, int icbmflags, short flag1, short flag2) {
    }

    public void incomingIMCH1(AIMSession sess, AIMFrame frame, int channel, UserInfo userinfo, AOLIM args) {
        String client = "unknown client";
        if (args.getFeatures() != null) {
            int id = AIMFingerPrintInfo.getFingerPrintId(args.getFeatures());
            switch (id) {
                case 1: {
                    client = "AOL Mobile Communicator";
                    break;
                }
                case 2: {
                    client = "WinAIM";
                    break;
                }
                case 3: {
                    client = "WinAIM 4.1";
                    break;
                }
                case 4: {
                    client = "AOL, CompuServe, TOC, or iChat";
                    break;
                }
                case 5: {
                    client = "ICQ";
                    break;
                }
            }
        }
        LOG.debug((Object)(userinfo.getSN() + " (using " + client + "): " + args.getMsg()));
    }

    public boolean checkIcon(String sn, int iconcsum) {
        File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + AIMUtil.normalize(sn) + ".gif");
        short oursum = 0;
        try {
            oursum = BuddyIconRendezvous.calculateChecksum(file);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
        if (oursum == iconcsum) {
            LOG.debug((Object)"[10] Icon sums equal, no need to save icon");
            return true;
        }
        LOG.debug((Object)"[10] Icon sums differ, no need to save icon");
        return false;
    }

    public boolean checkIcon(String sn, byte[] iconcsum) {
        File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + AIMUtil.normalize(sn) + ".gif");
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (file.exists()) {
                DataInputStream dis = new DataInputStream(new FileInputStream(file));
                byte[] ourdata = new byte[(int)file.length()];
                dis.readFully(ourdata);
                md.update(ourdata);
                byte[] oursum = md.digest();
                if (Arrays.equals(oursum, iconcsum)) {
                    LOG.debug((Object)"[10] Icon sums equal");
                    return true;
                }
                LOG.debug((Object)"[10] Icon sums differ");
            } else {
                LOG.debug((Object)"[10] Icon file doesn't exist");
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            LOG.error((Object)"NoSuchAlgorithmException", (Throwable)nsae);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
        return false;
    }

    private void writeIcon(String sn, byte[] icon) {
        File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + AIMUtil.normalize(sn) + ".gif");
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(icon);
            fos.close();
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void incomingIMCH2(AIMSession sess, AIMFrame frame, int channel, UserInfo userinfo, IncomingIMCH2 args) {
        LOG.debug((Object)(userinfo.getSN() + " sent us the message=" + args.getMsg()));
        if ((args.getReqClass() & 4) != 0) {
            LOG.debug((Object)(sess.getSN() + " received direct im request from " + userinfo.getSN() + " (" + args.getVerifiedIP() + ")"));
            LOG.debug((Object)(args.getClientIP1() + ":" + args.getClientIP2()));
            DirectIM dim = new DirectIM(sess, args.getCookie(), userinfo.getSN(), args.getVerifiedIP(), args.getPort(), false);
            dim.setListener(false);
            dim.start();
        } else if ((args.getReqClass() & 8) != 0) {
            Chat chat2 = args.getInfo().getChat().getRoomInfo();
            LOG.debug((Object)("Want to join room: " + AIMUtil.extractRoomName(chat2.getName()) + ", " + chat2.getExchange() + ", " + chat2.getInstance()));
            ChatHandler chat = (ChatHandler)sess.getHandler(14);
            AIMConnection chatConn = AIMConnection.findByGroup(sess, 13);
            try {
                LOG.debug((Object)("FIXME: we are about to join room " + chat2.getName() + " without asking"));
                chat.join(sess, this.bosconn, chat2.getExchange(), chat2.getName(), chat2.getInstance());
            }
            catch (IOException ioe) {
                LOG.error((Object)"IOException", (Throwable)ioe);
            }
        } else if ((args.getReqClass() & 1) != 0) {
            byte[] icon = args.getInfo().getIcon().getIcon();
            int iconcsum = args.getInfo().getIcon().getChecksum();
            if (!this.checkIcon(this.sn, iconcsum)) {
                this.writeIcon(this.sn, icon);
            }
        } else if ((args.getReqClass() & 0x20) != 0) {
            String ip = null;
            String ip1 = args.getClientIP1();
            String ip2 = args.getClientIP2();
            String ip3 = args.getVerifiedIP();
            LOG.debug((Object)(ip3 + "/" + ip2 + "/" + ip1));
            if (args.isProxied() && ip1 != null) {
                ip = ip1;
            } else if (ip3 != null) {
                ip = ip3;
            } else if (ip1 != null) {
                ip = ip1;
            } else if (ip2 != null) {
                ip = ip2;
            } else if (ip == null) {
                return;
            }
            MsgCookie cookie = new MsgCookie(frame.getConn(), null, 17, null);
            FileTransfer ftrans = new FileTransfer(sess);
            ftrans.sendFileAccept(cookie.getCookie(), args.getCookie(), userinfo.getSN(), ip, args.getPort());
        } else if ((args.getReqClass() & 0x10) != 0) {
            String ip = null;
            String ip1 = args.getClientIP1();
            String ip2 = args.getClientIP2();
            String ip3 = args.getVerifiedIP();
            LOG.debug((Object)(ip3 + "/" + ip2 + "/" + ip1));
            if (args.isProxied() && ip1 != null) {
                ip = ip1;
            } else if (ip3 != null) {
                ip = ip3;
            } else if (ip1 != null) {
                ip = ip1;
            } else if (ip2 != null) {
                ip = ip2;
            } else if (ip == null) {
                return;
            }
            MsgCookie cookie = new MsgCookie(frame.getConn(), null, 17, null);
            FileTransfer ftrans = new FileTransfer(sess);
            ftrans.getFileAccept(cookie.getCookie(), args.getCookie(), userinfo.getSN(), ip, args.getPort());
        } else if ((args.getReqClass() & 0x40) != 0 || (args.getReqClass() & 0x200) != 0 || (args.getReqClass() & 0x80) != 0) {
            LOG.debug((Object)("Game requested: game=" + args.getInfo().getGame() + ", computer=" + args.getInfo().getComputer()));
        } else if ((args.getReqClass() & 0x10000) != 0) {
            TrillianSecureIM tsi;
            if (args.getStatus() == 1 || args.getTrillianEncryption().getCmdType() == 4) {
                tsi = (TrillianSecureIM)this.trillianSessions.remove(AIMUtil.normalize(userinfo.getSN()));
                String present = "not present";
                if (tsi != null) {
                    present = "present";
                }
                if (args.getStatus() == 1) {
                    LOG.debug((Object)(userinfo.getSN() + " cancelled Tril SecureIM and tsi=" + present));
                }
                if (args.getTrillianEncryption().getCmdType() == 4) {
                    LOG.debug((Object)(userinfo.getSN() + " closed Tril SecureIM and tsi=" + present));
                }
            }
            if ((tsi = (TrillianSecureIM)this.trillianSessions.get(AIMUtil.normalize(userinfo.getSN()))) != null) {
                LOG.debug((Object)("Found existing Trillian SecureIM session with " + userinfo.getSN()));
                tsi.handleSecureIM(args);
            } else {
                LOG.debug((Object)("No previous Trillian SecureIM session with " + userinfo.getSN() + " found. Creating..."));
                tsi = new TrillianSecureIM(sess, userinfo.getSN());
                this.trillianSessions.put(AIMUtil.normalize(userinfo.getSN()), tsi);
                tsi.handleSecureIM(args);
            }
        } else if ((args.getReqClass() & 0x1000) != 0) {
            LOG.debug((Object)(userinfo.getSN() + " (using ICQ): " + args.getInfo().getRTFMsg().getRTFMsg()));
        }
    }

    public void incomingIMCH4(AIMSession sess, AIMFrame frame, int channel, UserInfo userinfo, IncomingIMCH4 args) {
        String typeString = "";
        String icqSep = "";
        try {
            icqSep = new String(new byte[]{-2}, "US-ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            LOG.error((Object)"UnsupportedEncodingException", (Throwable)uee);
        }
        switch (args.getType()) {
            case 1: {
                typeString = "Normal message";
                break;
            }
            case 4: {
                typeString = "URL";
                StringTokenizer st = new StringTokenizer(args.getMsg(), icqSep);
                String url = st.nextToken();
                String desc = st.nextToken();
                LOG.debug((Object)("URL=" + url + (desc != null ? " (" + desc + ")" : "")));
                break;
            }
            case 6: {
                typeString = "Requesting authorization from you";
                break;
            }
            case 7: {
                typeString = "User has denied your authorization request";
                break;
            }
            case 8: {
                typeString = "User has granted your authorization request";
                break;
            }
            case 12: {
                typeString = "User has added you to their contact list";
                break;
            }
            case 13: {
                typeString = "User has sent you this message via the web";
                break;
            }
            case 14: {
                typeString = "User has sent you this message via email";
                break;
            }
            case 18: {
                typeString = "Acknowledgement";
                break;
            }
            case 19: {
                StringTokenizer st2 = new StringTokenizer(args.getMsg(), icqSep);
                int buddyCount = Integer.parseInt(st2.nextToken());
                for (int i = 0; i < buddyCount; ++i) {
                    LOG.debug((Object)("UIN=" + st2.nextToken() + ", nick=" + st2.nextToken()));
                }
                break;
            }
            case 26: {
                typeString = "User sent you this message via SMS";
                break;
            }
            default: {
                typeString = "Unknown message type=" + Integer.toHexString(args.getType());
            }
        }
        if ((args.getType() & 0x8000) != 0) {
            typeString = typeString + " [Mass message]";
        }
        LOG.debug((Object)(userinfo.getSN() + ": " + args.getMsg() + " (" + typeString + ")"));
        if (args.getType() == 26) {
            ICQSMSMessage ism = new ICQSMSMessage(args.getMsg());
            LOG.debug((Object)ism.toString());
        }
    }

    public void paramInfo(AIMSession sess, AIMFrame frame, ICBMParams params) {
        params.setMaxChan(0);
        params.setFlags(sess.isICQ() ? 3 : 11);
        params.setMaxMsgLen(8000);
        params.setMaxSenderWarn(999);
        params.setMaxReceiverWarn(999);
        params.setMinMsgInterval(0);
        try {
            ICBMHandler im = (ICBMHandler)sess.getHandler(4);
            im.setICBMParams(sess, params);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void missedCall(AIMSession sess, AIMFrame frame, int channel, UserInfo userinfo, int numMissed, int reason) {
        String s = "unknown reason";
        switch (reason) {
            case 0: {
                s = "invalid";
                break;
            }
            case 1: {
                s = "too large";
                break;
            }
            case 2: {
                s = "rate exceeded";
                break;
            }
            case 3: {
                s = "sender too evil";
                break;
            }
            case 4: {
                s = "receiver too evil";
                break;
            }
        }
        LOG.debug((Object)("You missed " + numMissed + " message(s) from " + userinfo.getSN() + " because " + s));
    }

    public void clientAutoresp(AIMSession sess, AIMFrame frame, int channel, String sn, int reason) {
    }

    public void clientAutoresp(AIMSession sess, AIMFrame frame, int channel, String sn, int reason, int state, String msg) {
        LOG.debug((Object)("screenname=" + sn + ", status=" + Oscar.icqStatus(state) + ", msg=" + msg));
    }

    public void msgAck(AIMSession sess, AIMFrame frame, int type, String sn) {
        LOG.debug((Object)("Sent message to " + sn));
    }

    public void typingNotification(AIMSession sess, AIMFrame frame, byte[] ck, short type, String sn, short typing) {
        LOG.debug((Object)("Got typing code=" + Integer.toHexString(typing)));
    }

    public void locateRights(AIMSession sess, AIMFrame frame, int maxsiglen) {
        block6: {
            try {
                LocateHandler loc = (LocateHandler)sess.getHandler(2);
                this.maxSigLen = maxsiglen;
                AIMConnection conn = AIMConnection.findByType(sess, 2);
                if (!sess.isICQ()) {
                    String certFilename = System.getProperty("user.home") + System.getProperty("file.separator") + "mycert.p12";
                    if (new File(certFilename).exists()) {
                        SecureIM secureIM = new SecureIM(sess, certFilename, "password");
                        try {
                            secureIM.init();
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Exception", (Throwable)e);
                        }
                        loc.setProfile(sess, conn, "us-ascii", null, "us-ascii", null, this.aimCaps, secureIM.getEncoded());
                        break block6;
                    }
                    loc.setProfile(sess, conn, "us-ascii", null, "us-ascii", null, this.aimCaps, null);
                    break block6;
                }
                loc.setProfile(sess, conn, "us-ascii", null, "us-ascii", null, 218112, null);
            }
            catch (IOException ioe) {
                LOG.error((Object)"IOException", (Throwable)ioe);
            }
        }
    }

    public void userInfo(AIMSession sess, AIMFrame frame, UserInfo info, int infoType, String textEncoding, String text) {
        String onlineSince = null;
        String memberSince = null;
        String idleTime = null;
        if (text != null && text.length() > 0) {
            LOG.debug((Object)("Profile: " + text));
        }
        if ((info.getPresent() & 4) != 0) {
            LOG.debug((Object)("onlineSince=" + info.getOnlineSince()));
            onlineSince = "Online since: " + new Date((long)info.getOnlineSince() * 1000L);
        }
        if ((info.getPresent() & 2) != 0) {
            memberSince = "Member since: " + new Date((long)info.getMemberSince() * 1000L);
        }
        idleTime = (info.getPresent() & 8) != 0 ? "Idle: " + info.getIdleTime() + " minutes" : "Idle: Active";
        LOG.debug((Object)("Username: " + info.getSN() + "\n" + "Warning Level: " + info.getWarnLevel() / 10.0f + "%" + "\n" + (onlineSince != null ? onlineSince : "") + "\n" + (memberSince != null ? memberSince : "") + "\n" + (idleTime != null ? idleTime : "") + "\n"));
        if (infoType == 3) {
            LOG.debug((Object)("Away Message: " + (text != null ? text : "User has no away message")));
        } else if (infoType == 4) {
            LOG.debug((Object)("Client Capabilities: " + this.capsToText(info.getCapabilities())));
        } else {
            LOG.debug((Object)"No information provided");
        }
    }

    public void invitationSent(AIMSession sess, AIMFrame frame, AIMInputStream buffer) {
        LOG.debug((Object)"invitationSent: invitation sent successfully!");
    }

    public void reply(AIMSession sess, AIMFrame frame, String searchAddr, int j, ArrayList buf) {
        String s = "";
        while (j-- > 0) {
            s = s + buf.get(j) + " ";
        }
        LOG.debug((Object)(searchAddr + " has the following screennames: " + s));
    }

    public void parsePopup(AIMSession sess, AIMFrame frame, AIMPopup popup) {
        LOG.debug((Object)("parsePopup: Got popup: msg=" + popup.getMsg() + ", url=" + popup.getURL() + ", width=" + popup.getWidth() + ", height=" + popup.getHeight() + ", delay=" + popup.getDelay()));
    }

    public void reportInterval(AIMSession sess, AIMFrame frame, int interval) {
        LOG.debug((Object)("reportInterval: Server wants you to report stats every " + interval / 60 + " minutes"));
    }

    public void reportAck(AIMSession sess, AIMFrame frame, AIMInputStream buffer) {
        LOG.debug((Object)"reportAck");
    }

    public void parseInfoPerms(AIMSession sess, AIMFrame frame, int subtype, int maxrooms, int curexchange, ArrayList exchanges) {
        switch (subtype) {
            case 2: {
                LOG.debug((Object)"chat info: Chat Rights:\n");
                LOG.debug((Object)("chat info: \tMax Concurrent Rooms: " + maxrooms));
                LOG.debug((Object)("chat info: \tExchange List: (" + exchanges.size() + " total)"));
                for (int i = 0; i < exchanges.size(); ++i) {
                    ExchangeInfo ei = (ExchangeInfo)exchanges.get(i);
                    LOG.debug((Object)("chat info: Exchange #" + ei.getNumber() + ":\tExchange name:\t" + (ei.getName() != null ? ei.getName() : "(none)")));
                }
                break;
            }
            default: {
                LOG.warn((Object)("Unknown permissions=" + Integer.toHexString(subtype)));
            }
        }
    }

    public void parseInfoCreate(AIMSession sess, AIMFrame frame, int subtype, String fqcn, int instance, int exchange, int flags, int createtime, int maxmsglen, int maxoccupancy, int createperms, int unknown, String name, String ck) {
        switch (subtype) {
            case 8: {
                LOG.debug((Object)("created room: " + fqcn + " " + exchange + " " + instance + " " + flags + " " + createtime + " " + maxmsglen + " " + maxoccupancy + " " + createperms + " " + unknown + " " + name + " " + ck));
                ChatHandler chat = (ChatHandler)sess.getHandler(14);
                try {
                    chat.join(sess, this.bosconn, exchange, ck, instance);
                }
                catch (IOException ioe) {
                    LOG.error((Object)"IOException", (Throwable)ioe);
                }
                break;
            }
            default: {
                LOG.warn((Object)("chatnav info: unknown type " + Integer.toHexString(subtype)));
            }
        }
    }

    public void infoUpdate(AIMSession sess, AIMFrame frame, Chat roominfo, String roomName, int userCount, ArrayList occupants, String roomdesc, int flags, int creationTime, int maxmsglen, int maxOccupancy, int creationPerms, int maxvisiblemsglen) {
    }

    public void userlistChange(AIMSession sess, AIMFrame frame, int curcount, ArrayList userinfo) {
        int type = frame.getSNAC().getSubtype();
        if (type == 3) {
            LOG.debug((Object)"user joined room");
        } else if (type == 4) {
            LOG.debug((Object)"user left room");
        }
    }

    public void incomingChatMsg(AIMSession sess, AIMFrame frame, UserInfo userinfo, String msg) {
        LOG.debug((Object)("<" + userinfo.getSN() + "> " + msg + "[[CHAT MSG]]"));
    }

    public void searchReply(AIMSession sess, AIMFrame frame, ArrayList matches) {
        int count = matches.size();
        LOG.debug((Object)("Got searchReply: " + count + " matches"));
        for (int i = 0; i < count; ++i) {
            LOG.debug((Object)("Match " + i + ":\n" + (ODirInfo)matches.get(i)));
        }
    }

    public void interestsReply(AIMSession sess, AIMFrame frame, ArrayList interests) {
        int count = interests.size();
        LOG.debug((Object)("Got interestsReply: " + count + " interests"));
        ODirHandler odir = (ODirHandler)sess.getHandler(15);
        ArrayList<String> myInterests = new ArrayList<String>(1);
        myInterests.add("Computers and Technology");
    }

    public void uploadAck(AIMSession sess, AIMFrame frame, byte[] cksum) {
        LOG.debug((Object)("Got upload ack " + AIMUtil.byteArrayToHexString(cksum)));
    }

    public void parseIcon(AIMSession sess, AIMFrame frame, String sn, byte[] iconcsum, byte[] icon) {
        this.writeIcon(sn, icon);
        this.icons.remove(AIMUtil.normalize(sn));
    }

    public void youveGotMail(AIMSession sess, AIMFrame frame, EmailInfo ei, boolean haveNewMail) {
        LOG.debug((Object)("url=" + ei.getURL() + ", numUnread=" + ei.getNumMsgs() + ", haveMail=" + (haveNewMail ? "yes" : "no") + ", domain=" + ei.getDomain() + ", flag=" + ei.getFlag()));
    }

    public void snacError(AIMSession sess, AIMFrame frame, int error, Object data) {
        LOG.error((Object)("SNAC threw error code=" + error + ", reason=" + AIMUtil.snacErrorToString(error)));
    }

    public void icbmRemoveCookie(AIMSession sess, MsgCookie cookie) {
    }

    public void snacRequestTimedOut(AIMSession sess, SNAC snac) {
        LOG.error((Object)("Request timed out for SNAC request ID=" + Integer.toHexString(snac.getId())));
    }

    public void unhandledFrame(AIMSession sess, AIMFrame frame) {
    }

    public void parseRights(AIMSession sess, AIMFrame frame, short[] maxitems) {
        LOG.debug((Object)"ssi rights: ");
        for (int i = 0; i < maxitems.length; ++i) {
            LOG.debug((Object)("max type 0x" + Integer.toHexString(i) + "=" + maxitems[i]));
        }
        if (maxitems.length >= 0) {
            LOG.debug((Object)("maxbuddies=" + maxitems[0]));
        }
        if (maxitems.length >= 1) {
            LOG.debug((Object)("maxgroups=" + maxitems[1]));
        }
        if (maxitems.length >= 2) {
            LOG.debug((Object)("maxpermits=" + maxitems[2]));
        }
        if (maxitems.length >= 3) {
            LOG.debug((Object)("maxdenies=" + maxitems[3]));
        }
    }

    public void parseData(AIMSession sess, AIMFrame frame, int fmtVer, int numitems, List list, int timestamp) {
        LOG.debug((Object)"ssi: syncing local list and server list");
        try {
            SSIHandler ssi = (SSIHandler)sess.getHandler(19);
            ssi.cleanList(sess);
            BuddyGroup buddyGroup = null;
            if (list != null && !list.isEmpty()) {
                ssi.cleanList(sess);
                this.buddyGroups = new ArrayList(100);
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    SSIItem item = (SSIItem)i.next();
                    if (item.getType() == 0 && item.getName() != null) {
                        buddyGroup.addBuddy(item.getName()).setProperty(Buddy.SESSION, sess);
                        continue;
                    }
                    if (item.getType() != 1 || item.getName() == null || item.getName().length() <= 0) continue;
                    buddyGroup = new BuddyGroup(item.getName());
                    this.buddyGroups.add(buddyGroup);
                }
            }
            String infoString = "Visit the daim website at <a href=\"http://daim.dev.java.net/\">http://daim.dev.java.net/</a>.";
            this.setInfo(sess, "utf-8", infoString);
            ServiceHandler service = (ServiceHandler)sess.getHandler(1);
            service.setAvailableMsg(sess, "I'm using daim! Find out more at http://daim.dev.java.net/>.", null);
            service.setIdle(sess, 0);
            service.setSecureIM(sess);
            if (sess.isICQ()) {
                ICQHandler icq = (ICQHandler)sess.getHandler(21);
                icq.reqOfflineMsgs(sess);
                icq.metaSomething(sess);
                icq.reqXML(sess);
                if (this.buddyGroups != null) {
                    Iterator i = this.buddyGroups.iterator();
                    while (i.hasNext()) {
                        buddyGroup = (BuddyGroup)i.next();
                        Iterator i2 = buddyGroup.iterator();
                        while (i2.hasNext()) {
                            Buddy buddy = (Buddy)i2.next();
                            icq.metaReqBasicInfo(sess, Integer.parseInt(buddy.getName()));
                        }
                    }
                } else {
                    LOG.debug((Object)"No buddylist found!");
                }
            }
            ssi.enable(sess);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void parseAck(AIMSession sess, AIMFrame frame) {
    }

    public void parseDataUnchanged(AIMSession sess, AIMFrame frame) {
        this.parseData(sess, frame, 0, 0, null, 0);
    }

    public void parseAuthReq(AIMSession sess, AIMFrame frame, String sn, String reason) {
    }

    public void receiveAuthGranted(AIMSession sess, AIMFrame frame, String sn, byte reply, String msg) {
        LOG.debug((Object)("User " + sn + " has granted you authorization"));
    }

    public void receiveAdded(AIMSession sess, AIMFrame frame, String sn) {
        LOG.debug((Object)(sn + " has added you to their contact list"));
    }

    public void parseAdd(AIMSession sess, AIMFrame frame) {
    }

    public void parseMod(AIMSession sess, AIMFrame frame) {
    }

    public void parseDel(AIMSession sess, AIMFrame frame) {
    }

    public void receiveAuthGrant(AIMSession sess, AIMFrame frame, String sn, String msg) {
    }

    public void receiveAuthRequest(AIMSession sess, AIMFrame frame, String sn, String msg) {
    }

    public void receiveAuthReply(AIMSession sess, AIMFrame frame, String sn, byte reply, String msg) {
    }

    public void srvOfflineMsgDone(AIMSession sess, AIMFrame frame) {
    }

    public void srvMetaGeneralDone(AIMSession sess, AIMFrame frame) {
    }

    public void srvMetaMoreDone(AIMSession sess, AIMFrame frame) {
    }

    public void srvMetaAboutDone(AIMSession sess, AIMFrame frame) {
    }

    public void srvMetaPassDone(AIMSession sess, AIMFrame frame) {
    }

    public void srvMetaGeneral(AIMSession sess, AIMFrame frame, ICQMetaGeneral img) {
    }

    public void srvMetaWork(AIMSession sess, AIMFrame frame, ICQMetaWork imw) {
    }

    public void srvMetaMore(AIMSession sess, AIMFrame frame, ICQMetaMore imm) {
    }

    public void srvMetaAbout(AIMSession sess, AIMFrame frame, String about) {
    }

    public void srvMetaMoreEmail(AIMSession sess, AIMFrame frame, byte country, byte flags, String email) {
    }

    public void srvMetaInterest(AIMSession sess, AIMFrame frame, byte interestCount, ArrayList interestAreas, ArrayList interestDescriptions) {
    }

    public void srvMetaBackground(AIMSession sess, AIMFrame frame, byte pastCount, ArrayList pastAreas, ArrayList pastDescriptions, byte affiliationCount, ArrayList affiliationAreas, ArrayList affiliationDescriptions) {
    }

    public void srvMetaInfo(AIMSession sess, AIMFrame frame, ICQMetaGeneral img) {
        ICQPacket icqPacket = this.getICQPacket(frame);
        if (icqPacket == null) {
            return;
        }
        byte[] data = icqPacket.getData();
        AIMInputStream buffer = new AIMInputStream(new ByteArrayInputStream(data));
        String uin = "invalid";
        try {
            uin = "" + buffer.readIntLE();
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
        LOG.debug((Object)("Got info for " + uin + "/" + img.getNick() + "/" + img.getFirst() + "/" + img.getLast() + "/" + img.getEmail()));
    }

    public void srvMeta10E(AIMSession sess, AIMFrame frame, int unknown) {
    }

    public void srvMetaFound(AIMSession sess, AIMFrame frame, ICQMetaFound imf) {
    }

    public void srvMetaLast(AIMSession sess, AIMFrame frame, ICQMetaFound imf, int missed) {
    }

    public void srvMetaRandom(AIMSession sess, AIMFrame frame, int uin, short group, byte[] externalIP, int port, byte[] internalIP, byte tcpFlags, short tcpVersion, byte[] unknown) {
    }

    public void srvMetaRandomDone(AIMSession sess, AIMFrame frame) {
    }

    public void srvOfflineMsg(AIMSession sess, AIMFrame frame, ICQOfflineMsg msg) {
        LOG.debug((Object)("Received offline message from " + msg.getSender() + ", type=" + Integer.toHexString(msg.getType()) + ", msg=" + msg.getMsg()));
    }

    public void rateResp(AIMSession sess, AIMFrame frame) {
        try {
            switch (frame.getConn().getType()) {
                case 7: {
                    this.connInitDoneLogin(sess, frame);
                    break;
                }
                case 2: {
                    this.connInitDoneBOS(sess, frame);
                    break;
                }
                case 13: {
                    this.connInitDoneChatNav(sess, frame);
                    break;
                }
                case 14: {
                    this.connInitDoneChat(sess, frame);
                    break;
                }
                case 15: {
                    this.connInitDoneODir(sess, frame);
                    break;
                }
                case 16: {
                    this.connInitDoneIcon(sess, frame);
                    break;
                }
                case 24: {
                    this.connInitDoneMail(sess, frame);
                    break;
                }
                default: {
                    LOG.debug((Object)("Unknown connection type=" + Integer.toHexString(frame.getConn().getType())));
                    break;
                }
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void rateChange(AIMSession sess, AIMFrame frame, int code, RateClass rc) {
        String[] codes = new String[]{"invalid", "change", "warning", "limit", "limit cleared"};
        LOG.debug((Object)("Rate change, code=" + (code < 5 ? codes[code] : codes[0])));
        if (code == 3) {
            LOG.debug((Object)"The last message was not sent because you are exceeding the rate limit. Please try again later.");
        }
    }

    public void serverPause(AIMSession sess, AIMFrame frame) {
        LOG.debug((Object)"Got server pause");
    }

    public void serverResume(AIMSession sess, AIMFrame frame) {
        LOG.debug((Object)"Got server resume");
    }

    public void selfInfo(AIMSession sess, AIMFrame frame, UserInfo userinfo) {
    }

    public void evilNotify(AIMSession sess, AIMFrame frame, int newEvil, UserInfo userinfo) {
        LOG.debug((Object)("evilNotify: Evil now " + newEvil / 10 + ". Eviled by " + userinfo.getSN()));
    }

    public void migrate(AIMSession sess, AIMFrame frame, String ip, byte[] cookie) {
    }

    public void motd(AIMSession sess, AIMFrame frame, int id, String msg) {
    }

    public void memRequest(AIMSession sess, AIMFrame frame, int offset, int len, String modname) {
        LOG.debug((Object)("offset=" + offset + ", length=" + len + ", file=" + (modname != null ? modname : "aim.exe")));
        ServiceHandler service = (ServiceHandler)sess.getHandler(1);
        try {
            if (len == 0) {
                LOG.debug((Object)"len is 0, hashing null");
                service.sendMemBlock(sess, frame.getConn(), offset, len, null, 0);
                return;
            }
            URL url = new URL("http://gaim.sourceforge.net/aim_data.php3?offset=" + offset + "&len=" + len + "&modname=" + modname);
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = br.readLine();
            br.close();
            if (line == null) {
                LOG.warn((Object)"Unable to get a valid hash for logging in");
                return;
            }
            service.sendMemBlock(sess, frame.getConn(), 0, 16, line.getBytes(), 1);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    private void connInitDoneLogin(AIMSession sess, AIMFrame frame) throws IOException {
        AIMConnection tstconn = frame.getConn();
        tstconn.registerListener(7, 1, this);
        tstconn.registerListener(7, 3, this);
        tstconn.registerListener(7, 5, this);
        tstconn.registerListener(7, 7, this);
        ServiceHandler service = (ServiceHandler)sess.getHandler(1);
        service.clientReady(sess, tstconn);
        if (this.changePassword) {
            this.changePassword(sess, this.oldPassword, this.newPassword);
        } else if (this.formatScreenname) {
            this.formatScreenname(sess, this.nick);
        } else if (this.confirmAccount) {
            this.confirmAccount(sess);
        } else if (this.getEmail) {
            this.getEmail(sess);
        } else if (this.setEmail) {
            this.changeEmail(sess, this.email);
        }
    }

    private void connInitDoneBOS(AIMSession sess, AIMFrame frame) throws IOException {
        AIMConnection tstconn = frame.getConn();
        this.rct = new RateClearTask(tstconn);
        sess.getTimer().schedule((TimerTask)this.rct, 60000L, 60000L);
        ServiceHandler service = (ServiceHandler)sess.getHandler(1);
        service.reqPersonalInfo(sess, tstconn);
        SSIHandler ssi = (SSIHandler)sess.getHandler(19);
        ssi.reqRights(sess);
        ssi.reqData(sess);
        LocateHandler loc = (LocateHandler)sess.getHandler(2);
        loc.reqLocateRights(sess, tstconn);
        BuddyListHandler buddy = (BuddyListHandler)sess.getHandler(3);
        buddy.reqBuddyRights(sess, tstconn);
        ICBMHandler im = (ICBMHandler)sess.getHandler(4);
        im.reqICBMParams(sess);
        BOSHandler bos = (BOSHandler)sess.getHandler(9);
        bos.reqRights(sess, tstconn);
        if (!sess.isICQ()) {
            bos.setGroupPerm(sess, frame.getConn(), 31);
            service.setPrivacyFlags(sess, frame.getConn(), 3);
            StocksHandler sh = new StocksHandler();
            this.stocks = sh.getStocks("AOL,MSFT");
            NewsHandler nh = new NewsHandler();
            this.news = nh.getNews();
        }
    }

    private void connInitDoneChatNav(AIMSession sess, AIMFrame frame) throws IOException {
        AIMConnection tstconn = frame.getConn();
        tstconn.registerListener(13, 1, this);
        tstconn.registerListener(13, 9, this);
        ServiceHandler service = (ServiceHandler)sess.getHandler(1);
        service.clientReady(sess, tstconn);
        ChatNavHandler chatNav = (ChatNavHandler)sess.getHandler(13);
        chatNav.reqRights(sess, tstconn);
    }

    private void connInitDoneChat(AIMSession sess, AIMFrame frame) throws IOException {
        AIMConnection tstconn = frame.getConn();
        tstconn.registerListener(14, 1, this);
        tstconn.registerListener(14, 3, this);
        tstconn.registerListener(14, 4, this);
        tstconn.registerListener(14, 2, this);
        tstconn.registerListener(14, 6, this);
        ServiceHandler service = (ServiceHandler)sess.getHandler(1);
        service.clientReady(sess, tstconn);
    }

    private void connInitDoneMail(AIMSession sess, AIMFrame frame) throws IOException {
        AIMConnection tstconn = frame.getConn();
        tstconn.registerListener(24, 1, this);
        tstconn.registerListener(24, 7, this);
        ServiceHandler service = (ServiceHandler)sess.getHandler(1);
        service.clientReady(sess, tstconn);
        this.checkMail(sess);
    }

    private void connInitDoneODir(AIMSession sess, AIMFrame frame) throws IOException {
        AIMConnection tstconn = frame.getConn();
        tstconn.registerListener(15, 1, this);
        tstconn.registerListener(15, 3, this);
        tstconn.registerListener(15, 5, this);
        ServiceHandler service = (ServiceHandler)sess.getHandler(1);
        service.clientReady(sess, tstconn);
    }

    private void getIcons(AIMSession sess) {
        AIMConnection conn = AIMConnection.findByGroup(sess, 16);
        if (conn == null) {
            LOG.debug((Object)"[10] Can't request icons now, since no conn available");
            return;
        }
        IconHandler icon = (IconHandler)sess.getHandler(16);
        LOG.debug((Object)"[10] Icon connection done!");
        Iterator i = this.icons.keySet().iterator();
        while (i.hasNext()) {
            String sn = (String)i.next();
            byte[] cookie = (byte[])this.icons.get(sn);
            i.remove();
            if (cookie == null || sn == null) {
                LOG.warn((Object)("icon request error: sn=" + sn + ", cookie=" + AIMUtil.byteArrayToHexString(cookie)));
                break;
            }
            try {
                LOG.debug((Object)("[10] Requesting icon for " + sn + "..."));
                icon.request(sess, sn, cookie);
            }
            catch (IOException ioe) {
                LOG.error((Object)"IOException", (Throwable)ioe);
            }
        }
    }

    private void connInitDoneIcon(AIMSession sess, AIMFrame frame) throws IOException {
        AIMConnection tstconn = frame.getConn();
        tstconn.registerListener(16, 1, this);
        tstconn.registerListener(16, 3, this);
        tstconn.registerListener(16, 5, this);
        ServiceHandler service = (ServiceHandler)sess.getHandler(1);
        service.clientReady(sess, tstconn);
    }

    public void redirect(AIMSession sess, AIMFrame frame, Redir redir) {
        AIMConnection tstconn = null;
        try {
            AIMConnection exist = AIMConnection.findByType(sess, redir.getGroup());
            if (exist != null) {
                exist.close();
            }
            String dest = redir.getIp();
            LoginHandler login = null;
            switch (redir.getGroup()) {
                case 7: {
                    tstconn = new AIMConnection(sess, 7, dest);
                    tstconn.registerListener(1, 7, this);
                    tstconn.registerListener(1, 5, this);
                    tstconn.registerListener(1, 10, this);
                    tstconn.registerListener(1, 16, this);
                    tstconn.registerListener(1, 1, this);
                    tstconn.registerListener(1, 19, this);
                    tstconn.registerListener(1, 31, this);
                    tstconn.registerListener(1, 15, this);
                    tstconn.registerListener(1, 2, this);
                    tstconn.connect();
                    login = (LoginHandler)sess.getHandler(23);
                    login.sendCookie(sess, tstconn, redir.getCookie());
                    break;
                }
                case 13: {
                    tstconn = new AIMConnection(sess, 13, dest);
                    tstconn.registerListener(1, 7, this);
                    tstconn.registerListener(1, 5, this);
                    tstconn.registerListener(1, 10, this);
                    tstconn.registerListener(1, 16, this);
                    tstconn.registerListener(1, 1, this);
                    tstconn.registerListener(1, 19, this);
                    tstconn.registerListener(1, 31, this);
                    tstconn.registerListener(1, 15, this);
                    tstconn.registerListener(1, 2, this);
                    tstconn.connect();
                    login = (LoginHandler)sess.getHandler(23);
                    login.sendCookie(sess, tstconn, redir.getCookie());
                    break;
                }
                case 14: {
                    tstconn = new AIMConnection(sess, 14, dest);
                    tstconn.registerListener(1, 7, this);
                    tstconn.registerListener(1, 5, this);
                    tstconn.registerListener(1, 10, this);
                    tstconn.registerListener(1, 16, this);
                    tstconn.registerListener(1, 1, this);
                    tstconn.registerListener(1, 19, this);
                    tstconn.registerListener(1, 31, this);
                    tstconn.registerListener(1, 15, this);
                    tstconn.registerListener(1, 2, this);
                    tstconn.connect();
                    login = (LoginHandler)sess.getHandler(23);
                    login.sendCookie(sess, tstconn, redir.getCookie());
                    break;
                }
                case 15: {
                    tstconn = new AIMConnection(sess, 15, dest);
                    tstconn.registerListener(1, 7, this);
                    tstconn.registerListener(1, 5, this);
                    tstconn.registerListener(1, 10, this);
                    tstconn.registerListener(1, 16, this);
                    tstconn.registerListener(1, 1, this);
                    tstconn.registerListener(1, 19, this);
                    tstconn.registerListener(1, 31, this);
                    tstconn.registerListener(1, 15, this);
                    tstconn.registerListener(1, 2, this);
                    tstconn.connect();
                    login = (LoginHandler)sess.getHandler(23);
                    login.sendCookie(sess, tstconn, redir.getCookie());
                    break;
                }
                case 16: {
                    tstconn = new AIMConnection(sess, 16, dest);
                    tstconn.registerListener(1, 7, this);
                    tstconn.registerListener(1, 5, this);
                    tstconn.registerListener(1, 10, this);
                    tstconn.registerListener(1, 16, this);
                    tstconn.registerListener(1, 1, this);
                    tstconn.registerListener(1, 19, this);
                    tstconn.registerListener(1, 31, this);
                    tstconn.registerListener(1, 15, this);
                    tstconn.registerListener(1, 2, this);
                    tstconn.connect();
                    login = (LoginHandler)sess.getHandler(23);
                    login.sendCookie(sess, tstconn, redir.getCookie());
                    break;
                }
                case 24: {
                    tstconn = new AIMConnection(sess, 24, dest);
                    tstconn.registerListener(1, 7, this);
                    tstconn.registerListener(1, 5, this);
                    tstconn.registerListener(1, 10, this);
                    tstconn.registerListener(1, 16, this);
                    tstconn.registerListener(1, 1, this);
                    tstconn.registerListener(1, 19, this);
                    tstconn.registerListener(1, 31, this);
                    tstconn.registerListener(1, 15, this);
                    tstconn.registerListener(1, 2, this);
                    tstconn.connect();
                    login = (LoginHandler)sess.getHandler(23);
                    login.sendCookie(sess, tstconn, redir.getCookie());
                    break;
                }
                default: {
                    LOG.warn((Object)("redirect: unhandled group=" + redir.getGroup()));
                    break;
                }
            }
        }
        catch (IOException ioe) {
            tstconn.close();
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }
}

