/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.client.Buddy;
import org.walluck.oscar.client.Oscar;
import org.walluck.oscar.components.IMWindowListener;
import org.walluck.oscar.components.IconManager;
import org.walluck.oscar.components.Main;
import org.walluck.oscar.components.SessionManager;
import org.walluck.oscar.components.SmallToggleButton;

final class IMWindow
extends JFrame
implements WindowListener {
    final String default_output = "<html>\n  <body>\n    <table width='100%' cellpadding='0' cellspacing='2'>\n      <tr><td width=\"1\"></td><td></td>\n    </table>\n  </body>\n</html>\n";
    final String default_input = "<html>\n  <body>\n  </body>\n</html>\n";
    private IconManager iconmgr = IconManager.getInstance();
    private Buddy buddy;
    private static HashMap imWindows = new HashMap();
    private JEditorPane incoming;
    private JScrollPane scroll;
    private JEditorPane outgoing;
    private JScrollPane outscroll;
    private HTMLEditorKit outeditor;
    private HTMLDocument outdoc;
    private JPanel inputpanel;
    private SpringLayout inputsl;
    private JToolBar editbar;
    private SmallToggleButton bold;
    private SmallToggleButton italic;
    private SmallToggleButton underline;
    private JButton send;
    private JSplitPane split;
    private JRootPane myroot;
    protected boolean m_skipUpdate;
    protected int m_xStart = -1;
    protected int m_xFinish = -1;
    private JTabbedPane tabs = new JTabbedPane(3, 1);
    private JMenu sendAs;
    private SendIMAction sendimaction = new SendIMAction("Send", "Send instant message", new Integer(83));
    private static final String EAST = "East";
    private static final String WEST = "West";
    private static final String NORTH = "North";
    private static final String SOUTH = "South";

    private IMWindow(Buddy buddy) {
        this.buddy = buddy;
        this.setTitle(this.buddy.getName() + " - Instant Message");
        this.buildUI();
        this.pack();
        this.addWindowListener(this);
        this.setVisible(true);
    }

    public void appendIM(AIMSession sess, String from, String message, boolean isAutoResponse) {
        message = AIMUtil.convertOSCARToHTML(message);
        if (isAutoResponse) {
            from = from + " &lt;AUTO-REPLY&gt;";
        }
        from = from.equals(sess.getSN()) ? "<B><FONT COLOR=\"blue\">" + from + ": " + "</FONT></B>" : "<B><FONT COLOR=\"red\">" + from + ": " + "</FONT></B>";
        from.replaceAll(" ", "&nbsp;");
        StringBuffer sb = new StringBuffer();
        sb.append("<tr><td valign=\"top\">");
        sb.append("(");
        sb.append(new SimpleDateFormat("HH:mm:ss").format(new Date()));
        sb.append(")&nbsp;");
        sb.append("</td><td valign=\"top\">");
        sb.append(from);
        sb.append(message);
        sb.append("</td></tr>\n");
        boolean scrollEnd = false;
        JScrollBar vertbar = this.scroll.getVerticalScrollBar();
        if (vertbar != null) {
            scrollEnd = vertbar.getValue() + vertbar.getVisibleAmount() >= vertbar.getMaximum();
            System.out.println("val: " + vertbar.getValue() + " vis: " + vertbar.getVisibleAmount() + " max: " + vertbar.getMaximum() + " scroll: " + scrollEnd);
        }
        try {
            HTMLDocument doc = (HTMLDocument)this.incoming.getDocument();
            Element table = this.findElement(doc, "table");
            doc.insertAfterEnd(table.getElement(table.getElementCount() - 1), sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!vertbar.getValueIsAdjusting() && scrollEnd) {
            vertbar.setValue(vertbar.getMaximum());
        }
    }

    private Element findElement(Element elm, String name) {
        for (int i = 0; i < elm.getElementCount(); ++i) {
            Element e = elm.getElement(i);
            if (name.equals(e.getName())) {
                return e;
            }
            if ((e = this.findElement(e, name)) == null) continue;
            return e;
        }
        return null;
    }

    private Element findElement(Document doc, String name) {
        return this.findElement(doc.getDefaultRootElement(), name);
    }

    private void initActions() {
    }

    private void buildUI() {
        this.initActions();
        this.incoming = new JEditorPane("text/html", "<html>\n  <body>\n    <table width='100%' cellpadding='0' cellspacing='2'>\n      <tr><td width=\"1\"></td><td></td>\n    </table>\n  </body>\n</html>\n");
        this.incoming.setEditable(false);
        this.incoming.setPreferredSize(new Dimension(300, 200));
        this.scroll = new JScrollPane(this.incoming);
        this.scroll.setVerticalScrollBarPolicy(22);
        this.outgoing = new JEditorPane("text/html", "<html>\n  <body>\n  </body>\n</html>\n");
        this.outgoing.setPreferredSize(new Dimension(300, 40));
        this.outeditor = (HTMLEditorKit)this.outgoing.getEditorKit();
        this.outdoc = (HTMLDocument)this.outgoing.getDocument();
        CaretListener clst = new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                IMWindow.this.showAttributes(e.getDot());
            }
        };
        this.outgoing.addCaretListener(clst);
        FocusListener flst = new FocusListener(){

            public void focusGained(FocusEvent e) {
                int len = IMWindow.this.outgoing.getDocument().getLength();
                if (IMWindow.this.m_xStart >= 0 && IMWindow.this.m_xFinish >= 0 && IMWindow.this.m_xStart < len && IMWindow.this.m_xFinish < len) {
                    if (IMWindow.this.outgoing.getCaretPosition() == IMWindow.this.m_xStart) {
                        IMWindow.this.outgoing.setCaretPosition(IMWindow.this.m_xFinish);
                        IMWindow.this.outgoing.moveCaretPosition(IMWindow.this.m_xStart);
                    } else {
                        IMWindow.this.outgoing.select(IMWindow.this.m_xStart, IMWindow.this.m_xFinish);
                    }
                }
            }

            public void focusLost(FocusEvent e) {
                IMWindow.this.m_xStart = IMWindow.this.outgoing.getSelectionStart();
                IMWindow.this.m_xFinish = IMWindow.this.outgoing.getSelectionEnd();
            }
        };
        this.outgoing.addFocusListener(flst);
        this.outgoing.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    if (!(ke.isShiftDown() || ke.isControlDown() || ke.isAltDown() || ke.isMetaDown())) {
                        ke.consume();
                        IMWindow.this.send.doClick();
                    } else {
                        Element cursor = IMWindow.this.outdoc.getCharacterElement(IMWindow.this.outgoing.getSelectionStart());
                        try {
                            IMWindow.this.outdoc.insertAfterEnd(cursor, "<br>");
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        this.outscroll = new JScrollPane(this.outgoing, 20, 31);
        this.editbar = new JToolBar();
        this.editbar.setRollover(true);
        this.editbar.setFloatable(false);
        this.editbar.setBorderPainted(false);
        this.bold = new SmallToggleButton(false, this.iconmgr.getIcon("toolbar/text/Bold16"), this.iconmgr.getIcon("toolbar/text/Bold16"), "Toggle bold");
        this.bold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setBold(attr, IMWindow.this.bold.isSelected());
                IMWindow.this.setAttributeSet(attr);
                IMWindow.this.outgoing.grabFocus();
            }
        });
        this.editbar.add(this.bold);
        this.italic = new SmallToggleButton(false, this.iconmgr.getIcon("toolbar/text/Italic16"), this.iconmgr.getIcon("toolbar/text/Italic16"), "Toggle italic");
        this.italic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setItalic(attr, IMWindow.this.italic.isSelected());
                IMWindow.this.setAttributeSet(attr);
                IMWindow.this.outgoing.grabFocus();
            }
        });
        this.editbar.add(this.italic);
        this.underline = new SmallToggleButton(false, this.iconmgr.getIcon("toolbar/text/Underline16"), this.iconmgr.getIcon("toolbar/text/Underline16"), "Toggle underline");
        this.underline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setUnderline(attr, IMWindow.this.underline.isSelected());
                IMWindow.this.setAttributeSet(attr);
                IMWindow.this.outgoing.grabFocus();
            }
        });
        this.editbar.add(this.underline);
        this.send = new JButton(this.sendimaction);
        this.inputsl = new SpringLayout();
        this.inputpanel = new JPanel(this.inputsl);
        this.inputpanel.add(this.editbar);
        this.inputpanel.add(this.outscroll);
        this.inputpanel.add(this.send);
        this.inputpanel.setBorder(BorderFactory.createEmptyBorder());
        SpringLayout.Constraints editcons = this.inputsl.getConstraints(this.editbar);
        SpringLayout.Constraints outcons = this.inputsl.getConstraints(this.outscroll);
        SpringLayout.Constraints sendcons = this.inputsl.getConstraints(this.send);
        editcons.setX(Spring.constant(0));
        editcons.setY(Spring.constant(0));
        editcons.setWidth(outcons.getWidth());
        outcons.setX(Spring.constant(0));
        outcons.setY(editcons.getConstraint(SOUTH));
        sendcons.setY(Spring.sum(outcons.getConstraint(SOUTH), Spring.constant(3)));
        sendcons.setX(Spring.sum(outcons.getWidth(), Spring.minus(sendcons.getWidth())));
        sendcons.setWidth(Spring.constant(sendcons.getWidth().getPreferredValue(), sendcons.getWidth().getPreferredValue(), sendcons.getWidth().getMaximumValue()));
        this.inputsl.putConstraint(EAST, (Component)this.inputpanel, 0, EAST, (Component)this.outscroll);
        this.inputsl.putConstraint(SOUTH, (Component)this.inputpanel, 0, SOUTH, (Component)this.send);
        this.split = new JSplitPane(0, true, this.scroll, this.inputpanel);
        this.split.setResizeWeight(1.0);
        this.split.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.myroot = new JRootPane();
        this.myroot.getContentPane().add((Component)this.split, "Center");
        this.tabs.addTab(this.buddy.getName(), this.iconmgr.getIcon("buddy_online"), this.myroot);
        this.getContentPane().add((Component)this.tabs, "Center");
        this.buildMenu();
    }

    private void buildMenu() {
        JMenuBar mbar = new JMenuBar();
        this.myroot.setJMenuBar(mbar);
        JMenu conversation = new JMenu("Conversation");
        conversation.setMnemonic(67);
        mbar.add(conversation);
        JMenuItem item = new JMenuItem(this.sendimaction);
        conversation.add(item);
        this.buildSendAsMenu();
    }

    private void buildSendAsMenu() {
        AIMSession[] session = SessionManager.getSessions();
        if (session.length != 1) {
            this.sendAs = new JMenu("Send As");
            ButtonGroup g = new ButtonGroup();
            this.myroot.getJMenuBar().add(this.sendAs);
            for (int i = 0; i < session.length; ++i) {
                JRadioButtonMenuItem item = new JRadioButtonMenuItem(session[i].getSN());
                item.putClientProperty("aim_session", session[i]);
                this.sendAs.add(item);
                g.add(item);
                if (i != 0) continue;
                item.setSelected(true);
            }
        }
    }

    public static IMWindow createIMWindow(AIMSession sess, Buddy buddy) {
        String sn = AIMUtil.normalize(buddy.getName());
        IMWindow w = (IMWindow)imWindows.get(sn);
        if (w == null) {
            w = new IMWindow(buddy);
            imWindows.put(sn, w);
        } else {
            w.toFront();
        }
        Iterator i = sess.getListeners(253, 1);
        while (i.hasNext()) {
            ((IMWindowListener)((Object)i)).newConvo(sess, sn);
        }
        return w;
    }

    public static Exception sendIM(AIMSession session, String sn, String msg) {
        if (msg.length() == 0) {
            return new IllegalArgumentException("Cannot send a message of 0 length");
        }
        int flag = session.isICQ() ? Oscar.getICQCaps() : Main.OSCAR.getAIMCaps();
        try {
            Buddy b = Main.OSCAR.findBuddy(sn);
            Main.OSCAR.sendIM(session, sn, msg, flag);
        }
        catch (IOException e) {
            return e;
        }
        return null;
    }

    public void windowActivated(WindowEvent evt) {
    }

    public void windowClosed(WindowEvent evt) {
    }

    public void windowClosing(WindowEvent evt) {
        imWindows.remove(AIMUtil.normalize(this.buddy.getName()));
    }

    public void windowDeactivated(WindowEvent evt) {
    }

    public void windowDeiconified(WindowEvent evt) {
    }

    public void windowIconified(WindowEvent evt) {
    }

    public void windowOpened(WindowEvent evt) {
    }

    protected void showAttributes(int p) {
        this.m_skipUpdate = true;
        MutableAttributeSet attr = this.outeditor.getInputAttributes();
        boolean b = StyleConstants.isBold(attr);
        if (b != this.bold.isSelected()) {
            this.bold.setSelected(b);
        }
        if ((b = StyleConstants.isItalic(attr)) != this.italic.isSelected()) {
            this.italic.setSelected(b);
        }
        if ((b = StyleConstants.isUnderline(attr)) != this.underline.isSelected()) {
            this.underline.setSelected(b);
        }
        this.m_skipUpdate = false;
    }

    protected void setAttributeSet(AttributeSet attr) {
        if (this.m_skipUpdate) {
            return;
        }
        int xStart = this.outgoing.getSelectionStart();
        int xFinish = this.outgoing.getSelectionEnd();
        if (!this.outgoing.hasFocus()) {
            xStart = this.m_xStart;
            xFinish = this.m_xFinish;
        }
        if (xStart != xFinish) {
            this.outdoc.setCharacterAttributes(xStart, xFinish - xStart, attr, false);
        } else {
            MutableAttributeSet inputAttributes = this.outeditor.getInputAttributes();
            inputAttributes.addAttributes(attr);
        }
    }

    static /* synthetic */ Buddy access$800(IMWindow x0) {
        return x0.buddy;
    }

    static /* synthetic */ HTMLDocument access$202(IMWindow x0, HTMLDocument x1) {
        x0.outdoc = x1;
        return x0.outdoc;
    }

    private class SendIMAction
    extends AbstractAction {
        public SendIMAction(String text, String desc, Integer mnemonic) {
            super(text);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            AIMSession session = null;
            if (IMWindow.this.sendAs != null) {
                for (int i = IMWindow.this.sendAs.getItemCount() - 1; i >= 0; --i) {
                    JMenuItem menu = IMWindow.this.sendAs.getItem(i);
                    if (!((JRadioButtonMenuItem)menu).isSelected()) continue;
                    session = (AIMSession)menu.getClientProperty("aim_session");
                    break;
                }
            } else {
                session = SessionManager.getSessions()[0];
            }
            AIMSession sess = session;
            SwingUtilities.invokeLater(new Runnable(this, sess){
                private final /* synthetic */ AIMSession val$sess;
                private final /* synthetic */ SendIMAction this$1;
                {
                    this.this$1 = this$1;
                    this.val$sess = val$sess;
                }

                public void run() {
                    String msg = IMWindow.access$000(SendIMAction.access$700(this.this$1)).getText();
                    msg = msg.substring(msg.indexOf("<body>") + 6);
                    msg = msg.substring(0, msg.indexOf("</body>"));
                    if ((msg = msg.trim()).length() != 0) {
                        Exception e = IMWindow.sendIM(this.val$sess, IMWindow.access$800(SendIMAction.access$700(this.this$1)).getName(), msg);
                        if (e != null) {
                            e.printStackTrace();
                        } else {
                            SendIMAction.access$700(this.this$1).appendIM(this.val$sess, this.val$sess.getSN(), msg, false);
                        }
                        IMWindow.access$000(SendIMAction.access$700(this.this$1)).setText("<html>\n  <body>\n  </body>\n</html>\n");
                        IMWindow.access$202(SendIMAction.access$700(this.this$1), (HTMLDocument)IMWindow.access$000(SendIMAction.access$700(this.this$1)).getDocument());
                        IMWindow.access$000(SendIMAction.access$700(this.this$1)).grabFocus();
                    }
                }
            });
        }

        static /* synthetic */ IMWindow access$700(SendIMAction x0) {
            return x0.IMWindow.this;
        }
    }
}

