/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.components;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.client.Oscar;
import org.walluck.oscar.components.Protocol;
import org.walluck.oscar.components.SessionManager;

final class Main
extends JFrame
implements ActionListener,
WindowListener {
    public static final Main LOGINWINDOW = new Main();
    public static final Oscar OSCAR = new Oscar();
    private JTextField password = new JPasswordField();
    private JTextField username = new JTextField();
    private Protocol proto = new Protocol();

    private Main() {
        super("Daim - Login");
        this.addWindowListener(this);
        this.buildUI();
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.username || evt.getSource() == this.password || evt.getActionCommand().equals("Login")) {
            final String sn = this.username.getText();
            if (sn.length() <= 0) {
                JOptionPane.showMessageDialog(this, "You need to enter a screenname", "Cannot login", 0);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            AIMSession s = SessionManager.connectWithNewSession(OSCAR, sn, Main.this.password.getText());
                            AIMConnection conn = AIMConnection.findByType(s, 7);
                            conn.registerListener(23, 3, Main.this.proto);
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(Main.this, e.getMessage(), "Error", 0);
                            e.printStackTrace();
                            Main.this.setVisible(true);
                        }
                    }
                });
                this.setVisible(false);
            }
        } else if (evt.getActionCommand().equals("Quit")) {
            Main.exit();
        }
    }

    private void buildButtons(Container comp, GridBagLayout bag, GridBagConstraints c) {
        JPanel panel = new JPanel(new FlowLayout(1));
        JButton button = new JButton("Login");
        panel.add(button);
        button.addActionListener(this);
        button = new JButton("Quit");
        panel.add(button);
        button.addActionListener(this);
        c.gridwidth = 0;
        bag.setConstraints(panel, c);
        comp.add(panel);
    }

    private void buildPW(Container comp, GridBagLayout bag, GridBagConstraints c) {
        JLabel label = new JLabel("Password: ");
        bag.setConstraints(label, c);
        comp.add(label);
        c.gridx = 1;
        c.gridwidth = 0;
        bag.setConstraints(this.password, c);
        comp.add(this.password);
        this.password.addActionListener(this);
    }

    private void buildSN(Container comp, GridBagLayout bag, GridBagConstraints c) {
        JLabel label = new JLabel("Screenname: ");
        bag.setConstraints(label, c);
        comp.add(label);
        c.gridx = 1;
        c.gridwidth = 0;
        bag.setConstraints(this.username, c);
        comp.add(this.username);
        this.username.addActionListener(this);
    }

    private void buildUI() {
        GridBagLayout bag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.getContentPane().setLayout(bag);
        c.fill = 1;
        c.gridy = 0;
        c.gridx = 0;
        this.buildSN(this.getContentPane(), bag, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.buildPW(this.getContentPane(), bag, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.buildButtons(this.getContentPane(), bag, c);
    }

    public static void exit() {
        AIMSession[] sessions = SessionManager.getSessions();
        for (int i = 0; i < sessions.length; ++i) {
            AIMConnection.killAllInSess(sessions[i]);
        }
        System.exit(0);
    }

    public static void main(String[] args) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent evt) {
        Main.exit();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

