/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFingerPrintInfo;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.FLAP;
import org.walluck.oscar.ICBMParams;
import org.walluck.oscar.IncomingIMCH2;
import org.walluck.oscar.MsgCookie;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.TLV;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.channel.aolim.AOLIM;
import org.walluck.oscar.channel.aolim.MPMsg;
import org.walluck.oscar.channel.aolim.MPMsgSection;
import org.walluck.oscar.channel.rendezvous.Rendezvous;
import org.walluck.oscar.handlers.ICBMListener;
import org.walluck.oscar.handlers.MiscHandler;
import org.walluck.oscar.handlers.SNACHandler;
import org.walluck.oscar.handlers.icq.IncomingIMCH4;

public class ICBMHandler
extends SNACHandler {
    private static final Logger LOG = Logger.getLogger((String)ICBMHandler.class.getName());

    public ICBMHandler() {
        this.setFamily(4);
        this.setVersion(1);
    }

    public int fingerprintClient(byte[] msghdr) {
        return AIMFingerPrintInfo.getFingerPrintId(msghdr);
    }

    public void setICBMParams(AIMSession sess, ICBMParams params) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 4)) == null) {
            throw new NullPointerException();
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(4, 2, 0, null, false);
        AIMOutputStream buffer = new AIMOutputStream(16);
        buffer.writeShort(0);
        buffer.writeInt(params.getFlags());
        buffer.writeShort(params.getMaxMsgLen());
        buffer.writeShort(params.getMaxSenderWarn());
        buffer.writeShort(params.getMaxReceiverWarn());
        buffer.writeInt(params.getMinMsgInterval());
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    public void reqICBMParams(AIMSession sess) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 4)) == null) {
            throw new NullPointerException();
        }
        MiscHandler misc = (MiscHandler)sess.getHandler(65535);
        misc.genericReqNull(sess, conn, 4, 4);
    }

    private void paramInfo(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        ICBMParams params = new ICBMParams();
        params.setMaxChan(buffer.readShort());
        params.setFlags(buffer.readInt());
        params.setMaxMsgLen(buffer.readShort());
        params.setMaxSenderWarn(buffer.readShort());
        params.setMaxReceiverWarn(buffer.readShort());
        params.setMinMsgInterval(buffer.readInt());
        Iterator i = frame.getConn().getListeners(4, 5);
        while (i.hasNext()) {
            ((ICBMListener)i.next()).paramInfo(sess, frame, params);
        }
    }

    public void sendCH1Ext(AIMSession sess, AOLIM args) throws IOException {
        AIMOutputStream tmpbuffer;
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 4)) == null) {
            throw new NullPointerException();
        }
        if (args == null) {
            throw new NullPointerException();
        }
        if ((args.getFlags() & 0x400) != 0) {
            if (args.getMPMsg().size() < 0) {
                throw new IllegalArgumentException();
            }
            if (args.getMsg() == null || args.getMsgLen() <= 0) {
                throw new NullPointerException();
            }
            if (args.getMsgLen() > 7987) {
                throw new IllegalArgumentException();
            }
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(4, 6, 0, args.getDestSN(), false);
        AIMOutputStream buffer = new AIMOutputStream();
        MsgCookie cookie = new MsgCookie(conn, null, 1, null);
        buffer.writeICBM(cookie.getCookie(), (short)1, args.getDestSN());
        AIMOutputStream buffer2 = new AIMOutputStream();
        TLVChain tlvchain2 = new TLVChain(7);
        if ((args.getFlags() & 0x80) != 0 && args.getFeatures() != null) {
            tlvchain2.addBytes(1281, args.getFeatures());
        } else if (sess.isICQ()) {
            tlvchain2.addBytes(1281, AIMFingerPrintInfo.getFingerPrintData(5));
        } else if (sess.isIChat()) {
            tlvchain2.addBytes(1281, AIMFingerPrintInfo.getFingerPrintData(4));
        } else {
            tlvchain2.addBytes(1281, AIMFingerPrintInfo.getFingerPrintData(2));
        }
        if ((args.getFlags() & 0x400) != 0) {
            tmpbuffer = new AIMOutputStream();
            Iterator i = args.getMPMsg().iterator();
            while (i.hasNext()) {
                MPMsgSection sec = (MPMsgSection)i.next();
                tmpbuffer.writeShort(sec.getCharset());
                tmpbuffer.writeShort(sec.getCharSubset());
                tmpbuffer.writeString(sec.getData());
            }
            tlvchain2.addBytes(257, tmpbuffer.getBytes());
        } else {
            tmpbuffer = new AIMOutputStream(args.getMsgLen() + 4);
            if ((args.getFlags() & 0x200) != 0) {
                tmpbuffer.writeShort(args.getCharset());
                tmpbuffer.writeShort(args.getCharSubset());
            } else {
                if ((args.getFlags() & 4) != 0) {
                    tmpbuffer.writeShort(2);
                } else if ((args.getFlags() & 8) != 0) {
                    tmpbuffer.writeShort(3);
                } else {
                    tmpbuffer.writeShort(0);
                }
                tmpbuffer.writeShort(0);
            }
            tmpbuffer.writeString(args.getMsg());
            tlvchain2.addBytes(257, tmpbuffer.getBytes());
        }
        if ((args.getFlags() & 2) != 0) {
            tlvchain2.addNull(3);
            snac.setWantResponse(true);
        }
        if ((args.getFlags() & 1) != 0) {
            tlvchain2.addNull(4);
        }
        if ((args.getFlags() & 0x800) != 0) {
            tlvchain2.addNull(6);
        }
        if ((args.getFlags() & 0x20) != 0) {
            tmpbuffer = new AIMOutputStream(12);
            tmpbuffer.writeInt(args.getIconLen());
            tmpbuffer.writeShort(1);
            tmpbuffer.writeShort(args.getIconSum());
            tmpbuffer.writeInt((int)args.getIconStamp());
            tlvchain2.addBytes(8, tmpbuffer.getBytes());
        }
        if ((args.getFlags() & 0x10) != 0) {
            tlvchain2.addNull(9);
        }
        if ((sess.getFlags() & 8) != 0) {
            snac.setWantResponse(false);
        } else {
            snac.setWantResponse(false);
        }
        TLVChain tlvchain = new TLVChain(1);
        buffer2.writeTLVChain(tlvchain2);
        tlvchain.addBytes(2, buffer2.getBytes());
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    public void sendCH1(AIMSession sess, String destSN, int flags, String msg) throws IOException {
        AOLIM args = new AOLIM();
        args.setDestSN(destSN);
        args.setFlags(flags &= 0xFFFFFB5F);
        args.setMsg(msg);
        args.setMsgLen(msg.length());
        this.sendCH1Ext(sess, args);
    }

    public void sendRendezvous(AIMSession sess, String sn, Rendezvous rv) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 4)) == null) {
            throw new NullPointerException();
        }
        if (sn == null) {
            throw new NullPointerException();
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(4, 6, 0, null, false);
        AIMOutputStream buffer = new AIMOutputStream(11 + sn.length());
        byte[] ck = rv.getCookie();
        MsgCookie cookie = new MsgCookie(conn, ck, 1, null);
        buffer.writeICBM(cookie.getCookie(), (short)2, sn);
        rv.setCookie(cookie.getCookie());
        TLVChain sd = rv.getServiceData();
        int sdlen = sd != null ? sd.length() : 0;
        AIMOutputStream rvbuffer = new AIMOutputStream(26 + sdlen);
        rvbuffer.writeRendezvous(rv);
        TLVChain tlvchain = new TLVChain(1);
        tlvchain.addBytes(5, rvbuffer.getBytes());
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    public void sendCH4(AIMSession sess, String sn, int type, String message) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 4)) == null) {
            throw new NullPointerException();
        }
        if (sn == null || message == null) {
            throw new NullPointerException();
        }
        if (type == 0) {
            throw new IllegalArgumentException();
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(4, 6, 0, null, false);
        AIMOutputStream buffer = new AIMOutputStream();
        MsgCookie cookie = new MsgCookie(conn, null, 1, null);
        buffer.writeICBM(cookie.getCookie(), (short)4, sn);
        AIMOutputStream buffer2 = new AIMOutputStream();
        buffer2.writeIntLE(Integer.parseInt(sess.getSN()));
        TLVChain tlvchain2 = new TLVChain(2);
        AIMOutputStream buffer3 = new AIMOutputStream(message.length() + 1);
        buffer3.writeString0(message);
        tlvchain2.addBytes(type, buffer3.getBytes());
        tlvchain2.addNull(6);
        TLVChain tlvchain = new TLVChain(1);
        buffer2.writeTLVChain(tlvchain2);
        tlvchain.addBytes(5, buffer2.getBytes());
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void outgoingIM(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 4)) == null) {
            throw new NullPointerException();
        }
        byte[] cookie = buffer.readBytes(8);
        short channel = buffer.readShort();
        if (channel != 1) {
            LOG.warn((Object)("ICBM recieved on unsupported channel, chan=" + Integer.toHexString(channel)));
            return;
        }
        String sn = buffer.readStringL();
        TLVChain tlvchain = buffer.readTLVChain();
        int flags = 0;
        if (tlvchain.getTLV(3, 1) != null) {
            flags |= 2;
        }
        if (tlvchain.getTLV(4, 1) != null) {
            flags |= 1;
        }
        short flag1 = 0;
        short flag2 = 0;
        String msg = null;
        TLV msgblock = tlvchain.getTLV(2, 1);
        if (msgblock != null) {
            AIMInputStream buffer2 = new AIMInputStream(new ByteArrayInputStream(msgblock.getValue()));
            buffer2.readByte();
            buffer2.readByte();
            for (int featurelen = buffer2.readShort(); featurelen > 0; --featurelen) {
                buffer2.readByte();
            }
            buffer2.readByte();
            buffer2.readByte();
            int msglen = buffer2.readShort() - 4;
            flag1 = buffer2.readShort();
            flag2 = buffer2.readShort();
            msg = buffer2.readString(msglen);
        }
        Iterator i = frame.getConn().getListeners(4, 6);
        while (i.hasNext()) {
            ((ICBMListener)i.next()).outgoingIM(sess, frame, channel, sn, msg, flags, flag1, flag2);
        }
    }

    private void incomingIMCH1ParseMsgs(AIMSession sess, AIMInputStream buffer, AOLIM args) throws IOException {
        int flags = 0;
        int[] charsetpri = new int[]{0, 3, 2};
        int charsetpricount = 3;
        MPMsg mpmpsg = new MPMsg();
        while (buffer.getEmpty() > 0) {
            buffer.readByte();
            buffer.readByte();
            int msglen = buffer.readShort();
            short flag1 = buffer.readShort();
            short flag2 = buffer.readShort();
            if ((msglen -= 4) <= 0) continue;
            String msgbuf = buffer.readString(msglen);
            MPMsgSection sec = new MPMsgSection();
            sec.setCharset(flag1);
            sec.setCharSubset(flag2);
            sec.setData(msgbuf);
            sec.setDataLen(msglen);
            args.getMPMsg().addSection(sec);
        }
        flags |= 0x400;
        for (int j = 0; j < 3 && args.getMPMsg() != null; ++j) {
            Iterator i = args.getMPMsg().iterator();
            while (i.hasNext()) {
                MPMsgSection sec = (MPMsgSection)i.next();
                if (sec.getCharset() != charsetpri[j]) continue;
                args.setCharset(sec.getCharset());
                args.setCharSubset(sec.getCharSubset());
                flags |= 0x200;
                if (args.getCharset() == 0) {
                    flags |= 0;
                } else if (args.getCharset() == 2) {
                    flags |= 4;
                } else if (args.getCharset() == 3) {
                    flags |= 8;
                } else if (args.getCharset() == 65535) {
                    flags |= 0;
                }
                if (args.getCharSubset() == 0) {
                    flags |= 0;
                } else if (args.getCharSubset() == 11) {
                    flags |= 0x40;
                } else if (args.getCharSubset() == 65535) {
                    flags |= 0;
                }
                args.setMsg(sec.getData());
                args.setMsgLen(sec.getDataLen());
                return;
            }
        }
        args.setFlags(flags);
        args.setCharset(65535);
        args.setCharSubset(65535);
        args.setMsg(null);
        args.setMsgLen(0);
    }

    private void incomingIMCH1(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, int channel, UserInfo userinfo, AIMInputStream buffer, byte[] cookie) throws IOException {
        AIMInputStream buffer2;
        AOLIM args = new AOLIM();
        TLVChain tlvchain = buffer.readTLVChain();
        int flags = 0;
        TLV tlv = tlvchain.getTLV(2, 1);
        if (tlv != null) {
            buffer2 = new AIMInputStream(new ByteArrayInputStream(tlv.getValue()));
            buffer2.readByte();
            buffer2.readByte();
            args.setFeatures(buffer2.readBytes(buffer2.readShort()));
            flags |= 0x80;
            this.incomingIMCH1ParseMsgs(sess, buffer2, args);
        }
        if ((tlv = tlvchain.getTLV(3, 1)) != null) {
            flags |= 2;
        }
        if ((tlv = tlvchain.getTLV(4, 1)) != null) {
            flags |= 1;
        }
        if ((tlv = tlvchain.getTLV(6, 1)) != null) {
            flags |= 0x800;
        }
        if ((tlv = tlvchain.getTLV(8, 1)) != null) {
            buffer2 = new AIMInputStream(new ByteArrayInputStream(tlv.getValue()));
            args.setIconLen(buffer2.readInt());
            buffer2.readShort();
            args.setIconSum(buffer2.readShort());
            args.setIconStamp(buffer2.readInt());
            if (args.getIconLen() > 0) {
                flags |= 0x20;
            }
        }
        if ((tlv = tlvchain.getTLV(9, 1)) != null) {
            flags |= 0x10;
        }
        if ((tlv = tlvchain.getTLV(11, 1)) != null) {
            flags |= 0x40;
        }
        if ((tlv = tlvchain.getTLV(23, 1)) != null) {
            AIMInputStream a = new AIMInputStream(new ByteArrayInputStream(tlv.getValue()));
            args.setExtDataLen(tlv.getLength());
            args.setExtData(a.readBytes(args.getExtDataLen()));
        }
        args.setFlags(flags);
        Iterator i = frame.getConn().getListeners(4, 7);
        while (i.hasNext()) {
            ((ICBMListener)i.next()).incomingIMCH1(sess, frame, channel, userinfo, args);
        }
    }

    private void incomingIMCH2(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, int channel, UserInfo userinfo, TLVChain tlvchain, byte[] cookie) throws IOException {
        Rendezvous rv;
        AIMInputStream buffer2;
        String clientIP1 = "";
        String clientIP2 = "";
        String verifiedIP = "";
        IncomingIMCH2 args = new IncomingIMCH2();
        TLV block1 = tlvchain.getTLV(5, 1);
        AIMInputStream buffer = new AIMInputStream(new ByteArrayInputStream(block1.getValue()));
        args.setStatus(buffer.readShort());
        byte[] cookie2 = buffer.readBytes(8);
        if (!Arrays.equals(cookie, cookie2)) {
            LOG.warn((Object)"Warning cookies don't match!");
        }
        args.setCookie(cookie2);
        byte[] uuid = buffer.readBytes(16);
        AIMInputStream uuidbuffer = new AIMInputStream(new ByteArrayInputStream(uuid));
        args.setReqClass(uuidbuffer.readCaps(16));
        TLVChain list2 = buffer.readTLVChain();
        if (list2 == null) {
            list2 = new TLVChain(0);
        }
        args.setTLVChain(list2);
        TLV tlv = list2.getTLV(2, 1);
        if (tlv != null) {
            buffer2 = new AIMInputStream(new ByteArrayInputStream(tlv.getValue()));
            args.setClientIP1(buffer2.readIP());
        }
        if ((tlv = list2.getTLV(3, 1)) != null) {
            buffer2 = new AIMInputStream(new ByteArrayInputStream(tlv.getValue()));
            args.setClientIP2(buffer2.readIP());
        }
        if ((tlv = list2.getTLV(4, 1)) != null) {
            buffer2 = new AIMInputStream(new ByteArrayInputStream(tlv.getValue()));
            args.setVerifiedIP(buffer2.readIP());
        }
        if ((tlv = list2.getTLV(5, 1)) != null) {
            args.setPort(tlv.getValueShort());
        }
        if ((tlv = list2.getTLV(7, 1)) != null) {
            args.setGamesURL(tlv.getValueString());
        }
        if ((tlv = list2.getTLV(11, 1)) != null) {
            args.setErrorCode(tlv.getValueShort());
        }
        if ((tlv = list2.getTLV(13, 1)) != null) {
            args.setEncoding(tlv.getValueString());
        }
        if ((tlv = list2.getTLV(14, 1)) != null) {
            args.setLanguage(tlv.getValueString());
        }
        if ((tlv = list2.getTLV(12, 1)) != null) {
            args.setMsg(new String(tlv.getValue(), AIMUtil.charsetAOLToJava(args.getEncoding())));
        }
        if ((tlv = list2.getTLV(10, 1)) != null) {
            LOG.debug((Object)("Rendezvous request type=0x" + Integer.toHexString(tlv.getValueShort())));
        }
        if ((tlv = list2.getTLV(15, 1)) != null) {
            LOG.warn((Object)("Unknown TLV type=0x" + Integer.toHexString(15) + ", value=" + (tlv.getValue() == null ? "null" : "0x" + AIMUtil.byteArrayToHexString(tlv.getValue()))));
        }
        if ((tlv = list2.getTLV(16, 1)) != null) {
            args.setProxied(true);
        }
        if (clientIP1.length() > 0) {
            args.setClientIP1(clientIP1);
        }
        if (clientIP2.length() > 0) {
            args.setClientIP2(clientIP2);
        }
        if (verifiedIP.length() > 0) {
            args.setVerifiedIP(verifiedIP);
        }
        AIMInputStream sdbsptr = null;
        tlv = list2.getTLV(10001, 1);
        if (tlv != null) {
            AIMInputStream sdbs;
            sdbsptr = sdbs = new AIMInputStream(new ByteArrayInputStream(tlv.getValue()));
        }
        if ((rv = sess.getRendezvous(args.getReqClass())) != null) {
            LOG.debug((Object)("Found Rendezvous, type=0x" + Integer.toHexString(rv.getType()) + ", uuid=" + AIMUtil.byteArrayToHexString(uuid)));
            rv.handleServiceData(sess, handler, frame, snac, userinfo, args, sdbsptr);
        } else {
            LOG.warn((Object)("Unknown Rendezvous, uuid=" + AIMUtil.byteArrayToHexString(uuid)));
        }
        Iterator i = frame.getConn().getListeners(4, 7);
        while (i.hasNext()) {
            ((ICBMListener)i.next()).incomingIMCH2(sess, frame, channel, userinfo, args);
        }
    }

    public void incomingIMCH4(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, int channel, UserInfo userinfo, TLVChain tlvchain, byte[] cookie) throws IOException {
        IncomingIMCH4 args = new IncomingIMCH4();
        TLV tlv = tlvchain.getTLV(5, 1);
        if (tlv == null) {
            return;
        }
        AIMInputStream buffer = new AIMInputStream(new ByteArrayInputStream(tlv.getValue()));
        args.setUIN(buffer.readIntLE());
        args.setType(buffer.readShortLE());
        args.setMsg(buffer.readStringLLLE());
        Iterator i = frame.getConn().getListeners(4, 7);
        while (i.hasNext()) {
            ((ICBMListener)i.next()).incomingIMCH4(sess, frame, channel, userinfo, args);
        }
    }

    private void incomingIM(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        byte[] cookie = buffer.readBytes(8);
        short channel = buffer.readShort();
        UserInfo userinfo = buffer.readUserInfo();
        if (channel == 1) {
            this.incomingIMCH1(sess, handler, frame, snac, channel, userinfo, buffer, cookie);
        } else if (channel == 2) {
            TLVChain tlvchain = buffer.readTLVChain();
            this.incomingIMCH2(sess, handler, frame, snac, channel, userinfo, tlvchain, cookie);
        } else if (channel == 4) {
            TLVChain tlvchain = buffer.readTLVChain();
            this.incomingIMCH4(sess, handler, frame, snac, channel, userinfo, tlvchain, cookie);
        } else {
            LOG.warn((Object)("Unknown ICBM Channel=" + Integer.toHexString(channel)));
        }
    }

    public void warn(AIMSession sess, AIMConnection conn, String destsn, int flags) throws IOException {
        int outFlags = 0;
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(4, 8, 0, null, false);
        if ((flags & 1) != 0) {
            outFlags |= 1;
        }
        AIMOutputStream buffer = new AIMOutputStream(3 + destsn.length());
        buffer.writeShort(outFlags);
        buffer.writeStringL(destsn);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void missedCall(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        while (!buffer.isEmpty()) {
            short channel = buffer.readShort();
            UserInfo userinfo = buffer.readUserInfo();
            short numMissed = buffer.readShort();
            short reason = buffer.readShort();
            Iterator i = frame.getConn().getListeners(4, 10);
            while (i.hasNext()) {
                ((ICBMListener)i.next()).missedCall(sess, frame, channel, userinfo, numMissed, reason);
            }
        }
    }

    public void clientAutoresp(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        byte[] ck = buffer.readBytes(8);
        short channel = buffer.readShort();
        String sn = buffer.readStringL();
        short reason = buffer.readShort();
        short len = 0;
        LOG.debug((Object)("clientAutoresp: channel=0x" + Integer.toHexString(channel) + ", sn=" + sn + ", reason=" + reason));
        switch (reason) {
            case 3: {
                int state;
                if (!sess.isICQ()) {
                    len = buffer.readShort();
                    buffer.readBytes(len);
                    int state2 = 0;
                    String msg = "";
                    Iterator i = frame.getConn().getListeners(4, 11);
                    while (i.hasNext()) {
                        ((ICBMListener)i.next()).clientAutoresp(sess, frame, channel, sn, reason, state2, msg);
                    }
                    return;
                }
                len = buffer.readShortLE();
                buffer.readBytes(len);
                len = buffer.readShortLE();
                buffer.readBytes(len);
                byte statusmsgtype = buffer.readByte();
                switch (statusmsgtype) {
                    case 232: {
                        state = 1;
                        break;
                    }
                    case 233: {
                        state = 17;
                        break;
                    }
                    case 234: {
                        state = 5;
                        break;
                    }
                    case 235: {
                        state = 19;
                        break;
                    }
                    case 236: {
                        state = 32;
                        break;
                    }
                    default: {
                        state = 0;
                    }
                }
                buffer.readByte();
                buffer.readShortLE();
                buffer.readShortLE();
                String msg = buffer.readStringLLLE();
                Iterator i = frame.getConn().getListeners(4, 11);
                while (i.hasNext()) {
                    ((ICBMListener)i.next()).clientAutoresp(sess, frame, channel, sn, reason, state, msg);
                }
                break;
            }
            default: {
                Iterator i = frame.getConn().getListeners(4, 11);
                while (i.hasNext()) {
                    ((ICBMListener)i.next()).clientAutoresp(sess, frame, channel, sn, reason);
                }
                break block0;
            }
        }
    }

    private void msgAck(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        byte[] ck = buffer.readBytes(8);
        short type = buffer.readShort();
        String sn = buffer.readStringL();
        Iterator i = frame.getConn().getListeners(4, 12);
        while (i.hasNext()) {
            ((ICBMListener)i.next()).msgAck(sess, frame, type, sn);
        }
    }

    public void sendMtn(AIMSession sess, String sn, int typing) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 4)) == null || sn == null) {
            throw new NullPointerException();
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(4, 20, 0, null, false);
        AIMOutputStream buffer = new AIMOutputStream(11 + sn.length() + 2);
        buffer.writeInt(0);
        buffer.writeInt(0);
        buffer.writeShort(1);
        buffer.writeStringL(sn);
        buffer.writeShort(typing);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void mtnReceive(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        byte[] ck = buffer.readBytes(8);
        short type = buffer.readShort();
        String sn = buffer.readStringL();
        short typing = buffer.readShort();
        Iterator i = frame.getConn().getListeners(4, 20);
        while (i.hasNext()) {
            ((ICBMListener)i.next()).typingNotification(sess, frame, ck, type, sn, typing);
        }
    }

    public void delICBMParams(AIMSession sess) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 4)) == null) {
            throw new NullPointerException();
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(4, 3, 0, null, false);
        AIMOutputStream buffer = new AIMOutputStream(2);
        buffer.writeShort(0);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    public void handleSNAC(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        if (snac.getSubtype() == 5) {
            this.paramInfo(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 6) {
            this.outgoingIM(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 7) {
            this.incomingIM(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 10) {
            this.missedCall(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 11) {
            this.clientAutoresp(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 12) {
            this.msgAck(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 20) {
            this.mtnReceive(sess, handler, frame, snac, buffer);
        } else {
            LOG.warn((Object)("Unrecognized SNAC(" + Integer.toHexString(snac.getFamily()) + ", " + Integer.toHexString(snac.getSubtype()) + ")"));
            frame.setHandled(false);
        }
    }
}

