/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers;

import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.FLAP;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.handlers.InviteListener;
import org.walluck.oscar.handlers.SNACHandler;

public class InviteHandler
extends SNACHandler {
    private static final Logger LOG = Logger.getLogger((String)InviteHandler.class.getName());

    public InviteHandler() {
        this.setFamily(6);
        this.setVersion(1);
    }

    public void invite(AIMSession sess, AIMConnection conn, String email, String message) throws IOException {
        if (email == null || message == null) {
            throw new NullPointerException();
        }
        if (message.length() > 256) {
            throw new IllegalArgumentException("Message length of " + message.length() + " is greater than 256");
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(6, 2, 0, null, true);
        TLVChain tlvchain = new TLVChain(2);
        tlvchain.addString(17, email);
        tlvchain.addString(21, message);
        AIMOutputStream buffer = new AIMOutputStream(tlvchain.length());
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void invitationSent(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) {
        Iterator i = frame.getConn().getListeners(6, 3);
        while (i.hasNext()) {
            ((InviteListener)i.next()).invitationSent(sess, frame, buffer);
        }
    }

    public void handleSNAC(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        if (snac.getSubtype() == 3) {
            this.invitationSent(sess, handler, frame, snac, buffer);
        } else {
            LOG.warn((Object)("Unrecognized SNAC(" + Integer.toHexString(snac.getFamily()) + ", " + Integer.toHexString(snac.getSubtype()) + ")"));
            frame.setHandled(false);
        }
    }
}

