/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.FLAP;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.SSIItem;
import org.walluck.oscar.SSITmp;
import org.walluck.oscar.TLV;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.handlers.MiscHandler;
import org.walluck.oscar.handlers.SNACHandler;
import org.walluck.oscar.handlers.SSIListener;

public class SSIHandler
extends SNACHandler {
    private static final Logger LOG = Logger.getLogger((String)SSIHandler.class.getName());

    public SSIHandler() {
        this.setFamily(19);
        this.setVersion(3);
    }

    public void debugPrintLists(AIMSession sess) {
        SSIItem item;
        int j;
        LOG.debug((Object)"begin official list");
        for (j = 0; sess.getSSI().getOfficial() != null && j < sess.getSSI().getOfficial().size(); ++j) {
            item = (SSIItem)sess.getSSI().getOfficial().get(j);
            LOG.debug((Object)("official: bid=" + item.getBid() + ", gid=" + item.getGid() + ", name=" + item.getName() + ", data=" + (item.getData() != null ? ((TLVChain)item.getData()).toString() : "null")));
        }
        LOG.debug((Object)"end official list");
        LOG.debug((Object)"begin local list");
        for (j = 0; sess.getSSI().getLocal() != null && j < sess.getSSI().getLocal().size(); ++j) {
            item = (SSIItem)sess.getSSI().getLocal().get(j);
            LOG.debug((Object)("local: bid=" + item.getBid() + ", gid=" + item.getGid() + ", name=" + item.getName() + ", data=" + (item.getData() != null ? ((TLVChain)item.getData()).toString() : "null")));
        }
        LOG.debug((Object)"end local list");
    }

    private SSIItem itemListRebuildGroup(List list, String name) throws IOException {
        byte[] newdata;
        Iterator i;
        if (list == null) {
            return null;
        }
        SSIItem group = this.itemListFindItem(list, name, null, 1);
        if (group == null) {
            LOG.warn((Object)("itemListRebuildGroup: Could not find group " + group));
            return null;
        }
        group.setData(null);
        AIMOutputStream buffer = new AIMOutputStream();
        if (group.getGid() == 0) {
            i = list.iterator();
            while (i.hasNext()) {
                SSIItem cur = (SSIItem)i.next();
                if (cur.getType() != 1 || cur.getGid() == 0) continue;
                buffer.writeShort(cur.getGid());
            }
        } else {
            i = list.iterator();
            while (i.hasNext()) {
                SSIItem cur = (SSIItem)i.next();
                if (cur.getGid() != group.getGid() || cur.getType() != 0) continue;
                buffer.writeShort(cur.getBid());
            }
        }
        if ((newdata = buffer.getBytes()) != null && newdata.length > 0) {
            TLVChain tlvchain = (TLVChain)group.getData();
            if (tlvchain != null) {
                tlvchain.removeTLV(200, 1);
                tlvchain.ensureCapacity(1);
            } else {
                tlvchain = new TLVChain(1);
            }
            tlvchain.addBytes(200, newdata);
        }
        return group;
    }

    public SSIItem itemListAdd(List list, String name, int gid, int bid, int type, TLVChain data) {
        SSIItem cur;
        Iterator i;
        if (list == null) {
            return null;
        }
        SSIItem newitem = new SSIItem();
        newitem.setName(name);
        newitem.setGid(gid);
        newitem.setBid(bid);
        boolean j = false;
        if (type == 1) {
            if (newitem.getGid() == -1 && name != null) {
                do {
                    newitem.setGid(newitem.getGid() + 1);
                    j = false;
                    i = list.iterator();
                    while (i.hasNext() && !j) {
                        cur = (SSIItem)i.next();
                        if (cur.getType() != 1 || cur.getGid() != newitem.getGid()) continue;
                        j = true;
                    }
                } while (j);
            }
        } else if (newitem.getBid() == -1) {
            do {
                newitem.setBid(newitem.getBid() + 1);
                j = false;
                i = list.iterator();
                while (i.hasNext() && !j) {
                    cur = (SSIItem)i.next();
                    if (cur.getBid() != newitem.getBid() || cur.getGid() != newitem.getGid()) continue;
                    j = true;
                }
            } while (j);
        }
        newitem.setType(type);
        newitem.setData(data);
        int size = list.size();
        int pos = 0;
        for (pos = 0; pos < size; ++pos) {
            SSIItem tmp = (SSIItem)list.get(pos);
            if (newitem.getGid() < tmp.getGid() || newitem.getGid() == tmp.getGid() && newitem.getBid() < tmp.getBid()) break;
        }
        list.add(pos, newitem);
        LOG.debug((Object)("itemListAdd: pos=" + pos + "/" + size + ", gid=" + newitem.getGid() + ", bid=" + newitem.getBid() + ", type=" + newitem.getType() + ", data=" + (TLVChain)newitem.getData()));
        return newitem;
    }

    public int itemListDel(List list, SSIItem del) {
        if (list == null || list.isEmpty() || del == null) {
            return -1;
        }
        list.remove(del);
        return 0;
    }

    public int itemListCmp(SSIItem cur1, SSIItem cur2) throws IOException {
        TLVChain tlvchain2;
        TLVChain tlvchain1;
        if (cur1 == null || cur2 == null) {
            return 1;
        }
        if (cur1.getData() != null && cur2.getData() == null) {
            return 2;
        }
        if (cur1.getData() == null && cur2.getData() != null) {
            return 3;
        }
        if (cur1.getData() != null && cur2.getData() != null && !(tlvchain1 = (TLVChain)cur1.getData()).equals(tlvchain2 = (TLVChain)cur2.getData())) {
            return 4;
        }
        if (cur1.getName() != null && cur2.getName() == null) {
            return 5;
        }
        if (cur1.getName() == null && cur2.getName() != null) {
            return 6;
        }
        if (cur1.getName() != null && cur2.getName() != null && !AIMUtil.snCmp(cur1.getName(), cur2.getName())) {
            return 7;
        }
        if (cur1.getGid() != cur2.getGid()) {
            return 8;
        }
        if (cur1.getBid() != cur2.getBid()) {
            return 9;
        }
        if (cur1.getType() != cur2.getType()) {
            return 10;
        }
        return 0;
    }

    public boolean itemListValid(List list, SSIItem item) {
        return list.contains(item);
    }

    public SSIItem itemListFind(List list, int gid, int bid) {
        if (list == null) {
            return null;
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            SSIItem cur = (SSIItem)i.next();
            if (cur.getGid() != gid || cur.getBid() != bid) continue;
            return cur;
        }
        return null;
    }

    public SSIItem itemListFindItem(List list, String gn, String sn, int type) {
        if (list == null) {
            return null;
        }
        if (gn != null && sn != null) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                SSIItem cur = (SSIItem)i.next();
                if (cur.getType() != type || cur.getName() == null || !AIMUtil.snCmp(cur.getName(), sn)) continue;
                Iterator i2 = list.iterator();
                while (i.hasNext()) {
                    SSIItem curg = (SSIItem)i2.next();
                    if (curg.getType() != 1 || curg.getGid() != cur.getGid() || curg.getName() == null || !AIMUtil.snCmp(curg.getName(), gn)) continue;
                    return cur;
                }
            }
        } else if (gn != null) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                SSIItem cur = (SSIItem)i.next();
                if (cur.getType() != type || cur.getBid() != 0 || cur.getName() == null || !AIMUtil.snCmp(cur.getName(), gn)) continue;
                return cur;
            }
        } else if (sn != null) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                SSIItem cur = (SSIItem)i.next();
                if (cur.getType() != type || cur.getName() == null || !AIMUtil.snCmp(cur.getName(), sn)) continue;
                return cur;
            }
        } else {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                SSIItem cur = (SSIItem)i.next();
                if (cur.getType() != type || cur.getName() != null) continue;
                return cur;
            }
        }
        return null;
    }

    public SSIItem itemListExists(List list, String sn) {
        if (list == null || sn == null) {
            return null;
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            SSIItem cur = (SSIItem)i.next();
            if (cur.getType() != 0 || cur.getName() == null || !AIMUtil.snCmp(cur.getName(), sn)) continue;
            return cur;
        }
        return null;
    }

    public String itemListFindParentName(List list, String sn) {
        if (list == null || sn == null) {
            return null;
        }
        SSIItem cur = this.itemListExists(list, sn);
        if (cur == null) {
            return null;
        }
        SSIItem curg = this.itemListFind(list, cur.getGid(), 0);
        if (curg == null) {
            return null;
        }
        return curg.getName();
    }

    public byte getPermdeny(List list) throws IOException {
        TLV tlv;
        TLVChain tlvchain;
        SSIItem cur = this.itemListFindItem(list, null, null, 4);
        if (cur != null && (tlvchain = (TLVChain)cur.getData()) != null && (tlv = tlvchain.getTLV(202, 1)) != null && tlv.getValue() != null) {
            return tlv.getValueByte();
        }
        return 0;
    }

    public int getPresence(List list) throws IOException {
        TLV tlv;
        TLVChain tlvchain;
        SSIItem cur = this.itemListFindItem(list, null, null, 5);
        if (cur != null && (tlvchain = (TLVChain)cur.getData()) != null && (tlv = tlvchain.getTLV(201, 1)) != null && tlv.getLength() > 0) {
            return tlv.getValueInt();
        }
        return -1;
    }

    public String getAlias(List list, String gn, String sn) throws IOException {
        TLV tlv;
        TLVChain tlvchain;
        SSIItem cur = this.itemListFindItem(list, gn, sn, 0);
        if (cur != null && (tlvchain = (TLVChain)cur.getData()) != null && (tlv = tlvchain.getTLV(305, 1)) != null && tlv.getLength() > 0) {
            return tlv.getValueString();
        }
        return null;
    }

    public String getBuddyComment(List list, String gn, String sn) throws IOException {
        TLV tlv;
        TLVChain tlvchain;
        SSIItem cur = this.itemListFindItem(list, gn, sn, 0);
        if (cur != null && (tlvchain = (TLVChain)cur.getData()) != null && (tlv = tlvchain.getTLV(316, 1)) != null && tlv.getLength() > 0) {
            return tlv.getValueString();
        }
        return null;
    }

    public boolean waitingForAuth(List list, String gn, String sn) throws IOException {
        TLVChain tlvchain;
        SSIItem cur = this.itemListFindItem(list, gn, sn, 0);
        return cur != null && (tlvchain = (TLVChain)cur.getData()) != null && tlvchain.getTLV(102, 1) != null;
    }

    public void sync(AIMSession sess) throws IOException {
        SSITmp newitem;
        SSIItem cur1;
        Iterator i;
        if (sess == null) {
            throw new NullPointerException();
        }
        if (sess.getSSI().isWaitingForAck()) {
            LOG.debug((Object)"sync() called, but waiting for ack");
            return;
        }
        if (sess.getSSI().getPending() == null) {
            i = sess.getSSI().getLocal().iterator();
            while (i.hasNext()) {
                cur1 = (SSIItem)i.next();
                if (this.itemListFind(sess.getSSI().getOfficial(), cur1.getGid(), cur1.getBid()) != null) continue;
                LOG.debug((Object)"addition in sync()");
                newitem = new SSITmp();
                newitem.setAction(8);
                newitem.setAck(-1);
                newitem.setName(null);
                newitem.setItem(cur1);
                if (sess.getSSI().getPending() == null) {
                    sess.getSSI().setPending(new Vector());
                }
                sess.getSSI().getPending().add(newitem);
            }
        }
        if (sess.getSSI().getPending() == null) {
            i = sess.getSSI().getOfficial().iterator();
            while (i.hasNext()) {
                cur1 = (SSIItem)i.next();
                if (this.itemListFind(sess.getSSI().getLocal(), cur1.getGid(), cur1.getBid()) != null) continue;
                LOG.debug((Object)"deletion in sync()");
                newitem = new SSITmp();
                newitem.setAction(10);
                newitem.setAck(-1);
                newitem.setName(null);
                newitem.setItem(cur1);
                if (sess.getSSI().getPending() == null) {
                    sess.getSSI().setPending(new Vector());
                }
                sess.getSSI().getPending().add(newitem);
            }
        }
        if (sess.getSSI().getPending() == null) {
            i = sess.getSSI().getLocal().iterator();
            while (i.hasNext()) {
                cur1 = (SSIItem)i.next();
                SSIItem cur2 = this.itemListFind(sess.getSSI().getOfficial(), cur1.getGid(), cur1.getBid());
                if (cur2 == null || this.itemListCmp(cur1, cur2) <= 0) continue;
                LOG.debug((Object)("itemListCmp(cur1, cur2) returns " + this.itemListCmp(cur1, cur2)));
                LOG.debug((Object)"modification in sync()");
                newitem = new SSITmp();
                newitem.setAction(9);
                newitem.setAck(-1);
                newitem.setName(null);
                newitem.setItem(cur1);
                if (sess.getSSI().getPending() == null) {
                    sess.getSSI().setPending(new Vector());
                }
                sess.getSSI().getPending().add(newitem);
            }
        }
        if (sess.getSSI().getPending() == null) {
            LOG.debug((Object)"sync() called and pending is null, yay! :)");
            this.modEnd(sess);
            return;
        }
        LOG.debug((Object)("sync() called, but pending has " + sess.getSSI().getPending().size() + " items"));
        sess.getSSI().setWaitingForAck(true);
        this.addModDel(sess);
    }

    public void freeList(AIMSession sess) {
        sess.getSSI().getOfficial().clear();
        sess.getSSI().getLocal().clear();
        sess.getSSI().getPending().clear();
        sess.getSSI().setNumItems(0);
        sess.getSSI().setOfficial(null);
        sess.getSSI().setLocal(null);
        sess.getSSI().setPending(null);
        sess.getSSI().setTimestamp(0);
    }

    public void deleteList(AIMSession sess) throws IOException {
        if (sess == null) {
            throw new NullPointerException();
        }
        sess.getSSI().getLocal().clear();
        sess.getSSI().setLocal(null);
        this.sync(sess);
    }

    public void cleanList(AIMSession sess) throws IOException {
        SSIItem cur;
        int i;
        if (sess == null) {
            throw new NullPointerException();
        }
        SSIItem masterGroup = this.itemListFind(sess.getSSI().getLocal(), 0, 0);
        if (masterGroup != null && masterGroup.getName() != null) {
            LOG.warn((Object)("Master group has name=" + masterGroup.getName() + ", should be null"));
            masterGroup.setName(null);
            this.sync(sess);
        } else if (masterGroup == null) {
            LOG.warn((Object)"master group not found, adding...");
            masterGroup = this.itemListAdd(sess.getSSI().getLocal(), null, 0, 0, 1, null);
            this.itemListRebuildGroup(sess.getSSI().getLocal(), null);
            this.sync(sess);
        }
        if (masterGroup != null && masterGroup.getData() == null) {
            LOG.warn((Object)"Master group is empty");
            this.itemListDel(sess.getSSI().getLocal(), masterGroup);
        }
        for (i = 0; i < sess.getSSI().getLocal().size(); ++i) {
            cur = (SSIItem)sess.getSSI().getLocal().get(i);
            if (cur.getName() != null) continue;
            if (cur.getType() == 0) {
                this.delBuddy(sess, null, null);
                continue;
            }
            if (cur.getType() == 2) {
                this.delPermit(sess, null);
                continue;
            }
            if (cur.getType() == 3) {
                this.delDeny(sess, null);
                continue;
            }
            if (cur.getType() != 0 || cur.getGid() != 0 && this.itemListFind(sess.getSSI().getLocal(), cur.getGid(), 0) != null) continue;
            this.addBuddy(sess, cur.getName(), "Orphans", null, null, null, false);
            this.delBuddy(sess, cur.getName(), null);
        }
        for (i = 0; i < sess.getSSI().getLocal().size(); ++i) {
            cur = (SSIItem)sess.getSSI().getLocal().get(i);
            if (cur.getType() != 1) continue;
            TLVChain tlvchain = (TLVChain)cur.getData();
            TLV tlv = null;
            if (tlvchain != null) {
                tlv = tlvchain.getTLV(200, 1);
            }
            if (tlv != null && tlv.getLength() != 0) continue;
            this.itemListDel(sess.getSSI().getLocal(), cur);
        }
    }

    public void addBuddy(AIMSession sess, String name, String group, String alias, String comment, String smsnum, boolean needauth) throws IOException {
        TLVChain data = null;
        if (sess == null || name == null || group == null) {
            throw new NullPointerException();
        }
        SSIItem parent = this.itemListFindItem(sess.getSSI().getLocal(), group, null, 1);
        if (parent == null) {
            parent = this.itemListFind(sess.getSSI().getLocal(), 0, 0);
            if (parent != null) {
                LOG.debug((Object)"master group not found, adding...");
                parent = this.itemListAdd(sess.getSSI().getLocal(), null, 0, 0, 1, null);
                if (parent == null) {
                    throw new NullPointerException();
                }
            }
            if ((parent = this.itemListAdd(sess.getSSI().getLocal(), group, -1, 0, 1, null)) == null) {
                throw new NullPointerException();
            }
            this.itemListRebuildGroup(sess.getSSI().getLocal(), null);
        }
        if (needauth) {
            data.addNull(102);
        }
        if (alias != null) {
            data.addString(305, alias);
        }
        if (smsnum != null) {
            data.addString(314, smsnum);
        }
        if (comment != null) {
            data.addString(316, comment);
        }
        this.itemListAdd(sess.getSSI().getLocal(), name, parent.getGid(), -1, 0, data);
        this.itemListRebuildGroup(sess.getSSI().getLocal(), group);
        this.sync(sess);
    }

    public void addPermit(AIMSession sess, String name) throws IOException {
        if (sess == null || name == null) {
            throw new NullPointerException();
        }
        this.itemListAdd(sess.getSSI().getLocal(), name, 0, -1, 2, null);
        this.sync(sess);
    }

    public void addDeny(AIMSession sess, String name) throws IOException {
        if (sess == null || name == null) {
            throw new NullPointerException();
        }
        this.itemListAdd(sess.getSSI().getLocal(), name, 0, -1, 3, null);
        this.sync(sess);
    }

    public void delBuddy(AIMSession sess, String name, String group) throws IOException {
        if (sess == null) {
            throw new NullPointerException();
        }
        SSIItem del = this.itemListFindItem(sess.getSSI().getLocal(), group, name, 0);
        if (del == null) {
            throw new NullPointerException();
        }
        this.itemListDel(sess.getSSI().getLocal(), del);
        this.itemListRebuildGroup(sess.getSSI().getLocal(), group);
        del = this.itemListFindItem(sess.getSSI().getLocal(), group, null, 1);
        if (del == null && del.getData() == null) {
            this.itemListDel(sess.getSSI().getLocal(), del);
            this.itemListRebuildGroup(sess.getSSI().getLocal(), null);
            del = this.itemListFind(sess.getSSI().getLocal(), 0, 0);
            if (del == null && del.getData() == null) {
                this.itemListDel(sess.getSSI().getLocal(), del);
            }
        }
        this.sync(sess);
    }

    public void delPermit(AIMSession sess, String name) throws IOException {
        if (sess == null) {
            throw new NullPointerException();
        }
        SSIItem del = this.itemListFindItem(sess.getSSI().getLocal(), null, name, 2);
        if (del == null) {
            throw new NullPointerException();
        }
        this.itemListDel(sess.getSSI().getLocal(), del);
        this.sync(sess);
    }

    public void delDeny(AIMSession sess, String name) throws IOException {
        if (sess == null) {
            throw new NullPointerException();
        }
        SSIItem del = this.itemListFindItem(sess.getSSI().getLocal(), null, name, 3);
        if (del == null) {
            throw new NullPointerException();
        }
        this.itemListDel(sess.getSSI().getLocal(), del);
        this.sync(sess);
    }

    public void moveBuddy(AIMSession sess, String oldgn, String newgn, String sn) throws IOException {
        this.addBuddy(sess, sn, newgn, this.getAlias(sess.getSSI().getLocal(), oldgn, sn), null, null, this.waitingForAuth(sess.getSSI().getLocal(), oldgn, sn));
        this.delBuddy(sess, sn, oldgn);
    }

    public void aliasBuddy(AIMSession sess, String gn, String sn, String alias) throws IOException {
        TLVChain data = null;
        if (sess == null || gn == null || sn == null) {
            throw new NullPointerException();
        }
        SSIItem tmp = this.itemListFindItem(sess.getSSI().getLocal(), gn, sn, 0);
        if (tmp == null) {
            throw new NullPointerException();
        }
        if (alias != null && alias.length() == 0) {
            alias = null;
        }
        if (alias != null) {
            data.addString(305, alias);
        }
        tmp.setData(data);
        this.sync(sess);
    }

    public void renameGroup(AIMSession sess, String oldgn, String newgn) throws IOException {
        if (sess == null || oldgn == null || newgn == null) {
            throw new NullPointerException();
        }
        SSIItem group = this.itemListFindItem(sess.getSSI().getLocal(), oldgn, null, 1);
        if (group == null) {
            throw new NullPointerException();
        }
        group.setName(newgn);
        this.sync(sess);
    }

    public void setPermDeny(AIMSession sess, byte permdeny, int vismask) throws IOException {
        TLVChain data = new TLVChain(2);
        if (sess == null) {
            throw new NullPointerException();
        }
        data.addByte(202, permdeny);
        data.addInt(203, vismask);
        SSIItem tmp = this.itemListFindItem(sess.getSSI().getLocal(), null, null, 4);
        if (tmp == null) {
            tmp.setData(data);
        } else {
            tmp = this.itemListAdd(sess.getSSI().getLocal(), null, 0, -1, 4, data);
        }
        this.sync(sess);
    }

    public void setIcon(AIMSession sess, byte[] iconsum) throws IOException {
        TLVChain data = new TLVChain(2);
        byte[] csumdata = new byte[iconsum.length + 2];
        if (sess == null || iconsum == null || iconsum.length == 0) {
            throw new NullPointerException();
        }
        csumdata[0] = 0;
        csumdata[1] = 16;
        System.arraycopy(csumdata, 2, iconsum, 0, iconsum.length);
        data.addBytes(213, csumdata);
        data.addNull(305);
        SSIItem tmp = this.itemListFindItem(sess.getSSI().getLocal(), null, "0", 20);
        if (tmp != null) {
            TLVChain tlvchain1 = (TLVChain)tmp.getData();
            TLVChain tlvchain2 = data;
            if (tlvchain1 != null && tlvchain2 != null && tlvchain1.equals(tlvchain2)) {
                return;
            }
            tmp.setData(data);
        } else {
            tmp = this.itemListAdd(sess.getSSI().getLocal(), "0", 0, -1, 20, data);
        }
        this.sync(sess);
    }

    public void setPresence(AIMSession sess, int presence) throws IOException {
        TLVChain data = new TLVChain(1);
        if (sess == null) {
            throw new NullPointerException();
        }
        data.addInt(201, presence);
        SSIItem tmp = this.itemListFindItem(sess.getSSI().getLocal(), null, null, 5);
        if (tmp == null) {
            tmp.setData(data);
        } else {
            tmp = this.itemListAdd(sess.getSSI().getLocal(), null, 0, -1, 5, data);
        }
        this.sync(sess);
    }

    public void reqRights(AIMSession sess) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 19)) == null) {
            throw new NullPointerException();
        }
        MiscHandler misc = (MiscHandler)sess.getHandler(65535);
        misc.genericReqNull(sess, conn, 19, 2);
    }

    private void parseRights(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        TLVChain tlvchain = buffer.readTLVChain();
        TLV tlv = tlvchain.getTLV(4, 1);
        if (tlv == null) {
            return;
        }
        AIMInputStream buffer2 = new AIMInputStream(new ByteArrayInputStream(tlv.getValue()));
        short[] maxitems = new short[tlv.getLength() / 2];
        for (int i = 0; i < tlv.getLength() / 2; ++i) {
            maxitems[i] = buffer2.readShort();
        }
        Iterator i = frame.getConn().getListeners(19, 3);
        while (i.hasNext()) {
            ((SSIListener)i.next()).parseRights(sess, frame, maxitems);
        }
    }

    public void reqData(AIMSession sess) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 19)) == null) {
            throw new NullPointerException();
        }
        MiscHandler misc = (MiscHandler)sess.getHandler(65535);
        misc.genericReqNull(sess, conn, 19, 4);
    }

    public void reqIfChanged(AIMSession sess, long timestamp, short numitems) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 19)) == null) {
            throw new NullPointerException();
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(19, 5, 0, null, true);
        snac.setId(65540);
        AIMOutputStream buffer = new AIMOutputStream(6);
        buffer.writeInt((int)timestamp);
        buffer.writeShort(numitems);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void parseData(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        TLVChain data = null;
        byte fmtVer = buffer.readByte();
        sess.getSSI().setNumItems(sess.getSSI().getNumItems() + buffer.readShort());
        if (sess.getSSI().getOfficial() == null) {
            sess.getSSI().setOfficial(new Vector());
        }
        if (sess.getSSI().getLocal() == null) {
            sess.getSSI().setLocal(new Vector());
        }
        while (buffer.getEmpty() > 4) {
            String name = buffer.readStringLL();
            short gid = buffer.readShort();
            short bid = buffer.readShort();
            short type = buffer.readShort();
            short len = buffer.readShort();
            if (len > 0) {
                data = buffer.readTLVChain(len);
            }
            this.itemListAdd(sess.getSSI().getOfficial(), name, gid, bid, type, data);
        }
        sess.getSSI().setTimestamp(buffer.readInt());
        if ((snac.getFlags() & 1) == 0) {
            Iterator i = sess.getSSI().getOfficial().iterator();
            while (i.hasNext()) {
                SSIItem cur = (SSIItem)i.next();
                this.itemListAdd(sess.getSSI().getLocal(), cur.getName(), cur.getGid(), cur.getBid(), cur.getType(), (TLVChain)cur.getData());
            }
            sess.getSSI().setReceivedData(true);
            Iterator i2 = frame.getConn().getListeners(19, 6);
            while (i2.hasNext()) {
                ((SSIListener)i2.next()).parseData(sess, frame, fmtVer, sess.getSSI().getNumItems(), sess.getSSI().getOfficial(), sess.getSSI().getTimestamp());
            }
        }
    }

    public void enable(AIMSession sess) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 19)) == null) {
            throw new NullPointerException();
        }
        MiscHandler misc = (MiscHandler)sess.getHandler(65535);
        misc.genericReqNull(sess, conn, 19, 7);
    }

    public void addModDel(AIMSession sess) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 19)) == null || sess.getSSI().getPending() == null || sess.getSSI().getPending().isEmpty() || ((SSITmp)sess.getSSI().getPending().get(0)).getItem() == null) {
            throw new NullPointerException();
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(19, ((SSITmp)sess.getSSI().getPending().get(0)).getAction(), 0, null, true);
        AIMOutputStream buffer = new AIMOutputStream();
        Iterator i = sess.getSSI().getPending().iterator();
        while (i.hasNext()) {
            SSITmp cur = (SSITmp)i.next();
            if (cur.getItem().getName() != null) {
                buffer.writeStringLL(cur.getItem().getName());
            } else {
                buffer.writeShort(0);
            }
            buffer.writeShort(cur.getItem().getGid());
            buffer.writeShort(cur.getItem().getBid());
            buffer.writeShort(cur.getItem().getType());
            TLVChain tlvchain = (TLVChain)cur.getItem().getData();
            if (tlvchain != null) {
                buffer.writeShort(tlvchain.length());
                buffer.writeTLVChain(tlvchain);
                continue;
            }
            buffer.writeShort(0);
        }
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void parseAdd(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        TLVChain data = null;
        while (buffer.getEmpty() > 0) {
            String name = buffer.readStringLL();
            short gid = buffer.readShort();
            short bid = buffer.readShort();
            short type = buffer.readShort();
            short len = buffer.readShort();
            if (len > 0) {
                data = buffer.readTLVChain(len);
            }
            this.itemListAdd(sess.getSSI().getLocal(), name, gid, bid, type, data);
            this.itemListAdd(sess.getSSI().getOfficial(), name, gid, bid, type, data);
        }
        Iterator i = frame.getConn().getListeners(19, 8);
        while (i.hasNext()) {
            ((SSIListener)i.next()).parseAdd(sess, frame);
        }
    }

    private void parseMod(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        TLVChain data = null;
        while (buffer.getEmpty() > 0) {
            SSIItem item;
            String name = buffer.readStringLL();
            short gid = buffer.readShort();
            short bid = buffer.readShort();
            short type = buffer.readShort();
            short len = buffer.readShort();
            if (len > 0) {
                data = buffer.readTLVChain(len);
            }
            if ((item = this.itemListFind(sess.getSSI().getLocal(), gid, bid)) != null) {
                item.setType(type);
                item.setName(name);
                item.setData(data);
            }
            if ((item = this.itemListFind(sess.getSSI().getOfficial(), gid, bid)) == null) continue;
            item.setType(type);
            item.setName(name);
            item.setData(data);
        }
        Iterator i = frame.getConn().getListeners(19, 9);
        while (i.hasNext()) {
            ((SSIListener)i.next()).parseMod(sess, frame);
        }
    }

    private void parseDel(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        while (buffer.getEmpty() > 0) {
            short tmplen = buffer.readShort();
            byte[] tmp = buffer.readBytes(tmplen);
            LOG.debug((Object)("Unknown data, length=" + tmplen));
            LOG.debug((Object)AIMUtil.hexdump(tmp));
            short gid = buffer.readShort();
            short bid = buffer.readShort();
            short unknown = buffer.readShort();
            LOG.warn((Object)("unknown short=0x" + Integer.toHexString(unknown)));
            tmplen = buffer.readShort();
            tmp = buffer.readBytes(tmplen);
            LOG.debug((Object)("Unknown data, length=" + tmplen));
            LOG.debug((Object)AIMUtil.hexdump(tmp));
            SSIItem del = this.itemListFind(sess.getSSI().getLocal(), gid, bid);
            if (del != null) {
                this.itemListDel(sess.getSSI().getLocal(), del);
            }
            if ((del = this.itemListFind(sess.getSSI().getOfficial(), gid, bid)) != null) {
                this.itemListDel(sess.getSSI().getOfficial(), del);
            }
            Iterator i = frame.getConn().getListeners(19, 10);
            while (i.hasNext()) {
                ((SSIListener)i.next()).parseDel(sess, frame);
            }
        }
    }

    private void parseAck(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        SSITmp cur = null;
        int tmp = 0;
        Iterator i = sess.getSSI().getPending().iterator();
        while (i.hasNext()) {
            cur = (SSITmp)i.next();
            cur.setAck(buffer.readShort());
            LOG.debug((Object)("Got addModDel ack=0x" + Integer.toHexString(cur.getAck())));
            ++tmp;
        }
        LOG.debug((Object)("The pending list size=" + sess.getSSI().getPending().size() + " and we got tmp=" + tmp + " acks"));
        i = sess.getSSI().getPending().iterator();
        while (i.hasNext() && cur.getAck() != -1) {
            SSIItem cur1;
            cur = (SSITmp)i.next();
            if (cur.getItem() == null) continue;
            if (cur.getAck() > 0) {
                LOG.debug((Object)"Action unsuccessful");
                switch (cur.getAck()) {
                    case 2: {
                        LOG.debug((Object)"item not found");
                        break;
                    }
                    case 10: {
                        LOG.debug((Object)"id number in use");
                        break;
                    }
                    case 12: {
                        LOG.debug((Object)"max list size reached");
                        break;
                    }
                    case 13: {
                        LOG.debug((Object)"invalid item name");
                        break;
                    }
                    case 14: {
                        LOG.warn((Object)"FIXME: authorization required");
                        break;
                    }
                    default: {
                        LOG.warn((Object)("unknown error code=0x" + Integer.toHexString(cur.getAck())));
                    }
                }
                if (cur.getAction() == 8) {
                    if (this.itemListValid(sess.getSSI().getLocal(), cur.getItem())) {
                        if (cur.getItem().getName() != null) {
                            cur.setName(cur.getItem().getName());
                        }
                        this.itemListDel(sess.getSSI().getLocal(), cur.getItem());
                    }
                    cur.setItem(null);
                    continue;
                }
                if (cur.getAction() == 9) {
                    if (this.itemListValid(sess.getSSI().getLocal(), cur.getItem())) {
                        cur1 = this.itemListFind(sess.getSSI().getOfficial(), cur.getItem().getGid(), cur.getItem().getBid());
                        if (cur1 == null) continue;
                        if (cur1.getName() != null) {
                            cur.getItem().setName(cur1.getName());
                        } else {
                            cur.getItem().setName(null);
                        }
                        cur.getItem().setData(cur1.getData());
                        continue;
                    }
                    cur.setItem(null);
                    continue;
                }
                if (cur.getAction() != 10) continue;
                if (this.itemListValid(sess.getSSI().getOfficial(), cur.getItem())) {
                    this.itemListAdd(sess.getSSI().getLocal(), cur.getItem().getName(), cur.getItem().getGid(), cur.getItem().getBid(), cur.getItem().getType(), (TLVChain)cur.getItem().getData());
                    continue;
                }
                cur.setItem(null);
                continue;
            }
            LOG.debug((Object)"Successful action");
            if (cur.getAction() == 8) {
                LOG.debug((Object)"now adding to official list");
                if (this.itemListValid(sess.getSSI().getLocal(), cur.getItem())) {
                    this.itemListAdd(sess.getSSI().getOfficial(), cur.getItem().getName(), cur.getItem().getGid(), cur.getItem().getBid(), cur.getItem().getType(), (TLVChain)cur.getItem().getData());
                    continue;
                }
                LOG.debug((Object)"item not valid");
                cur.setItem(null);
                continue;
            }
            if (cur.getAction() == 9) {
                if (this.itemListValid(sess.getSSI().getLocal(), cur.getItem())) {
                    cur1 = this.itemListFind(sess.getSSI().getOfficial(), cur.getItem().getGid(), cur.getItem().getBid());
                    if (cur1 == null) continue;
                    if (cur.getItem().getName() != null) {
                        cur1.setName(cur.getItem().getName());
                    } else {
                        cur1.setName(null);
                    }
                    cur1.setData(cur.getItem().getData());
                    continue;
                }
                cur.setItem(null);
                continue;
            }
            if (cur.getAction() != 10) continue;
            if (this.itemListValid(sess.getSSI().getOfficial(), cur.getItem())) {
                this.itemListDel(sess.getSSI().getOfficial(), cur.getItem());
            }
            cur.setItem(null);
        }
        LOG.debug((Object)"Firing srvAck listener");
        i = frame.getConn().getListeners(19, 14);
        while (i.hasNext()) {
            ((SSIListener)i.next()).parseAck(sess, frame);
        }
        LOG.debug((Object)("Now trying to remove the items, " + sess.getSSI().getPending().size()));
        int removed = 0;
        Vector pending = sess.getSSI().getPending();
        SSITmp[] tmps = pending.toArray(new SSITmp[pending.size()]);
        int n = tmps.length;
        for (int i2 = 0; i2 < n; ++i2) {
            LOG.debug((Object)("Trying to remove 0x" + Integer.toHexString(tmps[i2].getAck())));
            if (tmps[i2].getAck() != -1) {
                pending.remove(tmps[i2]);
                ++removed;
                continue;
            }
            LOG.debug((Object)("Couldn't remove item since getAck()=0x" + Integer.toHexString(tmps[i2].getAck())));
        }
        LOG.debug((Object)("Removed " + removed + " items, " + sess.getSSI().getPending().size()));
        if (sess.getSSI().getPending().isEmpty()) {
            sess.getSSI().setPending(null);
        }
        if (sess.getSSI().getPending() == null) {
            LOG.debug((Object)"all acks complete!");
            sess.getSSI().setPending(null);
            sess.getSSI().setWaitingForAck(false);
            this.sync(sess);
        }
    }

    private void parseDataUnchanged(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        sess.getSSI().setReceivedData(true);
        Iterator i = frame.getConn().getListeners(19, 15);
        while (i.hasNext()) {
            ((SSIListener)i.next()).parseDataUnchanged(sess, frame);
        }
    }

    public void modBegin(AIMSession sess) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 19)) == null) {
            throw new NullPointerException();
        }
        MiscHandler misc = (MiscHandler)sess.getHandler(65535);
        misc.genericReqNull(sess, conn, 19, 17);
    }

    public void modEnd(AIMSession sess) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 19)) == null) {
            throw new NullPointerException();
        }
        MiscHandler misc = (MiscHandler)sess.getHandler(65535);
        misc.genericReqNull(sess, conn, 19, 18);
    }

    public void sendAuth(AIMSession sess, String sn, String msg) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 19)) == null || sn == null) {
            throw new NullPointerException();
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(19, 20, 0, null, true);
        AIMOutputStream buffer = new AIMOutputStream(1 + sn.length() + 2 + msg.length() + 2);
        buffer.writeStringL(sn);
        if (msg != null) {
            buffer.writeStringLL0(msg);
        } else {
            buffer.writeShort(0);
        }
        buffer.writeShort(0);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void receiveAuthGrant(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        String sn = buffer.readStringL();
        String msg = buffer.readStringLL();
        short unknown = buffer.readShort();
        LOG.warn((Object)("Unknown short=0x" + Integer.toHexString(unknown)));
        Iterator i = frame.getConn().getListeners(19, 21);
        while (i.hasNext()) {
            ((SSIListener)i.next()).receiveAuthGrant(sess, frame, sn, msg);
        }
    }

    public void sendAuthRequest(AIMSession sess, String sn, String msg) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 19)) == null || sn == null) {
            throw new NullPointerException();
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(19, 24, 0, null, true);
        AIMOutputStream buffer = new AIMOutputStream(1 + sn.length() + 2 + msg.length() + 2);
        buffer.writeStringL(sn);
        if (msg != null) {
            buffer.writeStringLL0(msg);
        } else {
            buffer.writeShort(0);
        }
        buffer.writeShort(0);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void receiveAuthRequest(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        String sn = buffer.readStringL();
        String msg = buffer.readStringLL();
        short unknown = buffer.readShort();
        LOG.warn((Object)("Unknown short=0x" + unknown));
        Iterator i = frame.getConn().getListeners(19, 25);
        while (i.hasNext()) {
            ((SSIListener)i.next()).receiveAuthRequest(sess, frame, sn, msg);
        }
    }

    public void sendAuthReply(AIMSession sess, String sn, byte reply, String msg) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 19)) == null || sn == null) {
            throw new NullPointerException();
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(19, 26, 0, null, true);
        AIMOutputStream buffer = new AIMOutputStream(1 + sn.length() + 1 + 2 + (msg != null ? msg.length() + 1 : 0) + 2);
        buffer.writeStringL(sn);
        buffer.writeByte(reply);
        if (msg != null) {
            buffer.writeStringLL0(msg);
        } else {
            buffer.writeShort(0);
        }
        buffer.writeShort(0);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void receiveAuthReply(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        String sn = buffer.readStringL();
        byte reply = buffer.readByte();
        String msg = buffer.readStringLL();
        short unknown = buffer.readShort();
        LOG.warn((Object)("Unknown short=0x" + Integer.toHexString(unknown)));
        Iterator i = frame.getConn().getListeners(19, 27);
        while (i.hasNext()) {
            ((SSIListener)i.next()).receiveAuthReply(sess, frame, sn, reply, msg);
        }
    }

    private void receiveAdded(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        String sn = buffer.readStringL();
        Iterator i = frame.getConn().getListeners(19, 28);
        while (i.hasNext()) {
            ((SSIListener)i.next()).receiveAdded(sess, frame, sn);
        }
    }

    public void handleSNAC(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        if (snac.getSubtype() == 3) {
            this.parseRights(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 6) {
            this.parseData(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 8) {
            this.parseAdd(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 9) {
            this.parseMod(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 10) {
            this.parseDel(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 14) {
            this.parseAck(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 15) {
            this.parseDataUnchanged(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 21) {
            this.receiveAuthGrant(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 25) {
            this.receiveAuthRequest(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 27) {
            this.receiveAuthReply(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 28) {
            this.receiveAdded(sess, handler, frame, snac, buffer);
        } else {
            LOG.warn((Object)("Unrecognized SNAC(" + Integer.toHexString(snac.getFamily()) + ", " + Integer.toHexString(snac.getSubtype()) + ")"));
            frame.setHandled(false);
        }
    }
}

