/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers.stocks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.walluck.oscar.handlers.stocks.Stock;

public class StocksHandler {
    private static final Logger LOG = Logger.getLogger((String)StocksHandler.class.getName());

    private static String replaceSymbols(String symbols, String oldName, String newName) {
        StringTokenizer st = new StringTokenizer(symbols, ",");
        String newSymbols = "";
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            newSymbols = name.equals(oldName) ? newSymbols + newName : newSymbols + name;
            if (!st.hasMoreTokens()) continue;
            newSymbols = newSymbols + ",";
        }
        return newSymbols;
    }

    public ArrayList getStocks(String symbols) {
        ArrayList<Stock> stocks = new ArrayList<Stock>();
        try {
            String line;
            URL url = new URL("http://quote-web.aol.com/?action=aim&fields=snpghlocvAa&syms=" + (symbols != null ? symbols : ""));
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            String restline = null;
            Stock stock = null;
            while ((line = br.readLine()) != null) {
                restline = line.substring(line.indexOf("=") + 1, line.length() - 1);
                StringTokenizer st = new StringTokenizer(restline, ";");
                if (line.startsWith("Title=")) {
                    stock = new Stock();
                    stock.setTitle(st.nextToken());
                    continue;
                }
                if (line.startsWith("Section=")) {
                    stock.setSection(st.nextToken());
                    continue;
                }
                if (!line.startsWith("DATA=")) continue;
                try {
                    stock.setSymbol(st.nextToken());
                    stock.setName(st.nextToken());
                    String name = stock.getName();
                    if (name.indexOf("changed to") != -1) {
                        StringTokenizer st2 = new StringTokenizer(name, "'");
                        String oldName = st2.nextToken();
                        st2.nextToken();
                        String newName = st2.nextToken();
                        LOG.debug((Object)("Stock name changed from " + oldName + " to " + newName + ". Requesting again with " + newName));
                        LOG.debug((Object)("Old stock symbols were " + symbols));
                        symbols = StocksHandler.replaceSymbols(symbols, oldName, newName);
                        LOG.debug((Object)("New stock symbols are " + symbols));
                        return this.getStocks(symbols);
                    }
                    stock.setLastPrice(st.nextToken());
                    stock.setChange(st.nextToken());
                    stock.setPercentChange(st.nextToken());
                    stock.setHigh(st.nextToken());
                    stock.setLow(st.nextToken());
                    stock.setOpen(st.nextToken());
                    stock.setVolume(st.nextToken());
                    stock.setYearHigh(st.nextToken());
                    stock.setYearLow(st.nextToken());
                }
                catch (NoSuchElementException nsee) {
                    LOG.error((Object)"NoSuchElementException", (Throwable)nsee);
                }
                stocks.add(stock);
                LOG.debug((Object)("Added stock for " + stock.getName() + " (" + stock.getSymbol() + ")"));
            }
            br.close();
        }
        catch (MalformedURLException mue) {
            LOG.error((Object)"MalformedURLException", (Throwable)mue);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
        return stocks;
    }

    public void saveStocks(ArrayList stocks) {
        try {
            File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "stocks.txt");
            PrintWriter out = new PrintWriter(new FileWriter(file));
            out.println("Symbol\tLast Price\tChange\t% Change\tHigh\tLow\tOpen\tVolume\t52-Week\tHigh\t52-Week Low\tName\t");
            int count = stocks.size();
            for (int i = 0; i < count; ++i) {
                Stock stock = (Stock)stocks.get(i);
                out.println(stock.getSymbol() + "\t" + stock.getLastPrice() + "\t" + stock.getChange() + "\t" + stock.getPercentChange() + "\t" + stock.getHigh() + "\t" + stock.getLow() + "\t" + stock.getOpen() + "\t" + stock.getVolume() + "\t" + stock.getYearHigh() + "\t" + stock.getYearLow() + "\t" + stock.getName());
            }
            out.close();
        }
        catch (FileNotFoundException fnfe) {
            LOG.error((Object)"FileNotFoundException", (Throwable)fnfe);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }
}

