/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.tools;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.RateClass;
import org.walluck.oscar.Redir;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.handlers.AdminHandler;
import org.walluck.oscar.handlers.AdminListener;
import org.walluck.oscar.handlers.LoginHandler;
import org.walluck.oscar.handlers.ServiceHandler;
import org.walluck.oscar.handlers.ServiceListener;
import org.walluck.oscar.tools.Tool;

public class AdminTool
extends Tool
implements AdminListener,
ServiceListener {
    private static final Logger LOG = Logger.getLogger((String)AdminTool.class.getName());
    private boolean changePassword = false;
    private String oldPassword;
    private String newPassword;
    private boolean formatScreenname = false;
    private String nick;
    private boolean confirmAccount = false;
    private boolean getEmail = false;
    private boolean setEmail = false;
    private String email;

    public AdminTool() {
        this.setFamily(7);
        this.setId(16);
        this.setVersion(1849);
    }

    public void changePassword(AIMSession sess, String oldp, String newp) throws IOException {
        AIMConnection conn = AIMConnection.findByType(sess, 7);
        if (conn == null) {
            this.changePassword = true;
            this.oldPassword = oldp;
            this.newPassword = newp;
            ServiceHandler service = (ServiceHandler)sess.getHandler(1);
            service.reqService(sess, this.getToolData().getBosconn(), 7);
        } else {
            AdminHandler admin = (AdminHandler)sess.getHandler(7);
            admin.changePassword(sess, conn, newp, oldp);
        }
    }

    public void formatScreenname(AIMSession sess, String sn) throws IOException {
        if (!AIMUtil.snCmp(this.nick, sess.getSN())) {
            AIMConnection conn = AIMConnection.findByType(sess, 7);
            if (conn == null) {
                this.formatScreenname = true;
                this.nick = sn;
                ServiceHandler service = (ServiceHandler)sess.getHandler(1);
                service.reqService(sess, this.getToolData().getBosconn(), 7);
            } else {
                AdminHandler admin = (AdminHandler)sess.getHandler(7);
                admin.setNick(sess, conn, this.nick);
            }
        }
    }

    public void confirmAccount(AIMSession sess) throws IOException {
        AIMConnection conn = AIMConnection.findByType(sess, 7);
        if (conn == null) {
            this.confirmAccount = true;
            ServiceHandler service = (ServiceHandler)sess.getHandler(1);
            service.reqService(sess, this.getToolData().getBosconn(), 7);
        } else {
            AdminHandler admin = (AdminHandler)sess.getHandler(7);
            admin.reqConfirm(sess, conn);
        }
    }

    public void getEmail(AIMSession sess) throws IOException {
        AIMConnection conn = AIMConnection.findByType(sess, 7);
        if (conn == null) {
            this.getEmail = true;
            ServiceHandler service = (ServiceHandler)sess.getHandler(1);
            service.reqService(sess, this.getToolData().getBosconn(), 7);
        } else {
            AdminHandler admin = (AdminHandler)sess.getHandler(7);
            admin.getInfo(sess, conn, 17);
        }
    }

    public void changeEmail(AIMSession sess, String eml) throws IOException {
        AIMConnection conn = AIMConnection.findByType(sess, 7);
        if (conn == null) {
            this.setEmail = true;
            this.email = eml;
            ServiceHandler service = (ServiceHandler)sess.getHandler(1);
            service.reqService(sess, this.getToolData().getBosconn(), 7);
        } else {
            AdminHandler admin = (AdminHandler)sess.getHandler(7);
            admin.setEmail(sess, conn, this.email);
        }
    }

    public void infoChange(AIMSession sess, AIMFrame frame, boolean infoChange, short perms, short err, String url, String sn, String email) {
    }

    public void accountConfirm(AIMSession sess, AIMFrame frame, int status) {
    }

    private void registerAdmListeners(AIMConnection tstconn) {
        tstconn.registerListener(7, 3, this);
        tstconn.registerListener(7, 5, this);
        tstconn.registerListener(7, 7, this);
        tstconn.registerListener(1, 7, this);
        tstconn.registerListener(1, 5, this);
    }

    public void rateResp(AIMSession sess, AIMFrame frame) {
        if (frame.getConn().getType() == 7) {
            AIMConnection tstconn = frame.getConn();
            this.registerAdmListeners(tstconn);
            ServiceHandler service = (ServiceHandler)sess.getHandler(1);
            try {
                service.clientReady(sess, tstconn);
                if (this.changePassword) {
                    this.changePassword(sess, this.oldPassword, this.newPassword);
                } else if (this.formatScreenname) {
                    this.formatScreenname(sess, this.nick);
                } else if (this.confirmAccount) {
                    this.confirmAccount(sess);
                } else if (this.getEmail) {
                    this.getEmail(sess);
                } else if (this.setEmail) {
                    this.changeEmail(sess, this.email);
                }
            }
            catch (IOException e) {
                LOG.error((Object)"IOException", (Throwable)e);
            }
        }
    }

    public void redirect(AIMSession sess, AIMFrame frame, Redir redir) {
        if (redir.getGroup() == 7) {
            AIMConnection exist = AIMConnection.findByType(sess, 7);
            if (exist != null) {
                exist.close();
            }
            AIMConnection tstconn = new AIMConnection(sess, 7, redir.getIp());
            try {
                this.registerAdmListeners(tstconn);
                tstconn.connect();
                LoginHandler login = (LoginHandler)sess.getHandler(23);
                login.sendCookie(sess, tstconn, redir.getCookie());
            }
            catch (IOException ioe) {
                tstconn.close();
                LOG.error((Object)"IOException", (Throwable)ioe);
            }
        }
    }

    public void rateChange(AIMSession sess, AIMFrame frame, int code, RateClass rc) {
    }

    public void serverPause(AIMSession sess, AIMFrame frame) {
    }

    public void serverResume(AIMSession sess, AIMFrame frame) {
    }

    public void selfInfo(AIMSession sess, AIMFrame frame, UserInfo userinfo) {
    }

    public void evilNotify(AIMSession sess, AIMFrame frame, int newEvil, UserInfo userinfo) {
    }

    public void migrate(AIMSession sess, AIMFrame frame, String ip, byte[] cookie) {
    }

    public void motd(AIMSession sess, AIMFrame frame, int id, String msg) {
    }

    public void memRequest(AIMSession sess, AIMFrame frame, int offset, int len, String modname) {
    }

    public void shutdown(AIMSession sess) {
    }

    public void bosConnectionAvailable() {
        AIMConnection bosconn = this.getToolData().getBosconn();
        bosconn.registerListener(1, 7, this);
        bosconn.registerListener(1, 5, this);
    }
}

