/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.tools;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.SSIItem;
import org.walluck.oscar.TLV;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.client.Buddy;
import org.walluck.oscar.client.BuddyGroup;
import org.walluck.oscar.client.DaimBuddyListener;
import org.walluck.oscar.handlers.BuddyListListener;
import org.walluck.oscar.handlers.SSIHandler;
import org.walluck.oscar.handlers.trilliansecureim.TrillianSecureIM;
import org.walluck.oscar.tools.IconTool;
import org.walluck.oscar.tools.Tool;

public class BuddyListTool
extends Tool
implements BuddyListListener {
    private static final Logger LOG = Logger.getLogger((String)BuddyListTool.class.getName());
    private ArrayList buddyGroups = new ArrayList(100);
    public static final int UC_UNAVAILABLE = 1;
    public static final int UC_AOL = 2;
    public static final int UC_ADMIN = 4;
    public static final int UC_UNCONFIRMED = 8;
    public static final int UC_NORMAL = 16;
    public static final int UC_AB = 32;
    public static final int UC_WIRELESS = 64;
    public static final int UC_HIPTOP = 128;

    public BuddyListTool() {
        this.setFamily(3);
        this.setId(272);
        this.setVersion(1849);
    }

    public synchronized ArrayList getBuddyGroups() {
        return this.buddyGroups;
    }

    public synchronized Buddy[] ssiSetBuddyList(List list) {
        this.buddyGroups.clear();
        BuddyGroup buddyGroup = null;
        int buddies = 0;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            SSIItem item = (SSIItem)it.next();
            if (item.getType() == 0 && item.getName() != null && buddyGroup != null) {
                buddyGroup.addBuddy(item.getName()).setProperty(Buddy.SESSION, this.getSession());
                ++buddies;
                continue;
            }
            if (item.getType() != 1 || item.getName() == null || item.getName().length() <= 0) continue;
            buddyGroup = new BuddyGroup(item.getName());
            this.buddyGroups.add(buddyGroup);
        }
        Buddy[] array = new Buddy[buddies];
        int i = 0;
        Iterator git = this.buddyGroups.iterator();
        while (git.hasNext()) {
            buddyGroup = (BuddyGroup)git.next();
            Iterator bit = buddyGroup.iterator();
            while (bit.hasNext()) {
                array[i++] = (Buddy)bit.next();
            }
        }
        DaimBuddyListener[] ls = (DaimBuddyListener[])this.listeners.getListeners(DaimBuddyListener.class);
        for (int bc = 0; bc < ls.length; ++bc) {
            ls[bc].newBuddyList(array);
        }
        return array;
    }

    public synchronized void printBuddyList() {
        if (this.buddyGroups == null) {
            return;
        }
        Iterator i = this.buddyGroups.iterator();
        while (i.hasNext()) {
            BuddyGroup buddyGroup = (BuddyGroup)i.next();
            System.out.println(buddyGroup.getName());
            Iterator i2 = buddyGroup.iterator();
            while (i2.hasNext()) {
                Buddy buddy = (Buddy)i2.next();
                System.out.println("  " + buddy.getName());
            }
        }
    }

    private synchronized BuddyGroup findGroup(String group) {
        Iterator i = this.buddyGroups.iterator();
        while (i.hasNext()) {
            BuddyGroup buddyGroup = (BuddyGroup)i.next();
            if (!AIMUtil.snCmp(buddyGroup.getName(), group)) continue;
            return buddyGroup;
        }
        return null;
    }

    private synchronized Buddy findBuddy(String name, String group) {
        BuddyGroup buddyGroup = this.findGroup(group);
        if (buddyGroup != null) {
            return this.findBuddy(name, buddyGroup);
        }
        return null;
    }

    public synchronized Buddy findBuddy(String name, BuddyGroup bg) {
        Iterator it = bg.iterator();
        while (it.hasNext()) {
            Buddy buddy = (Buddy)it.next();
            if (!AIMUtil.snCmp(buddy.getName(), name)) continue;
            return buddy;
        }
        return null;
    }

    public synchronized Buddy findBuddy(String sn) {
        Iterator it = this.buddyGroups.iterator();
        while (it.hasNext()) {
            BuddyGroup bg = (BuddyGroup)it.next();
            Buddy b = this.findBuddy(sn, bg);
            if (b == null) continue;
            return b;
        }
        return null;
    }

    public synchronized BuddyGroup findGroupForBuddy(String sn) {
        Iterator it = this.buddyGroups.iterator();
        while (it.hasNext()) {
            BuddyGroup bg = (BuddyGroup)it.next();
            Buddy b = this.findBuddy(sn, bg);
            if (b == null) continue;
            return bg;
        }
        return null;
    }

    public boolean addBuddy(String name, String group) throws IOException {
        SSIHandler ssi = (SSIHandler)this.getSession().getHandler(19);
        if (this.getSession().getSSI().getReceivedData() && ssi.itemListExists(this.getSession().getSSI().getLocal(), name) == null) {
            ssi.addBuddy(this.getSession(), name, group, null, null, null, false);
            BuddyGroup bg = this.findGroup(group);
            if (bg == null) {
                bg = new BuddyGroup(group);
                this.buddyGroups.add(bg);
            }
            Buddy b = bg.addBuddy(name);
            b.setProperty(Buddy.SESSION, this.getSession());
            return true;
        }
        return false;
    }

    public boolean moveBuddy(String name, String oldGroup, String newGroup) throws IOException {
        BuddyGroup oldg = this.findGroupForBuddy(name);
        if (oldg == null) {
            return false;
        }
        Buddy buddy = this.findBuddy(name, oldg);
        if (this.getSession().getSSI().getReceivedData()) {
            SSIHandler ssi = (SSIHandler)this.getSession().getHandler(19);
            ssi.moveBuddy(this.getSession(), oldGroup, newGroup, name);
            oldg.remove(buddy);
            return true;
        }
        return false;
    }

    public boolean removeBuddy(String name, String group) throws IOException {
        if (this.findBuddy(name, group) == null) {
            LOG.debug((Object)("Tried to remove non-existent buddy=" + name));
            return false;
        }
        SSIHandler ssi = (SSIHandler)this.getSession().getHandler(19);
        if (this.getSession().getSSI().getReceivedData()) {
            ssi.delBuddy(this.getSession(), name, group);
            return true;
        }
        return false;
    }

    public boolean renameGroup(String oldGroup, String newGroup) throws IOException {
        BuddyGroup bg = this.findGroup(oldGroup);
        if (bg == null) {
            return false;
        }
        bg.setName(newGroup);
        SSIHandler ssi = (SSIHandler)this.getSession().getHandler(19);
        ssi.renameGroup(this.getSession(), oldGroup, newGroup);
        return true;
    }

    public void buddyChange(AIMSession sess, AIMFrame frame, UserInfo info) {
        SNAC snac = frame.getSNAC();
        if (snac.getFamily() != 3) {
            LOG.error((Object)"buddyChange() with invalid family!");
            return;
        }
        if (frame.getSNAC().getSubtype() != 12 && frame.getSNAC().getSubtype() != 11) {
            LOG.error((Object)"buddyChange() with invalide sub-type");
            return;
        }
        Buddy buddy = this.findBuddy(info.getSN());
        LOG.debug((Object)("buddyChange on Buddy: " + buddy + " (" + info.getSN() + ")"));
        if (frame.getSNAC().getSubtype() == 12) {
            LOG.debug((Object)(info.getSN() + " signed off"));
            TrillianSecureIM tsi = (TrillianSecureIM)this.getToolData().getTrillianSessions().remove(AIMUtil.normalize(info.getSN()));
            if (tsi != null) {
                LOG.debug((Object)("Removed Trillian SecureIM session with " + info.getSN()));
            }
            if (buddy != null) {
                buddy.setProperty(Buddy.STATE, "Offline");
                LOG.debug((Object)("[3] " + info.getSN() + "'s state set to " + "Offline"));
            }
            DaimBuddyListener[] ls = (DaimBuddyListener[])this.listeners.getListeners(DaimBuddyListener.class);
            for (int bc = 0; bc < ls.length; ++bc) {
                ls[bc].buddyOffline(info.getSN(), buddy);
            }
            return;
        }
        String state = "Online";
        String available = null;
        if (!sess.isICQ() && (info.getPresent() & 1) != 0) {
            if ((info.getFlags() & 0x20) != 0) {
                state = "Away";
            } else if (info.getAvailableMsg() != null) {
                LOG.debug((Object)(info.getSN() + " is available: " + info.getAvailableMsg()));
                available = info.getAvailableMsg();
            } else {
                LOG.warn((Object)(info.getSN() + " is not away, and has no available message"));
            }
        }
        int caps = 0;
        if ((info.getPresent() & 0x80) != 0) {
            caps = info.getCapabilities();
        }
        if ((info.getPresent() & 0x400) != 0) {
            caps |= info.getCapabilities2();
        }
        if ((info.getPresent() & 0x2000) != 0) {
            caps |= info.getCapabilities3();
        }
        if ((caps & 0x400) != 0) {
            caps ^= 0x400;
        }
        int type = 0;
        if ((info.getPresent() & 0x10) != 0) {
            type = info.getIcqInfo().getStatus();
            if ((type & 0x20) == 0 && type != 0) {
                type = 1;
            }
        } else {
            if ((info.getCapabilities() & 0x400000) != 0) {
                type |= 0x80;
            }
            if (!sess.isICQ() && (info.getPresent() & 1) != 0) {
                if ((info.getFlags() & 1) != 0) {
                    type |= 8;
                }
                if ((info.getFlags() & 2) != 0) {
                    type |= 4;
                }
                if ((info.getFlags() & 4) != 0) {
                    type |= 2;
                }
                if ((info.getFlags() & 0x10) != 0) {
                    type |= 0x10;
                }
                if ((info.getFlags() & 0x20) != 0) {
                    type |= 1;
                }
                if ((info.getFlags() & 0x400) != 0) {
                    type |= 0x20;
                }
                if ((info.getFlags() & 0x80) != 0) {
                    type |= 0x40;
                }
                if ((info.getCapabilities() & 0x400000) != 0) {
                    type |= 0x80;
                }
            }
        }
        long idleTime = 0L;
        if ((info.getPresent() & 8) != 0) {
            idleTime = (long)info.getIdleTime() * 60L * 1000L;
        }
        long signon = 0L;
        if ((info.getPresent() & 0x100) != 0) {
            signon = (long)info.getSessionLen() * 1000L;
        }
        float warnLevel = info.getWarnLevel();
        long memberSince = info.getMemberSince();
        TLV tlv = info.getIconData();
        if (sess.isICQ() && tlv != null) {
            try {
                LOG.debug((Object)("icon data TLV, length=" + tlv.getLength()));
                LOG.debug((Object)AIMUtil.hexdump(tlv.getValue()));
                AIMInputStream tmp = new AIMInputStream(new ByteArrayInputStream(tlv.getValue()));
                IconTool it = (IconTool)this.getSession().getTool(16);
                while (!tmp.isEmpty()) {
                    short ttype = tmp.readShort();
                    byte flag = tmp.readByte();
                    byte length = tmp.readByte();
                    byte[] data = tmp.readBytes(length);
                    LOG.debug((Object)("type=0x" + ttype + ", flag=0x" + flag + ", length=" + length + ", data=" + (data != null ? AIMUtil.byteArrayToHexString(data) : "empty")));
                    if (ttype == 1 && flag == 1) {
                        String nsn = AIMUtil.normalize(info.getSN());
                        it.getIcon(nsn, data);
                        break;
                    }
                    if (ttype == 2 && flag == 4) {
                        AIMInputStream tmp2 = new AIMInputStream(new ByteArrayInputStream(data));
                        byte[] availableMsgBytes = tmp2.readBytes(tmp2.readShort());
                        if (tmp2.readShort() == 1) {
                            LOG.debug((Object)("AvailableMsgEncoding short value=0x" + Integer.toHexString(tmp2.readShort())));
                            info.setAvailableMsgEncoding(tmp2.readStringLL());
                        } else {
                            info.setAvailableMsgEncoding("utf-8");
                        }
                        String enc = info.getAvailableMsgEncoding();
                        available = new String(availableMsgBytes, AIMUtil.charsetAOLToJava(enc));
                        break;
                    }
                    LOG.warn((Object)"Unhandled TLV packet!");
                }
                it.getIcons(sess);
            }
            catch (IOException ioe) {
                LOG.error((Object)"IOException", (Throwable)ioe);
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append(info.getSN());
        sb.append(": ");
        sb.append("protocol=" + (sess.isICQ() ? "ICQ" : (sess.isIChat() ? "IChat" : "AIM")) + ", ");
        sb.append("warnLevel=" + warnLevel + "%, ");
        sb.append("signon=" + AIMUtil.prettyPrintTime(signon) + " ago, ");
        sb.append("idleTime=" + AIMUtil.prettyPrintTime(idleTime) + ", ");
        sb.append("class=" + type + "/" + this.typeToText(type) + ", ");
        sb.append("capabilities=" + BuddyListTool.capsToText(caps) + ", ");
        sb.append("member since=" + (memberSince > 0L ? new Date(memberSince * 1000L).toString() : "Unavailable") + ", ");
        sb.append("state=" + state + ", ");
        sb.append("available='" + available + "'");
        LOG.debug((Object)sb.toString());
        if (buddy != null) {
            if (caps != 0) {
                buddy.setProperty(Buddy.CAPABILITIES, new Integer(caps));
            }
            buddy.setProperty(Buddy.STATE, state);
            LOG.debug((Object)("[3] " + info.getSN() + "'s state set to " + state));
            buddy.setProperty(Buddy.WARN_LEVEL, new Float(warnLevel));
            buddy.setProperty(Buddy.CLASS, this.typeToText(type));
            buddy.setProperty(Buddy.MEMBER_SINCE, new Date(memberSince * 1000L));
            buddy.setProperty(Buddy.SIGNON_TIME, new Long(signon));
            buddy.setProperty(Buddy.IDLE_TIME, new Long(idleTime));
            buddy.setProperty(Buddy.AVAILABLE, available);
        }
        DaimBuddyListener[] ls = (DaimBuddyListener[])this.listeners.getListeners(DaimBuddyListener.class);
        for (int bc = 0; bc < ls.length; ++bc) {
            ls[bc].buddyOnline(info.getSN(), buddy);
        }
    }

    private String typeToText(int type) {
        if ((type & 0x20) != 0) {
            return "ActiveBuddy!";
        }
        if ((type & 2) != 0) {
            return "AOL";
        }
        if ((type & 4) != 0) {
            return "Administrator";
        }
        if ((type & 8) != 0) {
            return "Unconfirmed Internet";
        }
        if ((type & 0x10) != 0) {
            return "Internet";
        }
        if ((type & 0x40) != 0) {
            return "Mobile Device User";
        }
        if ((type & 1) != 0) {
            return "Unavailable";
        }
        if ((type & 0x80) != 0) {
            return "Hiptop";
        }
        return null;
    }

    public static String capsToText(int caps) {
        String s;
        StringBuffer sb = new StringBuffer();
        if ((caps & 0x800) != 0) {
            sb.append("Active Buddy, ");
        }
        if ((caps & 0x40) != 0 || (caps & 0x200) != 0 || (caps & 0x80) != 0) {
            sb.append("Add-Ins, ");
        }
        if ((caps & 1) != 0) {
            sb.append("Buddy Icon, ");
        }
        if ((caps & 8) != 0) {
            sb.append("Chat, ");
        }
        if ((caps & 4) != 0) {
            sb.append("Direct IM, ");
        }
        if ((caps & 0x2000) != 0) {
            sb.append("Empty, ");
        }
        if ((caps & 0x10) != 0) {
            sb.append("File Sharing, ");
        }
        if ((caps & 0x20) != 0) {
            sb.append("File Transfer, ");
        }
        if ((caps & 0x40000) != 0) {
            sb.append("Interoperate, ");
        }
        if ((caps & 0x10000) != 0) {
            sb.append("SecureIM, ");
        }
        if ((caps & 0x200000) != 0) {
            sb.append("Security Enabled, ");
        }
        if ((caps & 0x100) != 0) {
            sb.append("Send Buddy List, ");
        }
        if ((caps & 2) != 0) {
            sb.append("Talk, ");
        }
        if ((caps & 0x400) != 0) {
            sb.append("ICQ, ");
        }
        if ((caps & 0x1000) != 0) {
            sb.append("ICQ RTF, ");
        }
        if ((caps & 0x4000) != 0) {
            sb.append("ICQ Server Relay, ");
        }
        if ((caps & 0x8000) != 0) {
            sb.append("ICQ Unknown, ");
        }
        if ((caps & 0x20000) != 0) {
            sb.append("ICQ UTF-8, ");
        }
        if ((s = sb.toString()) != null && s.length() >= 2) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }

    public void buddylistRights(AIMSession sess, AIMFrame frame, int maxbuddies, int maxwatchers) {
    }

    public void shutdown(AIMSession sess) {
    }

    public void bosConnectionAvailable() {
        AIMConnection bosconn = this.getToolData().getBosconn();
        bosconn.registerListener(3, 3, this);
        bosconn.registerListener(3, 11, this);
        bosconn.registerListener(3, 12, this);
    }

    public void addListener(DaimBuddyListener l) {
        this.listeners.add(DaimBuddyListener.class, l);
    }

    public void removeListener(DaimBuddyListener l) {
        this.listeners.remove(DaimBuddyListener.class, l);
    }
}

