/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMClientInfo;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMConstants;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.ClientInfo;
import org.walluck.oscar.IChatClientInfo;
import org.walluck.oscar.LoginResponseInfo;
import org.walluck.oscar.client.DaimLoginEvent;
import org.walluck.oscar.client.DaimLoginListener;
import org.walluck.oscar.handlers.LoginHandler;
import org.walluck.oscar.handlers.LoginListener;
import org.walluck.oscar.tools.Tool;

public class LoginTool
extends Tool
implements AIMConstants,
LoginListener {
    private static final Logger LOG = Logger.getLogger((String)LoginTool.class.getName());

    public LoginTool() {
        this.setFamily(23);
        this.setId(272);
        this.setVersion(1849);
    }

    public void addLoginListener(DaimLoginListener l) {
        this.listeners.add(DaimLoginListener.class, l);
    }

    public void removeLoginListener(DaimLoginListener l) {
        this.listeners.remove(DaimLoginListener.class, l);
    }

    public void login() throws IOException {
        String dest = "login.oscar.aol.com:5190";
        AIMConnection conn = new AIMConnection(this.getSession(), 7, dest);
        conn.registerListener(23, 7, this);
        conn.registerListener(23, 3, this);
        conn.connect();
        LoginHandler login = (LoginHandler)this.getSession().getHandler(23);
        login.requestLogin(this.getSession(), conn, this.getSession().getSN());
    }

    public void godDamnICQ(AIMSession sess, AIMFrame frame, String unused) {
        try {
            LoginHandler login = (LoginHandler)sess.getHandler(23);
            login.sendLogin(sess, frame.getConn(), this.getSession().getSN(), this.getSession().getPassword(), null, null, null);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void parse(AIMSession sess, AIMFrame frame, LoginResponseInfo info, int family, int subtype) {
        sess.setLoginInfo(info);
        try {
            if (info.getBosip() == null) {
                LOG.fatal((Object)("Error in signon code=" + info.getErrorCode() + " url=" + info.getErrorURL()));
                String errorMsg = null;
                int errorcode = new Short(info.getErrorCode()).intValue();
                switch (info.getErrorCode()) {
                    case 1: {
                        errorcode = 5;
                    }
                    case 5: {
                        errorMsg = "Incorrect nickname or password.";
                        break;
                    }
                    case 17: {
                        errorMsg = "Your account is currently suspended.";
                        break;
                    }
                    case 20: {
                        errorMsg = "The AOL Instant Messenger service is temporarily unavailable.";
                        break;
                    }
                    case 24: {
                        errorMsg = "You have been connecting and disconnecting too frequently. If you continue to try, you will need to wait even longer.";
                        break;
                    }
                    case 28: {
                        errorMsg = "The client version you are using is too old. Please upgrade.";
                        break;
                    }
                    default: {
                        errorcode = 255;
                        errorMsg = "Unknown.";
                    }
                }
                DaimLoginEvent dle = new DaimLoginEvent(this.getSession(), errorcode);
                DaimLoginListener[] ls = (DaimLoginListener[])this.listeners.getListeners(DaimLoginListener.class);
                for (int i = 0; i < ls.length; ++i) {
                    ls[i].loginError(dle);
                }
                LOG.fatal((Object)errorMsg);
                frame.getConn().close();
                return;
            }
            LOG.debug((Object)"Closing authorizer connection...");
            frame.getConn().close();
            LOG.debug((Object)"Creating BOS connection...");
            AIMConnection bosconn = new AIMConnection(sess, 2, info.getBosip());
            this.getToolData().setBosconn(bosconn);
            ArrayList tools = this.getSession().getTools();
            Iterator it = tools.iterator();
            while (it.hasNext()) {
                ((Tool)it.next()).bosConnectionAvailable();
            }
            bosconn.getTransmitQueue().setMode(1);
            bosconn.connect();
            LoginHandler login = (LoginHandler)sess.getHandler(23);
            login.sendCookie(sess, bosconn, info.getCookie());
            DaimLoginEvent dle = new DaimLoginEvent(this.getSession());
            DaimLoginListener[] ls = (DaimLoginListener[])this.listeners.getListeners(DaimLoginListener.class);
            for (int i = 0; i < ls.length; ++i) {
                ls[i].loginDone(dle);
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void keyParse(AIMSession sess, AIMFrame frame, String keystr) {
        ClientInfo ci = !sess.isIChat() ? new AIMClientInfo() : new IChatClientInfo();
        try {
            LoginHandler login = (LoginHandler)sess.getHandler(23);
            System.out.println("Login Hdlr: " + login + " Session: " + this.getSession());
            login.sendLogin(sess, frame.getConn(), this.getSession().getSN(), this.getSession().getPassword(), ci, keystr, "AOL Instant Messenger (SM)");
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void newUIN(AIMSession sess, AIMFrame frame, int uin, int ip, int port) {
        LOG.debug((Object)("Got new UIN=" + uin));
        DaimLoginEvent dle = new DaimLoginEvent(this.getSession());
        dle.setUin(uin);
        DaimLoginListener[] ls = (DaimLoginListener[])this.listeners.getListeners(DaimLoginListener.class);
        for (int i = 0; i < ls.length; ++i) {
            ls[i].loginDone(dle);
        }
    }

    public void securID(AIMSession sess, AIMFrame frame) {
        LOG.debug((Object)"Got SecurID request");
    }

    public void shutdown(AIMSession sess) {
    }

    public void bosConnectionAvailable() {
    }
}

