/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.tools;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.ODirInfo;
import org.walluck.oscar.RateClass;
import org.walluck.oscar.Redir;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.handlers.LoginHandler;
import org.walluck.oscar.handlers.ODirListener;
import org.walluck.oscar.handlers.ServiceHandler;
import org.walluck.oscar.handlers.ServiceListener;
import org.walluck.oscar.tools.Tool;

public class ODirTool
extends Tool
implements ODirListener,
ServiceListener {
    private static final Logger LOG = Logger.getLogger((String)ODirTool.class.getName());

    public ODirTool() {
        this.setFamily(15);
        this.setId(16);
        this.setVersion(1849);
    }

    public void searchReply(AIMSession sess, AIMFrame frame, ArrayList matches) {
        int count = matches.size();
        LOG.debug((Object)("Got searchReply: " + count + " matches"));
        for (int i = 0; i < count; ++i) {
            LOG.debug((Object)("Match " + i + ":\n" + (ODirInfo)matches.get(i)));
        }
    }

    public void interestsReply(AIMSession sess, AIMFrame frame, ArrayList interests) {
        int count = interests.size();
        LOG.debug((Object)("Got interestsReply: " + count + " interests"));
        ArrayList<String> myInterests = new ArrayList<String>(1);
        myInterests.add("Computers and Technology");
    }

    private void registerODirListeners(AIMConnection tstconn) {
        tstconn.registerListener(15, 3, this);
        tstconn.registerListener(15, 5, this);
        tstconn.registerListener(1, 7, this);
        tstconn.registerListener(1, 5, this);
    }

    public void rateResp(AIMSession sess, AIMFrame frame) {
        if (frame.getConn().getType() == 15) {
            AIMConnection tstconn = frame.getConn();
            this.registerODirListeners(tstconn);
            ServiceHandler service = (ServiceHandler)sess.getHandler(1);
            try {
                service.clientReady(sess, tstconn);
            }
            catch (IOException e) {
                LOG.error((Object)"IOException", (Throwable)e);
            }
        }
    }

    public void redirect(AIMSession sess, AIMFrame frame, Redir redir) {
        if (redir.getGroup() == 15) {
            AIMConnection exist = AIMConnection.findByType(sess, 15);
            if (exist != null) {
                exist.close();
            }
            AIMConnection tstconn = new AIMConnection(sess, 15, redir.getIp());
            try {
                this.registerODirListeners(tstconn);
                tstconn.connect();
                LoginHandler login = (LoginHandler)sess.getHandler(23);
                login.sendCookie(sess, tstconn, redir.getCookie());
            }
            catch (IOException ioe) {
                tstconn.close();
                LOG.error((Object)"IOException", (Throwable)ioe);
            }
        }
    }

    public void rateChange(AIMSession sess, AIMFrame frame, int code, RateClass rc) {
    }

    public void serverPause(AIMSession sess, AIMFrame frame) {
    }

    public void serverResume(AIMSession sess, AIMFrame frame) {
    }

    public void selfInfo(AIMSession sess, AIMFrame frame, UserInfo userinfo) {
    }

    public void evilNotify(AIMSession sess, AIMFrame frame, int newEvil, UserInfo userinfo) {
    }

    public void migrate(AIMSession sess, AIMFrame frame, String ip, byte[] cookie) {
    }

    public void motd(AIMSession sess, AIMFrame frame, int id, String msg) {
    }

    public void memRequest(AIMSession sess, AIMFrame frame, int offset, int len, String modname) {
    }

    public void shutdown(AIMSession sess) {
    }

    public void bosConnectionAvailable() {
        AIMConnection bosconn = this.getToolData().getBosconn();
        bosconn.registerListener(1, 7, this);
        bosconn.registerListener(1, 5, this);
    }
}

