/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.RateClass;
import org.walluck.oscar.RateClearTask;
import org.walluck.oscar.Redir;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.handlers.BOSHandler;
import org.walluck.oscar.handlers.BuddyListHandler;
import org.walluck.oscar.handlers.ICBMHandler;
import org.walluck.oscar.handlers.LocateHandler;
import org.walluck.oscar.handlers.SSIHandler;
import org.walluck.oscar.handlers.ServiceHandler;
import org.walluck.oscar.handlers.ServiceListener;
import org.walluck.oscar.tools.Tool;

public class ServiceTool
extends Tool
implements ServiceListener {
    private static final Logger LOG = Logger.getLogger((String)ServiceTool.class.getName());
    private static final String AIMHASHDATA = "http://gaim.sourceforge.net/aim_data.php3";
    private RateClearTask rct;

    public ServiceTool() {
        this.setFamily(1);
        this.setId(272);
        this.setVersion(1849);
    }

    public void shutdown(AIMSession sess) {
    }

    public void bosConnectionAvailable() {
        AIMConnection bosconn = this.getToolData().getBosconn();
        bosconn.registerListener(1, 7, this);
        bosconn.registerListener(1, 5, this);
        bosconn.registerListener(1, 10, this);
        bosconn.registerListener(1, 16, this);
        bosconn.registerListener(1, 19, this);
        bosconn.registerListener(1, 31, this);
        bosconn.registerListener(1, 15, this);
    }

    public void rateResp(AIMSession sess, AIMFrame frame) {
        LOG.debug((Object)("RateResp received for connection " + frame.getConn().getType()));
        if (frame.getConn().getType() == 2) {
            AIMConnection tstconn = frame.getConn();
            this.rct = new RateClearTask(tstconn);
            sess.getTimer().schedule((TimerTask)this.rct, 60000L, 60000L);
            try {
                ServiceHandler service = (ServiceHandler)sess.getHandler(1);
                service.reqPersonalInfo(sess, tstconn);
                SSIHandler ssi = (SSIHandler)sess.getHandler(19);
                ssi.reqRights(sess);
                ssi.reqData(sess);
                LocateHandler loc = (LocateHandler)sess.getHandler(2);
                loc.reqLocateRights(sess, tstconn);
                BuddyListHandler buddy = (BuddyListHandler)sess.getHandler(3);
                buddy.reqBuddyRights(sess, tstconn);
                ICBMHandler im = (ICBMHandler)sess.getHandler(4);
                im.reqICBMParams(sess);
                BOSHandler bos = (BOSHandler)sess.getHandler(9);
                bos.reqRights(sess, tstconn);
                if (!sess.isICQ()) {
                    bos.setGroupPerm(sess, frame.getConn(), 31);
                    service.setPrivacyFlags(sess, frame.getConn(), 3);
                }
            }
            catch (IOException ioe) {
                LOG.error((Object)"IOException", (Throwable)ioe);
            }
        }
    }

    public void rateChange(AIMSession sess, AIMFrame frame, int code, RateClass rc) {
        String[] codes = new String[]{"invalid", "change", "warning", "limit", "limit cleared"};
        LOG.debug((Object)("Rate change, code=" + (code < 5 ? codes[code] : codes[0])));
        if (code == 3) {
            LOG.debug((Object)"The last message was not sent because you are exceeding the rate limit. Please try again later.");
        }
    }

    public void serverPause(AIMSession sess, AIMFrame frame) {
        LOG.debug((Object)"Got server pause");
    }

    public void serverResume(AIMSession sess, AIMFrame frame) {
        LOG.debug((Object)"Got server resume");
    }

    public void selfInfo(AIMSession sess, AIMFrame frame, UserInfo userinfo) {
    }

    public void evilNotify(AIMSession sess, AIMFrame frame, int newEvil, UserInfo userinfo) {
        LOG.debug((Object)("evilNotify: Evil now " + newEvil / 10 + ". Eviled by " + userinfo.getSN()));
    }

    public void migrate(AIMSession sess, AIMFrame frame, String ip, byte[] cookie) {
    }

    public void motd(AIMSession sess, AIMFrame frame, int id, String msg) {
    }

    public void memRequest(AIMSession sess, AIMFrame frame, int offset, int len, String modname) {
        LOG.debug((Object)("offset=" + offset + ", length=" + len + ", file=" + (modname != null ? modname : "aim.exe")));
        ServiceHandler service = (ServiceHandler)sess.getHandler(1);
        try {
            if (len == 0) {
                LOG.debug((Object)"len is 0, hashing null");
                service.sendMemBlock(sess, frame.getConn(), offset, len, null, 0);
                return;
            }
            URL url = new URL("http://gaim.sourceforge.net/aim_data.php3?offset=" + offset + "&len=" + len + "&modname=" + modname);
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = br.readLine();
            br.close();
            if (line == null) {
                LOG.warn((Object)"Unable to get a valid hash for logging in");
                return;
            }
            service.sendMemBlock(sess, frame.getConn(), 0, 16, line.getBytes(), 1);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void redirect(AIMSession sess, AIMFrame frame, Redir redir) {
        LOG.debug((Object)("Redirecting connection " + redir.getGroup() + " to IP " + redir.getIp()));
    }
}

