/*
 * Decompiled with CFR 0.152.
 */
package er.rest;

import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import er.rest.ERXRestClassDescriptionFactory;
import er.rest.ERXRestUtils;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.List;

public class BeanInfoClassDescription
extends EOClassDescription {
    private BeanInfo _beanInfo;

    public BeanInfoClassDescription(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("You must provide a class name.");
        }
        try {
            this._beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public String entityName() {
        return this._beanInfo.getBeanDescriptor().getBeanClass().getSimpleName();
    }

    public Class classForAttributeKey(String key) {
        for (PropertyDescriptor descriptor : this._beanInfo.getPropertyDescriptors()) {
            if (!descriptor.getName().equals(key) || !this.isAttribute(descriptor)) continue;
            return descriptor.getPropertyType();
        }
        return null;
    }

    protected boolean isAttribute(PropertyDescriptor descriptor) {
        return this.isAttribute(descriptor.getPropertyType());
    }

    protected boolean isAttribute(Class type) {
        return ERXRestUtils.isPrimitive(type);
    }

    protected boolean isToMany(PropertyDescriptor descriptor) {
        return this.isToMany(descriptor.getPropertyType());
    }

    protected boolean isToMany(Class type) {
        return List.class.isAssignableFrom(type);
    }

    public boolean isAttributeMethod(String methodName) {
        for (MethodDescriptor descriptor : this._beanInfo.getMethodDescriptors()) {
            Method descriptorMethod = descriptor.getMethod();
            Class<?> descriptorReturnType = descriptorMethod.getReturnType();
            if (!descriptor.getName().equals(methodName) || descriptorReturnType == Void.TYPE || descriptorMethod.getParameterTypes().length != 0 || !this.isAttribute(descriptorReturnType)) continue;
            return true;
        }
        return false;
    }

    public boolean isToOneMethod(String methodName) {
        for (MethodDescriptor descriptor : this._beanInfo.getMethodDescriptors()) {
            Method descriptorMethod = descriptor.getMethod();
            Class<?> descriptorReturnType = descriptorMethod.getReturnType();
            if (!descriptor.getName().equals(methodName) || descriptorReturnType == Void.TYPE || descriptorMethod.getParameterTypes().length != 0 || this.isAttribute(descriptorReturnType) || this.isToMany(descriptorReturnType)) continue;
            return true;
        }
        return false;
    }

    public boolean isToManyMethod(String methodName) {
        for (MethodDescriptor descriptor : this._beanInfo.getMethodDescriptors()) {
            Method descriptorMethod = descriptor.getMethod();
            Class<?> descriptorReturnType = descriptorMethod.getReturnType();
            if (!descriptor.getName().equals(methodName) || descriptorReturnType == Void.TYPE || descriptorMethod.getParameterTypes().length != 0 || !this.isToMany(descriptorReturnType)) continue;
            return true;
        }
        return false;
    }

    public NSArray attributeKeys() {
        NSMutableArray attributes = new NSMutableArray();
        for (PropertyDescriptor descriptor : this._beanInfo.getPropertyDescriptors()) {
            if (!this.isAttribute(descriptor)) continue;
            attributes.addObject((Object)descriptor.getName());
        }
        return attributes;
    }

    public NSArray toOneRelationshipKeys() {
        NSMutableArray relationships = new NSMutableArray();
        for (PropertyDescriptor descriptor : this._beanInfo.getPropertyDescriptors()) {
            if (this.isAttribute(descriptor) || this.isToMany(descriptor) || "class".equals(descriptor.getName())) continue;
            relationships.addObject((Object)descriptor.getName());
        }
        return relationships;
    }

    public NSArray toManyRelationshipKeys() {
        NSMutableArray relationships = new NSMutableArray();
        for (PropertyDescriptor descriptor : this._beanInfo.getPropertyDescriptors()) {
            if (!this.isToMany(descriptor)) continue;
            relationships.addObject((Object)descriptor.getName());
        }
        return relationships;
    }

    public EOClassDescription classDescriptionForDestinationKey(String detailKey) {
        for (PropertyDescriptor propertyDescriptor : this._beanInfo.getPropertyDescriptors()) {
            if (!propertyDescriptor.getName().equals(detailKey)) continue;
            if (this.isToMany(propertyDescriptor)) {
                return ERXRestClassDescriptionFactory.classDescriptionForClass(Object.class, true);
            }
            return ERXRestClassDescriptionFactory.classDescriptionForClass(propertyDescriptor.getPropertyType(), false);
        }
        for (FeatureDescriptor featureDescriptor : this._beanInfo.getMethodDescriptors()) {
            Method descriptorMethod = ((MethodDescriptor)featureDescriptor).getMethod();
            Class<?> descriptorReturnType = descriptorMethod.getReturnType();
            if (!featureDescriptor.getName().equals(detailKey) || descriptorReturnType == Void.TYPE || descriptorMethod.getParameterTypes().length != 0) continue;
            if (this.isToMany(descriptorReturnType)) {
                return ERXRestClassDescriptionFactory.classDescriptionForClass(Object.class, true);
            }
            return ERXRestClassDescriptionFactory.classDescriptionForClass(descriptorReturnType, false);
        }
        return null;
    }

    public Object createInstance() {
        try {
            return this._beanInfo.getBeanDescriptor().getBeanClass().newInstance();
        }
        catch (Exception e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }
}

